/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SERVICEAFFECTSMANAGEDELEMENT_H_
#define OPENDRIM_SERVICEAFFECTSMANAGEDELEMENT_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_Service.h"
#include "CIM_ServiceAccess.h"
*/

const static char* OpenDRIM_ServiceAffectsManagedElement_classnames[] = {"OpenDRIM_ServiceAffectsManagedElement"};
static string OpenDRIM_ServiceAffectsManagedElement_NAMESPACE = _NAMESPACE;
const static string AffectedElement_role = "AffectedElement";
const static char* AffectedElement_classnames[] = {"CIM_ManagedElement"};
const static string AffectedElement_NAMESPACE = _NAMESPACE;

const static string AffectingElement_role = "AffectingElement";
const static char* AffectingElement_classnames[] = {"OpenDRIM_SoftwareInstallationService"};
const static string AffectingElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_ServiceAffectsManagedElement {

public:
	
	Objectpath AffectedElement;
	bool AffectedElement_isNULL;
	
	Objectpath AffectingElement;
	bool AffectingElement_isNULL;
	
	vector<unsigned short> ElementEffects;
	bool ElementEffects_isNULL;
	
	vector<string> OtherElementEffectsDescriptions;
	bool OtherElementEffectsDescriptions_isNULL;
	
	OpenDRIM_ServiceAffectsManagedElement() {
		AffectedElement_isNULL = true;
		AffectingElement_isNULL = true;
		ElementEffects_isNULL = true;
		OtherElementEffectsDescriptions_isNULL = true;
	}
	
	~OpenDRIM_ServiceAffectsManagedElement() {}
	
	string getKeys() const {
		return CF_toLowCase(".AffectedElement=\"" + CF_quoteString(AffectedElement.toString()) + "\""".AffectingElement=\"" + CF_quoteString(AffectingElement.toString()) + "\"");
	}

	int getAffectedElement(Objectpath& value) const {
		if (AffectedElement_isNULL==true)
			return NOT_FOUND;
		value = AffectedElement;
		return OK;
	}
	
	int setAffectedElement(const Objectpath& newValue) {
		AffectedElement = newValue;
		AffectedElement.setNamespace(AffectedElement_NAMESPACE);
		AffectedElement_isNULL = false;
		return OK;
	}

	int getAffectingElement(Objectpath& value) const {
		if (AffectingElement_isNULL==true)
			return NOT_FOUND;
		value = AffectingElement;
		return OK;
	}
	
	int setAffectingElement(const Objectpath& newValue) {
		AffectingElement = newValue;
		AffectingElement.setNamespace(AffectingElement_NAMESPACE);
		AffectingElement_isNULL = false;
		return OK;
	}

	int getElementEffects(vector<unsigned short>& value) const {
		if (ElementEffects_isNULL==true)
			return NOT_FOUND;
		value = ElementEffects;
		return OK;
	}
	
	int setElementEffects(const vector<unsigned short>& newValue) {
		ElementEffects = newValue;
		ElementEffects_isNULL = false;
		return OK;
	}

	int getOtherElementEffectsDescriptions(vector<string>& value) const {
		if (OtherElementEffectsDescriptions_isNULL==true)
			return NOT_FOUND;
		value = OtherElementEffectsDescriptions;
		return OK;
	}
	
	int setOtherElementEffectsDescriptions(const vector<string>& newValue) {
		OtherElementEffectsDescriptions = newValue;
		OtherElementEffectsDescriptions_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SERVICEAFFECTSMANAGEDELEMENT_H_*/
