/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_BIOSConcreteComponentAccess.h"

int BIOS_OpenDRIM_BIOSConcreteComponent_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(BIOS_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(BIOS_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(BIOS_CIM_ManagedElement_unload(errorMessage));
	CF_assert(BIOS_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_isAssociated(const Instance& PartComponent, const Instance& GroupComponent, bool& isAssociated, string& errorMessage) {
	_E_;
	// Determine if the association can be established or not
	isAssociated=false;
	
	if(PartComponent.getClassname().find("OpenDRIM")==0) isAssociated=true;
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BIOSConcreteComponent>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumeratePartComponents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumeratePartComponents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		BIOS_OpenDRIM_BIOSConcreteComponent_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			PartComponent_classnames[0], GroupComponent_classnames[0],
			PartComponent_role.c_str(), GroupComponent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_referencePartComponentToGroupComponent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BIOSConcreteComponent& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath PartComponent_objectpath;
	instance.getPartComponent(PartComponent_objectpath);
	Instance PartComponent_instance;
	CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_getPartComponent(broker, ctx, PartComponent_objectpath, PartComponent_instance, NULL, errorMessage));
	
	Objectpath GroupComponent_objectpath;
	instance.getGroupComponent(GroupComponent_objectpath);
	Instance GroupComponent_instance;
	CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_getGroupComponent(broker, ctx, GroupComponent_objectpath, GroupComponent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_isAssociated(PartComponent_instance, GroupComponent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& newInstance, const OpenDRIM_BIOSConcreteComponent& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> GroupComponent_instances;
	if (discriminant=="a")
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<GroupComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_isAssociated(PartComponent_instance, GroupComponent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			GroupComponent_associatedInstances.push_back(GroupComponent_instances[i]);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> PartComponent_instances;
	if (discriminant=="a")
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<PartComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(BIOS_OpenDRIM_BIOSConcreteComponent_isAssociated(PartComponent_instances[i], GroupComponent_instance, isAssociated, errorMessage));
		if (isAssociated)
			PartComponent_associatedInstances.push_back(PartComponent_instances[i]);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_BIOSConcreteComponent>& OpenDRIM_BIOSConcreteComponent_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < GroupComponent_instances.size(); i++) {
		OpenDRIM_BIOSConcreteComponent instance;
		instance.setPartComponent(((Instance) PartComponent_instance).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instances[i]).getObjectpath());
		
		OpenDRIM_BIOSConcreteComponent_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_BIOSConcreteComponent>& OpenDRIM_BIOSConcreteComponent_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < PartComponent_instances.size(); i++) {
		OpenDRIM_BIOSConcreteComponent instance;
		instance.setPartComponent(((Instance) PartComponent_instances[i]).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instance).getObjectpath());
		
		OpenDRIM_BIOSConcreteComponent_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSConcreteComponent_populate(OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

