// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Select3D_Projector_HeaderFile
#define _Select3D_Projector_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Select3D_Projector.hxx>

#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
#include <gp_GTrsf.hxx>
#include <gp_Trsf.hxx>
#include <Graphic3d_Mat4d.hxx>
#include <Standard_Transient.hxx>
#include <Handle_V3d_View.hxx>
class Standard_NoSuchObject;
class V3d_View;
class gp_Ax2;
class gp_Trsf;
class gp_GTrsf;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class gp_Vec2d;
class gp_Lin;


//! A framework to define 3D projectors.
//! Projector provides services for projecting points from
//! world-coordinates to a viewing plane. Projection could be defined by
//! corresponding transformation, or coordinate system. The transformation
//! could be constructed for a view with transposed view transformation
//! matrix ( that represents view-orientation ), including, for perspective
//! view, focal distance ( distance from an eye to the view plane ) and
//! translational part that represents translation of focal point in
//! view-coordinate space. The Select3D_Projector class recognizes the
//! predefined set of popular projections: axonometric, top view, front
//! view and uses more efficient algorithm for projection computations.
//! User-defined transformation could be also defined in constructor.
//! Perspective projection consists of two separate parts, that are
//! composed together during computation: transformation component and
//! focale distance.
class Select3D_Projector : public Standard_Transient
{

public:

  
  //! Constructs the 3D projector object from the passed view.
  //! The projector captures current model-view and projection transformation
  //! of the passed view.
  Standard_EXPORT Select3D_Projector(const Handle(V3d_View)& theView);
  
  //! Constructs identity projector.
  Standard_EXPORT Select3D_Projector();
  
  //! Builds the Projector from the model-view transformation specified
  //! by the passed viewing coordinate system <theCS>. The Projector has
  //! identity projection transformation, is orthogonal.
  //! The viewing coordinate system could be constructed from x direction,
  //! view plane normal direction, and view point location in
  //! world-coordinate space.
  Standard_EXPORT Select3D_Projector(const gp_Ax2& theCS);
  
  //! Builds the Projector from the model-view transformation specified
  //! by the passed view coordinate system <theCS> and simplified perspective
  //! projection transformation defined by <theFocus> parameter.
  //! The viewing coordinate system could be constructed from x direction,
  //! view plane normal direction, and focal point location in world-coordinate
  //! space. <theFocus> should represent distance of an eye from view plane
  //! in world-coordinate space (focal distance).
  Standard_EXPORT Select3D_Projector(const gp_Ax2& theCS, const Standard_Real theFocus);
  
  //! Build the Projector from the model-view transformation passed
  //! as <theViewTrsf> and simplified perspective projection transformation
  //! parameters passed as <theIsPersp> and <theFocus>.
  //! In case, when <theViewTrsf> transformation should represent custom view
  //! projection, it could be constructed from two separate components:
  //! transposed view orientation matrix and translation of focal point
  //! in view-coordinate system.
  //! <theViewTrsf> could be built up from x direction, up direction,
  //! view plane normal direction vectors and translation with SetValues(...)
  //! method, where first row arguments (a11, a12, a13, a14)  are x, y, z
  //! component of x direction vector, and x value of reversed translation
  //! vector. Second row arguments, are x y z for up direction and y value of
  //! reversed translation, and the third row defined in the same manner.
  //! This also suits for simple perspective view, where <theFocus> is the focale
  //! distance of an eye from view plane in world-space coordinates.
  //! Note, that in that case amount of perspective distortion (perspective
  //! angle) should be defined through focal distance.
  Standard_EXPORT Select3D_Projector(const gp_Trsf& theViewTrsf, const Standard_Boolean theIsPersp, const Standard_Real theFocus);
  
  //! Builds the Projector from the model-view transformation passed
  //! as <theViewTrsf> and projection transformation for <theIsPersp> and
  //! <theFocus> parameters.
  //! In case, when <theViewTrsf> transformation should represent custom view
  //! projection, it could be constructed from two separate components:
  //! transposed view orientation matrix and translation of a focal point
  //! in view-coordinate system.
  //! This also suits for perspective view, with <theFocus> that could be
  //! equal to distance from an eye to a view plane in
  //! world-coordinates (focal distance).
  //! The 3x3 transformation matrix is built up from three vectors:
  //! x direction, up direction and view plane normal vectors, where each
  //! vector is a matrix row. Then <theViewTrsf> is constructed from matrix and
  //! reversed translation with methods SetTranslationPart(..) and
  //! SetVectorialPart(..).
  //! Note, that in that case amount of perspective distortion (perspective
  //! angle) should be defined through focal distance.
  Standard_EXPORT Select3D_Projector(const gp_GTrsf& theViewTrsf, const Standard_Boolean theIsPersp, const Standard_Real theFocus);
  
  //! Builds the Projector from the passed model-view <theViewTrsf>
  //! and projection <theProjTrsf> transformation matrices.
  Standard_EXPORT Select3D_Projector(const Graphic3d_Mat4d& theViewTrsf, const Graphic3d_Mat4d& theProjTrsf);
  
  //! Sets new parameters for the Projector.
  Standard_EXPORT   void Set (const gp_Trsf& theViewTrsf, const Standard_Boolean theIsPersp, const Standard_Real theFocus) ;
  
  //! Sets new parameters for the Projector.
  Standard_EXPORT   void Set (const Graphic3d_Mat4d& theViewTrsf, const Graphic3d_Mat4d& theProjTrsf) ;
  
  //! Sets new parameters for the Projector
  //! captured from the passed view.
  Standard_EXPORT   void SetView (const Handle(V3d_View)& theView) ;
  
  //! Pre-compute inverse transformation and ensure whether it is possible
  //! to use optimized transformation for the common view-orientation type or not
  //! if <theToCheckOptimized> is TRUE.
  Standard_EXPORT virtual   void Scaled (const Standard_Boolean theToCheckOptimized = Standard_False) ;
  
  //! Returns True if there is simplified perspective
  //! projection approach is used. Distortion defined by Focus.
    virtual   Standard_Boolean Perspective()  const;
  
  //! Returns the focal length of simplified perspective
  //! projection approach. Raises program error exception if the
  //! the projection transformation is not specified as simplified
  //! Perspective (for example, custom projection transformation is defined
  //! or the orthogonal Projector is defined).
    virtual   Standard_Real Focus()  const;
  
  //! Returns projection transformation. Please note that for
  //! simplified perspective projection approach, defined by Focus, the
  //! returned transformation is identity.
     const  Graphic3d_Mat4d& Projection()  const;
  
  //! Returns the view transformation.
    virtual  const  gp_GTrsf& Transformation()  const;
  
  //! Returns the inverted view transformation.
    virtual  const  gp_GTrsf& InvertedTransformation()  const;
  
  //! Returns the uniform-scaled view transformation.
    virtual  const  gp_Trsf& FullTransformation()  const;
  
  //! Transforms the vector into view-coordinate space.
    virtual   void Transform (gp_Vec& theD)  const;
  
  //! Transforms the point into view-coordinate space.
    virtual   void Transform (gp_Pnt& thePnt)  const;
  
  //! Transforms the point into view-coordinate space
  //! and applies projection transformation.
  Standard_EXPORT virtual   void Project (const gp_Pnt& theP, gp_Pnt2d& thePout)  const;
  
  //! Transforms the point into view-coordinate space
  //! and applies projection transformation.
  Standard_EXPORT   void Project (const gp_Pnt& theP, Standard_Real& theX, Standard_Real& theY, Standard_Real& theZ)  const;
  
  //! Transforms the point and vector passed from its location
  //! into view-coordinate space and applies projection transformation.
  Standard_EXPORT virtual   void Project (const gp_Pnt& theP, const gp_Vec& theD1, gp_Pnt2d& thePout, gp_Vec2d& theD1out)  const;
  
  //! Return projection line going through the 2d point <theX, theY>
  Standard_EXPORT virtual   gp_Lin Shoot (const Standard_Real theX, const Standard_Real theY)  const;
  
    virtual   void Transform (gp_Pnt& thePnt, const gp_GTrsf& theTrsf)  const;
  
    virtual   void Transform (gp_Lin& theLin, const gp_GTrsf& theTrsf)  const;




  DEFINE_STANDARD_RTTI(Select3D_Projector)

protected:


  Standard_Boolean myPersp;
  Standard_Real myFocus;
  gp_GTrsf myGTrsf;
  gp_GTrsf myInvTrsf;
  gp_Trsf myScaledTrsf;
  Graphic3d_Mat4d myProjTrsf;


private: 


  Standard_Integer myType;


};


#include <Select3D_Projector.lxx>





#endif // _Select3D_Projector_HeaderFile
