// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepAlgoAPI_HeaderFile
#define _BRepAlgoAPI_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_CString.hxx>
#include <BOPAlgo_Operation.hxx>
#include <Standard_Boolean.hxx>
class TopoDS_Shape;
class BRepAlgoAPI_BooleanOperation;
class BRepAlgoAPI_Fuse;
class BRepAlgoAPI_Common;
class BRepAlgoAPI_Cut;
class BRepAlgoAPI_Section;
class BRepAlgoAPI_Check;


//! The BRepAlgoAPI package provides a full range of
//! services to perform Boolean Operations on arguments (shapes
//! that are defined in the BRep data structures). The
//! implemented new algorithm is intended to replace the Old
//! Boolean Operations algorithm in the BRepAlgoAPI package.
//! The New algorithm is free of a large number of weak spots
//! and limitations characteristics of the Old algorithm.
//! It is more powerful and flexible.
//! It can process arguments the Old algorithm was not adapted for.
//! The new algorithm is based on a new approach to operations
//! with interfered shapes. The advantages of the new algorithm
//! include an ability to treat arguments that have shared
//! entities. It can properly process two solids with shared
//! faces (in terms of TopoDS_Shape::IsSame()), two
//! faces that have shared edges and so on. Now the New Boolean
//! Operation algorithm can treat a wide range of shapes while the
//! Old one fails on them.
//! A generalization of treatment of same-domain faces
//! was included into the New algorithm. Two faces that share
//! the same domain are processed according to the common rule
//! even if the underlying surfaces are of different types. This
//! allows to execute Boolean Operations properly for the same
//! domain faces. It also concerns solids and shells that have the
//! same domain faces. It is quite frequent when two faces share
//! the same domain. And the New algorithm successfully copes
//! with it in contrast to the Old one.
//! Generalization oftreatment of degenerated edges
//! gives a possibility to process them properly. Although there
//! are still some difficulties with processing faces in areas close
//! to degenerated edges.
//! Now the processing of arguments having internal sub-shapes gives
//! a correct result. Internal sub-shape means a sub-shape of a
//! shape with the orientation TopAbs_INTERNAL and is located
//! inside the shape boundaries. The New algorithm processes faces
//! with internal edges properly. The new API of the Boolean
//! Operations (in addition to the old API) allows to reuse the
//! already computed interference between arguments in different
//! types of Boolean Operations. It is possible to use once computed
//! interference in FUSE, CUT and COMMON operations on given
//! arguments. So there is no need to re-compute the interference
//! between the arguments. It allows to reduce time for more than one
//! operation on given arguments.
//! The shape type of a Boolean Operation result and types of the arguments:
//! -      For arguments with the same shape type (e.g. SOLID /
//! SOLID) the type of the resulting shape will be a
//! COMPOUND, containing shapes of this type;
//! -      For arguments with different shape types (e.g.
//! SHELL / SOLID) the type of the resulting shape will be a
//! COMPOUND, containing shapes of the type that is the same as
//! that of the low type of the argument. Example: For
//! SHELL/SOLID the result is a COMPOUND of SHELLs.
//! -      For arguments with different shape types some of
//! Boolean Operations can not be done using the default
//! implementation, because of a non-manifold type of the
//! result. Example: the FUSE operation for SHELL and SOLID
//! can not be done, but the CUT operation can be done, where
//! SHELL is the object and SOLID is the tool.
//! It is possible to perform Boolean Operations on arguments
//! of the COMPOUND shape type. In this case each compound must not
//! be heterogeneous, i.e. it must contain equidimensional shapes
//! (EDGEs or/and WIREs, FACEs or/and SHELLs, SOLIDs). SOLIDs
//! inside the COMPOUND must not contact (intersect or touch)
//! each other. The same condition is true for SHELLs or FACEs,
//! WIREs or EDGEs.
//! It does not support Boolean Operations for COMPSOLID type of shape.
class BRepAlgoAPI 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Check shapes on validity for boolean
  //! operation.
  //! Dump arguments and result of boolean operation in the file specified by path.
  Standard_EXPORT static   void DumpOper (const Standard_CString theFilePath, const TopoDS_Shape& theShape1, const TopoDS_Shape& theShape2, const TopoDS_Shape& theResult, const BOPAlgo_Operation theOperation, const Standard_Boolean isNonValidArgs) ;




protected:





private:




friend class BRepAlgoAPI_BooleanOperation;
friend class BRepAlgoAPI_Fuse;
friend class BRepAlgoAPI_Common;
friend class BRepAlgoAPI_Cut;
friend class BRepAlgoAPI_Section;
friend class BRepAlgoAPI_Check;

};







#endif // _BRepAlgoAPI_HeaderFile
