;; mlangia-tab.scm

;; Copyright 2015-2018 Matthew R. Wette
;; 
;; This library is free software; you can redistribute it and/or
;; modify it under the terms of the GNU Lesser General Public
;; License as published by the Free Software Foundation; either
;; version 3 of the License, or (at your option) any later version.
;; See the file COPYING included with the this distribution.

(define mlangia-mtab
  '(($start . 101) ($lone-comm . 3) ($string . 4) ($float . 5) ($fixed . 6) 
    ($ident . 7) (";" . 8) ("." . 9) (".'" . 10) ("'" . 11) ("~" . 12) 
    (".^" . 13) (".\\" . 14) ("./" . 15) (".*" . 16) ("^" . 17) ("\\" . 18) 
    ("/" . 19) ("*" . 20) (".-" . 21) (".+" . 22) ("-" . 23) ("+" . 24) 
    (">=" . 25) ("<=" . 26) (">" . 27) ("<" . 28) ("~=" . 29) ("==" . 30) 
    ("&" . 31) ("|" . 32) (":" . 33) ("}" . 34) ("{" . 35) ("case" . 36) 
    ("elseif" . 37) ("load" . 38) ("global" . 39) ("clear" . 40) ("return" . 
    41) ("otherwise" . 42) ("switch" . 43) ("else" . 44) ("if" . 45) ("while" 
    . 46) ("for" . 47) ("\n" . 48) ("," . 49) (")" . 50) ("(" . 51) ("=" . 52)
    ("]" . 53) ("[" . 54) ("function" . 55) ("end" . 56) ($error . 2) ($end . 
    58)))

(define mlangia-ntab
  '((59 . float) (60 . lone-comment-list-1) (61 . term-list) (62 . nl) 
    (63 . row-term) (64 . matrix-row) (65 . matrix-row-list) (66 . number) 
    (67 . primary-expr) (68 . postfix-expr) (69 . unary-expr) (70 . mul-expr) 
    (71 . add-expr) (72 . rel-expr) (73 . equality-expr) (74 . and-expr) 
    (75 . or-expr) (76 . expr-list) (77 . string-list) (78 . fixed-list) 
    (79 . string) (80 . fixed) (81 . case-expr) (82 . arg-list) (83 . command)
    (84 . case-list) (85 . elseif-list) (86 . expr) (87 . 
    nontrivial-statement-1) (88 . lone-comment) (89 . trivial-statement) 
    (90 . triv-stmt-list-1) (91 . ident) (92 . ident-list) (93 . 
    lone-comment-list) (94 . function-decl-line) (95 . term) (96 . the-end) 
    (97 . stmt-list) (98 . non-comment-statement) (99 . function-decl) 
    (100 . statement) (101 . mlang-item) (102 . mlang-item-list-1) (103 . 
    function-defn) (104 . mlang-item-list) (105 . nontrivial-statement) 
    (106 . triv-stmt-list) (107 . translation-unit)))

(define mlangia-len-v
  #(1 3 3 2 2 1 0 2 1 1 4 3 2 2 2 1 10 9 8 7 6 5 1 3 1 2 1 1 2 1 1 1 1 2 1 2 
    1 3 7 5 8 6 7 5 8 5 1 2 1 1 1 1 2 4 5 0 5 1 1 3 3 1 2 1 2 1 3 1 1 3 5 3 5 
    1 3 1 3 1 3 3 1 3 3 3 3 1 3 3 3 3 1 3 3 3 3 3 3 3 3 1 2 2 2 1 2 2 4 3 3 1 
    1 1 3 2 3 2 3 1 3 1 1 1 3 1 2 1 1 1 1 2 3 1 1 1 1 1 1 1 1))

(define mlangia-rto-v
  #(#f 107 107 107 107 104 102 102 101 101 103 103 103 96 99 99 94 94 94 94 
    94 94 92 92 97 97 106 90 90 100 100 98 98 89 89 105 87 87 87 87 87 87 87 
    87 87 87 87 87 83 83 83 82 82 85 85 84 84 81 81 81 81 78 78 77 77 76 76 86
    86 86 86 86 86 75 75 74 74 73 73 73 72 72 72 72 72 71 71 71 71 71 70 70 70
    70 70 70 70 70 70 69 69 69 69 68 68 68 68 68 68 67 67 67 67 67 67 67 67 65
    65 63 63 64 64 61 61 95 95 95 93 60 60 91 80 59 66 66 79 88 62))

(define mlangia-pat-v
  #(((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) 
    (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) 
    (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) 
    (45 . 37) (46 . 38) (47 . 39) (86 . 40) (55 . 41) (87 . 42) (95 . 43) 
    (88 . 44) (94 . 45) (105 . 46) (89 . 47) (99 . 48) (100 . 49) (103 . 50) 
    (101 . 51)) ((1 . -133)) ((1 . -132)) ((1 . -136)) ((1 . -135)) ((1 . -134
    )) ((1 . -131)) ((34 . 104) (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 101) (64 . 102) 
    (65 . 105)) ((53 . 100) (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 101) (64 . 102) 
    (65 . 103)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) 
    (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 99)) ((1 . -111)) ((1 . -110
    )) ((1 . -109)) ((1 . -103)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (68 . 98)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (68 . 97)) 
    ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (68 . 96)) ((11 . 92) 
    (10 . 93) (51 . 94) (9 . 95) (1 . -99)) ((1 . -90)) ((20 . 84) (19 . 85) 
    (18 . 86) (17 . 87) (16 . 88) (15 . 89) (14 . 90) (13 . 91) (1 . -85)) 
    ((24 . 80) (23 . 81) (22 . 82) (21 . 83) (1 . -80)) ((28 . 76) (27 . 77) 
    (26 . 78) (25 . 79) (1 . -77)) ((30 . 74) (29 . 75) (1 . -75)) ((31 . 73) 
    (1 . -73)) ((1 . -138)) ((1 . -68)) ((33 . 71) (32 . 72) (1 . -67)) 
    ((1 . -50)) ((1 . -49)) ((1 . -48)) ((1 . -137)) ((1 . -127)) ((1 . -126))
    ((1 . -125)) ((7 . 6) (91 . 69) (82 . 70)) ((1 . -46)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (33 . 25) 
    (75 . 26) (86 . 68)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 67)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (33 . 25) (75 . 26) (86 . 66)) ((7 . 6) (91 . 65)) ((52 . 64) (1 . -36)) 
    ((54 . 62) (7 . 6) (91 . 63)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) 
    (95 . 61)) ((1 . -34)) ((48 . 60)) ((3 . 30) (88 . 57) (60 . 58) (93 . 59)
    (1 . -15)) ((1 . -30)) ((1 . -29)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) 
    (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) 
    (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) 
    (71 . 20) (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (48 . 24) (83 . 34) (41 . 35) (43 . 36) (45 . 37) 
    (46 . 38) (47 . 39) (86 . 40) (49 . 31) (8 . 32) (62 . 33) (87 . 42) 
    (105 . 52) (95 . 53) (98 . 54) (56 . 55) (96 . 56)) ((1 . -9)) ((1 . -8)) 
    ((58 . 0)) ((1 . -32)) ((1 . -31)) ((56 . 55) (96 . 152) (5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 153) (97 . 154)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 151)
    ) ((1 . -12)) ((48 . 24) (62 . 150)) ((3 . 30) (88 . 149) (1 . -128)) 
    ((1 . -14)) ((1 . -33)) ((1 . -35)) ((7 . 6) (91 . 147) (92 . 148)) 
    ((51 . 145) (52 . 146)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 144)) ((52 . 143))
    ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 142)) ((48 . 24) (49 . 31) 
    (8 . 32) (62 . 33) (95 . 141)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) 
    (95 . 140)) ((1 . -51)) ((7 . 6) (91 . 139) (1 . -47)) ((56 . 137) 
    (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) 
    (74 . 23) (75 . 138)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 136)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5)
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 135)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 134)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 133)) 
    ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 132)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 131)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5)
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 130)) 
    ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 129)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 128)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 127)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 126)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5)
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 125)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 124)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 123)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 122)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 121)) ((5 . 1) (6 . 2) (4 . 3) 
    (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) 
    (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 120)) 
    ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 119)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5)
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 118)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 117)) ((1 . -104)) ((1 . -105)) ((50 . 114) (5 . 1) (6 . 2) (4 . 3) 
    (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) 
    (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) 
    (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) 
    (86 . 115) (76 . 116)) ((7 . 6) (91 . 113)) ((11 . 92) (10 . 93) (51 . 94)
    (9 . 95) (1 . -100)) ((11 . 92) (10 . 93) (51 . 94) (9 . 95) (1 . -101)) 
    ((11 . 92) (10 . 93) (51 . 94) (9 . 95) (1 . -102)) ((50 . 112)) ((1 . 
    -113)) ((1 . -121)) ((49 . 111) (1 . -117)) ((53 . 110) (48 . 24) (62 . 
    107) (8 . 108) (63 . 109)) ((1 . -115)) ((34 . 106) (48 . 24) (62 . 107) 
    (8 . 108) (63 . 109)) ((1 . -116)) ((1 . -120)) ((1 . -119)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (33 . 25) (75 . 26) (86 . 101) (64 . 171)) ((1 . -114)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (33 . 25) 
    (75 . 26) (86 . 170)) ((1 . -112)) ((1 . -108)) ((1 . -107)) ((1 . -65)) 
    ((50 . 168) (49 . 169)) ((1 . -98)) ((1 . -97)) ((1 . -96)) ((1 . -95)) 
    ((1 . -94)) ((1 . -93)) ((1 . -92)) ((1 . -91)) ((20 . 84) (19 . 85) 
    (18 . 86) (17 . 87) (16 . 88) (15 . 89) (14 . 90) (13 . 91) (1 . -89)) 
    ((20 . 84) (19 . 85) (18 . 86) (17 . 87) (16 . 88) (15 . 89) (14 . 90) 
    (13 . 91) (1 . -88)) ((20 . 84) (19 . 85) (18 . 86) (17 . 87) (16 . 88) 
    (15 . 89) (14 . 90) (13 . 91) (1 . -87)) ((20 . 84) (19 . 85) (18 . 86) 
    (17 . 87) (16 . 88) (15 . 89) (14 . 90) (13 . 91) (1 . -86)) ((24 . 80) 
    (23 . 81) (22 . 82) (21 . 83) (1 . -84)) ((24 . 80) (23 . 81) (22 . 82) 
    (21 . 83) (1 . -83)) ((24 . 80) (23 . 81) (22 . 82) (21 . 83) (1 . -82)) 
    ((24 . 80) (23 . 81) (22 . 82) (21 . 83) (1 . -81)) ((28 . 76) (27 . 77) 
    (26 . 78) (25 . 79) (1 . -79)) ((28 . 76) (27 . 77) (26 . 78) (25 . 79) 
    (1 . -78)) ((30 . 74) (29 . 75) (1 . -76)) ((31 . 73) (1 . -74)) ((1 . -71
    )) ((32 . 72) (33 . 167) (1 . -69)) ((1 . -52)) ((84 . 166) (1 . -55)) 
    ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) 
    (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) 
    (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) 
    (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) 
    (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) 
    (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) 
    (105 . 46) (89 . 47) (100 . 153) (97 . 165)) ((5 . 1) (6 . 2) (4 . 3) 
    (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) 
    (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) 
    (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) 
    (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) 
    (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) 
    (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 153) 
    (97 . 164)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) 
    (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 163)) ((1 . -37)) ((7 . 6) 
    (91 . 147) (92 . 161) (50 . 162)) ((7 . 6) (91 . 160)) ((1 . -22)) 
    ((49 . 158) (53 . 159)) ((48 . 24) (62 . 157)) ((1 . -129)) ((1 . -13)) 
    ((1 . -11)) ((1 . -24)) ((56 . 55) (96 . 155) (5 . 1) (6 . 2) (4 . 3) 
    (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) 
    (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) 
    (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) 
    (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) 
    (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) 
    (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 156)) 
    ((1 . -10)) ((1 . -25)) ((1 . -130)) ((7 . 6) (91 . 188)) ((52 . 187)) 
    ((51 . 186)) ((50 . 185) (49 . 158)) ((48 . 24) (49 . 31) (8 . 32) 
    (62 . 33) (95 . 184)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 183)) 
    ((56 . 182) (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) 
    (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) 
    (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) 
    (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) 
    (88 . 44) (105 . 46) (89 . 47) (100 . 156)) ((56 . 178) (5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 156) (44 . 179) (37 . 180) (85 . 181)) ((56 . 175) (36 . 176) 
    (42 . 177)) ((56 . 173) (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (75 . 174)) ((1 . -106)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (33 . 25) 
    (75 . 26) (86 . 172)) ((1 . -122)) ((49 . 111) (1 . -118)) ((1 . -66)) 
    ((1 . -72)) ((32 . 72) (1 . -70)) ((1 . -45)) ((4 . 3) (6 . 2) (35 . 200) 
    (79 . 201) (80 . 202) (81 . 203)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) 
    (95 . 199)) ((1 . -43)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 153) (97 . 198)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (33 . 25) (75 . 26) (86 . 197)) ((44 . 194) (37 . 195) (56 . 196)) 
    ((1 . -39)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) 
    (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) 
    (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) 
    (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) 
    (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) 
    (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) 
    (88 . 44) (105 . 46) (89 . 47) (100 . 153) (97 . 193)) ((1 . -21)) 
    ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 192)) ((7 . 6) (91 . 147) 
    (92 . 190) (50 . 191)) ((7 . 6) (91 . 189)) ((1 . -23)) ((51 . 217)) 
    ((50 . 216) (49 . 158)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 215)
    ) ((1 . -20)) ((56 . 214) (5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 156)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 153) (97 . 213)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (33 . 25) (75 . 26) (86 . 212)) ((1 . -41)) 
    ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 211)) ((56 . 210) (5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) 
    (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) 
    (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) 
    (89 . 47) (100 . 156)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) 
    (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13) 
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 153) (97 . 209)) ((6 . 2) 
    (80 . 205) (78 . 206) (4 . 3) (79 . 207) (77 . 208)) ((1 . -58)) ((1 . -57
    )) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 204)) ((5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 153) (97 . 229)) ((1 . -61)) ((34 . 227) (6 . 2) (80 . 228)) 
    ((1 . -63)) ((34 . 225) (4 . 3) (79 . 226)) ((56 . 224) (5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 156)) ((1 . -42)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 153) (97 . 223)) ((48 . 24
    ) (49 . 31) (8 . 32) (62 . 33) (95 . 222)) ((56 . 221) (5 . 1) (6 . 2) 
    (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) 
    (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) (68 . 17) 
    (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) (48 . 24) 
    (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) (49 . 31) 
    (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) (46 . 38) 
    (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) (89 . 47) 
    (100 . 156)) ((1 . -38)) ((1 . -19)) ((48 . 24) (49 . 31) (8 . 32) 
    (62 . 33) (95 . 220)) ((7 . 6) (91 . 147) (92 . 218) (50 . 219)) ((50 . 
    232) (49 . 158)) ((48 . 24) (49 . 31) (8 . 32) (62 . 33) (95 . 231)) 
    ((1 . -18)) ((1 . -40)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 153) (97 . 230)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) 
    (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) 
    (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) 
    (89 . 47) (100 . 156) (1 . -53)) ((1 . -44)) ((1 . -60)) ((1 . -64)) 
    ((1 . -59)) ((1 . -62)) ((5 . 1) (6 . 2) (4 . 3) (59 . 4) (80 . 5) 
    (7 . 6) (35 . 7) (54 . 8) (51 . 9) (79 . 10) (66 . 11) (91 . 12) (67 . 13)
    (12 . 14) (24 . 15) (23 . 16) (68 . 17) (69 . 18) (70 . 19) (71 . 20) 
    (72 . 21) (73 . 22) (74 . 23) (48 . 24) (33 . 25) (75 . 26) (38 . 27) 
    (39 . 28) (40 . 29) (3 . 30) (49 . 31) (8 . 32) (62 . 33) (83 . 34) 
    (41 . 35) (43 . 36) (45 . 37) (46 . 38) (47 . 39) (86 . 40) (87 . 42) 
    (95 . 43) (88 . 44) (105 . 46) (89 . 47) (100 . 156) (1 . -56)) ((5 . 1) 
    (6 . 2) (4 . 3) (59 . 4) (80 . 5) (7 . 6) (35 . 7) (54 . 8) (51 . 9) 
    (79 . 10) (66 . 11) (91 . 12) (67 . 13) (12 . 14) (24 . 15) (23 . 16) 
    (68 . 17) (69 . 18) (70 . 19) (71 . 20) (72 . 21) (73 . 22) (74 . 23) 
    (48 . 24) (33 . 25) (75 . 26) (38 . 27) (39 . 28) (40 . 29) (3 . 30) 
    (49 . 31) (8 . 32) (62 . 33) (83 . 34) (41 . 35) (43 . 36) (45 . 37) 
    (46 . 38) (47 . 39) (86 . 40) (87 . 42) (95 . 43) (88 . 44) (105 . 46) 
    (89 . 47) (100 . 156) (1 . -54)) ((1 . -17)) ((48 . 24) (49 . 31) (8 . 32)
    (62 . 33) (95 . 233)) ((1 . -16))))

(define mlangia-tables
  (list
   (cons 'mtab mlangia-mtab)
   (cons 'ntab mlangia-ntab)
   (cons 'len-v mlangia-len-v)
   (cons 'rto-v mlangia-rto-v)
   (cons 'pat-v mlangia-pat-v)
   ))

;;; end tables
