/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "notesapplication.h"

#include <QCoreApplication>

NotesApplication::NotesApplication(QObject *parent) :
    QObject(parent)
{
    this->connect(QCoreApplication::instance(), SIGNAL(aboutToQuit()), SIGNAL(aboutToQuit()));
}

QString NotesApplication::applicationName() const
{
    return QCoreApplication::instance()->applicationName();
}

void NotesApplication::setApplicationName(QString &applicationName)
{
    QCoreApplication* application = QCoreApplication::instance();
    if (application->applicationName() != applicationName) {
        application->setApplicationName(applicationName);
        Q_EMIT applicationNameChanged();
    }
}
