<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [ElementHandle](./puppeteer.elementhandle.md)

## ElementHandle class

ElementHandle represents an in-page DOM element.

<b>Signature:</b>

```typescript
export declare class ElementHandle<ElementType extends Element = Element> extends JSHandle<ElementType> 
```
<b>Extends:</b> [JSHandle](./puppeteer.jshandle.md)&lt;ElementType&gt;

## Remarks

ElementHandles can be created with the [Page.$()](./puppeteer.page._.md) method.

```js
const puppeteer = require('puppeteer');

(async () => {
 const browser = await puppeteer.launch();
 const page = await browser.newPage();
 await page.goto('https://example.com');
 const hrefElement = await page.$('a');
 await hrefElement.click();
 // ...
})();

```
ElementHandle prevents the DOM element from being garbage-collected unless the handle is [disposed](./puppeteer.jshandle.dispose.md). ElementHandles are auto-disposed when their origin frame gets navigated.

ElementHandle instances can be used as arguments in [Page.$eval()](./puppeteer.page._eval.md) and [Page.evaluate()](./puppeteer.page.evaluate.md) methods.

If you're using TypeScript, ElementHandle takes a generic argument that denotes the type of element the handle is holding within. For example, if you have a handle to a `<select>` element, you can type it as `ElementHandle<HTMLSelectElement>` and you get some nicer type checks.

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `ElementHandle` class.

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [$(selector)](./puppeteer.elementhandle._.md) |  | Runs <code>element.querySelector</code> within the page. If no element matches the selector, the return value resolves to <code>null</code>. |
|  [$$(selector)](./puppeteer.elementhandle.__.md) |  | Runs <code>element.querySelectorAll</code> within the page. If no elements match the selector, the return value resolves to <code>[]</code>. |
|  [$$eval(selector, pageFunction, args)](./puppeteer.elementhandle.__eval.md) |  | This method runs <code>document.querySelectorAll</code> within the element and passes it as the first argument to <code>pageFunction</code>. If there's no element matching <code>selector</code>, the method throws an error.If <code>pageFunction</code> returns a Promise, then <code>frame.$$eval</code> would wait for the promise to resolve and return its value. |
|  [$eval(selector, pageFunction, args)](./puppeteer.elementhandle._eval.md) |  | This method runs <code>document.querySelector</code> within the element and passes it as the first argument to <code>pageFunction</code>. If there's no element matching <code>selector</code>, the method throws an error.If <code>pageFunction</code> returns a Promise, then <code>frame.$eval</code> would wait for the promise to resolve and return its value. |
|  [$x(expression)](./puppeteer.elementhandle._x.md) |  | The method evaluates the XPath expression relative to the elementHandle. If there are no such elements, the method will resolve to an empty array. |
|  [asElement()](./puppeteer.elementhandle.aselement.md) |  |  |
|  [boundingBox()](./puppeteer.elementhandle.boundingbox.md) |  | This method returns the bounding box of the element (relative to the main frame), or <code>null</code> if the element is not visible. |
|  [boxModel()](./puppeteer.elementhandle.boxmodel.md) |  | This method returns boxes of the element, or <code>null</code> if the element is not visible. |
|  [click(options)](./puppeteer.elementhandle.click.md) |  | This method scrolls element into view if needed, and then uses [Page.mouse](./puppeteer.page.mouse.md) to click in the center of the element. If the element is detached from DOM, the method throws an error. |
|  [clickablePoint()](./puppeteer.elementhandle.clickablepoint.md) |  |  |
|  [contentFrame()](./puppeteer.elementhandle.contentframe.md) |  | Resolves to the content frame for element handles referencing iframe nodes, or null otherwise |
|  [drag(target)](./puppeteer.elementhandle.drag.md) |  | This method creates and captures a dragevent from the element. |
|  [dragAndDrop(target, options)](./puppeteer.elementhandle.draganddrop.md) |  | This method triggers a dragenter, dragover, and drop on the element. |
|  [dragEnter(data)](./puppeteer.elementhandle.dragenter.md) |  | This method creates a <code>dragenter</code> event on the element. |
|  [dragOver(data)](./puppeteer.elementhandle.dragover.md) |  | This method creates a <code>dragover</code> event on the element. |
|  [drop(data)](./puppeteer.elementhandle.drop.md) |  | This method triggers a drop on the element. |
|  [focus()](./puppeteer.elementhandle.focus.md) |  | Calls [focus](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/focus) on the element. |
|  [hover()](./puppeteer.elementhandle.hover.md) |  | This method scrolls element into view if needed, and then uses [Page.mouse](./puppeteer.page.mouse.md) to hover over the center of the element. If the element is detached from DOM, the method throws an error. |
|  [isIntersectingViewport()](./puppeteer.elementhandle.isintersectingviewport.md) |  | Resolves to true if the element is visible in the current viewport. |
|  [press(key, options)](./puppeteer.elementhandle.press.md) |  | Focuses the element, and then uses [Keyboard.down()](./puppeteer.keyboard.down.md) and [Keyboard.up()](./puppeteer.keyboard.up.md). |
|  [screenshot(options)](./puppeteer.elementhandle.screenshot.md) |  | This method scrolls element into view if needed, and then uses [Page.screenshot()](./puppeteer.page.screenshot.md) to take a screenshot of the element. If the element is detached from DOM, the method throws an error. |
|  [select(values)](./puppeteer.elementhandle.select.md) |  | Triggers a <code>change</code> and <code>input</code> event once all the provided options have been selected. If there's no <code>&lt;select&gt;</code> element matching <code>selector</code>, the method throws an error. |
|  [tap()](./puppeteer.elementhandle.tap.md) |  | This method scrolls element into view if needed, and then uses [Touchscreen.tap()](./puppeteer.touchscreen.tap.md) to tap in the center of the element. If the element is detached from DOM, the method throws an error. |
|  [type(text, options)](./puppeteer.elementhandle.type.md) |  | Focuses the element, and then sends a <code>keydown</code>, <code>keypress</code>/<code>input</code>, and <code>keyup</code> event for each character in the text.To press a special key, like <code>Control</code> or <code>ArrowDown</code>, use [ElementHandle.press()](./puppeteer.elementhandle.press.md). |
|  [uploadFile(filePaths)](./puppeteer.elementhandle.uploadfile.md) |  | This method expects <code>elementHandle</code> to point to an [input element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input). |

