/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

public class XdmDestination
implements Destination {
    TreeModel treeModel = null;
    URI baseURI;
    Builder builder;

    public void setBaseURI(URI baseURI) {
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.baseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setTreeModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        TreeModel model = this.treeModel;
        if (model == null) {
            model = TreeModel.getTreeModel(config.getTreeModel());
        }
        this.builder = model.makeBuilder();
        if (this.baseURI != null) {
            this.builder.setBaseURI(this.baseURI.toString());
        }
        this.builder.setPipelineConfiguration(config.makePipelineConfiguration());
        return this.builder;
    }

    public XdmNode getXdmNode() {
        if (this.builder == null) {
            throw new IllegalStateException("The document has not yet been built");
        }
        return (XdmNode)XdmValue.wrap(this.builder.getCurrentRoot());
    }

    public void reset() {
        this.builder = null;
    }
}

