---
name: HISAT2
url: https://ccb.jhu.edu/software/hisat2/
description: >
  HISAT2 is a fast and sensitive alignment program for mapping NGS reads
  (both DNA and RNA) to reference genomes.
---

[HISAT2](https://ccb.jhu.edu/software/hisat2/)
is a fast and sensitive alignment program for mapping NGS reads
(both DNA and RNA) to a population of human genomes (as well as to a
single reference genome).

The HISAT2 MultiQC module parses summary statistics generated by
versions >= v2.1.0 where the command line option `--new-summary`
has been specified.

Note that running HISAT2 without this option (and older versions)
gives log output identical to Bowtie2. These logs are indistinguishable
and summary statistics will appear in MultiQC reports labelled as Bowtie2.
See GitHub issues on the [HISAT2 repository](https://github.com/infphilo/hisat2/issues/48)
and the [MultiQC repository](https://github.com/ewels/MultiQC/issues/221)
for more information.

HISAT2 does not report the input file names in the log, so MultiQC
takes the filename as the sample. Note that if you specify
`--summary-file` when running HISAT2 the same summary output
appears both there and in the `stdout`. So if you save both with
different names you may end up with duplicate samples in your
MultiQC report.
