// Copyright 2020, Collabora, Ltd.
// SPDX-License-Identifier: BSL-1.0
/*!
 * @file
 * @brief  IPC documentation.
 * @author Jakob Bornecrantz <jakob@collabora.com>
 * @ingroup ipc
 */

#pragma once


/*!
 * @defgroup ipc Inter-Process Communication
 * @ingroup xrt
 *
 * @brief Inter-Process Communication layer for Monado.
 */

/*!
 * @defgroup ipc_shared Shared IPC code
 * @ingroup ipc
 *
 * @brief Shared IPC code.
 */

/*!
 * @defgroup ipc_client Client IPC
 * @ingroup ipc
 *
 * @brief Client side IPC code.
 */

/*!
 * @defgroup ipc_server Server IPC
 * @ingroup ipc
 *
 * @brief Server side IPC code.
 */

/*!
 * @defgroup ipc_android Android IPC code
 * @ingroup ipc
 *
 * @brief Android IPC code.
 */

/*!
 * @dir xrt/ipc
 * @ingroup xrt
 *
 * @brief Inter-Process Communication layer
 */

/*!
 * @dir xrt/ipc/shared
 * @ingroup ipc
 *
 * @brief Inter-Process Communication layer shared code
 */

/*!
 * @dir xrt/ipc/server
 * @ingroup ipc
 *
 * @brief Inter-Process Communication layer server code
 */

/*!
 * @dir xrt/ipc/client
 * @ingroup ipc
 *
 * @brief Inter-Process Communication layer client code
 */

/*!
 * @dir xrt/ipc/android
 * @ingroup ipc
 *
 * @brief Inter-Process Communication layer android code
 */
