/*
 * Copyright (C) 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 * 
 * Author: Gerd Petermann
 * Create date: 2017-01-10
 */
package func;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.junit.Test;

import func.lib.Args;
import uk.me.parabola.splitter.Main;


/**
 * Compare file sizes with expected results. A very basic check that the size of
 * the output files has not changed. This can be used to make sure that a change
 * that is not expected to change the output does not do so.
 *
 * The sizes will have to be always changed when the output does change though.
 * 
 * 
 * @author Gerd Petermann
 */
public class SolverAndProblemGeneratorTest extends Base {
	
	/**
	 * @throws IOException 
	 */
	@Test
	public void testHamburg() throws IOException {
		runSplitter(Args.expectedHamburg, "--stop-after=gen-problem-list", Args.HAMBURG);
	}

	@Test
	public void testAlaska() throws IOException {
		runSplitter(Args.expectedAlaska,"--stop-after=gen-problem-list", Args.ALASKA);
	}

	@Test
	public void testAlaskaOverlap() throws IOException {
		runSplitter(Args.expectedAlaskaOverlap,"--stop-after=split","--keep-complete=false", Args.ALASKA);
	}

	@Test
	/** verifies that --max-areas has no effect on the output */
	public void testAlaskaMaxAreas7() throws IOException {
		runSplitter(Args.expectedAlaska,"--stop-after=gen-problem-list","--max-areas=5", Args.ALASKA);
	}


	private static void runSplitter(Map<String, Integer> expected, String... optArgs) throws IOException {
		List<String> argsList = new ArrayList<>(Arrays.asList(Args.MAIN_ARGS));
		for (String arg : optArgs)
			argsList.add(arg);
		
		Main.mainNoSystemExit(argsList.toArray(new String[argsList.size()]));
		
		for (Entry<String, Integer> entry : expected.entrySet()) {
			String f = entry.getKey();
			long expectedSize = entry.getValue();
			assertTrue("no " + f + " generated", new File(f).exists());
			List<String> lines = Files.readAllLines(Paths.get(f, ""));
			long realSize = 0;
			for (String l : lines) {
				realSize += l.length();
			}
			assertEquals(f + " has wrong size", expectedSize, realSize);
		}
	}

	@Test
	public void testNoSuchFile() {
		Main.mainNoSystemExit("no-such-file-xyz.osm");
		assertFalse("no file generated", new File(Args.DEF_AREAS_LIST).exists());
	}

}
