/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ObjectList
// Gilberto Camara - ECMWF Sep 97
//
// .NAME:
//  ObjectList
//
// .AUTHOR:
//  Gilberto Camara and Fernando Ii
//
// .SUMMARY:
//  A class for handling methods associated
//  with the ObjectList
//
// .CLIENTS:
//  Most modules in PlotMod
//
//
// .RESPONSABILITIES:
//  Provide configuration information for
//  other modules in PlotMod, by use of static methods
//
//
// .COLLABORATORS:
//
//
//
// .BASE CLASS:
//
//
// .DERIVED CLASSES:
//
//
// .REFERENCES:
//
//
#ifndef ObjectList_H
#define ObjectList_H

#include <MvRequest.h>
#include "MvIconDataBase.h"

class ObjectList
{
public:
    static MvRequest& Instance();

    static MvRequest Find(const Cached&, const Cached&);
    static MvRequest FindPlusChildren(const char*, const char*);

    static int FindAll(const Cached& name, MvRequest& out);

    static int FindAll(const Cached& name, const Cached& classe, MvRequest& out);

    static Cached Find(const Cached&, const Cached&, const Cached&);
    static string FindPlusChildren(const string&, const string&, const string&);

    static Cached FindMainRequestValue(const Cached& requestVerb,
                                       const Cached& parameter);

    static Cached FindGraphicsEngine(const MvRequest& reqst);
    static Cached FindView(const MvRequest& reqst);
    static MvRequest FindReqService(const char* classe, const char* action);
    static string FindService(const char* classe, const char* action);

    static Cached DefaultVisDefClass(const char* dataUnitVerb);

    static bool CheckValidVisDef(const char*, const char*, const char*);
    static bool CheckValidVisDef(const char*, const char*, int = 0);
    static bool CheckValidVisDefList(const char*, MvIconList&, const char* = 0);

    static void VisDefNDimFlags(int, vector<string>&);

    static MvRequest UserPreferencesRequest(const char*);
    static MvRequest UserDefaultRequest(const char*, bool expand = false);

    static MvRequest ExpandRequest(const MvRequest&, long);

    // Create a request in case there isn't one.
    // expandFlag = 0 means use the expand flag value from the ObjectList.
    static MvRequest CreateDefaultRequest(const char*, int expandFlag = 0, const char* path = 0);

    // Check objects
    static bool IsDataUnit(const Cached&);
    static bool IsImage(const char*);
    static bool IsService(const char*, const char* action = 0, bool context = false);
    static bool IsDefaultValue(MvRequest&, const char*);
    static bool IsWindow(const Cached&);
    static bool IsView(const Cached&);
    static bool IsGeographicalView(const string&);
    static bool IsVisDef(const Cached&);
    static bool IsVisDefContour(const char*);
    static bool IsVisDefIsotachs(const MvRequest&);
    static bool IsVisDefCoastlines(const Cached&);
    static bool IsVisDefText(const char*);
    static bool IsVisDefTextTitle(const MvRequest&);
    static bool IsVisDefTextAnnotation(const MvRequest&);
    static bool IsVisDefLegend(const char*);
    static bool IsVisDefImport(const char*);
    static bool IsVisDefAxis(const Cached&);
    static bool IsVisDefGraph(const Cached&);
    static bool IsLayer(const char*);
    static bool AreCompanions(const string&, const string&);
    static bool CalledFromMacro(const MvRequest&);
    static bool IsThermoView(const char*);
    static bool IsThermoGrid(const char*);
    static bool IsTaylorGrid(const char*);

    static Cached MacroName(const Cached& iconClass);
    static void GetCompanion(const string&, string&, string&, bool&);

private:
    // Contructor
    ObjectList();

    // Destructor
    ~ObjectList();
};

#endif
