/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Wastebasket_H
#define Wastebasket_H

#include "SystemFolder.h"

class Wastebasket : public SystemFolder
{
public:
    Wastebasket(Folder* parent, const IconClass& kind, const string& name, IconInfo* info);
    virtual ~Wastebasket();

    virtual void empty();

private:
    Wastebasket(const Wastebasket&);
    Wastebasket& operator=(const Wastebasket&);

    virtual bool adopt(IconObject*);
    virtual set<string> can();
};

inline void destroy(Wastebasket**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Wastebasket);
//#endif

#endif
