# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.executive import Executive


class DemandDrivenPipeline(Executive):
    r"""
    DemandDrivenPipeline - Executive supporting on-demand execution.
    
    Superclass: Executive
    
    DemandDrivenPipeline is an executive that will execute an
    algorithm only when its outputs are out-of-date with respect to its
    inputs.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDemandDrivenPipeline, obj, update, **traits)
    
    def get_release_data_flag(self, *args):
        """
        get_release_data_flag(self, port:int) -> int
        C++: virtual int get_release_data_flag(int port)
        Get whether the given output port releases data when it is
        consumed.
        """
        ret = self._wrap_call(self._vtk_obj.GetReleaseDataFlag, *args)
        return ret

    def set_release_data_flag(self, *args):
        """
        set_release_data_flag(self, port:int, n:int) -> int
        C++: virtual int set_release_data_flag(int port, int n)
        Set whether the given output port releases data when it is
        consumed.  Returns 1 if the value changes and 0 otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.SetReleaseDataFlag, *args)
        return ret

    def _get_pipeline_m_time(self):
        return self._vtk_obj.GetPipelineMTime()
    pipeline_m_time = traits.Property(_get_pipeline_m_time, desc=\
        r"""
        Get the pipeline_m_time for this exective.
        """
    )

    def DATA_NOT_GENERATED(self):
        """
        data__not__generated() -> InformationIntegerKey
        C++: static InformationIntegerKey *data__not__generated()
        Key to store a mark for an output that will not be generated.
        Algorithms use this to tell the executive that they will not
        generate certain outputs for a REQUEST_DATA.@ingroup
        information_keys
        """
        ret = wrap_vtk(self._vtk_obj.DATA_NOT_GENERATED())
        return ret
        

    def new_data_object(self, *args):
        """
        new_data_object(type:str) -> DataObject
        C++: static DataObject *new_data_object(const char *type)
        Create (New) and return a data object of the given type. This is
        here for backwards compatibility. Use
        DataObjectTypes::NewDataObject() instead.
        """
        ret = self._wrap_call(self._vtk_obj.NewDataObject, *args)
        return wrap_vtk(ret)

    def RELEASE_DATA(self):
        """
        release__data() -> InformationIntegerKey
        C++: static InformationIntegerKey *release__data()
        Key to specify in pipeline information the request that data be
        released after it is used.@ingroup information_keys
        """
        ret = wrap_vtk(self._vtk_obj.RELEASE_DATA())
        return ret
        

    def REQUEST_DATA(self):
        """
        request__data() -> InformationRequestKey
        C++: static InformationRequestKey *request__data()
        Key defining a request to make sure the output data are up to
        date.@ingroup information_keys
        """
        ret = wrap_vtk(self._vtk_obj.REQUEST_DATA())
        return ret
        

    def REQUEST_DATA_NOT_GENERATED(self):
        """
        request__data__not__generated() -> InformationRequestKey
        C++: static InformationRequestKey *request__data__not__generated()
        Key defining a request to mark outputs that will NOT be generated
        during a REQUEST_DATA.@ingroup information_keys
        """
        ret = wrap_vtk(self._vtk_obj.REQUEST_DATA_NOT_GENERATED())
        return ret
        

    def REQUEST_DATA_OBJECT(self):
        """
        request__data__object() -> InformationRequestKey
        C++: static InformationRequestKey *request__data__object()
        Key defining a request to make sure the output data objects
        exist.@ingroup information_keys
        """
        ret = wrap_vtk(self._vtk_obj.REQUEST_DATA_OBJECT())
        return ret
        

    def REQUEST_INFORMATION(self):
        """
        request__information() -> InformationRequestKey
        C++: static InformationRequestKey *request__information()
        Key defining a request to make sure the output information is up
        to date.@ingroup information_keys
        """
        ret = wrap_vtk(self._vtk_obj.REQUEST_INFORMATION())
        return ret
        

    def update_data(self, *args):
        """
        update_data(self, outputPort:int) -> int
        C++: virtual int update_data(int outputPort)
        Bring the output data up to date.  This should be called only
        when information is up to date.  Use the Update method if it is
        not known that the information is up to date.
        """
        ret = self._wrap_call(self._vtk_obj.UpdateData, *args)
        return ret

    def update_data_object(self):
        """
        update_data_object(self) -> int
        
        Bring the output data object's existence up to date.  This does
        not actually produce data, but does create the data object that
        will store data produced during the update_data step.
        """
        ret = self._vtk_obj.UpdateDataObject()
        return ret
        

    def update_pipeline_m_time(self):
        """
        update_pipeline_m_time(self) -> int
        C++: virtual int update_pipeline_m_time()
        Bring the pipeline_m_time up to date.
        """
        ret = self._vtk_obj.UpdatePipelineMTime()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DemandDrivenPipeline, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DemandDrivenPipeline properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit DemandDrivenPipeline properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DemandDrivenPipeline properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

