/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_GENERIC_PARSER_H
#define _TRANSLATE_GENERIC_PARSER_H

#include <glib.h>

typedef struct
{
  char		*tag;
  char		**target_tags;
} TranslateGenericLanguage;

typedef struct
{
  char		*name;
  char		*value;
} TranslateGenericHttpHeader;

typedef struct
{
  char		*url;
  char		*post;
  char		*content_type;
  GSList	*http_headers;
} TranslateGenericLocation;

typedef struct
{
  int				ref_count;

  GSList			*languages;
  GHashTable			*service_tags;

  GSList			*http_headers;
  
  TranslateGenericLocation	*text_location;
  GSList			*text_pre_markers;
  char				*text_post_marker;
  GSList			*text_error_markers;

  TranslateGenericLocation	*web_page_location;
} TranslateGenericGroup;

void translate_generic_parse (const char *filename);

TranslateGenericGroup *translate_generic_group_ref (TranslateGenericGroup *group);
void translate_generic_group_unref (TranslateGenericGroup *group);

const char *translate_generic_group_get_service_tag (TranslateGenericGroup *group,
						     const char *tag);

typedef gboolean (*TranslateGenericGroupForeachPairFunc) (const char *from,
							  const char *to,
							  gpointer user_data);
void translate_generic_group_foreach_pair (TranslateGenericGroup *group,
					   TranslateGenericGroupForeachPairFunc func,
					   gpointer user_data);

#endif /* _TRANSLATE_GENERIC_PARSER_H */
