package PDF::Builder::Resource::Font::CoreFont::timesbolditalic;

use strict;
use warnings;

our $VERSION = '3.026'; # VERSION
our $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::timesbolditalic - font-specific information for bold weight + italic Times font

=cut

sub data { return {
    'fontname' => 'Times-BoldItalic',
    'type' => 'Type1',
    'apiname' => 'TiBoIt',
    'ascender' => '683',
    'capheight' => '669',
    'descender' => '-217',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'italicangle' => '-15',
    'stdhw' => '42',
    'stdvw' => '121',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '462',
    'firstchar' => '32',
    'lastchar' => '255',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -200, -218, 996, 921 ],
# source: \Windows\Fonts\timesbi.ttf
# font underline position = -223
# CIDs 0 .. 3577 to be output
# fontbbox = (-547 -306 1400 1032)
    'wx' => { # HORIZ. WIDTH TABLE
	# +1  official .afm spec one larger than what TTF reports
	# (+1)  not in .afm spec, but increased (by 1) per base letter
	# -1  official .afm spec one smaller than what TTF reports
	# others as noted (.afm spec or original .pm plus some %)
        'A'       => 667,                                         # +1
        'AE'       => 944,                                        # +1
        'AEacute'       => 943,
        'AEmacron'       => 943,
        'Aacute'       => 667,                                    # +1
        'Abreve'       => 667,                                    # +1
        'Abreveacute'       => 667,                               # (+1)
        'Abrevecyrillic'       => 666,
        'Abrevedotbelow'       => 667,                            # (+1)
        'Abrevegrave'       => 667,                               # (+1)
        'Abrevehookabove'       => 667,                           # (+1)
        'Abrevetilde'       => 667,                               # (+1)
        'Acaron'       => 667,                                    # (+1)
        'Acircumflex'       => 667,                               # +1
        'Acircumflexacute'       => 667,                          # (+1)
        'Acircumflexdotbelow'       => 667,                       # (+1)
        'Acircumflexgrave'       => 667,                          # (+1)
        'Acircumflexhookabove'       => 667,                      # (+1)
        'Acircumflextilde'       => 667,                          # (+1)
        'Adblgrave'       => 667,                                 # (+1)
        'Adieresis'       => 667,                                 # +1
        'Adieresiscyrillic'       => 666,
        'Adieresismacron'       => 667,                           # (+1)
        'Adotbelow'       => 667,                                 # (+1)
        'Adotmacron'       => 667,                                # (+1)
        'Agrave'       => 667,                                    # +1
        'Ahookabove'       => 667,                                # (+1)
        'Aiecyrillic'       => 943,
        'Ainvertedbreve'       => 667,                            # (+1)
        'Alpha'       => 667,                                     # (+1)
        'Alphatonos'       => 667,                                # (+1)
        'Amacron'       => 667,                                   # +1
        'Aogonek'       => 667,                                   # +1
        'Aring'       => 667,                                     # +1
        'Aringacute'       => 667,                                # (+1)
        'Aringbelow'       => 667,                                # (+1)
        'Atilde'       => 667,                                    # +1
        'Aybarmenian'       => 732,
        'B'       => 667,                                         # +1
        'Bdotaccent'       => 667,                                # (+1)
        'Bdotbelow'       => 667,                                 # (+1)
        'Benarmenian'       => 705,
        'Beta'       => 667,                                      # (+1)
        'Bhook'       => 714,
        'Blinebelow'       => 667,                                # (+1)
        'Btopbar'       => 635,
        'C'       => 667,                                         # +1
        'Caarmenian'       => 729,
        'Cacute'       => 667,                                    # +1
        'Ccaron'       => 667,                                    # +1
        'Ccedilla'       => 667,                                  # +1
        'Ccedillaacute'       => 667,                             # (+1)
        'Ccircumflex'       => 667,                               # (+1)
        'Cdotaccent'       => 667,                                # (+1)
        'Chaarmenian'       => 690,
        'Cheabkhasiancyrillic'       => 873,
        'Chedescenderabkhasiancyrillic'       => 873,
        'Chedescendercyrillic'       => 748,
        'Chedieresiscyrillic'       => 748,
        'Cheharmenian'       => 719,
        'Chekhakassiancyrillic'       => 748,
        'Cheverticalstrokecyrillic'       => 748,
        'Chi'       => 666,
        'Chook'       => 667,                                     # (+1)
        'Coarmenian'       => 678,
        'D'       => 722,
        'DZ'       => 1333,
        'DZcaron'       => 1333,
        'Daarmenian'       => 760,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 455,
        'Delta'       => 592,                         # afm 612 was TTF 626
        'Dhook'       => 780,
        'Digammagreek'       => 666,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 633,
        'Dz'       => 1111,
        'Dzcaron'       => 1111,
        'Dzeabkhasiancyrillic'       => 540,
        'E'       => 667,                                         # +1
        'Eacute'       => 667,                                    # +1
        'Ebreve'       => 667,                                    # (+1)
        'Ecaron'       => 667,                                    # +1
        'Ecedillabreve'       => 667,                             # (+1)
        'Echarmenian'       => 690,
        'Ecircumflex'       => 667,                               # +1
        'Ecircumflexacute'       => 667,                          # (+1)
        'Ecircumflexbelow'       => 667,                          # (+1)
        'Ecircumflexdotbelow'       => 667,                       # (+1)
        'Ecircumflexgrave'       => 667,                          # (+1)
        'Ecircumflexhookabove'       => 667,                      # (+1)
        'Ecircumflextilde'       => 667,                          # (+1)
        'Edblgrave'       => 667,                                 # (+1)
        'Edieresis'       => 667,                                 # +1
        'Edotaccent'       => 667,                                # +1
        'Edotbelow'       => 667,                                 # (+1)
        'Egrave'       => 667,                                    # +1
        'Eharmenian'       => 632,
        'Ehookabove'       => 667,                                # (+1)
        'Eightroman'       => 1347,
        'Einvertedbreve'       => 667,                            # (+1)
        'Eiotifiedcyrillic'       => 1001,
        'Elevenroman'       => 1078,
        'Emacron'       => 667,                                   # +1
        'Emacronacute'       => 667,                              # (+1)
        'Emacrongrave'       => 667,                              # (+1)
        'Endescendercyrillic'       => 777,
        'Eng'       => 783,
        'Enghecyrillic'       => 995,
        'Enhookcyrillic'       => 777,
        'Eogonek'       => 667,                                   # +1
        'Eopen'       => 508,
        'Epsilon'       => 667,                                   # (+1)
        'Epsilontonos'       => 776,
        'Ereversed'       => 667,                                 # (+1)
        'Esdescendercyrillic'       => 666,
        'Esh'       => 619,
        'Eta'       => 777,
        'Etarmenian'       => 695,
        'Etatonos'       => 895,
        'Eth'       => 722,
        'Etilde'       => 667,                                    # (+1)
        'Etildebelow'       => 667,                               # (+1)
        'Euro'       => 500,
        'Ezh'       => 540,
        'Ezhcaron'       => 540,
        'Ezhreversed'       => 540,
        'F'       => 667,                                         # +1
        'Fdotaccent'       => 667,                                # (+1)
        'Feharmenian'       => 915,
        'Feicoptic'       => 708,
        'Fhook'       => 667,                                     # (+1)
        'Fiveroman'       => 667,                                 # (+1)
        'Fourroman'       => 1038,
        'G'       => 722,
        'Gacute'       => 722,
        'Gamma'       => 604,
        'Gammaafrican'       => 704,
        'Gangiacoptic'       => 696,
        'Gbreve'       => 722,
        'Gcaron'       => 722,
        'Gcircumflex'       => 722,
        'Gcommaaccent'       => 722,
        'Gdotaccent'       => 722,
        'Ghadarmenian'       => 760,
        'Ghemiddlehookcyrillic'       => 743,
        'Ghestrokecyrillic'       => 604,
        'Ghook'       => 722,
        'Gimarmenian'       => 755,
        'Gmacron'       => 722,
        'Gsmallhook'       => 500,
        'Gstroke'       => 722,
        'H'       => 778,                                         # +1
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 722,
        'Hadescendercyrillic'       => 666,
        'Hbar'       => 778,                                      # (+1)
        'Hbrevebelow'       => 778,                               # (+1)
        'Hcedilla'       => 778,                                  # (+1)
        'Hcircumflex'       => 778,                               # (+1)
        'Hdieresis'       => 778,                                 # (+1)
        'Hdotaccent'       => 778,                                # (+1)
        'Hdotbelow'       => 778,                                 # (+1)
        'Hoarmenian'       => 584,
        'Horicoptic'       => 589,
        'I'       => 389,
        'IJ'       => 822,
        'Iacute'       => 389,
        'Ibreve'       => 389,
        'Icaron'       => 389,
        'Icircumflex'       => 389,
        'Idblgrave'       => 389,
        'Idieresis'       => 389,
        'Idieresisacute'       => 389,
        'Idieresiscyrillic'       => 777,
        'Idotaccent'       => 389,
        'Idotbelow'       => 389,
        'Iebrevecyrillic'       => 666,
        'Ifraktur'       => 553,
        'Igrave'       => 389,
        'Ihookabove'       => 389,
        'Iinvertedbreve'       => 389,
        'Imacron'       => 389,
        'Imacroncyrillic'       => 777,
        'Iniarmenian'       => 670,
        'Iogonek'       => 389,
        'Iota'       => 389,
        'Iotaafrican'       => 277,
        'Iotadieresis'       => 389,
        'Iotatonos'       => 505,
        'Istroke'       => 389,
        'Itilde'       => 389,
        'Itildebelow'       => 389,
        'Izhitsadblgravecyrillic'       => 775,
        'J'       => 500,
        'Jaarmenian'       => 705,
        'Jcircumflex'       => 500,
        'Jheharmenian'       => 709,
        'K'       => 667,                                         # +1
        'Kabashkircyrillic'       => 820,
        'Kacute'       => 667,                                    # (+1)
        'Kadescendercyrillic'       => 678,
        'Kahookcyrillic'       => 678,
        'Kappa'       => 666,
        'Kastrokecyrillic'       => 678,
        'Kaverticalstrokecyrillic'       => 678,
        'Kcaron'       => 667,                                    # (+1)
        'Kcommaaccent'       => 667,                              # +1
        'Kdotbelow'       => 667,                                 # (+1)
        'Keharmenian'       => 796,
        'Kenarmenian'       => 691,
        'Kheicoptic'       => 748,
        'Khook'       => 667,                                     # (+1)
        'Klinebelow'       => 667,                                # (+1)
        'Koppacyrillic'       => 666,
        'Koppagreek'       => 516,
        'Ksicyrillic'       => 508,
        'L'       => 611,                                         # +1
        'LJ'       => 1110,
        'Lacute'       => 611,                                    # +1
        'Lambda'       => 666,
        'Lcaron'       => 611,                                    # +1
        'Lcircumflexbelow'       => 611,                          # (+1)
        'Lcommaaccent'       => 611,                              # +1
        'Ldot'       => 611,                                      # (+1)
        'Ldotbelow'       => 611,                                 # (+1)
        'Ldotbelowmacron'       => 611,                           # (+1)
        'Liwnarmenian'       => 562,
        'Lj'       => 888,
        'Llinebelow'       => 611,                                # (+1)
        'Lslash'       => 611,                                    # +1
        'M'       => 889,
        'Macute'       => 889,
        'Mdotaccent'       => 889,
        'Mdotbelow'       => 889,
        'Menarmenian'       => 838,
        'Mturned'       => 845,
        'Mu'       => 889,
        'N'       => 722,
        'NJ'       => 1222,
        'Nacute'       => 722,
        'Ncaron'       => 722,
        'Ncircumflexbelow'       => 722,
        'Ncommaaccent'       => 722,
        'Ndotaccent'       => 722,
        'Ndotbelow'       => 722,
        'Nhookleft'       => 722,
        'Nineroman'       => 1062,
        'Nj'       => 1000,
        'Nlinebelow'       => 722,
        'Nowarmenian'       => 751,
        'Ntilde'       => 722,
        'Nu'       => 722,
        'O'       => 722,
        'OE'       => 944,                                        # +1
        'Oacute'       => 722,
        'Obarredcyrillic'       => 722,
        'Obarreddieresiscyrillic'       => 722,
        'Obreve'       => 722,
        'Ocaron'       => 722,
        'Ocenteredtilde'       => 722,
        'Ocircumflex'       => 722,
        'Ocircumflexacute'       => 722,
        'Ocircumflexdotbelow'       => 722,
        'Ocircumflexgrave'       => 722,
        'Ocircumflexhookabove'       => 722,
        'Ocircumflextilde'       => 722,
        'Odblgrave'       => 722,
        'Odieresis'       => 722,
        'Odieresiscyrillic'       => 722,
        'Odotbelow'       => 722,
        'Ograve'       => 722,
        'Oharmenian'       => 770,
        'Ohookabove'       => 722,
        'Ohorn'       => 722,
        'Ohornacute'       => 722,
        'Ohorndotbelow'       => 722,
        'Ohorngrave'       => 722,
        'Ohornhookabove'       => 722,
        'Ohorntilde'       => 722,
        'Ohungarumlaut'       => 722,
        'Oi'       => 1017,
        'Oinvertedbreve'       => 722,
        'Omacron'       => 722,
        'Omacronacute'       => 722,
        'Omacrongrave'       => 722,
        'Omega'       => 746,
        'Omegacyrillic'       => 1141,
        'Omegaroundcyrillic'       => 831,
        'Omegatitlocyrillic'       => 1180,
        'Omegatonos'       => 785,
        'Omicron'       => 722,
        'Omicrontonos'       => 730,
        'Oneroman'       => 389,
        'Oogonek'       => 722,
        'Oogonekmacron'       => 722,
        'Oopen'       => 666,
        'Oslash'       => 722,
        'Oslashacute'       => 722,
        'Otcyrillic'       => 1141,
        'Otilde'       => 722,
        'Otildeacute'       => 722,
        'Otildedieresis'       => 722,
        'P'       => 611,                                         # +1
        'Pacute'       => 611,                                    # (+1)
        'Pdotaccent'       => 611,                                # (+1)
        'Peharmenian'       => 821,
        'Pemiddlehookcyrillic'       => 1128,
        'Phi'       => 789,
        'Phook'       => 663,
        'Pi'       => 777,
        'Piwrarmenian'       => 894,
        'Psi'       => 799,
        'Psicyrillic'       => 799,
        'Q'       => 722,
        'R'       => 667,                                         # +1
        'Raarmenian'       => 810,
        'Racute'       => 667,                                    # +1
        'Rcaron'       => 667,                                    # +1
        'Rcommaaccent'       => 667,                              # +1
        'Rdblgrave'       => 667,                                 # (+1)
        'Rdotaccent'       => 667,                                # (+1)
        'Rdotbelow'       => 667,                                 # (+1)
        'Rdotbelowmacron'       => 667,                           # (+1)
        'Reharmenian'       => 680,
        'Rfraktur'       => 794,
        'Rho'       => 610,
        'Rinvertedbreve'       => 667,                            # (+1)
        'Rlinebelow'       => 667,                                # (+1)
        'Rsmallinverted'       => 492,
        'Rsmallinvertedsuperior'       => 306,
        'S'       => 556,
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 615,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 556,
        'Sacutedotaccent'       => 556,
        'Sampigreek'       => 712,
        'Scaron'       => 556,
        'Scarondotaccent'       => 556,
        'Scedilla'       => 556,
        'Schwacyrillic'       => 722,
        'Schwadieresiscyrillic'       => 722,
        'Scircumflex'       => 556,
        'Scommaaccent'       => 556,
        'Sdotaccent'       => 556,
        'Sdotbelow'       => 556,
        'Sdotbelowdotaccent'       => 556,
        'Seharmenian'       => 706,
        'Sevenroman'       => 1290,
        'Shaarmenian'       => 690,
        'Sheicoptic'       => 845,
        'Shhacyrillic'       => 748,
        'Shimacoptic'       => 769,
        'Sigma'       => 619,
        'Sixroman'       => 1056,
        'Stigmagreek'       => 666,
        'T'       => 611,                                         # +1
        'Tau'       => 611,                                       # (+1)
        'Tbar'       => 611,                                      # (+1)
        'Tcaron'       => 611,                                    # +1
        'Tcedilla'       => 611,                                  # (+1)
        'Tcircumflexbelow'       => 611,                          # (+1)
        'Tcommaaccent'       => 611,                              # +1
        'Tdotaccent'       => 611,                                # (+1)
        'Tdotbelow'       => 611,                                 # (+1)
        'Tedescendercyrillic'       => 610,
        'Tenroman'       => 666,
        'Tetsecyrillic'       => 777,
        'Theta'       => 763,
        'Thook'       => 611,                                     # (+1)
        'Thorn'       => 611,                                     # +1
        'Threeroman'       => 1104,
        'Tiwnarmenian'       => 639,
        'Tlinebelow'       => 611,                                # (+1)
        'Toarmenian'       => 891,
        'Tonefive'       => 486,
        'Tonesix'       => 633,
        'Tonetwo'       => 556,
        'Tretroflexhook'       => 611,                            # (+1)
        'Twelveroman'       => 1278,
        'Tworoman'       => 747,
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 695,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 774,
        'Uhornacute'       => 774,
        'Uhorndotbelow'       => 774,
        'Uhorngrave'       => 774,
        'Uhornhookabove'       => 774,
        'Uhorntilde'       => 774,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 695,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1111,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 695,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 610,
        'Upsilon1'       => 724,
        'Upsilonacutehooksymbolgreek'       => 840,
        'Upsilonafrican'       => 746,
        'Upsilondieresis'       => 610,
        'Upsilondieresishooksymbolgreek'       => 724,
        'Upsilontonos'       => 750,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 610,
        'Ustraightstrokecyrillic'       => 610,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 667,                                         # +1
        'Vdotbelow'       => 667,                                 # (+1)
        'Vewarmenian'       => 748,
        'Vhook'       => 711,
        'Voarmenian'       => 706,
        'Vtilde'       => 667,                                    # (+1)
        'W'       => 889,
        'Wacute'       => 889,
        'Wcircumflex'       => 889,
        'Wdieresis'       => 889,
        'Wdotaccent'       => 889,
        'Wdotbelow'       => 889,
        'Wgrave'       => 889,
        'X'       => 667,                                         # +1
        'Xdieresis'       => 667,                                 # (+1)
        'Xdotaccent'       => 667,                                # (+1)
        'Xeharmenian'       => 979,
        'Xi'       => 659,
        'Y'       => 611,                                         # +1
        'Yacute'       => 611,                                    # +1
        'Ycircumflex'       => 611,                               # (+1)
        'Ydieresis'       => 611,                                 # +1
        'Ydotaccent'       => 611,                                # (+1)
        'Ydotbelow'       => 611,                                 # (+1)
        'Yerudieresiscyrillic'       => 969,
        'Ygrave'       => 611,                                    # (+1)
        'Yhook'       => 653,
        'Yhookabove'       => 611,                                # (+1)
        'Yiarmenian'       => 690,
        'Yiwnarmenian'       => 561,
        'Ytilde'       => 611,                                    # (+1)
        'Yusbigcyrillic'       => 917,
        'Yusbigiotifiedcyrillic'       => 1318,
        'Yuslittlecyrillic'       => 668,
        'Yuslittleiotifiedcyrillic'       => 1044,
        'Z'       => 611,                                         # +1
        'Zaarmenian'       => 717,
        'Zacute'       => 611,                                    # +1
        'Zcaron'       => 611,                                    # +1
        'Zcircumflex'       => 611,                               # (+1)
        'Zdotaccent'       => 611,                                # +1
        'Zdotbelow'       => 611,                                 # (+1)
        'Zedescendercyrillic'       => 508,
        'Zedieresiscyrillic'       => 508,
        'Zeta'       => 610,
        'Zhearmenian'       => 770,
        'Zhebrevecyrillic'       => 917,
        'Zhedescendercyrillic'       => 917,
        'Zhedieresiscyrillic'       => 917,
        'Zlinebelow'       => 611,                                # (+1)
        'Zstroke'       => 611,                                   # (+1)
        'a'       => 500,
        'aacute'       => 500,
        'abbreviationmarkarmenian'       => 557,
        'abreve'       => 500,
        'abreveacute'       => 500,
        'abrevecyrillic'       => 500,
        'abrevedotbelow'       => 500,
        'abrevegrave'       => 500,
        'abrevehookabove'       => 500,
        'abrevetilde'       => 500,
        'acaron'       => 500,
        'acircumflex'       => 500,
        'acircumflexacute'       => 500,
        'acircumflexdotbelow'       => 500,
        'acircumflexgrave'       => 500,
        'acircumflexhookabove'       => 500,
        'acircumflextilde'       => 500,
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 500,
        'adieresis'       => 500,
        'adieresiscyrillic'       => 500,
        'adieresismacron'       => 500,
        'adotbelow'       => 500,
        'adotmacron'       => 500,
        'ae'       => 722,
        'aeacute'       => 722,
        'aemacron'       => 722,
        'afii00208'       => 1000,
        'afii10017'       => 666,
        'afii10018'       => 635,
        'afii10019'       => 666,
        'afii10020'       => 604,
        'afii10021'       => 683,
        'afii10022'       => 666,
        'afii10023'       => 666,
        'afii10024'       => 917,
        'afii10025'       => 508,
        'afii10026'       => 777,
        'afii10027'       => 777,
        'afii10028'       => 678,
        'afii10029'       => 686,
        'afii10030'       => 889,
        'afii10031'       => 777,
        'afii10032'       => 722,
        'afii10033'       => 777,
        'afii10034'       => 610,
        'afii10035'       => 666,
        'afii10036'       => 610,
        'afii10037'       => 695,
        'afii10038'       => 850,
        'afii10039'       => 666,
        'afii10040'       => 777,
        'afii10041'       => 748,
        'afii10042'       => 1125,
        'afii10043'       => 1125,
        'afii10044'       => 760,
        'afii10045'       => 969,
        'afii10046'       => 633,
        'afii10047'       => 650,
        'afii10048'       => 1056,
        'afii10049'       => 688,
        'afii10050'       => 470,
        'afii10051'       => 817,
        'afii10052'       => 604,
        'afii10053'       => 657,
        'afii10054'       => 556,
        'afii10055'       => 389,
        'afii10056'       => 389,
        'afii10057'       => 500,
        'afii10058'       => 908,
        'afii10059'       => 976,
        'afii10060'       => 811,
        'afii10061'       => 678,
        'afii10062'       => 695,
        'afii10065'       => 500,
        'afii10066'       => 499,
        'afii10067'       => 446,
        'afii10068'       => 369,
        'afii10069'       => 496,
        'afii10070'       => 443,
        'afii10071'       => 443,
        'afii10072'       => 952,
        'afii10073'       => 390,
        'afii10074'       => 556,
        'afii10075'       => 556,
        'afii10076'       => 506,
        'afii10077'       => 513,
        'afii10078'       => 685,
        'afii10079'       => 555,
        'afii10080'       => 500,
        'afii10081'       => 556,
        'afii10082'       => 500,
        'afii10083'       => 443,
        'afii10084'       => 777,
        'afii10085'       => 443,
        'afii10086'       => 715,
        'afii10087'       => 500,
        'afii10088'       => 556,
        'afii10089'       => 524,
        'afii10090'       => 833,
        'afii10091'       => 833,
        'afii10092'       => 526,
        'afii10093'       => 693,
        'afii10094'       => 457,
        'afii10095'       => 415,
        'afii10096'       => 729,
        'afii10097'       => 515,
        'afii10098'       => 369,
        'afii10099'       => 522,
        'afii10100'       => 393,
        'afii10101'       => 415,
        'afii10102'       => 389,
        'afii10103'       => 277,
        'afii10104'       => 277,
        'afii10105'       => 277,
        'afii10106'       => 659,
        'afii10107'       => 712,
        'afii10108'       => 556,
        'afii10109'       => 506,
        'afii10110'       => 443,
        'afii10145'       => 777,
        'afii10146'       => 633,
        'afii10147'       => 722,
        'afii10148'       => 775,
        'afii10193'       => 556,
        'afii10194'       => 666,
        'afii10195'       => 500,
        'afii10196'       => 535,
        'afii10846'       => 443,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57636'       => 758,
        'afii57645'       => 375,
        'afii57658'       => 333,
        'afii57664'       => 517,
        'afii57665'       => 467,
        'afii57666'       => 377,
        'afii57667'       => 438,
        'afii57668'       => 512,
        'afii57669'       => 308,
        'afii57670'       => 321,
        'afii57671'       => 511,
        'afii57672'       => 515,
        'afii57673'       => 280,
        'afii57674'       => 447,
        'afii57675'       => 440,
        'afii57676'       => 443,
        'afii57677'       => 481,
        'afii57678'       => 525,
        'afii57679'       => 304,
        'afii57680'       => 321,
        'afii57681'       => 456,
        'afii57682'       => 507,
        'afii57683'       => 487,
        'afii57684'       => 453,
        'afii57685'       => 550,
        'afii57686'       => 486,
        'afii57687'       => 453,
        'afii57688'       => 468,
        'afii57689'       => 676,
        'afii57690'       => 503,
        'afii57694'       => 676,
        'afii57695'       => 676,
        'afii57700'       => 308,
        'afii57705'       => 560,
        'afii57716'       => 617,
        'afii57717'       => 588,
        'afii57718'       => 560,
        'afii57723'       => 308,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 333,
        'afii57929'       => 333,
        'afii61248'       => 833,
        'afii61289'       => 427,
        'afii61352'       => 915,
        'afii61573'       => 1000,
        'afii61574'       => 1000,
        'afii61575'       => 1000,
        'afii61664'       => 0,
        'afii64937'       => 333,
        'agrave'       => 500,
        'ahookabove'       => 500,
        'aiecyrillic'       => 722,
        'ainvertedbreve'       => 500,
        'alefdageshhebrew'       => 517,
        'aleflamedhebrew'       => 541,
        'alefpatahhebrew'       => 517,
        'alefqamatshebrew'       => 517,
        'aleph'       => 647,
        'alpha'       => 553,
        'alphatonos'       => 553,
        'amacron'       => 500,
        'ampersand'       => 778,                                 # +1
        'angstrom'       => 666,
        'anoteleia'       => 333,
        'aogonek'       => 500,
        'apostrophearmenian'       => 249,
        'approxequal'       => 548,
        'arighthalfring'       => 500,
        'aring'       => 500,
        'aringacute'       => 500,
        'aringbelow'       => 500,
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 569,
        'arrowheadleftmod'       => 569,
        'arrowheadrightmod'       => 569,
        'arrowheadupmod'       => 569,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 570,                               # +1
        'asciitilde'       => 570,                                # +1
        'ascript'       => 500,
        'ascriptturned'       => 500,
        'asterisk'       => 500,
        'asterism'       => 938,
        'at'       => 832,
        'atilde'       => 500,
        'aturned'       => 466,
        'aybarmenian'       => 779,
        'ayinaltonehebrew'       => 507,
        'b'       => 500,
        'backslash'       => 278,                                 # +1
        'bar'       => 220,
        'bdotaccent'       => 500,
        'bdotbelow'       => 500,
        'benarmenian'       => 537,
        'bernou'       => 926,
        'beta'       => 512,
        'betasymbolgreek'       => 512,
        'betdagesh'       => 467,
        'beth'       => 564,
        'betrafehebrew'       => 467,
        'bhook'       => 500,
        'bilabialclick'       => 722,
        'blinebelow'       => 500,
        'block'       => 708,
        'braceleft'       => 348,
        'braceright'       => 348,
        'bracketleft'       => 333,
        'bracketright'       => 333,
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 220,
        'bstroke'       => 500,
        'btopbar'       => 500,
        'bullet'       => 350,
        'c'       => 444,                                         # +1
        'caarmenian'       => 512,
        'cacute'       => 444,                                    # +1
        'candrabinducmb'       => 0,
        'caret'       => 312,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 444,                                    # +1
        'ccedilla'       => 444,                                  # +1
        'ccedillaacute'       => 444,                             # (+1)
        'ccircumflex'       => 444,                               # (+1)
        'ccurl'       => 444,                                     # (+1)
        'cdotaccent'       => 444,                                # (+1)
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 500,
        'centigrade'       => 1042,
        'chaarmenian'       => 272,
        'cheabkhasiancyrillic'       => 556,
        'chedescenderabkhasiancyrillic'       => 556,
        'chedescendercyrillic'       => 524,
        'chedieresiscyrillic'       => 524,
        'cheharmenian'       => 529,
        'chekhakassiancyrillic'       => 524,
        'cheverticalstrokecyrillic'       => 524,
        'chi'       => 464,
        'chook'       => 444,                                     # (+1)
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 248,
        'clickdental'       => 220,
        'clickretroflex'       => 389,
        'club'       => 656,
        'coarmenian'       => 495,
        'colon'       => 333,
        'colonmonetary'       => 666,
        'colontriangularhalfmod'       => 333,
        'colontriangularmod'       => 333,
        'comma'       => 250,
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
        'commaaccent'       => 250,
        'commaarmenian'       => 207,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 333,
        'copyright'       => 747,
        'copysr'       => 747,
        'cruzeiro'       => 666,
        'cstretched'       => 463,
        'currency'       => 500,
        'd'       => 500,
        'daarmenian'       => 560,
        'dagger'       => 500,
        'daggerdbl'       => 500,
        'daletdagesh'       => 438,
        'daleth'       => 571,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 555,
        'dblverticalbar'       => 345,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 608,                        # use afm, was TTF 748
        'dcedilla'       => 500,
        'dcircumflexbelow'       => 500,
        'dcroat'       => 500,
        'ddotaccent'       => 500,
        'ddotbelow'       => 500,
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 384,
        'delta'       => 512,
        'deltaturned'       => 512,
        'dezh'       => 827,
        'dhook'       => 500,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 570,                        # use afm, was TTF 548
        'dkshade'       => 729,
        'dlinebelow'       => 500,
        'dnblock'       => 708,
        'dollar'       => 500,
        'dong'       => 512,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 277,
        'dotlessjstrokehook'       => 331,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 500,
        'dtopbar'       => 500,
        'dz'       => 889,
        'dzaltone'       => 747,
        'dzcaron'       => 889,
        'dzcurl'       => 747,
        'dzeabkhasiancyrillic'       => 471,
        'e'       => 444,                                         # +1
        'eacute'       => 444,                                    # +1
        'ebreve'       => 444,                                    # (+1)
        'ecaron'       => 444,                                    # +1
        'ecedillabreve'       => 444,                             # (+1)
        'echarmenian'       => 516,
        'echyiwnarmenian'       => 605,
        'ecircumflex'       => 444,                               # +1
        'ecircumflexacute'       => 444,                          # (+1)
        'ecircumflexbelow'       => 444,                          # (+1)
        'ecircumflexdotbelow'       => 444,                       # (+1)
        'ecircumflexgrave'       => 444,                          # (+1)
        'ecircumflexhookabove'       => 444,                      # (+1)
        'ecircumflextilde'       => 444,                          # (+1)
        'edblgrave'       => 444,                                 # (+1)
        'edieresis'       => 444,                                 # +1
        'edotaccent'       => 444,                                # +1
        'edotbelow'       => 444,                                 # (+1)
        'egrave'       => 444,                                    # +1
        'eharmenian'       => 458,
        'ehookabove'       => 444,                                # (+1)
        'eight'       => 500,
        'eightinferior'       => 299,
        'eightroman'       => 1234,
        'eightsuperior'       => 299,
        'einvertedbreve'       => 444,                            # (+1)
        'eiotifiedcyrillic'       => 673,
        'elevenroman'       => 778,
        'ellipsis'       => 1000,
        'emacron'       => 444,                                   # +1
        'emacronacute'       => 444,                              # (+1)
        'emacrongrave'       => 444,                              # (+1)
        'emdash'       => 1000,
        'emphasismarkarmenian'       => 202,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 500,
        'endescendercyrillic'       => 555,
        'eng'       => 540,
        'enghecyrillic'       => 628,
        'enhookcyrillic'       => 555,
        'enspace'       => 500,
        'eogonek'       => 444,                                   # +1
        'eopen'       => 410,
        'eopenclosed'       => 457,
        'eopenreversed'       => 410,
        'eopenreversedclosed'       => 457,
        'eopenreversedhook'       => 547,
        'epsilon'       => 410,
        'epsilontonos'       => 410,
        'equal'       => 570,                                     # +1
        'equalsuperior'       => 299,
        'equivalence'       => 569,
        'ereversed'       => 444,                                 # (+1)
        'esdescendercyrillic'       => 443,
        'esh'       => 331,
        'eshcurl'       => 331,
        'eshreversedloop'       => 364,
        'eshsquatreversed'       => 292,
        'estimated'       => 600,
        'eta'       => 548,
        'etarmenian'       => 561,
        'etatonos'       => 548,
        'eth'       => 500,
        'etilde'       => 444,                                    # (+1)
        'etildebelow'       => 444,                               # (+1)
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 444,                                   # (+1)
        'exclam'       => 389,
        'exclamarmenian'       => 172,
        'exclamdbl'       => 659,
        'exclamdown'       => 389,
        'ezh'       => 471,
        'ezhcaron'       => 471,
        'ezhcurl'       => 471,
        'ezhreversed'       => 471,
        'ezhtail'       => 471,
        'f'       => 333,
        'fahrenheit'       => 987,
        'fdotaccent'       => 333,
        'feharmenian'       => 705,
        'feicoptic'       => 556,
        'female'       => 750,
        'ff'       => 598,
        'ffi'       => 840,
        'ffl'       => 840,
        'fi'       => 556,
        'figuredash'       => 500,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 447,
        'five'       => 500,
        'fiveeighths'       => 750,
        'fiveinferior'       => 299,
        'fiveroman'       => 443,
        'fivesuperior'       => 299,
        'fl'       => 556,
        'florin'       => 500,
        'four'       => 500,
        'fourinferior'       => 299,
        'fourroman'       => 719,
        'foursuperior'       => 299,
        'fourthtonechinese'       => 333,
        'frac15'       => 750,
        'frac16'       => 750,
        'frac25'       => 750,
        'frac35'       => 750,
        'frac45'       => 750,
        'frac56'       => 750,
        'fraction'       => 167,                                  # +1
        'franc'       => 500,
        'g'       => 500,
        'gacute'       => 500,
        'gamma'       => 416,
        'gammad'       => 463,
        'gammalatinsmall'       => 485,
        'gammasuperior'       => 315,
        'gangiacoptic'       => 566,
        'gbreve'       => 500,
        'gcaron'       => 500,
        'gcircumflex'       => 500,
        'gcommaaccent'       => 500,
        'gdotaccent'       => 500,
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 228,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 500,
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 432,
        'ghadarmenian'       => 549,
        'ghemiddlehookcyrillic'       => 505,
        'ghestrokecyrillic'       => 369,
        'ghook'       => 500,
        'gimarmenian'       => 522,
        'gimel'       => 451,
        'gimeldagesh'       => 377,
        'glottalinvertedstroke'       => 367,
        'glottalstop'       => 411,
        'glottalstopinverted'       => 411,
        'glottalstopmod'       => 274,
        'glottalstopreversed'       => 411,
        'glottalstopreversedmod'       => 274,
        'glottalstopreversedsuperior'       => 274,
        'glottalstopstroke'       => 411,
        'glottalstopstrokereversed'       => 411,
        'gmacron'       => 500,
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 570,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 500,
        'gstroke'       => 500,
        'guillemotleft'       => 500,
        'guillemotright'       => 500,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 556,
        'haabkhasiancyrillic'       => 498,
        'hadescendercyrillic'       => 500,
        'hairsp'       => 83,
        'hamilt'       => 905,
        'hbar'       => 556,
        'hbrevebelow'       => 556,
        'hcedilla'       => 556,
        'hcircumflex'       => 556,
        'hdieresis'       => 556,
        'hdotaccent'       => 556,
        'hdotbelow'       => 556,
        'heart'       => 593,
        'hedagesh'       => 512,
        'henghook'       => 556,
        'hhook'       => 556,
        'hhooksuperior'       => 288,
        'hlinebelow'       => 556,
        'hoarmenian'       => 550,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 589,
        'horncmb'       => 0,
        'house'       => 600,
        'hsuperior'       => 288,
        'hturned'       => 556,
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 790,
        'hybull'       => 333,
        'hyphen'       => 333,
        'hyphentwo'       => 333,
        'i'       => 278,                                         # +1
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 278,                                    # (+1)
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 556,
        'idotbelow'       => 278,                                 # (+1)
        'iebrevecyrillic'       => 443,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 278,                                # (+1)
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 552,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 556,
        'infinity'       => 712,
        'iniarmenian'       => 558,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 718,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 278,                                   # +1
        'iota'       => 277,
        'iotadieresis'       => 277,
        'iotadieresistonos'       => 277,
        'iotalatin'       => 277,
        'iotatonos'       => 277,
        'istroke'       => 278,                                   # (+1)
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 278,                               # (+1)
        'izhitsadblgravecyrillic'       => 535,
        'j'       => 278,                                         # +1
        'jaarmenian'       => 532,
        'jcaron'       => 278,                                    # (+1)
        'jcircumflex'       => 278,                               # (+1)
        'jcrossedtail'       => 278,                              # (+1)
        'jdotlessstroke'       => 278,                            # (+1)
        'jheharmenian'       => 454,
        'jsuperior'       => 186,
        'k'       => 500,
        'kabashkircyrillic'       => 574,
        'kacute'       => 500,
        'kadescendercyrillic'       => 506,
        'kafdagesh'       => 440,
        'kafrafehebrew'       => 440,
        'kahookcyrillic'       => 506,
        'kappa'       => 529,
        'kappasymbolgreek'       => 565,
        'kastrokecyrillic'       => 506,
        'kaverticalstrokecyrillic'       => 506,
        'kcaron'       => 500,
        'kcommaaccent'       => 500,
        'kdotbelow'       => 500,
        'keharmenian'       => 537,
        'kenarmenian'       => 520,
        'kgreenlandic'       => 500,
        'kheicoptic'       => 462,
        'khook'       => 500,
        'klinebelow'       => 500,
        'koppacyrillic'       => 443,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 390,
        'kturned'       => 500,
        'l'       => 278,                                         # +1
        'lacute'       => 278,                                    # +1
        'lagran'       => 708,
        'lambda'       => 443,
        'lambdastroke'       => 443,
        'lameddagesh'       => 443,
        'lbar'       => 278,                                      # (+1)
        'lbelt'       => 278,                                     # (+1)
        'lcaron'       => 382,                        # use afm, was TTF 520
        'lcircumflexbelow'       => 278,                          # (+1)
        'lcommaaccent'       => 278,                              # +1
        'ldot'       => 375,
        'ldotbelow'       => 278,                                 # (+1)
        'ldotbelowmacron'       => 278,                           # (+1)
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 570,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 598,
        'lfblock'       => 708,
        'lhookretroflex'       => 278,                            # (+1)
        'lira'       => 500,
        'liwnarmenian'       => 286,
        'lj'       => 555,
        'llinebelow'       => 278,                                # (+1)
        'lmiddletilde'       => 278,                              # (+1)
        'logicalnot'       => 606,                                # +1
        'longs'       => 333,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,
        'lslash'       => 278,                                    # +1
        'ltshade'       => 708,
        'm'       => 778,                                         # +1
        'macron'       => 500,                        # afm 333 too narrow
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 778,                                    # (+1)
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 778,                                # (+1)
        'mdotbelow'       => 778,                                 # (+1)
        'memdagesh'       => 525,
        'menarmenian'       => 561,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 778,                                     # (+1)
        'minus'       => 606,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 281,
        'mlonglegturned'       => 778,                            # (+1)
        'mturned'       => 778,                                   # (+1)
        'mu'       => 546,                            # afm 576, use TTF-10
        'multiply'       => 570,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 556,
        'nacute'       => 556,
        'napostrophe'       => 718,
        'ncaron'       => 556,
        'ncircumflexbelow'       => 556,
        'ncommaaccent'       => 556,
        'ndotaccent'       => 556,
        'ndotbelow'       => 556,
        'nhookleft'       => 556,
        'nhookretroflex'       => 556,
        'nine'       => 500,
        'nineinferior'       => 299,
        'nineroman'       => 779,
        'ninesuperior'       => 299,
        'nj'       => 833,
        'nlegrightlong'       => 548,
        'nlinebelow'       => 556,
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 549,
        'nsuperior'       => 347,
        'ntilde'       => 556,
        'nu'       => 443,
        'numbersign'       => 500,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 500,
        'nundagesh'       => 321,
        'o'       => 500,
        'oacute'       => 500,
        'obarred'       => 500,
        'obarredcyrillic'       => 500,
        'obarreddieresiscyrillic'       => 500,
        'obreve'       => 500,
        'ocaron'       => 500,
        'ocircumflex'       => 500,
        'ocircumflexacute'       => 500,
        'ocircumflexdotbelow'       => 500,
        'ocircumflexgrave'       => 500,
        'ocircumflexhookabove'       => 500,
        'ocircumflextilde'       => 500,
        'odblgrave'       => 500,
        'odieresis'       => 500,
        'odieresiscyrillic'       => 500,
        'odotbelow'       => 500,
        'oe'       => 722,
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 500,
        'oharmenian'       => 520,
        'ohookabove'       => 500,
        'ohorn'       => 536,
        'ohornacute'       => 536,
        'ohorndotbelow'       => 536,
        'ohorngrave'       => 536,
        'ohornhookabove'       => 536,
        'ohorntilde'       => 536,
        'ohungarumlaut'       => 500,
        'oi'       => 724,
        'oinvertedbreve'       => 500,
        'olehebrew'       => 0,
        'omacron'       => 500,
        'omacronacute'       => 500,
        'omacrongrave'       => 500,
        'omega'       => 723,
        'omega1'       => 756,
        'omegacyrillic'       => 570,
        'omegalatinclosed'       => 706,
        'omegaroundcyrillic'       => 592,
        'omegatitlocyrillic'       => 806,
        'omegatonos'       => 723,
        'omicron'       => 500,
        'omicrontonos'       => 500,
        'one'       => 500,
        'onedotenleader'       => 333,
        'oneeighth'       => 750,
        'onehalf'       => 750,
        'oneinferior'       => 299,
        'onequarter'       => 750,
        'oneroman'       => 277,
        'onesuperior'       => 300,                               # +1
        'onethird'       => 750,
        'oogonek'       => 500,
        'oogonekmacron'       => 500,
        'oopen'       => 443,
        'openbullet'       => 354,
        'order'       => 405,
        'ordfeminine'       => 266,
        'ordmasculine'       => 300,                              # +1
        'orthogonal'       => 979,
        'oslash'       => 500,
        'oslashacute'       => 500,
        'otcyrillic'       => 570,
        'otilde'       => 500,
        'otildeacute'       => 500,
        'otildedieresis'       => 500,
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 500,
        'pacute'       => 500,
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 389,
        'paragraph'       => 500,
        'parenleft'       => 333,
        'parenleftinferior'       => 199,
        'parenleftsuperior'       => 199,
        'parenright'       => 333,
        'parenrightinferior'       => 199,
        'parenrightsuperior'       => 199,
        'partialdiff'       => 494,
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 500,
        'pedagesh'       => 453,
        'pefinaldageshhebrew'       => 487,
        'peharmenian'       => 780,
        'pemiddlehookcyrillic'       => 763,
        'perafehebrew'       => 453,
        'percent'       => 833,
        'period'       => 250,
        'periodarmenian'       => 277,
        'periodcentered'       => 250,
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 968,
        'phi'       => 584,
        'phi1'       => 578,
        'philatin'       => 675,
        'phmmat'       => 1115,
        'phook'       => 500,
        'pi'       => 545,
        'piwrarmenian'       => 781,
        'planck'       => 556,
        'plus'       => 570,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 570,                     # use afm, was TTF 548
        'plusmod'       => 333,
        'plussuperior'       => 299,
        'prescription'       => 722,
        'primemod'       => 277,
        'primereversed'       => 281,
        'product'       => 823,
        'psi'       => 667,
        'psicyrillic'       => 667,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 250,
        'q'       => 500,
        'qadmahebrew'       => 0,
        'qarneyparahebrew'       => 0,
        'qhook'       => 500,
        'qofdagesh'       => 453,
        'question'       => 500,
        'questionarmenian'       => 302,
        'questiondown'       => 500,
        'questiongreek'       => 333,
        'quotedbl'       => 555,
        'quotedblbase'       => 500,
        'quotedblleft'       => 500,
        'quotedblright'       => 500,
        'quoteleft'       => 333,
        'quotereversed'       => 333,
        'quoteright'       => 333,
        'quotesinglbase'       => 333,
        'quotesingle'       => 278,                               # +1
        'r'       => 389,
        'raarmenian'       => 558,
        'racute'       => 389,
        'radical'       => 549,                                   # +1
        'ramshorn'       => 456,
        'rcaron'       => 389,
        'rcommaaccent'       => 389,
        'rdblgrave'       => 389,
        'rdotaccent'       => 389,
        'rdotbelow'       => 389,
        'rdotbelowmacron'       => 389,
        'referencemark'       => 1000,
        'registered'       => 747,
        'reharmenian'       => 561,
        'reshdageshhebrew'       => 468,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 569,
        'rfishhook'       => 423,
        'rfishhookreversed'       => 391,
        'rho'       => 515,
        'rhook'       => 389,
        'rhookturned'       => 389,
        'rhookturnedsuperior'       => 210,
        'rhosymbolgreek'       => 546,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 199,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 389,
        'rlinebelow'       => 389,
        'rlongleg'       => 389,
        'rlonglegturned'       => 389,
        'rtblock'       => 708,
        'rturned'       => 389,
        'rturnedsuperior'       => 210,
        's'       => 389,
        'sacute'       => 389,
        'sacutedotaccent'       => 389,
        'samekhdagesh'       => 456,
        'scaron'       => 389,
        'scarondotaccent'       => 389,
        'scedilla'       => 389,
        'schwadieresiscyrillic'       => 443,
        'schwahook'       => 582,
        'scircumflex'       => 389,
        'scommaaccent'       => 389,
        'sdotaccent'       => 389,
        'sdotbelow'       => 389,
        'sdotbelowdotaccent'       => 389,
        'seagullbelowcmb'       => 0,
        'second'       => 552,
        'secondtonechinese'       => 333,
        'section'       => 500,
        'segoltahebrew'       => 0,
        'seharmenian'       => 560,
        'semicolon'       => 333,
        'seven'       => 500,
        'seveneighths'       => 750,
        'seveninferior'       => 299,
        'sevenroman'       => 978,
        'sevensuperior'       => 299,
        'shaarmenian'       => 374,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheicoptic'       => 777,
        'shhacyrillic'       => 556,
        'shimacoptic'       => 530,
        'shindagesh'       => 676,
        'shindageshshindot'       => 676,
        'shindageshsindot'       => 676,
        'shook'       => 389,
        'sigma'       => 539,
        'sigma1'       => 445,
        'sigmalunatesymbolgreek'       => 443,
        'six'       => 500,
        'sixinferior'       => 299,
        'sixroman'       => 722,
        'sixsuperior'       => 299,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 333,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 250,
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 500,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 712,                     # afm 600, use TTF
        'sun'       => 916,
        't'       => 278,                                         # +1
        'tau'       => 443,
        'tavdages'       => 503,
        'tbar'       => 278,                                      # (+1)
        'tcaron'       => 366,                        # use afm, was TTF 531
        'tccurl'       => 653,
        'tcedilla'       => 278,                                  # (+1)
        'tcircumflexbelow'       => 278,                          # (+1)
        'tcommaaccent'       => 278,                              # +1
        'tdieresis'       => 278,                                 # (+1)
        'tdotaccent'       => 278,                                # (+1)
        'tdotbelow'       => 278,                                 # (+1)
        'tedescendercyrillic'       => 777,
        'telephone'       => 1196,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tenroman'       => 500,
        'tesh'       => 521,
        'tetdagesh'       => 515,
        'tetsecyrillic'       => 556,
        'tevirhebrew'       => 0,
        'theta'       => 519,
        'theta1'       => 527,
        'thook'       => 278,                                     # (+1)
        'thorn'       => 500,
        'thousandcyrillic'       => 437,
        'three'       => 500,
        'threeeighths'       => 750,
        'threeinferior'       => 299,
        'threequarters'       => 750,
        'threeroman'       => 790,
        'threesuperior'       => 300,                             # +1
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 781,
        'tlinebelow'       => 278,                                # (+1)
        'toarmenian'       => 698,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 383,
        'tonesix'       => 500,
        'tonetwo'       => 389,
        'tonos'       => 333,
        'tpalatalhook'       => 278,                              # (+1)
        'tprime'       => 555,
        'trademark'       => 1000,
        'tretroflexhook'       => 278,                            # (+1)
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 604,
        'tsadidagesh'       => 486,
        'tturned'       => 278,                                   # (+1)
        'twelveroman'       => 1035,
        'two'       => 500,
        'twodotenleader'       => 666,
        'twoinferior'       => 299,
        'tworoman'       => 534,
        'twostroke'       => 500,
        'twosuperior'       => 300,                               # +1
        'twothirds'       => 750,
        'u'       => 556,
        'uacute'       => 556,
        'ubar'       => 556,
        'ubreve'       => 556,
        'ucaron'       => 556,
        'ucircumflex'       => 556,
        'ucircumflexbelow'       => 556,
        'udblgrave'       => 556,
        'udieresis'       => 556,
        'udieresisacute'       => 556,
        'udieresisbelow'       => 556,
        'udieresiscaron'       => 556,
        'udieresiscyrillic'       => 443,
        'udieresisgrave'       => 556,
        'udieresismacron'       => 556,
        'udotbelow'       => 556,
        'ugrave'       => 556,
        'uhookabove'       => 556,
        'uhorn'       => 599,
        'uhornacute'       => 599,
        'uhorndotbelow'       => 599,
        'uhorngrave'       => 599,
        'uhornhookabove'       => 599,
        'uhorntilde'       => 599,
        'uhungarumlaut'       => 556,
        'uhungarumlautcyrillic'       => 443,
        'uinvertedbreve'       => 556,
        'ukcyrillic'       => 885,
        'umacron'       => 556,
        'umacroncyrillic'       => 443,
        'umacrondieresis'       => 556,
        'underscore'       => 500,
        'underscoredbl'       => 500,
        'uni01F6'       => 982,
        'uni01F7'       => 689,
        'uni01F8'       => 722,
        'uni01F9'       => 556,
        'uni021C'       => 590,
        'uni021D'       => 446,
        'uni021E'       => 777,
        'uni021F'       => 556,
        'uni0220'       => 742,
        'uni0221'       => 500,
        'uni0222'       => 655,
        'uni0223'       => 539,
        'uni0224'       => 610,
        'uni0225'       => 389,
        'uni0226'       => 666,
        'uni0227'       => 500,
        'uni0228'       => 666,
        'uni0229'       => 443,
        'uni022A'       => 722,
        'uni022B'       => 500,
        'uni022C'       => 722,
        'uni022D'       => 500,
        'uni022E'       => 722,
        'uni022F'       => 500,
        'uni0230'       => 722,
        'uni0231'       => 500,
        'uni0232'       => 610,
        'uni0233'       => 443,
        'uni0234'       => 277,
        'uni0235'       => 556,
        'uni0236'       => 277,
        'uni0238'       => 731,
        'uni0239'       => 734,
        'uni023A'       => 666,
        'uni023B'       => 666,
        'uni023C'       => 500,
        'uni023D'       => 610,
        'uni023E'       => 610,
        'uni023F'       => 389,
        'uni0240'       => 389,
        'uni0241'       => 508,
        'uni0242'       => 465,
        'uni0243'       => 666,
        'uni0244'       => 722,
        'uni0245'       => 666,
        'uni0246'       => 666,
        'uni0247'       => 443,
        'uni0248'       => 500,
        'uni0249'       => 277,
        'uni024A'       => 784,
        'uni024B'       => 500,
        'uni024C'       => 666,
        'uni024D'       => 389,
        'uni024E'       => 610,
        'uni024F'       => 443,
        'uni0262'       => 500,
        'uni026A'       => 296,
        'uni0274'       => 519,
        'uni0276'       => 669,
        'uni0280'       => 488,
        'uni028F'       => 379,
        'uni0299'       => 488,
        'uni029C'       => 578,
        'uni029F'       => 421,
        'uni02A9'       => 799,
        'uni02AA'       => 596,
        'uni02AB'       => 516,
        'uni02AC'       => 515,
        'uni02AD'       => 480,
        'uni02AE'       => 556,
        'uni02AF'       => 556,
        'uni02B3'       => 210,
        'uni02DF'       => 381,
        'uni02E1'       => 169,
        'uni02E2'       => 235,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 500,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 333,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 0,
        'uni0364'       => 0,
        'uni0365'       => 0,
        'uni0366'       => 0,
        'uni0367'       => 0,
        'uni0368'       => 0,
        'uni0369'       => 0,
        'uni036A'       => 0,
        'uni036B'       => 0,
        'uni036C'       => 0,
        'uni036D'       => 0,
        'uni036E'       => 0,
        'uni036F'       => 0,
        'uni0370'       => 577,
        'uni0371'       => 432,
        'uni0372'       => 615,
        'uni0373'       => 521,
        'uni0376'       => 777,
        'uni0377'       => 647,
        'uni037B'       => 443,
        'uni037C'       => 443,
        'uni037D'       => 443,
        'uni037F'       => 500,
        'uni03CF'       => 706,
        'uni03D7'       => 565,
        'uni03D8'       => 722,
        'uni03D9'       => 500,
        'uni03DB'       => 450,
        'uni03DF'       => 451,
        'uni03E1'       => 521,
        'uni03F4'       => 722,
        'uni03F5'       => 430,
        'uni03F6'       => 430,
        'uni03F7'       => 610,
        'uni03F8'       => 500,
        'uni03F9'       => 666,
        'uni03FA'       => 889,
        'uni03FB'       => 661,
        'uni03FC'       => 515,
        'uni03FD'       => 666,
        'uni03FE'       => 666,
        'uni03FF'       => 666,
        'uni0400'       => 666,
        'uni040D'       => 777,
        'uni0450'       => 443,
        'uni045D'       => 556,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 777,
        'uni048B'       => 556,
        'uni048C'       => 633,
        'uni048D'       => 457,
        'uni048E'       => 610,
        'uni048F'       => 500,
        'uni04C5'       => 686,
        'uni04C6'       => 513,
        'uni04C9'       => 777,
        'uni04CA'       => 555,
        'uni04CD'       => 889,
        'uni04CE'       => 685,
        'uni04CF'       => 277,
        'uni04EC'       => 650,
        'uni04ED'       => 415,
        'uni04F6'       => 604,
        'uni04F7'       => 369,
        'uni04FA'       => 604,
        'uni04FB'       => 369,
        'uni04FC'       => 666,
        'uni04FD'       => 500,
        'uni04FE'       => 666,
        'uni04FF'       => 500,
        'uni0500'       => 610,
        'uni0501'       => 500,
        'uni0502'       => 796,
        'uni0503'       => 749,
        'uni0504'       => 778,
        'uni0505'       => 685,
        'uni0506'       => 541,
        'uni0507'       => 390,
        'uni0508'       => 890,
        'uni0509'       => 748,
        'uni050A'       => 982,
        'uni050B'       => 734,
        'uni050C'       => 722,
        'uni050D'       => 500,
        'uni050E'       => 713,
        'uni050F'       => 957,
        'uni0510'       => 508,
        'uni0511'       => 401,
        'uni0512'       => 686,
        'uni0513'       => 513,
        'uni0514'       => 992,
        'uni0515'       => 730,
        'uni0516'       => 856,
        'uni0517'       => 680,
        'uni0518'       => 962,
        'uni0519'       => 693,
        'uni051A'       => 722,
        'uni051B'       => 500,
        'uni051C'       => 889,
        'uni051D'       => 666,
        'uni051E'       => 666,
        'uni051F'       => 529,
        'uni0520'       => 1002,
        'uni0521'       => 705,
        'uni0522'       => 1095,
        'uni0523'       => 746,
        'uni0524'       => 777,
        'uni0525'       => 556,
        'uni0526'       => 748,
        'uni0527'       => 556,
        'uni0528'       => 777,
        'uni0529'       => 555,
        'uni052A'       => 1325,
        'uni052B'       => 1072,
        'uni052C'       => 748,
        'uni052D'       => 521,
        'uni052E'       => 686,
        'uni052F'       => 513,
        'uni058A'       => 369,
        'uni058D'       => 934,
        'uni058E'       => 934,
        'uni058F'       => 760,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 321,
        'uni05C7'       => 0,
        'uni1D00'       => 411,
        'uni1D01'       => 585,
        'uni1D02'       => 722,
        'uni1D03'       => 487,
        'uni1D04'       => 464,
        'uni1D05'       => 536,
        'uni1D06'       => 536,
        'uni1D07'       => 480,
        'uni1D08'       => 390,
        'uni1D09'       => 277,
        'uni1D0A'       => 380,
        'uni1D0B'       => 504,
        'uni1D0C'       => 415,
        'uni1D0D'       => 661,
        'uni1D0E'       => 647,
        'uni1D0F'       => 500,
        'uni1D10'       => 452,
        'uni1D11'       => 495,
        'uni1D12'       => 495,
        'uni1D13'       => 495,
        'uni1D14'       => 722,
        'uni1D15'       => 439,
        'uni1D16'       => 500,
        'uni1D17'       => 500,
        'uni1D18'       => 468,
        'uni1D19'       => 492,
        'uni1D1A'       => 488,
        'uni1D1B'       => 389,
        'uni1D1C'       => 440,
        'uni1D1D'       => 478,
        'uni1D1E'       => 648,
        'uni1D1F'       => 487,
        'uni1D20'       => 418,
        'uni1D21'       => 590,
        'uni1D22'       => 349,
        'uni1D23'       => 390,
        'uni1D24'       => 401,
        'uni1D25'       => 549,
        'uni1D26'       => 393,
        'uni1D27'       => 416,
        'uni1D28'       => 609,
        'uni1D29'       => 468,
        'uni1D2A'       => 524,
        'uni1D2B'       => 513,
        'uni1D2C'       => 416,
        'uni1D2D'       => 575,
        'uni1D2E'       => 376,
        'uni1D2F'       => 376,
        'uni1D30'       => 421,
        'uni1D31'       => 386,
        'uni1D32'       => 386,
        'uni1D33'       => 420,
        'uni1D34'       => 429,
        'uni1D35'       => 220,
        'uni1D36'       => 300,
        'uni1D37'       => 412,
        'uni1D38'       => 364,
        'uni1D39'       => 535,
        'uni1D3A'       => 443,
        'uni1D3B'       => 456,
        'uni1D3C'       => 432,
        'uni1D3D'       => 409,
        'uni1D3E'       => 364,
        'uni1D3F'       => 416,
        'uni1D40'       => 361,
        'uni1D41'       => 442,
        'uni1D42'       => 555,
        'uni1D43'       => 299,
        'uni1D44'       => 299,
        'uni1D45'       => 299,
        'uni1D46'       => 443,
        'uni1D47'       => 289,
        'uni1D48'       => 300,
        'uni1D49'       => 276,
        'uni1D4A'       => 276,
        'uni1D4B'       => 268,
        'uni1D4C'       => 268,
        'uni1D4D'       => 285,
        'uni1D4E'       => 169,
        'uni1D4F'       => 278,
        'uni1D50'       => 451,
        'uni1D51'       => 300,
        'uni1D52'       => 292,
        'uni1D53'       => 270,
        'uni1D54'       => 292,
        'uni1D55'       => 292,
        'uni1D56'       => 301,
        'uni1D57'       => 187,
        'uni1D58'       => 298,
        'uni1D59'       => 317,
        'uni1D5A'       => 438,
        'uni1D5B'       => 259,
        'uni1D5C'       => 344,
        'uni1D5D'       => 294,
        'uni1D5E'       => 249,
        'uni1D5F'       => 297,
        'uni1D60'       => 335,
        'uni1D61'       => 287,
        'uni1D62'       => 169,
        'uni1D63'       => 223,
        'uni1D64'       => 298,
        'uni1D65'       => 259,
        'uni1D66'       => 294,
        'uni1D67'       => 249,
        'uni1D68'       => 318,
        'uni1D69'       => 335,
        'uni1D6A'       => 287,
        'uni1D6B'       => 734,
        'uni1D6C'       => 500,
        'uni1D6D'       => 500,
        'uni1D6E'       => 333,
        'uni1D6F'       => 777,
        'uni1D70'       => 556,
        'uni1D71'       => 500,
        'uni1D72'       => 389,
        'uni1D73'       => 423,
        'uni1D74'       => 389,
        'uni1D75'       => 277,
        'uni1D76'       => 389,
        'uni1D77'       => 500,
        'uni1D78'       => 377,
        'uni1D79'       => 512,
        'uni1D7A'       => 780,
        'uni1D7B'       => 296,
        'uni1D7C'       => 277,
        'uni1D7D'       => 500,
        'uni1D7E'       => 440,
        'uni1D7F'       => 547,
        'uni1D80'       => 500,
        'uni1D81'       => 500,
        'uni1D82'       => 452,
        'uni1D83'       => 598,
        'uni1D84'       => 500,
        'uni1D85'       => 277,
        'uni1D86'       => 777,
        'uni1D87'       => 556,
        'uni1D88'       => 500,
        'uni1D89'       => 389,
        'uni1D8A'       => 389,
        'uni1D8B'       => 433,
        'uni1D8C'       => 443,
        'uni1D8D'       => 500,
        'uni1D8E'       => 389,
        'uni1D8F'       => 500,
        'uni1D90'       => 500,
        'uni1D91'       => 500,
        'uni1D92'       => 443,
        'uni1D93'       => 410,
        'uni1D94'       => 410,
        'uni1D95'       => 443,
        'uni1D96'       => 277,
        'uni1D97'       => 443,
        'uni1D98'       => 331,
        'uni1D99'       => 556,
        'uni1D9A'       => 471,
        'uni1D9B'       => 299,
        'uni1D9C'       => 253,
        'uni1D9D'       => 253,
        'uni1D9E'       => 285,
        'uni1D9F'       => 268,
        'uni1DA0'       => 188,
        'uni1DA1'       => 188,
        'uni1DA2'       => 272,
        'uni1DA3'       => 288,
        'uni1DA4'       => 170,
        'uni1DA5'       => 170,
        'uni1DA6'       => 170,
        'uni1DA7'       => 170,
        'uni1DA8'       => 170,
        'uni1DA9'       => 170,
        'uni1DAA'       => 170,
        'uni1DAB'       => 249,
        'uni1DAC'       => 427,
        'uni1DAD'       => 427,
        'uni1DAE'       => 288,
        'uni1DAF'       => 288,
        'uni1DB0'       => 292,
        'uni1DB1'       => 292,
        'uni1DB2'       => 397,
        'uni1DB3'       => 234,
        'uni1DB4'       => 188,
        'uni1DB5'       => 188,
        'uni1DB6'       => 298,
        'uni1DB7'       => 315,
        'uni1DB8'       => 298,
        'uni1DB9'       => 298,
        'uni1DBA'       => 259,
        'uni1DBB'       => 242,
        'uni1DBC'       => 288,
        'uni1DBD'       => 288,
        'uni1DBE'       => 288,
        'uni1DBF'       => 292,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 333,
        'uni1E9D'       => 333,
        'uni1E9E'       => 742,
        'uni1E9F'       => 512,
        'uni1EFA'       => 923,
        'uni1EFB'       => 531,
        'uni1EFC'       => 566,
        'uni1EFD'       => 479,
        'uni1EFE'       => 650,
        'uni1EFF'       => 457,
        'uni1F00'       => 553,
        'uni1F01'       => 553,
        'uni1F02'       => 553,
        'uni1F03'       => 553,
        'uni1F04'       => 553,
        'uni1F05'       => 553,
        'uni1F06'       => 553,
        'uni1F07'       => 553,
        'uni1F08'       => 666,
        'uni1F09'       => 666,
        'uni1F0A'       => 715,
        'uni1F0B'       => 715,
        'uni1F0C'       => 666,
        'uni1F0D'       => 666,
        'uni1F0E'       => 666,
        'uni1F0F'       => 666,
        'uni1F10'       => 410,
        'uni1F11'       => 410,
        'uni1F12'       => 410,
        'uni1F13'       => 410,
        'uni1F14'       => 410,
        'uni1F15'       => 410,
        'uni1F18'       => 764,
        'uni1F19'       => 764,
        'uni1F1A'       => 959,
        'uni1F1B'       => 959,
        'uni1F1C'       => 959,
        'uni1F1D'       => 959,
        'uni1F20'       => 548,
        'uni1F21'       => 548,
        'uni1F22'       => 548,
        'uni1F23'       => 548,
        'uni1F24'       => 548,
        'uni1F25'       => 548,
        'uni1F26'       => 548,
        'uni1F27'       => 548,
        'uni1F28'       => 875,
        'uni1F29'       => 875,
        'uni1F2A'       => 1037,
        'uni1F2B'       => 1037,
        'uni1F2C'       => 1037,
        'uni1F2D'       => 1037,
        'uni1F2E'       => 1037,
        'uni1F2F'       => 1037,
        'uni1F30'       => 277,
        'uni1F31'       => 277,
        'uni1F32'       => 277,
        'uni1F33'       => 277,
        'uni1F34'       => 277,
        'uni1F35'       => 277,
        'uni1F36'       => 277,
        'uni1F37'       => 277,
        'uni1F38'       => 486,
        'uni1F39'       => 486,
        'uni1F3A'       => 682,
        'uni1F3B'       => 682,
        'uni1F3C'       => 682,
        'uni1F3D'       => 682,
        'uni1F3E'       => 682,
        'uni1F3F'       => 682,
        'uni1F40'       => 500,
        'uni1F41'       => 500,
        'uni1F42'       => 500,
        'uni1F43'       => 500,
        'uni1F44'       => 500,
        'uni1F45'       => 500,
        'uni1F48'       => 819,
        'uni1F49'       => 819,
        'uni1F4A'       => 1015,
        'uni1F4B'       => 1015,
        'uni1F4C'       => 917,
        'uni1F4D'       => 917,
        'uni1F50'       => 489,
        'uni1F51'       => 489,
        'uni1F52'       => 489,
        'uni1F53'       => 489,
        'uni1F54'       => 489,
        'uni1F55'       => 489,
        'uni1F56'       => 489,
        'uni1F57'       => 489,
        'uni1F59'       => 757,
        'uni1F5B'       => 903,
        'uni1F5D'       => 903,
        'uni1F5F'       => 903,
        'uni1F60'       => 723,
        'uni1F61'       => 723,
        'uni1F62'       => 723,
        'uni1F63'       => 723,
        'uni1F64'       => 723,
        'uni1F65'       => 723,
        'uni1F66'       => 723,
        'uni1F67'       => 723,
        'uni1F68'       => 843,
        'uni1F69'       => 843,
        'uni1F6A'       => 1039,
        'uni1F6B'       => 1039,
        'uni1F6C'       => 941,
        'uni1F6D'       => 941,
        'uni1F6E'       => 941,
        'uni1F6F'       => 941,
        'uni1F70'       => 553,
        'uni1F71'       => 553,
        'uni1F72'       => 410,
        'uni1F73'       => 410,
        'uni1F74'       => 548,
        'uni1F75'       => 548,
        'uni1F76'       => 277,
        'uni1F77'       => 277,
        'uni1F78'       => 500,
        'uni1F79'       => 500,
        'uni1F7A'       => 489,
        'uni1F7B'       => 489,
        'uni1F7C'       => 723,
        'uni1F7D'       => 723,
        'uni1F80'       => 553,
        'uni1F81'       => 553,
        'uni1F82'       => 553,
        'uni1F83'       => 553,
        'uni1F84'       => 553,
        'uni1F85'       => 553,
        'uni1F86'       => 553,
        'uni1F87'       => 553,
        'uni1F88'       => 666,
        'uni1F89'       => 666,
        'uni1F8A'       => 715,
        'uni1F8B'       => 715,
        'uni1F8C'       => 666,
        'uni1F8D'       => 666,
        'uni1F8E'       => 666,
        'uni1F8F'       => 666,
        'uni1F90'       => 548,
        'uni1F91'       => 548,
        'uni1F92'       => 548,
        'uni1F93'       => 548,
        'uni1F94'       => 548,
        'uni1F95'       => 548,
        'uni1F96'       => 548,
        'uni1F97'       => 548,
        'uni1F98'       => 875,
        'uni1F99'       => 875,
        'uni1F9A'       => 1037,
        'uni1F9B'       => 1037,
        'uni1F9C'       => 1037,
        'uni1F9D'       => 1037,
        'uni1F9E'       => 1037,
        'uni1F9F'       => 1037,
        'uni1FA0'       => 723,
        'uni1FA1'       => 723,
        'uni1FA2'       => 723,
        'uni1FA3'       => 723,
        'uni1FA4'       => 723,
        'uni1FA5'       => 723,
        'uni1FA6'       => 723,
        'uni1FA7'       => 723,
        'uni1FA8'       => 843,
        'uni1FA9'       => 843,
        'uni1FAA'       => 1039,
        'uni1FAB'       => 1039,
        'uni1FAC'       => 941,
        'uni1FAD'       => 941,
        'uni1FAE'       => 941,
        'uni1FAF'       => 941,
        'uni1FB0'       => 553,
        'uni1FB1'       => 553,
        'uni1FB2'       => 553,
        'uni1FB3'       => 553,
        'uni1FB4'       => 553,
        'uni1FB6'       => 553,
        'uni1FB7'       => 553,
        'uni1FB8'       => 666,
        'uni1FB9'       => 666,
        'uni1FBA'       => 666,
        'uni1FBB'       => 666,
        'uni1FBC'       => 666,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 548,
        'uni1FC3'       => 548,
        'uni1FC4'       => 548,
        'uni1FC6'       => 548,
        'uni1FC7'       => 548,
        'uni1FC8'       => 813,
        'uni1FC9'       => 813,
        'uni1FCA'       => 924,
        'uni1FCB'       => 924,
        'uni1FCC'       => 777,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 277,
        'uni1FD1'       => 277,
        'uni1FD2'       => 277,
        'uni1FD3'       => 277,
        'uni1FD6'       => 277,
        'uni1FD7'       => 277,
        'uni1FD8'       => 389,
        'uni1FD9'       => 389,
        'uni1FDA'       => 535,
        'uni1FDB'       => 584,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 489,
        'uni1FE1'       => 489,
        'uni1FE2'       => 489,
        'uni1FE3'       => 489,
        'uni1FE4'       => 515,
        'uni1FE5'       => 515,
        'uni1FE6'       => 489,
        'uni1FE7'       => 489,
        'uni1FE8'       => 610,
        'uni1FE9'       => 610,
        'uni1FEA'       => 708,
        'uni1FEB'       => 708,
        'uni1FEC'       => 708,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 723,
        'uni1FF3'       => 723,
        'uni1FF4'       => 723,
        'uni1FF6'       => 723,
        'uni1FF7'       => 723,
        'uni1FF8'       => 917,
        'uni1FF9'       => 819,
        'uni1FFA'       => 941,
        'uni1FFB'       => 843,
        'uni1FFC'       => 746,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni2011'       => 333,
        'uni201F'       => 500,
        'uni2023'       => 350,
        'uni2027'       => 250,
        'uni2028'       => 1000,
        'uni2029'       => 1000,
        'uni202A'       => 1000,
        'uni202B'       => 1000,
        'uni202F'       => 200,
        'uni2031'       => 1339,
        'uni2036'       => 552,
        'uni2037'       => 555,
        'uni2038'       => 312,
        'uni203D'       => 500,
        'uni203F'       => 956,
        'uni2040'       => 956,
        'uni2045'       => 333,
        'uni2046'       => 333,
        'uni2047'       => 902,
        'uni2048'       => 742,
        'uni2049'       => 777,
        'uni204A'       => 454,
        'uni204B'       => 500,
        'uni204C'       => 500,
        'uni204D'       => 500,
        'uni204E'       => 500,
        'uni204F'       => 299,
        'uni2050'       => 956,
        'uni2051'       => 500,
        'uni2052'       => 500,
        'uni2053'       => 569,
        'uni2054'       => 956,
        'uni2055'       => 500,
        'uni2056'       => 500,
        'uni2057'       => 761,
        'uni2058'       => 500,
        'uni2059'       => 571,
        'uni205A'       => 328,
        'uni205B'       => 852,
        'uni205C'       => 639,
        'uni205D'       => 328,
        'uni205E'       => 333,
        'uni205F'       => 222,
        'uni2060'       => 0,
        'uni2061'       => 1000,
        'uni2062'       => 1000,
        'uni2063'       => 1000,
        'uni2064'       => 1000,
        'uni2066'       => 1000,
        'uni2067'       => 1000,
        'uni2068'       => 1000,
        'uni2069'       => 1000,
        'uni206A'       => 1000,
        'uni206B'       => 1000,
        'uni206C'       => 1000,
        'uni206D'       => 1000,
        'uni206E'       => 1000,
        'uni206F'       => 1000,
        'uni2071'       => 170,
        'uni207B'       => 299,
        'uni208A'       => 299,
        'uni208B'       => 299,
        'uni208C'       => 299,
        'uni2090'       => 299,
        'uni2091'       => 276,
        'uni2092'       => 292,
        'uni2093'       => 339,
        'uni2094'       => 276,
        'uni2095'       => 333,
        'uni2096'       => 299,
        'uni2097'       => 166,
        'uni2098'       => 466,
        'uni2099'       => 333,
        'uni209A'       => 299,
        'uni209B'       => 233,
        'uni209C'       => 166,
        'uni20A0'       => 610,
        'uni20A5'       => 777,
        'uni20A6'       => 722,
        'uni20A8'       => 1120,
        'uni20AD'       => 666,
        'uni20AE'       => 610,
        'uni20AF'       => 1169,
        'uni20B0'       => 500,
        'uni20B1'       => 610,
        'uni20B2'       => 722,
        'uni20B3'       => 666,
        'uni20B4'       => 556,
        'uni20B5'       => 666,
        'uni20B6'       => 500,
        'uni20B7'       => 556,
        'uni20B8'       => 610,
        'uni20B9'       => 500,
        'uni20BA'       => 500,
        'uni20BB'       => 645,
        'uni20BC'       => 733,
        'uni20BD'       => 500,
        'uni20BE'       => 724,
        'uni20BF'       => 666,
        'uni20F0'       => 0,
        'uni2100'       => 856,
        'uni2101'       => 843,
        'uni2102'       => 722,
        'uni2104'       => 714,
        'uni2106'       => 925,
        'uni2107'       => 549,
        'uni2108'       => 650,
        'uni210A'       => 509,
        'uni210C'       => 987,
        'uni210D'       => 777,
        'uni210E'       => 556,
        'uni2110'       => 687,
        'uni2114'       => 802,
        'uni2115'       => 722,
        'uni2119'       => 610,
        'uni211A'       => 777,
        'uni211B'       => 926,
        'uni211D'       => 722,
        'uni211F'       => 666,
        'uni2120'       => 949,
        'uni2123'       => 666,
        'uni2124'       => 666,
        'uni2125'       => 471,
        'uni2127'       => 800,
        'uni2128'       => 713,
        'uni2129'       => 310,
        'uni212A'       => 666,
        'uni212D'       => 645,
        'uni212F'       => 384,
        'uni2130'       => 615,
        'uni2131'       => 687,
        'uni2132'       => 670,
        'uni2139'       => 326,
        'uni213A'       => 982,
        'uni213B'       => 1215,
        'uni213C'       => 547,
        'uni213D'       => 467,
        'uni213E'       => 636,
        'uni213F'       => 777,
        'uni2140'       => 729,
        'uni2141'       => 777,
        'uni2142'       => 610,
        'uni2143'       => 610,
        'uni2144'       => 666,
        'uni2145'       => 722,
        'uni2146'       => 500,
        'uni2147'       => 443,
        'uni2148'       => 277,
        'uni2149'       => 277,
        'uni214A'       => 701,
        'uni214B'       => 833,
        'uni214C'       => 883,
        'uni214D'       => 879,
        'uni214E'       => 480,
        'uni214F'       => 1340,
        'uni2150'       => 750,
        'uni2151'       => 750,
        'uni2152'       => 964,
        'uni215F'       => 458,
        'uni216C'       => 610,
        'uni216D'       => 666,
        'uni216E'       => 722,
        'uni216F'       => 889,
        'uni217C'       => 277,
        'uni217D'       => 443,
        'uni217E'       => 500,
        'uni217F'       => 777,
        'uni2180'       => 1042,
        'uni2181'       => 722,
        'uni2182'       => 1042,
        'uni2183'       => 654,
        'uni2184'       => 443,
        'uni2185'       => 696,
        'uni2186'       => 690,
        'uni2187'       => 756,
        'uni2188'       => 1130,
        'uni2189'       => 750,
        'uni218A'       => 500,
        'uni218B'       => 500,
        'uni2C60'       => 610,
        'uni2C61'       => 277,
        'uni2C62'       => 610,
        'uni2C63'       => 610,
        'uni2C64'       => 666,
        'uni2C65'       => 500,
        'uni2C66'       => 277,
        'uni2C67'       => 777,
        'uni2C68'       => 556,
        'uni2C69'       => 666,
        'uni2C6A'       => 500,
        'uni2C6B'       => 610,
        'uni2C6C'       => 389,
        'uni2C6D'       => 792,
        'uni2C6E'       => 889,
        'uni2C6F'       => 666,
        'uni2C70'       => 792,
        'uni2C71'       => 535,
        'uni2C72'       => 937,
        'uni2C73'       => 775,
        'uni2C74'       => 443,
        'uni2C75'       => 676,
        'uni2C76'       => 454,
        'uni2C77'       => 584,
        'uni2C78'       => 566,
        'uni2C79'       => 389,
        'uni2C7A'       => 500,
        'uni2C7B'       => 480,
        'uni2C7C'       => 186,
        'uni2C7D'       => 418,
        'uni2C7E'       => 556,
        'uni2C7F'       => 610,
        'uni2E00'       => 333,
        'uni2E01'       => 333,
        'uni2E02'       => 333,
        'uni2E03'       => 333,
        'uni2E04'       => 333,
        'uni2E05'       => 333,
        'uni2E06'       => 432,
        'uni2E07'       => 432,
        'uni2E08'       => 419,
        'uni2E09'       => 419,
        'uni2E0A'       => 419,
        'uni2E0B'       => 421,
        'uni2E0C'       => 421,
        'uni2E0D'       => 421,
        'uni2E0E'       => 838,
        'uni2E0F'       => 0,
        'uni2E10'       => 0,
        'uni2E11'       => 0,
        'uni2E12'       => 250,
        'uni2E13'       => 548,
        'uni2E14'       => 666,
        'uni2E15'       => 666,
        'uni2E16'       => 569,
        'uni2E17'       => 333,
        'uni2E18'       => 500,
        'uni2E19'       => 500,
        'uni2E1A'       => 333,
        'uni2E1B'       => 569,
        'uni2E1C'       => 421,
        'uni2E1D'       => 421,
        'uni2E1E'       => 569,
        'uni2E1F'       => 569,
        'uni2E20'       => 333,
        'uni2E21'       => 333,
        'uni2E22'       => 333,
        'uni2E23'       => 333,
        'uni2E24'       => 333,
        'uni2E25'       => 333,
        'uni2E26'       => 744,
        'uni2E27'       => 744,
        'uni2E28'       => 547,
        'uni2E29'       => 547,
        'uni2E2A'       => 571,
        'uni2E2B'       => 571,
        'uni2E2C'       => 571,
        'uni2E2D'       => 607,
        'uni2E2E'       => 500,
        'uni2E2F'       => 333,
        'uni2E30'       => 354,
        'uni2E31'       => 250,
        'uni2E32'       => 250,
        'uni2E33'       => 250,
        'uni2E34'       => 250,
        'uni2E35'       => 333,
        'uni2E36'       => 500,
        'uni2E37'       => 500,
        'uni2E38'       => 500,
        'uni2E39'       => 500,
        'uni2E3A'       => 1000,
        'uni2E3B'       => 1000,
        'uni2E3C'       => 250,
        'uni2E3D'       => 277,
        'uni2E3E'       => 277,
        'uni2E3F'       => 666,
        'uni2E40'       => 333,
        'uni2E41'       => 250,
        'uni2E42'       => 500,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 333,
        'uniA71E'       => 333,
        'uniA71F'       => 333,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 268,
        'uniA723'       => 220,
        'uniA724'       => 268,
        'uniA725'       => 220,
        'uniA726'       => 777,
        'uniA727'       => 556,
        'uniA728'       => 811,
        'uniA729'       => 630,
        'uniA72A'       => 508,
        'uniA72B'       => 508,
        'uniA72C'       => 453,
        'uniA72D'       => 453,
        'uniA72E'       => 567,
        'uniA72F'       => 567,
        'uniA730'       => 443,
        'uniA731'       => 458,
        'uniA732'       => 1091,
        'uniA733'       => 744,
        'uniA734'       => 1075,
        'uniA735'       => 744,
        'uniA736'       => 1022,
        'uniA737'       => 761,
        'uniA738'       => 910,
        'uniA739'       => 695,
        'uniA73A'       => 910,
        'uniA73B'       => 695,
        'uniA73C'       => 910,
        'uniA73D'       => 695,
        'uniA73E'       => 666,
        'uniA73F'       => 443,
        'uniA740'       => 666,
        'uniA741'       => 500,
        'uniA742'       => 666,
        'uniA743'       => 500,
        'uniA744'       => 666,
        'uniA745'       => 500,
        'uniA746'       => 757,
        'uniA747'       => 393,
        'uniA748'       => 610,
        'uniA749'       => 277,
        'uniA74A'       => 722,
        'uniA74B'       => 500,
        'uniA74C'       => 805,
        'uniA74D'       => 548,
        'uniA74E'       => 1186,
        'uniA74F'       => 784,
        'uniA750'       => 610,
        'uniA751'       => 500,
        'uniA752'       => 688,
        'uniA753'       => 622,
        'uniA754'       => 854,
        'uniA755'       => 810,
        'uniA756'       => 722,
        'uniA757'       => 500,
        'uniA758'       => 796,
        'uniA759'       => 593,
        'uniA75A'       => 674,
        'uniA75B'       => 493,
        'uniA75C'       => 591,
        'uniA75D'       => 488,
        'uniA75E'       => 666,
        'uniA75F'       => 443,
        'uniA760'       => 889,
        'uniA761'       => 666,
        'uniA762'       => 530,
        'uniA763'       => 501,
        'uniA764'       => 610,
        'uniA765'       => 500,
        'uniA766'       => 610,
        'uniA767'       => 500,
        'uniA768'       => 573,
        'uniA769'       => 431,
        'uniA76A'       => 438,
        'uniA76B'       => 438,
        'uniA76C'       => 575,
        'uniA76D'       => 575,
        'uniA76E'       => 500,
        'uniA76F'       => 500,
        'uniA770'       => 311,
        'uniA771'       => 669,
        'uniA772'       => 434,
        'uniA773'       => 924,
        'uniA774'       => 706,
        'uniA775'       => 423,
        'uniA776'       => 697,
        'uniA777'       => 734,
        'uniA778'       => 480,
        'uniA779'       => 722,
        'uniA77A'       => 500,
        'uniA77B'       => 525,
        'uniA77C'       => 389,
        'uniA77D'       => 510,
        'uniA77E'       => 505,
        'uniA77F'       => 505,
        'uniA780'       => 610,
        'uniA781'       => 277,
        'uniA782'       => 773,
        'uniA783'       => 556,
        'uniA784'       => 525,
        'uniA785'       => 389,
        'uniA786'       => 640,
        'uniA787'       => 414,
        'uniA788'       => 333,
        'uniA789'       => 333,
        'uniA78A'       => 374,
        'uniA78B'       => 277,
        'uniA78C'       => 277,
        'uniA78D'       => 777,
        'uniA78E'       => 489,
        'uniA78F'       => 250,
        'uniA790'       => 722,
        'uniA791'       => 556,
        'uniA792'       => 666,
        'uniA793'       => 443,
        'uniA794'       => 443,
        'uniA795'       => 556,
        'uniA796'       => 740,
        'uniA797'       => 654,
        'uniA798'       => 666,
        'uniA799'       => 333,
        'uniA79A'       => 788,
        'uniA79B'       => 545,
        'uniA79C'       => 747,
        'uniA79D'       => 520,
        'uniA79E'       => 788,
        'uniA79F'       => 552,
        'uniA7A0'       => 722,
        'uniA7A1'       => 500,
        'uniA7A2'       => 666,
        'uniA7A3'       => 500,
        'uniA7A4'       => 722,
        'uniA7A5'       => 556,
        'uniA7A6'       => 666,
        'uniA7A7'       => 389,
        'uniA7A8'       => 556,
        'uniA7A9'       => 389,
        'uniA7AA'       => 836,
        'uniA7AB'       => 508,
        'uniA7AC'       => 792,
        'uniA7AD'       => 685,
        'uniA7AE'       => 610,
        'uniA7B0'       => 666,
        'uniA7B1'       => 610,
        'uniA7B2'       => 500,
        'uniA7B3'       => 697,
        'uniA7B4'       => 666,
        'uniA7B5'       => 512,
        'uniA7B6'       => 950,
        'uniA7B7'       => 723,
        'uniA7F7'       => 681,
        'uniA7F8'       => 472,
        'uniA7F9'       => 473,
        'uniA7FA'       => 777,
        'uniA7FB'       => 666,
        'uniA7FC'       => 610,
        'uniA7FD'       => 889,
        'uniA7FE'       => 389,
        'uniA7FF'       => 1137,
        'uniAB30'       => 558,
        'uniAB31'       => 699,
        'uniAB32'       => 433,
        'uniAB33'       => 443,
        'uniAB34'       => 585,
        'uniAB35'       => 333,
        'uniAB36'       => 500,
        'uniAB37'       => 391,
        'uniAB38'       => 327,
        'uniAB39'       => 309,
        'uniAB3A'       => 769,
        'uniAB3B'       => 532,
        'uniAB3C'       => 519,
        'uniAB3D'       => 497,
        'uniAB3E'       => 497,
        'uniAB3F'       => 500,
        'uniAB40'       => 750,
        'uniAB41'       => 722,
        'uniAB42'       => 722,
        'uniAB43'       => 784,
        'uniAB44'       => 784,
        'uniAB45'       => 531,
        'uniAB46'       => 566,
        'uniAB47'       => 364,
        'uniAB48'       => 520,
        'uniAB49'       => 446,
        'uniAB4A'       => 640,
        'uniAB4B'       => 447,
        'uniAB4C'       => 623,
        'uniAB4D'       => 331,
        'uniAB4E'       => 556,
        'uniAB4F'       => 556,
        'uniAB50'       => 777,
        'uniAB51'       => 777,
        'uniAB52'       => 556,
        'uniAB53'       => 464,
        'uniAB54'       => 461,
        'uniAB55'       => 461,
        'uniAB56'       => 500,
        'uniAB57'       => 500,
        'uniAB58'       => 500,
        'uniAB59'       => 500,
        'uniAB5A'       => 443,
        'uniAB5B'       => 333,
        'uniAB5C'       => 321,
        'uniAB5D'       => 242,
        'uniAB5E'       => 242,
        'uniAB5F'       => 327,
        'uniAB60'       => 693,
        'uniAB61'       => 702,
        'uniAB62'       => 710,
        'uniAB63'       => 804,
        'uniAB64'       => 538,
        'uniAB65'       => 605,
        'uniF301'       => 0,
        'uniFB05'       => 563,
        'uniFB06'       => 657,
        'uniFB13'       => 1110,
        'uniFB14'       => 1066,
        'uniFB15'       => 1108,
        'uniFB16'       => 1096,
        'uniFB17'       => 1347,
        'uniFB1D'       => 280,
        'uniFB1E'       => 0,
        'uniFB21'       => 664,
        'uniFB22'       => 585,
        'uniFB23'       => 658,
        'uniFB24'       => 586,
        'uniFB25'       => 589,
        'uniFB26'       => 627,
        'uniFB27'       => 615,
        'uniFB28'       => 649,
        'uniFB29'       => 569,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFFFC'       => 1000,
        'uogonek'       => 556,
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 489,
        'upsilondieresis'       => 489,
        'upsilondieresistonos'       => 489,
        'upsilonlatin'       => 547,
        'upsilontonos'       => 489,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 556,
        'ustraightcyrillic'       => 500,
        'ustraightstrokecyrillic'       => 500,
        'utilde'       => 556,
        'utildeacute'       => 556,
        'utildebelow'       => 556,
        'v'       => 444,                                         # +1
        'vdotbelow'       => 444,                                 # (+1)
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 546,
        'vhook'       => 489,
        'voarmenian'       => 562,
        'vtilde'       => 444,                                    # (+1)
        'vturned'       => 444,                                   # (+1)
        'w'       => 667,                                         # +1
        'wacute'       => 667,                                    # (+1)
        'wcircumflex'       => 667,                               # (+1)
        'wdieresis'       => 667,                                 # (+1)
        'wdotaccent'       => 667,                                # (+1)
        'wdotbelow'       => 667,                                 # (+1)
        'weierstrass'       => 740,
        'wgrave'       => 667,                                    # (+1)
        'won'       => 889,
        'wring'       => 667,                                     # (+1)
        'wsuperior'       => 387,
        'wturned'       => 667,                                   # (+1)
        'wynn'       => 504,
        'x'       => 500,
        'xabovecmb'       => 0,
        'xdieresis'       => 500,
        'xdotaccent'       => 500,
        'xeharmenian'       => 797,
        'xi'       => 449,
        'xsuperior'       => 339,
        'y'       => 444,                                         # +1
        'yacute'       => 444,                                    # +1
        'ycircumflex'       => 444,                               # (+1)
        'ydieresis'       => 444,                                 # +1
        'ydotaccent'       => 444,                                # (+1)
        'ydotbelow'       => 444,                                 # (+1)
        'yen'       => 500,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 693,
        'yetivhebrew'       => 0,
        'ygrave'       => 444,                                    # (+1)
        'yhook'       => 467,
        'yhookabove'       => 444,                                # (+1)
        'yiarmenian'       => 278,
        'yiwnarmenian'       => 389,
        'yoddagesh'       => 280,
        'yotgreek'       => 277,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 610,
        'yring'       => 444,                                     # (+1)
        'ysuperior'       => 270,
        'ytilde'       => 444,                                    # (+1)
        'yturned'       => 444,                                   # (+1)
        'yusbigcyrillic'       => 680,
        'yusbigiotifiedcyrillic'       => 983,
        'yuslittlecyrillic'       => 564,
        'yuslittleiotifiedcyrillic'       => 862,
        'z'       => 389,
        'zaarmenian'       => 506,
        'zacute'       => 389,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 321,
        'zcaron'       => 389,
        'zcircumflex'       => 389,
        'zcurl'       => 389,
        'zdotaccent'       => 389,
        'zdotbelow'       => 389,
        'zedescendercyrillic'       => 390,
        'zedieresiscyrillic'       => 390,
        'zero'       => 500,
        'zeroinferior'       => 299,
        'zerosuperior'       => 299,
        'zerowidthspace'       => 0,
        'zeta'       => 440,
        'zhearmenian'       => 514,
        'zhebrevecyrillic'       => 952,
        'zhedescendercyrillic'       => 952,
        'zhedieresiscyrillic'       => 952,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 389,
        'zretroflexhook'       => 389,
        'zstroke'       => 389,
    },
    'wxold' => { # HORIZ. WIDTH TABLE
        'space' => '250',                        # C+0x20 # U+0x0020
        'exclam' => '389',                       # C+0x21 # U+0x0021
        'quotedbl' => '555',                     # C+0x22 # U+0x0022
        'numbersign' => '500',                   # C+0x23 # U+0x0023
        'dollar' => '500',                       # C+0x24 # U+0x0024
        'percent' => '833',                      # C+0x25 # U+0x0025
        'ampersand' => '777',                    # C+0x26 # U+0x0026
        'quotesingle' => '277',                  # C+0x27 # U+0x0027
        'parenleft' => '333',                    # C+0x28 # U+0x0028
        'parenright' => '333',                   # C+0x29 # U+0x0029
        'asterisk' => '500',                     # C+0x2A # U+0x002A
        'plus' => '569',                         # C+0x2B # U+0x002B
        'comma' => '250',                        # C+0x2C # U+0x002C
        'hyphen' => '333',                       # C+0x2D # U+0x002D
        'period' => '250',                       # C+0x2E # U+0x002E
        'slash' => '277',                        # C+0x2F # U+0x002F
        'zero' => '500',                         # C+0x30 # U+0x0030
        'one' => '500',                          # C+0x31 # U+0x0031
        'two' => '500',                          # C+0x32 # U+0x0032
        'three' => '500',                        # C+0x33 # U+0x0033
        'four' => '500',                         # C+0x34 # U+0x0034
        'five' => '500',                         # C+0x35 # U+0x0035
        'six' => '500',                          # C+0x36 # U+0x0036
        'seven' => '500',                        # C+0x37 # U+0x0037
        'eight' => '500',                        # C+0x38 # U+0x0038
        'nine' => '500',                         # C+0x39 # U+0x0039
        'colon' => '333',                        # C+0x3A # U+0x003A
        'semicolon' => '333',                    # C+0x3B # U+0x003B
        'less' => '569',                         # C+0x3C # U+0x003C
        'equal' => '569',                        # C+0x3D # U+0x003D
        'greater' => '569',                      # C+0x3E # U+0x003E
        'question' => '500',                     # C+0x3F # U+0x003F
        'at' => '832',                           # C+0x40 # U+0x0040
        'A' => '666',                            # C+0x41 # U+0x0041
        'B' => '666',                            # C+0x42 # U+0x0042
        'C' => '666',                            # C+0x43 # U+0x0043
        'D' => '722',                            # C+0x44 # U+0x0044
        'E' => '666',                            # C+0x45 # U+0x0045
        'F' => '666',                            # C+0x46 # U+0x0046
        'G' => '722',                            # C+0x47 # U+0x0047
        'H' => '777',                            # C+0x48 # U+0x0048
        'I' => '389',                            # C+0x49 # U+0x0049
        'J' => '500',                            # C+0x4A # U+0x004A
        'K' => '666',                            # C+0x4B # U+0x004B
        'L' => '610',                            # C+0x4C # U+0x004C
        'M' => '889',                            # C+0x4D # U+0x004D
        'N' => '722',                            # C+0x4E # U+0x004E
        'O' => '722',                            # C+0x4F # U+0x004F
        'P' => '610',                            # C+0x50 # U+0x0050
        'Q' => '722',                            # C+0x51 # U+0x0051
        'R' => '666',                            # C+0x52 # U+0x0052
        'S' => '556',                            # C+0x53 # U+0x0053
        'T' => '610',                            # C+0x54 # U+0x0054
        'U' => '722',                            # C+0x55 # U+0x0055
        'V' => '666',                            # C+0x56 # U+0x0056
        'W' => '889',                            # C+0x57 # U+0x0057
        'X' => '666',                            # C+0x58 # U+0x0058
        'Y' => '610',                            # C+0x59 # U+0x0059
        'Z' => '610',                            # C+0x5A # U+0x005A
        'bracketleft' => '333',                  # C+0x5B # U+0x005B
        'backslash' => '277',                    # C+0x5C # U+0x005C
        'bracketright' => '333',                 # C+0x5D # U+0x005D
        'asciicircum' => '569',                  # C+0x5E # U+0x005E
        'underscore' => '500',                   # C+0x5F # U+0x005F
        'grave' => '333',                        # C+0x60 # U+0x0060
        'a' => '500',                            # C+0x61 # U+0x0061
        'b' => '500',                            # C+0x62 # U+0x0062
        'c' => '443',                            # C+0x63 # U+0x0063
        'd' => '500',                            # C+0x64 # U+0x0064
        'e' => '443',                            # C+0x65 # U+0x0065
        'f' => '333',                            # C+0x66 # U+0x0066
        'g' => '500',                            # C+0x67 # U+0x0067
        'h' => '556',                            # C+0x68 # U+0x0068
        'i' => '277',                            # C+0x69 # U+0x0069
        'j' => '277',                            # C+0x6A # U+0x006A
        'k' => '500',                            # C+0x6B # U+0x006B
        'l' => '277',                            # C+0x6C # U+0x006C
        'm' => '777',                            # C+0x6D # U+0x006D
        'n' => '556',                            # C+0x6E # U+0x006E
        'o' => '500',                            # C+0x6F # U+0x006F
        'p' => '500',                            # C+0x70 # U+0x0070
        'q' => '500',                            # C+0x71 # U+0x0071
        'r' => '389',                            # C+0x72 # U+0x0072
        's' => '389',                            # C+0x73 # U+0x0073
        't' => '277',                            # C+0x74 # U+0x0074
        'u' => '556',                            # C+0x75 # U+0x0075
        'v' => '443',                            # C+0x76 # U+0x0076
        'w' => '666',                            # C+0x77 # U+0x0077
        'x' => '500',                            # C+0x78 # U+0x0078
        'y' => '443',                            # C+0x79 # U+0x0079
        'z' => '389',                            # C+0x7A # U+0x007A
        'braceleft' => '348',                    # C+0x7B # U+0x007B
        'bar' => '220',                          # C+0x7C # U+0x007C
        'braceright' => '348',                   # C+0x7D # U+0x007D
        'asciitilde' => '569',                   # C+0x7E # U+0x007E
        'bullet' => '350',                       # C+0x7F # U+0x2022
        'Euro' => '500',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '333',               # C+0x82 # U+0x201A
        'florin' => '500',                       # C+0x83 # U+0x0192
        'quotedblbase' => '500',                 # C+0x84 # U+0x201E
        'ellipsis' => '1000',                    # C+0x85 # U+0x2026
        'dagger' => '500',                       # C+0x86 # U+0x2020
        'daggerdbl' => '500',                    # C+0x87 # U+0x2021
        'circumflex' => '333',                   # C+0x88 # U+0x02C6
        'perthousand' => '1000',                 # C+0x89 # U+0x2030
        'Scaron' => '556',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '333',                # C+0x8B # U+0x2039
        'OE' => '943',                           # C+0x8C # U+0x0152
        'Zcaron' => '610',                       # C+0x8E # U+0x017D
        'quoteleft' => '333',                    # C+0x91 # U+0x2018
        'quoteright' => '333',                   # C+0x92 # U+0x2019
        'quotedblleft' => '500',                 # C+0x93 # U+0x201C
        'quotedblright' => '500',                # C+0x94 # U+0x201D
        'endash' => '500',                       # C+0x96 # U+0x2013
        'emdash' => '1000',                      # C+0x97 # U+0x2014
        'tilde' => '333',                        # C+0x98 # U+0x02DC
        'trademark' => '1000',                   # C+0x99 # U+0x2122
        'scaron' => '389',                       # C+0x9A # U+0x0161
        'guilsinglright' => '333',               # C+0x9B # U+0x203A
        'oe' => '722',                           # C+0x9C # U+0x0153
        'zcaron' => '389',                       # C+0x9E # U+0x017E
        'Ydieresis' => '610',                    # C+0x9F # U+0x0178
        'exclamdown' => '389',                   # C+0xA1 # U+0x00A1
        'cent' => '500',                         # C+0xA2 # U+0x00A2
        'sterling' => '500',                     # C+0xA3 # U+0x00A3
        'currency' => '500',                     # C+0xA4 # U+0x00A4
        'yen' => '500',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '220',                    # C+0xA6 # U+0x00A6
        'section' => '500',                      # C+0xA7 # U+0x00A7
        'dieresis' => '333',                     # C+0xA8 # U+0x00A8
        'copyright' => '747',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '266',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '500',                # C+0xAB # U+0x00AB
        'logicalnot' => '605',                   # C+0xAC # U+0x00AC
        'registered' => '747',                   # C+0xAE # U+0x00AE
        'macron' => '520',                       # C+0xAF # U+0x00AF
        'degree' => '399',                       # C+0xB0 # U+0x00B0
        'plusminus' => '548',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '299',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '299',                # C+0xB3 # U+0x00B3
        'acute' => '333',                        # C+0xB4 # U+0x00B4
        'mu' => '556',                           # C+0xB5 # U+0x00B5
        'paragraph' => '500',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '250',               # C+0xB7 # U+0x00B7
        'cedilla' => '333',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '299',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '299',                 # C+0xBA # U+0x00BA
        'guillemotright' => '500',               # C+0xBB # U+0x00BB
        'onequarter' => '750',                   # C+0xBC # U+0x00BC
        'onehalf' => '750',                      # C+0xBD # U+0x00BD
        'threequarters' => '750',                # C+0xBE # U+0x00BE
        'questiondown' => '500',                 # C+0xBF # U+0x00BF
        'Agrave' => '666',                       # C+0xC0 # U+0x00C0
        'Aacute' => '666',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '666',                  # C+0xC2 # U+0x00C2
        'Atilde' => '666',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '666',                    # C+0xC4 # U+0x00C4
        'Aring' => '666',                        # C+0xC5 # U+0x00C5
        'AE' => '943',                           # C+0xC6 # U+0x00C6
        'Ccedilla' => '666',                     # C+0xC7 # U+0x00C7
        'Egrave' => '666',                       # C+0xC8 # U+0x00C8
        'Eacute' => '666',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '666',                  # C+0xCA # U+0x00CA
        'Edieresis' => '666',                    # C+0xCB # U+0x00CB
        'Igrave' => '389',                       # C+0xCC # U+0x00CC
        'Iacute' => '389',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '389',                  # C+0xCE # U+0x00CE
        'Idieresis' => '389',                    # C+0xCF # U+0x00CF
        'Eth' => '722',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '722',                       # C+0xD1 # U+0x00D1
        'Ograve' => '722',                       # C+0xD2 # U+0x00D2
        'Oacute' => '722',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '722',                  # C+0xD4 # U+0x00D4
        'Otilde' => '722',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '722',                    # C+0xD6 # U+0x00D6
        'multiply' => '569',                     # C+0xD7 # U+0x00D7
        'Oslash' => '722',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '722',                       # C+0xD9 # U+0x00D9
        'Uacute' => '722',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '722',                  # C+0xDB # U+0x00DB
        'Udieresis' => '722',                    # C+0xDC # U+0x00DC
        'Yacute' => '610',                       # C+0xDD # U+0x00DD
        'Thorn' => '610',                        # C+0xDE # U+0x00DE
        'germandbls' => '500',                   # C+0xDF # U+0x00DF
        'agrave' => '500',                       # C+0xE0 # U+0x00E0
        'aacute' => '500',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '500',                  # C+0xE2 # U+0x00E2
        'atilde' => '500',                       # C+0xE3 # U+0x00E3
        'adieresis' => '500',                    # C+0xE4 # U+0x00E4
        'aring' => '500',                        # C+0xE5 # U+0x00E5
        'ae' => '722',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '443',                     # C+0xE7 # U+0x00E7
        'egrave' => '443',                       # C+0xE8 # U+0x00E8
        'eacute' => '443',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '443',                  # C+0xEA # U+0x00EA
        'edieresis' => '443',                    # C+0xEB # U+0x00EB
        'igrave' => '277',                       # C+0xEC # U+0x00EC
        'iacute' => '277',                       # C+0xED # U+0x00ED
        'icircumflex' => '277',                  # C+0xEE # U+0x00EE
        'idieresis' => '277',                    # C+0xEF # U+0x00EF
        'eth' => '500',                          # C+0xF0 # U+0x00F0
        'ntilde' => '556',                       # C+0xF1 # U+0x00F1
        'ograve' => '500',                       # C+0xF2 # U+0x00F2
        'oacute' => '500',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '500',                  # C+0xF4 # U+0x00F4
        'otilde' => '500',                       # C+0xF5 # U+0x00F5
        'odieresis' => '500',                    # C+0xF6 # U+0x00F6
        'divide' => '548',                       # C+0xF7 # U+0x00F7
        'oslash' => '500',                       # C+0xF8 # U+0x00F8
        'ugrave' => '556',                       # C+0xF9 # U+0x00F9
        'uacute' => '556',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '556',                  # C+0xFB # U+0x00FB
        'udieresis' => '556',                    # C+0xFC # U+0x00FC
        'yacute' => '443',                       # C+0xFD # U+0x00FD
        'thorn' => '500',                        # C+0xFE # U+0x00FE
        'ydieresis' => '443',                    # C+0xFF # U+0x00FF
        'dotlessi' => '277',                     # U+0x0131
        'Lslash' => '610',                       # U+0x0141
        'lslash' => '277',                       # U+0x0142
        'caron' => '333',                        # U+0x02C7
        'breve' => '333',                        # U+0x02D8
        'dotaccent' => '333',                    # U+0x02D9
        'ring' => '333',                         # U+0x02DA
        'ogonek' => '333',                       # U+0x02DB
        'hungarumlaut' => '333',                 # U+0x02DD
	    'dblgravecmb' => '333',                  # U+0x030F
        'fraction' => '166',                     # U+0x2044
        'minus' => '605',                        # U+0x2212
        'fi' => '556',                           # U+0xFB01
        'fl' => '556',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
