/* ----- core/multsntrup953, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup953_checksums[] = {
  "6204041e985eecd6f688132f753441c49a9cfa99a37b142a49425a4e5f8c69f7",
  "1b3f1343cd066c133980283e6e6f76ee8a1f3b72b2399109ee03a77d1e3b460b",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup953_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup953_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup953_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup953_CONSTBYTES

static void *storage_core_multsntrup953_h;
static unsigned char *test_core_multsntrup953_h;
static void *storage_core_multsntrup953_n;
static unsigned char *test_core_multsntrup953_n;
static void *storage_core_multsntrup953_k;
static unsigned char *test_core_multsntrup953_k;
static void *storage_core_multsntrup953_c;
static unsigned char *test_core_multsntrup953_c;
static void *storage_core_multsntrup953_h2;
static unsigned char *test_core_multsntrup953_h2;
static void *storage_core_multsntrup953_n2;
static unsigned char *test_core_multsntrup953_n2;
static void *storage_core_multsntrup953_k2;
static unsigned char *test_core_multsntrup953_k2;
static void *storage_core_multsntrup953_c2;
static unsigned char *test_core_multsntrup953_c2;

#define precomputed_core_multsntrup953_NUM 4

static const unsigned char precomputed_core_multsntrup953_h[precomputed_core_multsntrup953_NUM][crypto_core_OUTPUTBYTES] = {
  {21,248,236,252,251,5,197,253,170,250,159,2,213,6,111,247,208,255,31,247,178,8,136,5,47,248,131,252,146,248,239,244,223,10,74,253,80,254,100,252,215,251,63,255,51,246,228,255,41,255,245,250,192,3,16,5,70,6,10,1,167,244,146,5,50,8,50,245,176,9,237,253,169,249,201,11,115,254,89,2,97,246,32,9,128,246,127,255,156,251,15,12,25,245,222,0,45,248,241,249,100,247,52,2,70,8,186,245,188,10,167,251,190,254,13,9,181,2,248,11,29,12,89,249,89,255,204,2,68,247,228,249,245,245,61,0,64,253,88,0,8,247,0,247,88,244,112,253,248,6,113,3,253,249,169,247,171,1,91,10,16,1,255,8,1,2,178,1,226,250,146,5,194,4,114,0,17,4,236,3,76,250,180,11,122,249,248,8,99,251,75,2,38,252,136,8,34,248,157,3,31,254,40,244,148,6,160,10,108,11,182,11,18,10,187,4,184,248,83,4,188,4,89,8,134,8,82,9,126,10,255,247,234,250,80,253,158,248,87,250,103,247,141,11,133,5,13,251,126,2,75,251,46,248,167,255,207,243,178,1,62,244,20,245,219,253,98,249,66,247,157,0,39,249,115,6,49,249,244,1,249,251,179,245,19,4,213,7,176,253,207,8,129,252,108,4,157,0,64,7,173,3,134,251,165,246,54,9,122,250,117,255,29,1,20,5,199,245,19,4,88,10,158,254,79,245,26,248,19,8,2,255,223,243,110,246,57,247,71,253,160,4,183,251,233,4,183,5,148,2,102,6,213,251,150,0,214,251,35,250,148,255,128,1,190,253,78,1,165,1,29,1,51,6,244,9,244,2,176,248,236,247,75,249,210,252,138,2,78,250,46,246,83,252,229,251,32,252,155,255,140,252,209,6,104,255,7,244,244,8,63,247,67,11,72,249,180,3,4,2,222,244,162,249,230,3,227,1,142,244,157,9,116,255,86,5,227,254,24,245,181,5,246,255,84,3,78,4,97,248,164,8,167,252,100,6,97,248,238,248,161,243,108,253,173,9,93,248,223,252,82,246,209,246,48,254,139,253,89,252,100,6,98,251,184,1,149,245,94,5,135,252,91,10,161,250,76,244,138,8,91,246,51,244,173,11,22,255,9,4,162,249,140,1,125,252,33,3,77,252,13,1,24,247,245,244,236,2,209,245,31,252,191,249,34,3,174,9,118,6,49,10,138,251,53,6,70,10,183,247,133,2,6,255,8,3,134,246,92,7,214,245,57,4,33,0,92,1,209,8,46,250,209,6,55,254,239,255,46,11,98,251,189,249,18,6,147,7,109,0,19,10,54,244,181,244,166,6,96,9,222,247,129,247,159,244,104,1,88,2,105,253,132,4,31,250,106,0,141,253,197,1,159,243,64,246,202,249,117,10,202,7,9,5,124,0,169,249,149,248,41,253,90,4,20,245,191,249,92,12,234,1,70,255,157,9,159,254,21,247,153,251,9,250,123,244,16,5,31,3,198,252,133,246,60,249,89,9,247,254,96,3,187,253,42,4,176,10,252,244,243,0,17,254,108,254,72,2,145,8,199,252,249,244,16,244,251,7,249,8,152,248,60,1,94,244,160,248,169,3,55,6,182,254,173,244,65,1,144,9,247,255,207,2,167,243,56,246,188,252,227,244,127,245,70,246,183,11,46,252,245,251,152,253,185,7,206,7,110,11,33,4,65,251,155,253,132,9,110,4,18,254,146,245,203,248,212,253,115,249,240,255,19,2,153,255,238,9,60,3,186,252,131,255,16,11,97,247,162,8,20,249,247,11,108,249,60,7,92,251,190,4,117,4,41,5,248,5,21,252,133,254,94,2,207,246,128,244,178,2,53,249,240,255,122,250,8,10,93,246,1,251,143,9,73,11,165,7,136,8,145,254,223,5,31,12,117,250,123,5,194,246,4,244,127,255,154,246,121,246,211,0,172,251,251,3,81,0,29,252,71,251,222,1,243,11,118,246,234,248,195,244,100,249,69,244,78,7,120,246,10,254,169,255,37,248,64,8,79,248,227,252,75,9,103,245,128,2,235,10,111,2,52,253,162,254,143,249,236,5,10,250,105,249,220,5,84,249,86,12,90,10,66,11,252,6,36,10,38,0,111,0,129,3,8,12,100,253,112,247,240,248,222,253,98,249,115,252,48,8,73,11,0,12,81,253,6,6,137,0,28,5,88,8,172,6,161,9,241,5,129,0,183,0,75,249,199,10,81,253,227,254,117,254,227,8,10,9,0,246,225,2,222,11,217,244,113,250,159,253,124,254,88,10,250,2,0,253,126,6,146,2,81,10,200,249,239,252,71,248,175,5,181,8,105,247,67,9,27,245,184,6,248,247,158,9,103,246,218,7,173,8,190,1,80,7,130,253,190,1,199,246,93,12,107,251,244,254,243,8,250,2,99,251,143,7,166,9,230,246,254,255,224,1,234,5,48,251,216,1,116,7,37,250,108,247,23,255,34,252,53,246,55,7,110,245,201,2,134,1,37,253,22,252,138,244,24,12,33,7,228,250,79,1,217,248,54,253,59,246,189,4,240,243,2,7,226,247,20,254,100,8,41,10,246,6,248,5,217,8,210,251,166,243,246,245,54,7,209,0,198,254,193,2,22,5,160,252,23,7,31,11,110,244,163,246,196,244,112,250,230,246,231,10,213,254,253,249,96,8,168,1,214,11,255,248,214,246,116,252,151,6,19,251,180,9,51,249,117,1,61,252,106,4,229,11,26,252,54,244,51,11,212,250,213,1,240,5,21,246,169,250,76,253,27,5,156,5,159,253,56,247,140,0,122,4,137,0,161,0,42,4,45,244,5,5,14,254,227,243,91,245,97,2,195,250,92,2,117,8,179,255,138,252,251,0,10,246,5,10,190,246,222,254,103,248,66,249,195,2,53,9,205,11,129,248,237,1,81,255,61,6,15,0,73,251,254,247,145,6,166,254,1,255,229,254,170,0,122,247,75,5,232,252,226,5,87,1,179,249,226,245,28,11,29,0,244,247,162,2,157,2,30,12,179,246,253,253,201,255,53,252,94,252,133,6,59,11,158,10,224,254,63,247,222,5,1,6,178,254,2,7,131,10,216,8,149,8,123,254,175,253,166,5,101,0,216,247,191,246,234,247,11,4,109,254,181,252,193,252,21,252,80,8,167,0,102,249,250,253,130,5,164,250,195,253,240,244,113,6,178,254,130,10,172,245,108,8,220,243,28,245,138,10,47,246,218,252,168,247,105,10,229,1,134,11,217,254,192,245,255,10,89,248,196,0,96,8,133,250,50,5,131,255,137,2,152,245,184,243,148,8,151,246,249,253,125,9,62,254,19,254,184,243,19,247,188,252,209,254,58,249,252,9,11,3,73,0,140,252,239,246,249,246,13,252,231,0,118,246,88,6,180,254,51,251,90,246,179,9,166,11,172,1,46,0,180,8,255,245,201,247,241,253,72,4,119,249,31,252,204,245,89,4,47,248,173,9,43,246,95,248,177,6,19,247,28,0,240,250,38,8,173,249,98,6,164,9,21,2,29,255,249,5,40,9,141,247,47,251,202,247,111,250,166,1,141,245,104,251,198,3,107,1,222,250,240,250,94,0,3,3,243,5,37,254,22,11,164,10,156,8,129,253,173,3,88,251,243,254,64,251,8,10,127,250,11,3,29,248,97,246,91,10,214,4,29,249,74,12,135,252,44,10,205,3,41,1,166,255,162,3,17,8,58,5,75,7,120,6,254,11,247,10,9,248,188,255,47,254,165,9,180,248,221,6,98,5,116,249,210,252,70,244,157,0,155,254,128,7,93,248,152,246,182,255,129,10,189,252,232,244,194,248,103,248,135,249,217,243,155,244,152,3,43,252,224,1,54,248,129,7,28,248,104,250,78,255,95,9,131,11,156,247,72,250,191,4,219,250,194,243,138,4,173,8,125,251,6,12,206,3,244,243,226,6,200,8,89,245,43,11,71,7,19,3,58,12,182,246,242,9,82,250,23,254,102,10,150,249,150,251,34,3,115,4,190,8,82,247,19,248,51,249,167,2,101,6,175,1,244,244,108,255,252,251,201,245,92,255,91,249,2,11,249,250,129,5,57,250,16,254,110,246,210,4,122,253,16,254,215,1,25,10,74,6,171,8,186,0,59,7,102,245,193,10,225,3,162,4,212,255,128,249,65,7,12,11,34,250,189,6,59,251,192,248,36,255,102,252,123,11,55,12,150,0,224,252,126,8,138,0,210,244,68,5,82,244,187,6,173,1,45,7,254,251},
  {109,5,24,246,242,254,228,9,22,249,101,9,48,249,215,243,120,247,27,4,41,8,58,255,238,254,119,3,238,8,244,0,191,246,132,250,191,1,35,4,221,2,181,6,78,246,30,3,39,244,134,11,10,8,166,11,127,250,15,246,140,0,181,7,75,249,187,2,126,4,157,1,145,252,228,10,10,10,212,7,237,4,47,245,198,244,241,0,186,10,201,4,118,244,168,11,52,253,81,251,32,253,21,252,224,245,139,252,182,8,149,7,67,245,213,7,155,253,37,246,16,2,88,244,1,248,87,245,70,248,0,249,25,244,161,8,125,251,17,249,194,252,81,11,238,248,227,7,228,248,207,9,44,253,95,247,143,253,255,3,37,254,223,1,172,255,183,7,216,249,116,6,222,0,197,0,76,254,178,245,209,250,126,251,198,243,94,252,95,10,20,11,94,249,191,5,180,2,196,254,24,11,82,9,96,12,110,0,240,10,14,3,250,249,251,2,87,252,24,3,81,3,116,247,185,253,208,9,144,6,68,250,49,6,100,245,74,254,252,246,40,245,163,1,79,247,195,8,226,6,178,11,91,8,17,246,118,255,251,9,17,255,187,5,63,10,9,1,200,244,129,4,92,12,102,9,100,249,212,248,69,3,78,4,36,10,34,1,129,249,81,244,176,9,94,253,230,6,51,5,84,9,173,8,118,7,29,5,232,249,129,3,247,5,172,253,85,255,4,248,106,247,124,252,91,1,118,255,79,253,248,254,8,8,244,7,43,253,145,10,16,9,183,5,89,0,145,252,162,9,0,255,133,3,250,7,63,12,4,252,54,1,183,7,17,249,44,246,136,6,84,244,187,1,131,3,214,10,71,254,127,4,5,249,190,7,125,254,170,1,2,5,139,10,154,253,65,6,158,246,223,247,114,255,143,3,26,254,240,247,235,2,63,5,21,252,2,9,209,0,47,9,22,9,61,244,251,9,218,246,61,3,17,247,247,1,126,1,141,253,41,12,197,0,86,254,68,11,235,252,190,248,114,246,108,11,130,9,142,10,89,252,61,8,250,254,195,250,11,1,133,245,50,6,172,5,13,4,137,254,14,248,85,247,214,1,35,2,232,253,42,247,196,244,8,248,167,246,83,12,93,9,119,11,201,11,5,1,168,7,4,10,70,8,96,255,7,251,121,7,80,2,66,244,130,246,17,254,93,7,142,0,92,8,132,6,98,2,102,253,210,247,63,245,171,247,86,250,182,1,148,248,121,6,242,255,187,3,3,12,196,10,45,5,188,247,91,7,101,247,210,6,191,254,29,4,177,11,166,252,13,248,49,255,204,244,152,248,235,247,99,253,55,246,252,0,82,1,107,251,53,4,226,2,223,247,252,9,240,6,104,250,178,10,210,254,217,8,174,245,13,254,162,9,166,1,195,3,240,4,117,252,8,254,86,245,53,252,99,8,29,244,118,255,254,244,119,3,22,246,244,246,217,7,73,244,14,9,60,4,151,6,112,255,197,7,197,4,30,253,213,251,83,253,229,250,243,253,55,244,151,7,178,3,192,11,125,250,56,245,231,252,72,246,0,9,92,251,31,250,133,252,22,246,100,11,212,254,110,247,176,255,221,253,7,12,209,10,60,6,204,0,139,1,14,247,52,2,245,4,7,11,112,251,121,5,237,6,44,5,143,251,175,10,198,248,180,243,212,243,39,5,155,246,54,251,161,0,239,7,139,3,232,243,39,3,165,255,87,11,123,246,184,247,182,5,34,7,0,246,82,1,34,4,172,6,18,7,178,8,26,254,23,9,49,4,156,7,71,250,28,5,125,251,103,251,158,5,140,3,190,251,127,1,20,3,36,11,184,244,193,4,136,0,1,244,130,7,128,9,242,5,48,252,152,251,103,4,49,5,232,244,116,3,195,2,3,247,50,252,145,249,166,8,23,11,54,254,76,6,64,252,79,10,103,5,35,248,70,255,135,8,236,248,172,2,138,246,16,253,17,8,88,8,164,5,66,248,149,244,153,245,69,2,150,11,154,245,0,6,243,251,163,253,200,8,89,11,153,4,57,5,46,255,251,248,176,245,210,255,84,4,100,245,50,254,98,248,250,9,177,7,138,248,197,255,40,254,26,3,183,250,51,245,37,247,85,255,219,1,136,4,34,5,60,0,78,248,36,3,252,4,179,5,145,0,177,4,158,2,251,246,85,244,166,253,195,253,214,1,140,0,83,244,182,6,60,253,157,247,219,10,125,10,179,255,230,4,196,252,120,11,236,2,31,250,107,9,82,244,44,11,197,249,255,248,154,0,60,247,8,2,10,10,173,1,36,5,51,10,2,12,125,254,0,3,242,250,123,1,243,11,49,9,179,255,208,250,156,250,151,249,0,7,4,246,144,252,86,245,62,0,75,2,17,9,188,255,108,1,27,246,235,6,32,7,243,243,94,4,50,251,179,5,116,6,59,254,153,253,40,9,60,252,110,251,90,11,220,251,202,243,240,8,194,8,226,251,206,9,214,4,122,247,30,244,107,251,95,6,191,243,252,3,112,11,194,243,129,255,53,245,182,244,11,1,157,243,43,2,195,5,134,248,172,6,164,252,169,2,42,253,153,4,13,248,220,6,180,245,88,249,16,4,184,8,218,247,40,0,204,254,118,4,24,1,178,0,160,2,143,7,184,10,53,3,42,10,117,6,70,8,249,0,52,246,191,245,228,10,136,1,247,7,179,7,201,3,27,8,17,252,9,255,57,5,215,5,72,254,167,253,186,249,218,255,178,2,91,253,124,248,128,4,52,5,41,7,6,245,187,11,10,12,238,1,48,251,183,254,31,244,29,1,90,2,149,2,195,244,110,5,2,1,173,6,30,253,118,2,41,254,72,253,10,6,127,249,126,245,35,12,84,251,97,255,169,243,140,247,147,247,255,6,43,244,123,253,1,244,89,9,187,245,43,4,14,249,142,5,204,10,251,248,185,9,181,248,172,3,112,244,89,247,156,250,86,250,99,244,150,0,136,9,26,255,46,250,246,7,40,252,234,245,230,2,191,248,170,9,132,249,21,8,199,244,190,244,44,7,243,2,53,1,36,250,204,251,165,250,223,3,35,251,158,9,128,10,1,255,38,0,159,9,214,244,223,243,40,7,192,1,22,248,190,9,236,6,124,8,133,4,40,253,39,2,139,248,236,9,206,255,51,248,144,255,152,1,163,8,124,8,53,4,139,251,167,3,203,1,255,248,54,254,21,251,196,1,79,252,82,5,205,243,155,4,237,243,232,8,193,254,165,243,218,0,223,244,78,248,125,11,9,249,253,10,212,255,169,2,198,246,139,10,20,3,79,249,133,251,41,1,149,247,174,246,133,247,24,11,225,2,6,252,211,3,30,244,104,10,8,252,178,244,169,248,245,248,9,250,9,5,84,5,237,1,124,9,223,8,182,244,204,11,13,245,209,250,14,0,152,255,20,9,54,246,54,248,228,7,185,248,77,247,182,5,117,251,145,6,40,252,12,245,96,10,57,1,42,249,34,2,136,11,14,8,243,2,119,5,44,1,215,8,196,252,118,1,116,4,17,3,113,253,228,8,173,9,109,6,230,1,142,245,226,7,223,0,99,7,53,9,93,254,11,251,18,0,206,1,229,9,227,243,160,249,80,252,64,245,232,250,178,244,91,249,236,252,105,248,167,249,140,3,69,250,147,246,33,246,211,255,135,10,63,2,218,254,242,10,122,1,92,254,140,7,44,250,124,246,191,10,123,8,220,1,160,245,10,1,14,255,132,252,145,11,176,3,68,255,53,4,115,250,86,6,125,253,220,9,42,10,230,252,199,2,136,0,151,252,84,1,198,5,51,12,101,254,4,5,204,2,128,248,0,250,84,246,71,255,245,252,118,9,77,252,229,243,3,245,219,10,138,0,98,9,96,246,5,255,198,8,230,3,208,4,74,255,251,6,67,0,32,245,227,248,233,246,121,7,217,243,226,6,12,7,27,2,232,247,6,0,81,10,235,245,132,244,190,11,230,245,43,254,137,1,152,8,52,11,157,11,192,1,167,10,205,243,3,2,116,1,250,248,221,247,101,244,70,250,132,244,209,7,40,12,237,246,34,249,201,254,251,0,51,254,130,255,137,1,124,249,153,248,48,250,191,252,182,246,13,250,179,8,47,6,2,245,216,243,225,251,78,3,178,245,190,248,222,254,105,249,43,252,129,254,178,248,210,250,86,6,48,9,42,0,96,7,104,253,26,254,74,249,121,253,71,252,154,9,10,4,64,4,134,245,2,8,230,6,62,249,82,9,194,6},
  {183,6,20,10,147,251,222,244,83,5,241,9,72,11,78,3,124,248,41,251,12,253,106,249,107,248,83,251,179,253,58,250,50,12,83,2,220,243,87,0,73,5,88,6,121,5,246,3,160,3,191,5,21,253,137,247,94,247,188,11,240,2,182,9,33,246,8,251,246,249,157,9,69,5,128,246,230,254,4,10,16,0,62,3,79,249,8,254,116,246,157,251,218,254,195,0,18,0,254,251,18,12,156,7,61,9,159,254,102,0,5,253,154,246,28,247,154,4,90,6,142,8,17,248,58,246,130,11,202,252,34,11,96,4,35,10,76,3,232,255,220,249,141,244,179,1,199,253,247,251,178,253,222,243,159,250,133,4,30,9,62,246,174,249,251,249,193,249,131,253,192,248,56,9,158,254,192,4,139,246,59,252,180,4,122,251,85,255,22,2,217,10,83,9,20,251,113,6,157,253,63,252,30,253,24,6,189,8,14,9,98,1,125,2,195,4,227,244,167,255,190,251,214,10,247,6,97,248,202,245,147,11,7,244,64,252,184,8,29,4,134,10,111,245,173,9,80,5,83,255,169,255,177,0,173,11,183,2,93,3,13,253,43,9,124,8,97,252,197,246,33,0,113,11,238,9,218,8,3,8,223,243,19,245,159,245,166,254,242,255,236,5,86,11,190,5,226,6,7,10,236,245,79,3,0,255,207,4,123,8,13,245,231,2,192,248,165,250,102,255,126,249,42,12,114,245,84,10,144,244,161,5,148,0,2,247,97,254,186,253,164,9,17,3,121,6,106,246,158,248,175,254,111,9,61,4,28,5,35,253,106,2,106,9,119,5,18,248,188,4,28,11,85,0,243,251,48,0,185,10,235,249,200,4,69,251,3,252,180,250,239,253,132,7,159,9,108,9,193,4,66,250,79,5,111,8,73,2,165,250,88,244,191,5,201,2,37,6,59,5,175,9,76,244,18,251,6,7,199,1,247,253,60,11,67,0,41,247,126,8,182,6,73,11,38,251,86,9,28,12,208,6,91,252,27,248,14,0,195,247,145,244,246,4,120,11,0,247,183,249,226,243,11,244,49,1,12,12,71,10,46,7,20,8,246,2,87,255,85,251,149,249,246,7,39,8,183,249,193,11,230,254,180,7,3,2,210,248,187,2,216,244,234,255,2,252,247,1,199,255,73,10,166,1,199,11,163,250,128,6,23,1,177,10,0,4,198,3,211,254,88,252,14,246,212,255,88,0,1,9,8,0,45,253,196,254,148,4,136,246,41,11,56,251,78,5,214,9,40,251,187,3,26,253,102,5,85,253,45,10,241,255,214,245,52,12,37,7,53,9,107,246,100,251,126,6,45,252,201,255,200,251,73,2,59,1,220,254,253,8,217,244,200,9,204,5,62,247,5,250,240,3,172,10,149,2,64,10,85,250,235,9,14,250,214,244,146,246,253,0,200,6,22,3,203,244,185,3,227,244,222,2,147,5,172,3,20,255,161,10,226,0,195,4,217,253,23,250,45,252,165,253,104,7,160,246,161,7,190,249,251,248,55,6,141,3,49,254,165,243,254,10,70,12,116,6,242,255,146,3,198,6,98,252,135,255,49,8,28,9,50,12,169,247,229,10,61,5,145,250,170,3,93,3,63,247,133,2,227,248,184,252,133,252,110,252,236,1,98,253,207,255,104,2,17,252,14,6,75,244,250,6,83,6,8,245,48,250,6,246,19,7,89,5,224,4,168,255,36,8,105,255,222,4,92,8,24,255,32,12,180,0,3,9,104,2,4,246,89,12,219,249,219,2,77,254,47,4,202,248,101,255,2,11,215,9,94,252,115,250,202,243,173,6,151,248,244,251,157,3,137,0,43,250,194,245,110,0,38,4,188,5,213,253,195,2,152,248,225,248,104,9,239,251,34,245,162,3,233,9,176,251,217,11,175,254,23,11,108,253,48,2,132,11,47,246,251,3,184,2,112,1,173,252,237,252,21,9,36,5,23,11,35,7,148,244,12,11,92,10,66,11,59,8,113,252,45,251,85,252,21,250,150,252,217,251,200,8,107,10,222,11,231,5,126,9,108,4,250,253,132,253,88,8,194,248,87,249,142,250,108,5,5,12,148,2,228,253,125,248,45,245,2,2,175,1,236,10,202,246,115,252,168,246,71,245,221,4,54,246,99,254,132,8,9,11,111,250,138,248,208,245,177,250,51,251,250,243,204,10,206,9,178,254,36,247,42,6,56,247,215,9,14,254,77,253,237,255,82,245,55,12,92,1,105,5,113,252,218,5,134,244,95,10,18,244,135,0,125,246,63,244,111,245,224,1,182,1,27,247,113,6,220,9,71,253,84,244,122,247,208,5,138,251,25,244,67,8,82,245,208,0,36,252,115,4,65,3,177,7,239,253,214,1,30,0,162,10,169,1,106,0,90,2,241,247,140,11,76,10,246,8,189,254,165,249,197,5,206,244,174,244,36,246,73,2,236,11,39,5,63,247,90,10,67,4,183,244,1,1,24,4,37,252,4,8,11,1,192,11,28,7,209,8,128,249,249,254,125,248,245,2,210,7,131,1,97,7,129,247,202,246,241,243,240,7,106,9,215,247,192,4,89,252,54,11,102,10,175,9,36,248,220,1,237,250,132,10,53,246,213,253,8,254,185,5,205,255,64,9,152,6,183,6,163,249,3,11,158,255,28,12,107,244,225,255,190,255,181,10,168,250,68,12,155,250,83,252,152,1,26,247,219,6,125,6,117,247,13,244,139,5,150,244,45,11,201,247,99,244,178,0,161,247,232,246,169,2,61,250,101,10,247,250,184,253,211,2,189,7,155,247,144,254,131,4,28,244,72,10,203,9,166,251,125,8,3,7,148,9,247,255,237,251,107,251,86,251,243,250,255,10,62,9,242,6,37,11,186,7,214,255,116,5,204,8,112,8,71,251,78,6,42,255,77,250,23,249,117,244,246,250,20,251,52,246,13,248,1,254,12,254,205,253,228,0,75,251,126,1,250,253,179,246,213,251,230,9,133,251,59,6,227,9,168,5,127,5,106,249,164,6,26,244,70,248,136,10,101,248,245,0,252,3,149,244,101,0,31,251,165,248,199,243,117,246,221,255,148,11,112,1,135,2,227,252,151,9,27,12,162,251,114,2,91,249,60,248,115,253,136,247,104,2,161,3,250,1,60,248,21,248,200,245,148,248,170,244,43,251,3,251,172,253,217,255,81,12,193,9,238,244,123,247,127,246,47,6,144,251,140,246,26,255,128,4,233,255,120,254,25,245,245,251,198,252,3,246,219,10,193,251,244,252,205,246,39,0,58,9,61,249,94,10,33,11,221,253,65,12,228,245,220,248,148,251,100,11,190,247,45,7,179,8,1,249,188,7,138,247,182,10,197,244,188,254,88,245,105,254,9,244,74,2,227,9,207,253,58,246,134,1,15,245,204,8,62,10,145,247,70,4,95,3,228,246,116,248,243,6,140,250,175,0,115,251,17,247,160,251,140,10,3,1,126,248,109,255,139,9,53,0,192,6,126,252,235,248,17,11,255,244,141,247,4,0,2,12,241,9,37,9,192,9,31,6,194,1,95,254,12,247,243,10,151,8,149,252,149,247,236,248,148,1,182,246,79,2,128,250,9,244,139,246,232,7,2,251,254,6,231,253,253,7,224,1,231,249,138,255,18,10,82,7,23,248,215,9,245,249,190,254,124,8,98,247,192,254,210,7,208,6,17,4,195,250,145,3,124,247,94,3,246,253,119,2,17,250,148,254,90,0,17,6,39,248,224,9,189,7,244,1,180,251,16,11,172,0,77,1,64,244,143,0,208,252,12,7,175,0,23,8,6,245,51,3,165,5,24,248,148,4,24,0,173,249,52,3,196,255,69,2,137,0,252,6,15,253,230,254,26,4,89,11,252,255,212,253,228,2,231,244,123,244,133,0,141,248,152,3,207,252,39,5,139,3,231,249,87,252,248,9,32,4,202,6,109,10,236,253,181,253,133,252,123,4,90,254,101,2,81,0,10,4,34,0,235,2,112,249,17,10,105,244,20,248,150,9,83,4,78,10,114,9,177,253,125,253,109,246,98,246,129,252,232,250,127,10,29,11,13,5,75,246,65,10,182,253,137,6,87,246,59,252,175,245,137,9,235,254,83,12,102,9,125,254,5,247,157,246,247,5,138,252,104,247,105,251,18,12,61,247,241,2,18,248,140,246,151,255,221,249,160,11,18,252,231,4,90,2,57,4,54,245,191,248,180,8,11,246,8,246,1,1,224,254,18,244,8,254,214,244,13,254,77,1},
  {18,11,177,246,136,253,78,12,166,249,42,4,67,8,134,244,92,251,41,7,70,253,11,10,235,251,104,3,230,249,178,249,57,6,105,3,152,5,249,11,248,252,141,244,6,245,157,4,143,2,16,247,87,9,141,3,49,246,33,247,100,245,132,6,154,253,200,7,238,6,207,243,63,4,241,5,102,250,159,1,24,9,13,253,93,10,39,6,116,8,209,248,169,11,126,248,250,4,250,245,122,7,69,11,173,250,137,246,16,254,94,6,231,0,131,247,17,10,250,245,162,2,229,6,75,2,28,248,203,9,23,253,134,9,114,8,205,252,90,6,147,248,169,254,246,244,192,253,254,8,156,7,121,10,76,247,200,9,157,0,80,9,94,255,33,249,122,248,35,0,171,8,81,3,92,253,240,7,81,6,177,1,249,251,85,8,142,249,68,252,82,8,129,248,215,7,7,6,111,249,241,251,104,255,136,253,18,10,144,10,97,9,64,9,57,11,107,245,66,4,245,2,191,250,55,247,43,4,208,9,221,249,101,2,249,254,224,7,56,254,165,7,201,254,57,11,172,255,81,5,106,251,45,248,4,247,50,2,32,252,206,249,82,12,156,245,152,251,250,8,114,9,237,9,244,247,128,250,12,251,117,10,68,252,142,252,84,251,237,8,27,1,81,1,139,244,137,11,215,2,56,248,153,245,221,10,73,1,98,10,136,252,122,255,129,248,73,0,24,10,41,11,238,247,208,8,76,7,179,3,173,0,58,252,22,0,108,4,72,248,249,10,165,255,60,1,223,244,6,2,52,9,219,246,234,248,244,251,8,5,194,3,43,0,204,245,80,254,63,2,255,250,86,9,175,243,231,245,178,246,79,8,104,2,192,249,248,243,88,250,54,3,99,248,124,247,29,253,109,3,193,249,246,254,133,3,94,4,84,246,224,1,163,2,151,1,214,245,161,245,190,6,153,247,164,250,83,6,161,0,231,244,131,5,8,248,153,8,32,250,213,11,206,246,91,250,89,1,166,10,18,251,234,251,179,6,35,12,79,9,191,246,200,251,25,4,233,5,73,248,39,246,194,255,159,251,252,250,38,1,161,5,127,254,169,254,134,251,47,254,153,9,155,248,161,11,8,1,145,247,229,244,48,249,220,0,49,248,245,255,222,243,254,8,157,249,163,10,126,0,87,2,176,247,177,248,202,252,5,246,146,6,20,249,16,1,61,1,109,8,190,245,80,6,255,246,5,7,0,6,37,246,110,252,91,248,22,2,94,7,14,2,108,9,5,6,235,249,62,252,146,9,223,249,69,8,0,247,65,254,227,245,122,247,182,248,118,247,0,9,105,8,105,255,220,255,212,251,252,245,33,2,207,245,180,7,78,252,102,244,186,243,233,251,187,1,109,5,97,252,149,251,207,246,206,255,175,245,232,246,107,244,149,248,216,249,8,4,44,3,188,2,151,253,148,250,19,8,216,245,68,9,72,245,221,1,126,247,98,244,74,10,120,253,140,10,53,245,161,1,20,244,118,0,176,253,136,1,80,3,1,250,175,252,146,3,210,243,169,253,3,251,87,11,151,245,173,244,127,244,25,10,66,248,199,3,2,250,78,8,60,246,125,254,16,5,221,0,55,246,183,0,63,247,225,249,95,8,199,246,100,247,77,254,87,244,229,1,12,5,225,254,94,246,57,8,238,246,68,10,100,11,244,10,136,3,213,251,190,252,219,249,56,6,188,249,88,251,114,9,42,8,128,0,247,248,201,9,254,7,7,255,105,251,106,7,7,253,235,247,72,5,6,251,109,10,226,252,151,6,237,246,221,6,97,245,253,246,2,255,46,245,231,9,139,6,129,1,167,245,63,8,194,11,252,249,136,3,92,4,18,252,33,254,143,0,188,249,37,244,211,248,107,255,18,3,147,248,236,1,144,254,50,249,174,2,116,1,36,0,57,253,201,249,14,12,81,5,111,5,72,8,252,252,22,9,73,252,63,4,131,245,142,255,17,11,222,8,120,6,62,248,46,251,130,0,89,246,2,9,234,4,68,3,6,10,192,250,109,248,150,5,250,250,149,248,71,2,168,249,253,252,167,245,179,1,170,6,63,3,54,9,59,255,119,11,231,1,228,253,142,9,30,3,3,9,72,255,59,6,97,10,213,3,199,3,224,246,210,9,102,250,92,2,48,248,68,9,238,253,168,4,29,252,43,2,116,2,161,253,189,244,137,244,85,255,241,248,199,9,195,243,243,250,125,7,220,245,58,4,67,251,192,4,137,252,180,250,129,249,203,244,51,4,31,6,1,245,225,244,121,249,225,251,89,247,9,248,178,244,170,250,235,251,124,252,154,5,114,10,173,9,225,253,55,244,189,251,154,255,54,8,244,6,184,4,65,254,37,252,254,248,215,247,149,8,121,7,16,7,121,251,250,254,85,8,123,247,142,11,125,2,68,4,224,243,224,6,9,249,177,244,212,4,161,251,150,248,6,246,204,250,178,245,33,5,248,243,244,7,168,249,111,254,36,247,64,6,233,7,101,2,177,0,109,250,44,2,101,253,212,255,236,246,239,253,55,5,167,0,115,246,60,252,1,247,10,246,228,10,125,10,38,0,133,244,145,252,15,1,239,245,42,245,163,246,147,8,56,253,227,251,193,244,89,3,174,8,158,8,94,4,74,1,199,251,71,7,129,2,61,7,245,254,45,251,197,250,168,245,6,250,16,8,171,252,255,0,207,248,153,7,116,7,87,5,36,254,146,252,108,11,172,3,39,4,14,12,82,253,171,5,60,249,67,3,217,249,112,252,60,11,124,3,115,6,69,250,130,6,145,255,209,251,251,3,187,249,229,247,114,247,244,4,173,245,105,254,166,2,205,255,102,251,217,244,130,4,255,244,244,9,175,2,150,247,46,253,54,252,178,250,15,246,184,243,196,245,215,2,80,254,220,254,141,8,167,252,103,9,13,254,39,5,10,7,1,251,172,7,215,243,252,251,202,6,215,246,183,250,162,11,60,253,155,248,99,11,155,244,222,255,4,12,112,244,26,4,248,245,18,3,31,247,20,250,191,248,35,251,158,254,53,0,164,11,19,4,78,2,6,247,241,3,11,12,101,4,235,10,183,4,1,250,229,255,135,245,217,9,111,3,131,244,17,1,183,254,125,250,21,12,144,6,168,3,104,9,103,4,220,247,60,251,59,12,20,9,13,8,38,251,168,250,1,255,214,251,53,6,135,251,128,5,151,9,192,244,70,12,147,6,246,7,27,250,57,12,235,255,16,8,10,6,12,250,231,254,165,2,225,6,213,0,183,1,158,248,173,248,11,254,248,248,35,6,110,0,208,11,53,11,222,8,144,251,9,249,227,247,179,247,219,251,177,4,60,12,81,11,1,251,103,4,206,248,44,246,235,250,99,2,66,6,221,247,134,244,70,250,152,0,167,251,202,250,178,11,74,253,197,10,52,9,249,251,120,0,42,244,231,4,222,244,92,12,250,249,130,0,99,0,46,253,221,253,169,10,107,1,253,8,152,0,142,254,49,6,91,10,219,7,80,249,210,244,91,4,202,6,32,8,36,248,36,249,102,250,178,253,155,248,146,249,114,255,75,11,175,247,36,249,255,4,204,9,132,249,27,247,161,243,32,9,225,245,37,12,147,253,3,249,128,1,255,5,239,4,216,1,60,4,194,255,130,3,104,3,195,255,68,6,0,3,177,11,255,8,240,254,33,251,171,245,130,249,85,248,195,244,5,9,159,3,137,8,162,249,2,244,49,253,179,0,46,244,181,249,209,252,231,0,155,3,195,244,208,246,41,253,47,4,57,3,7,9,103,251,169,5,128,4,115,253,85,254,236,247,201,1,61,248,57,253,110,4,30,251,58,12,120,244,56,12,31,8,130,250,224,251,61,11,110,10,124,6,16,12,95,0,164,243,254,247,222,4,45,251,224,0,15,255,147,1,200,253,12,245,115,248,42,3,40,11,127,4,149,245,28,250,105,7,165,255,235,251,236,251,96,1,71,255,120,3,42,253,97,255,104,250,233,1,237,8,183,248,94,6,248,6,143,254,43,244,69,0,50,253,23,4,175,250,107,247,46,5,164,244,184,244,230,1,241,1,74,4,38,244,81,2,200,247,230,4,165,6,240,244,111,9,198,247,212,7,210,5,218,254,58,9,132,0,30,4,238,10,246,1,232,9,58,246,57,8,235,250,47,2,188,0,211,9,195,7,18,2,236,9,113,1,120,9,60,4,126,3,234,9,137,252,169,4,192,255,144,251,44,4,84,247,157,3,12,245,41,254},
} ;

static const unsigned char precomputed_core_multsntrup953_n[precomputed_core_multsntrup953_NUM][crypto_core_INPUTBYTES] = {
  {53,4,143,218,41,249,73,35,200,52,201,98,199,232,67,103,43,164,23,16,61,22,16,28,161,176,143,142,215,229,180,119,150,156,1,100,205,113,137,123,166,115,247,126,166,120,200,116,41,235,226,140,194,150,31,198,157,208,190,252,224,33,106,64,93,221,27,70,156,41,46,236,62,228,234,144,202,145,185,13,189,135,135,162,104,168,63,92,167,117,166,31,169,241,38,25,136,121,205,201,37,124,143,71,25,187,31,210,80,254,152,200,26,168,11,181,210,36,183,21,123,117,77,250,83,51,163,254,121,124,138,132,19,30,212,36,230,67,42,235,182,126,98,1,170,46,227,178,122,245,214,127,51,48,44,177,50,240,251,205,68,10,119,113,242,1,231,211,209,96,65,185,69,174,99,165,43,216,231,81,163,236,97,228,11,32,172,58,218,49,6,81,60,83,123,78,5,130,181,58,239,12,82,4,170,133,109,252,153,3,228,153,136,110,51,96,72,174,175,187,208,71,75,218,115,80,248,197,154,186,165,79,210,52,211,184,136,103,243,30,242,248,118,101,88,48,196,47,80,134,57,144,194,205,61,239,38,244,21,96,255,114,251,158,251,11,67,216,241,81,5,43,102,21,161,136,124,130,160,99,221,34,63,88,252,191,18,183,18,135,83,192,201,184,220,0,124,96,227,112,110,146,30,217,100,176,212,41,153,65,38,18,56,219,203,86,202,49,252,29,172,72,180,62,223,230,118,44,225,212,194,85,147,101,84,63,89,190,83,55,18,151,45,151,22,68,95,139,65,14,24,156,57,18,91,29,35,66,211,42,53,115,61,187,195,191,221,110,112,253,5,68,202,8,28,1,238,99,215,137,162,141,62,110,48,86,245,192,75,139,161,183,58,167,28,116,124,183,235,81,21,159,97,1,41,132,179,76,87,106,129,96,135,20,177,60,93,221,166,162,196,44,152,52,177,128,42,40,150,105,139,223,163,77,219,173,17,31,30,14,165,53,75,220,58,162,44,250,115,55,82,218,68,118,242,216,211,159,25,199,230,181,241,200,251,109,13,28,118,104,66,228,227,134,144,186,86,247,202,181,30,88,165,149,186,137,190,146,52,123,162,164,14,59,229,106,80,225,151,64,163,204,74,61,73,159,217,169,188,176,204,34,226,222,254,60,248,247,32,209,245,42,135,133,177,93,14,6,240,99,12,136,143,173,208,237,23,226,224,230,215,36,131,172,57,208,162,108,51,55,39,224,156,235,101,46,79,12,40,39,116,243,134,228,226,225,125,131,27,248,162,247,71,88,120,205,83,41,212,173,39,58,37,212,172,52,36,176,94,127,74,174,221,252,56,109,232,3,226,12,90,212,214,225,196,102,175,207,212,44,199,249,153,114,79,204,110,237,99,183,68,42,38,216,180,249,88,73,210,186,55,91,108,22,180,241,200,85,6,6,11,186,167,168,240,101,191,79,75,194,160,32,142,175,164,158,73,15,155,81,134,59,239,59,227,222,130,250,15,8,201,147,62,170,141,29,179,160,66,97,105,116,45,9,18,101,40,89,209,129,130,202,231,3,11,109,111,61,118,57,206,5,221,16,255,239,83,17,228,110,175,2,192,99,72,188,40,179,57,86,149,171,154,70,95,238,105,154,199,99,224,242,134,87,236,91,3,157,213,204,44,224,114,94,67,3,161,97,9,31,229,96,60,201,178,15,155,148,54,98,75,178,13,20,49,117,82,191,95,15,92,36,28,40,120,219,15,115,29,218,13,66,92,138,237,53,180,106,165,216,179,51,27,156,45,71,191,172,35,67,119,54,192,103,107,2,9,15,98,232,78,206,175,123,190,138,11,136,30,233,114,162,240,161,64,78,118,114,149,137,92,180,209,90,180,60,123,130,78,161,222,184,43,101,41,90,243,111,149,102,65,116,113,109,233,72,88,178,213,217,84,79,37,221,236,41,101,11,163,162,190,244,150,48,101,220,29,209,164,125,55,70,203,231,172,193,5,142,181,68,172,88,41,26,109,122,46,176,226,69,74,218,80,40,3,158,177,9,204,235,119,140,109,26,170,110,5,8,174,133,66,161,50,209,0,171,81,255,29,203,211,132,0,118,176,145,125,79,208,70,108,231,38,0,193,239,95,89,77,226,110,93,152,167,68,199,87,174,33,34,238,218,96,66,108,178,169,7,36,70,28,69,126,232,190,95,40,249,157,218,251,92,170,137,138,29,191,207,169,200,126,159,38,177,182,94,35,54,83,44,140,79,124,80,172,179,214,140,209,164,90,182,253,133,136,119,111,183,153,58,251,1,240,28,183,190,167,67,137,68,248,142,84,82,200,189,65,141,111,27,230,206,207,62,198,24,34,134,240,5,205,129,84,232,34,234,40,177,37,133,43,158,153,113,179,66,4,99,160,114,154,41,77,61,160,99,255,26,33,165,164,73,130,226,33,3,125,163,150,214,17,184,122,192,82,161,177,30,167,137,96,63,192,75,197,249,249,120,235,252,243,24,243,254,202,192,156,173,44,132,217,52,101,167,161,123,254,2,180,148,46,113,80,203,79,109,140,144,121,169,177,244,204,99,70,227,167,164,119,75,48,24,30,23,255,255,57,48,189,183,166,192,104,91,36,132,132,16,44,162,115,145,66,5,116,54,218,88,136,209,191,79,110,72,240,83,34,227,243,125,194,71,179,175,24,84,162,91,15,88,212,206,139,119,177,198,157,37,139,135,28,211,94,169,190,43,232,224,134,225,35,87,117,16,184,40,86,252,145,114,76,229,146,192,250,102,212,255,64,36,248,90,182,15,173,174,92,40,211,2,77,2,80,57,27,109,58,142,249,97,107,150,70,177,237,255,98,158,79,121,208,110,191,119,63,38,188,146,250,211,26,73,5,162,244,162,114,2,190,50,45,246,213,22,241,112,235,84,116,80,116,143,213,242,46,2,239,129,246,31,20,115,173,68,88,254,2,154,50,184,65,21,133,191,118,149,2,137,41,180,153,188,57,19,53,72,112,112,170,8,42,110,78,211,163,168,103,10,83,253,68,97,29,82,4,105,194,121,11,40,185,99,251,47,92,86,82,233,98,236,14,33,200,100,83,198,29,46,162,248,198,98,8,64,193,158,105,22,79,247,39,178,239,15,31,95,177,51,149,100,154,166,29,244,214,102,155,3,49,162,21,17,203,235,168,204,125,174,218,10,191,245,2,138,42,33,122,92,58,253,0,102,188,226,226,158,247,140,68,137,79,174,51,180,113,135,181,212,85,0,188,253,18,113,66,38,202,231,218,129,150,114,17,246,177,156,104,82,62,80,137,249,100,220,171,250,95,154,60,203,146,233,19,180,101,30,240,180,1,219,241,210,209,222,210,57,217,3,220,69,233,100,92,72,125,83,199,156,30,39,186,170,108,237,187,58,57,48,134,19,97,120,154,215,86,142,245,249,71,209,52,71,248,68,133,127,15,128,156,40,48,82,250,140,14,28,235,46,118,207,39,248,77,124,135,1,55,182,50,66,170,28,76,114,125,41,209,127,150,232,75,59,128,117,255,99,212,83,114,191,32,38,216,254,0,39,156,247,223,133,43,193,137,88,214,22,111,246,10,16,37,27,219,123,91,237,127,119,224,250,238,157,208,49,140,230,212,71,156,80,6,151,35,225,116,135,42,50,176,172,85,147,30,88,233,136,97,209,251,136,104,119,150,216,124,57,156,235,108,1,149,73,168,47,42,26,6,146,141,33,6,10,88,165,87,16,124,170,51,115,124,242,163,29,198,230,172,141,229,18,27,113,6,79,80,230,7,200,99,172,235,246,12,233,119,193,72,162,168,105,83,28,92,173,124,23,186,22,166,163,193,55,232,217,238,31,201,164,42,138,142,35,251,54,195,58,254,157,21,136,188,155,78,136,51,19,104,11,236,150,126,47,152,145,189,191,167,183,51,41,91,146,13,177,201,65,149,139,249,232,129,47,56,197,83,169,149,167,159,204,128,0,220,124,93,164,90,53,213,229,98,191,220,91,147,158,190,87,63,23,157,73,251,145,214,134,102,216,119,94,87,205,192,59,122,255,125,191,207,124,95,250,205,189,188,0,230,89,73,9,52,53,43,38,231,18,245,249,171,81,173,24,223,207,222,49,37,134,28,207,226,31,66,174,163,25,231,174,26,63,133,83,16,69,217,236,45,20,87,29,116,0,49,101,128,146,177,26,102,238,253,239,52,220,180,67,7,58,105,66,139,250,32,8,71,70,10,13,64,112,190,46,223,25,64,196,232,35,218,220,12,236,196,72,77,197},
  {123,43,213,215,172,87,229,198,146,87,174,216,129,68,44,111,56,147,157,254,210,103,154,99,20,228,90,178,99,11,199,92,193,23,196,30,128,99,245,22,81,99,24,148,40,206,176,7,134,96,191,139,128,58,207,66,64,11,10,207,99,1,231,168,211,140,100,151,246,213,247,42,252,8,150,14,101,254,2,210,239,52,213,197,233,175,155,146,97,13,214,85,190,236,67,110,236,136,247,231,23,218,89,206,230,160,138,203,22,220,185,137,251,80,184,110,144,88,167,188,45,217,95,192,212,28,37,15,141,8,63,37,113,14,85,225,20,81,129,212,108,13,127,241,173,133,215,231,5,25,243,45,171,66,166,243,3,215,72,42,21,161,101,252,97,139,79,160,106,239,201,45,188,80,149,196,141,74,60,90,106,139,224,131,100,74,253,82,110,147,236,78,39,210,96,169,82,255,209,21,89,157,110,86,88,18,112,158,149,97,77,7,92,72,153,246,241,7,205,138,246,83,117,150,171,80,236,74,192,191,117,145,238,205,187,209,163,120,58,161,76,44,54,91,45,112,226,123,119,110,102,87,181,108,158,66,67,93,12,79,219,226,39,233,83,4,54,78,149,248,36,113,176,90,41,121,99,9,144,245,229,24,133,39,251,207,32,130,78,15,209,183,116,206,94,127,244,154,209,221,170,97,14,158,45,254,138,28,67,94,150,18,32,188,189,218,4,91,136,104,86,84,224,159,20,253,213,7,243,160,59,143,252,195,138,32,191,151,81,155,180,178,31,101,45,243,206,106,61,46,117,157,167,249,156,235,59,110,88,96,182,91,121,171,97,115,109,222,78,242,106,173,96,144,87,72,54,106,64,105,43,215,67,158,107,139,31,0,87,175,239,203,48,156,48,192,107,71,236,104,201,125,34,120,232,241,113,7,93,148,96,41,185,23,182,209,76,4,73,3,223,207,243,179,11,126,18,245,52,2,17,46,85,154,22,12,50,186,217,227,217,136,252,83,211,229,226,77,120,202,247,126,21,225,239,244,207,174,239,205,25,43,69,17,228,66,118,190,162,231,96,61,146,113,60,156,228,149,190,118,249,141,250,36,146,25,236,56,30,103,210,254,195,124,72,159,3,247,116,132,204,212,2,64,112,68,130,165,78,243,154,35,191,183,146,151,181,84,114,172,130,176,34,6,42,93,186,115,60,106,36,15,30,195,151,213,36,198,12,105,246,86,157,32,65,219,205,100,66,93,196,167,27,41,129,205,19,185,182,216,39,224,216,197,82,31,56,226,189,55,177,117,6,0,51,69,105,169,255,150,146,200,247,36,142,193,107,205,167,73,71,141,56,155,247,139,139,250,160,128,120,36,124,54,210,179,41,103,174,225,45,63,60,161,2,57,107,28,139,248,5,118,13,67,216,241,78,113,18,73,47,183,106,161,104,64,111,171,126,12,246,206,123,213,87,252,123,5,234,141,92,199,226,159,75,12,167,27,57,163,181,250,198,221,19,139,41,209,144,155,149,240,223,218,106,75,73,67,107,9,202,123,72,28,53,229,175,146,174,116,131,133,185,247,60,23,252,235,159,121,152,240,126,154,111,220,239,78,115,152,85,55,253,41,209,225,98,243,132,86,205,108,195,215,183,35,251,18,140,191,207,188,105,104,82,117,106,134,242,103,217,43,42,127,167,159,72,70,193,239,156,120,53,193,109,233,225,179,56,186,54,109,6,62,115,145,190,166,226,119,88,140,163,188,77,178,59,30,172,110,14,230,156,182,38,168,90,42,246,76,181,61,29,246,226,211,166,240,30,137,71,178,133,16,27,241,179,64,117,56,2,158,75,90,172,247,38,173,141,84,82,87,220,11,117,125,154,74,94,236,124,231,182,155,198,84,194,138,155,134,80,221,184,185,88,201,206,174,216,121,33,202,157,145,2,132,246,6,113,236,143,221,240,46,236,73,38,29,157,34,145,32,62,20,251,226,196,180,61,70,125,132,91,60,246,40,114,169,221,175,83,203,15,156,85,26,227,39,63,44,192,211,147,178,163,229,46,19,245,198,170,215,167,252,190,82,207,186,37,90,80,14,53,234,116,62,142,246,254,13,62,0,201,115,218,137,18,246,15,82,95,27,255,189,29,182,49,54,64,86,105,113,102,183,4,1,3,113,39,73,32,40,248,125,161,21,251,57,155,41,151,25,6,147,20,162,32,96,167,154,108,159,52,229,237,106,65,86,13,67,216,73,67,214,49,183,44,15,85,227,153,24,215,66,82,28,50,132,29,252,79,103,105,84,54,34,199,144,31,52,164,80,31,13,141,231,12,80,28,80,245,46,164,162,172,228,10,33,224,91,253,48,251,76,163,10,50,142,26,102,136,99,91,101,161,86,125,219,197,180,116,120,27,128,240,169,115,17,190,248,89,24,203,96,4,156,29,183,221,20,251,193,177,98,226,184,210,151,242,91,133,136,13,147,23,234,157,187,20,118,224,249,76,39,105,157,87,68,117,129,68,113,43,134,44,192,193,202,247,107,198,90,251,153,128,187,58,162,136,124,24,212,168,42,167,123,133,56,157,217,1,119,166,92,100,250,33,220,221,167,134,20,102,213,192,69,162,239,88,36,101,220,166,52,82,236,121,71,115,26,191,240,230,22,148,170,110,206,107,117,101,135,255,151,249,230,163,157,80,155,55,230,63,13,86,186,200,194,41,107,223,237,187,152,190,152,131,74,136,114,238,21,121,40,28,121,75,249,45,78,114,215,151,36,190,57,1,224,187,89,25,134,235,201,95,113,252,233,240,23,169,117,62,98,206,85,75,88,31,218,61,251,127,190,80,156,134,37,83,146,33,252,13,103,84,245,255,175,50,127,117,23,68,132,227,1,242,14,128,165,174,231,110,104,44,49,4,93,126,181,88,53,186,138,217,233,58,210,252,86,254,253,219,139,96,187,125,32,10,163,229,93,134,238,72,32,69,172,168,104,63,205,69,12,29,216,93,141,229,60,59,72,137,250,63,26,31,97,196,56,129,30,198,192,170,216,17,171,143,29,245,20,57,129,7,180,195,35,4,136,42,141,44,147,14,151,196,6,138,83,154,73,167,83,233,158,135,165,186,224,174,238,48,215,218,101,195,112,144,75,4,31,93,2,74,163,1,198,63,161,110,73,53,83,34,13,138,110,178,126,240,208,36,165,12,223,66,7,40,182,232,36,160,116,99,252,232,224,207,225,35,100,124,157,105,231,199,163,169,30,220,183,133,240,79,165,234,207,59,147,106,132,154,58,51,236,255,133,222,164,169,154,243,232,37,28,74,8,54,247,31,194,51,180,224,155,157,54,80,226,244,93,209,41,108,119,193,206,94,40,198,230,71,126,179,188,127,210,236,244,103,182,108,52,12,94,97,12,160,117,140,10,66,164,105,170,36,40,42,146,56,102,46,161,137,234,115,213,251,85,192,220,24,90,93,124,87,163,125,234,14,91,79,83,147,249,200,7,166,211,92,79,86,209,132,73,155,40,178,38,97,190,182,170,204,78,229,182,125,160,43,180,75,189,215,16,135,190,62,234,36,16,86,79,174,28,41,176,18,241,8,46,210,132,205,11,5,184,121,199,193,49,212,231,189,45,212,106,102,138,1,201,205,212,185,89,115,252,206,146,186,109,85,151,150,239,21,96,132,21,112,235,251,84,49,195,73,31,153,105,211,196,88,244,89,179,243,51,246,81,199,147,75,126,147,160,242,140,230,128,164,231,37,104,107,10,33,208,254,22,110,222,125,104,17,199,246,137,140,7,96,216,221,169,7,138,157,202,132,53,39,7,243,78,141,152,134,3,45,90,186,253,163,31,252,131,41,19,2,174,129,126,236,58,133,205,201,123,187,10,21,19,239,102,111,158,54,103,137,182,64,68,156,50,254,135,159,57,28,107,245,159,179,15,73,65,247,128,164,207,20,208,55,83,170,204,49,141,152,183,177,154,110,11,176,37,60,62,176,176,253,19,235,244,247,173,246,173,62,151,14,138,2,61,30,15,41,79,216,67,248,150,174,183,159,189,149,40,47,137,252,235,18,116,244,240,203,7,176,65,10,24,235,56,142,205,8,88,112,205,42,184,113,77,120,252,210,184,5,130,140,128,123,123,69,45,189,219,125,240,35,173,10,115,246,84,195,29,154,31,25,154,158,224,186,208,39,132,97,84,198,245,188,141,117,76,253,244,190,109,91,241,227,237,56,88,130,0,247,34,72,200,162,144,8,7,168,67,150,151,36,48,90,156,140,5,236,71,209,165,213,140,119,14,45,191},
  {221,29,174,72,18,211,230,156,79,56,165,25,247,46,178,13,240,124,52,149,217,3,31,228,12,130,207,87,166,186,68,190,134,207,29,255,154,207,179,24,241,205,164,85,222,78,126,191,229,193,113,232,80,128,229,133,105,39,232,19,191,53,95,126,216,119,33,252,180,125,103,146,140,213,59,70,40,105,107,216,89,255,164,102,75,2,87,55,75,225,214,227,206,113,39,148,51,174,100,245,123,255,202,26,213,22,113,213,188,93,31,195,191,94,240,85,113,222,224,38,72,197,81,175,17,16,149,179,70,171,87,229,144,126,180,31,102,186,247,209,163,199,115,27,175,76,131,39,63,120,27,40,215,64,223,218,66,15,44,7,12,221,209,45,54,136,206,135,141,24,64,181,170,31,159,99,0,50,242,30,111,155,132,171,145,200,5,24,26,163,73,116,161,51,94,230,111,145,1,151,253,20,90,240,18,227,240,96,32,214,0,207,22,155,236,84,222,160,141,113,203,204,188,114,65,147,53,23,68,115,145,26,68,204,33,128,120,14,74,41,57,217,161,200,139,127,142,180,250,87,40,166,90,97,77,105,48,245,219,117,127,157,188,219,94,129,108,158,84,112,241,252,63,231,218,176,230,73,1,98,64,79,62,91,244,246,131,112,245,132,153,216,0,200,23,60,34,49,201,84,47,103,160,71,53,200,102,62,98,163,250,211,51,81,160,101,119,149,245,42,136,231,19,93,255,208,49,133,84,238,129,194,134,136,236,192,107,196,238,15,135,109,26,69,172,158,1,49,87,85,212,16,154,205,92,249,228,146,168,40,51,206,70,180,1,35,133,164,66,239,178,31,2,146,230,19,133,249,15,166,45,54,46,187,23,223,198,238,112,238,143,44,41,174,82,20,207,25,151,234,0,108,117,62,139,86,207,249,152,203,30,28,81,65,223,75,223,250,169,172,60,9,72,135,197,247,99,182,39,66,241,191,240,68,244,46,38,112,173,66,253,107,74,104,150,217,174,150,153,32,20,215,200,1,20,68,109,38,14,145,47,153,130,179,220,160,106,249,210,232,131,55,70,159,113,198,10,29,208,243,79,155,71,46,41,198,83,99,10,227,105,168,128,44,169,189,81,95,36,144,172,18,64,139,198,234,199,67,162,14,42,122,45,228,168,204,183,129,7,218,140,242,248,102,16,206,244,3,169,24,17,209,11,205,52,194,147,4,90,83,40,130,137,78,211,112,119,135,91,86,40,242,192,197,133,76,47,155,62,15,7,9,12,159,96,102,203,160,2,251,74,29,18,55,54,113,226,174,113,69,56,45,77,68,193,101,200,102,55,170,128,225,4,23,217,178,4,150,15,83,145,97,47,159,223,198,221,123,106,91,70,182,253,181,137,81,235,151,178,229,146,7,67,230,47,165,96,6,120,229,173,210,75,237,71,203,154,255,56,234,153,176,204,159,128,108,61,227,218,134,52,80,68,220,193,61,151,239,62,198,84,166,94,19,251,191,27,88,184,155,224,231,45,252,147,244,35,171,168,220,234,201,145,72,222,245,33,235,194,132,18,41,52,44,149,32,208,109,28,91,198,140,108,237,17,119,227,170,53,138,140,35,13,232,176,14,232,138,255,144,139,222,30,216,20,139,137,90,252,61,105,2,254,234,106,155,176,120,131,21,254,228,17,200,118,39,227,4,146,102,83,83,13,211,125,133,59,254,122,123,77,148,143,184,2,214,156,232,94,74,50,27,38,147,160,198,33,77,154,218,158,203,225,132,106,108,193,152,161,253,180,121,133,149,79,195,124,96,80,5,138,137,212,175,68,92,72,215,146,125,229,109,116,227,236,127,83,221,151,147,121,224,223,255,166,253,47,174,233,133,228,135,167,156,153,190,108,220,40,49,67,158,132,190,107,108,54,26,108,182,90,42,181,210,169,172,122,254,65,30,148,128,7,193,39,147,201,72,128,29,84,32,217,100,127,45,39,180,42,12,191,15,59,71,117,128,240,162,73,126,12,21,56,23,103,116,215,100,204,202,205,156,104,92,239,141,162,214,243,1,125,117,130,178,219,238,25,23,72,76,84,239,134,8,166,40,98,16,89,80,153,89,252,26,221,67,182,237,17,117,160,195,103,206,250,16,136,159,179,100,36,247,187,135,147,176,66,37,126,141,143,218,76,218,245,42,162,249,152,191,133,69,45,80,115,11,6,4,34,36,213,253,30,227,37,96,139,30,184,134,167,130,122,25,36,11,47,127,84,212,165,120,135,6,37,60,86,232,180,155,68,63,50,39,186,137,115,22,128,61,77,210,166,115,65,153,170,224,54,0,200,231,135,177,175,140,47,126,202,96,60,194,134,76,251,101,19,173,196,140,79,79,73,53,138,215,207,160,160,191,177,155,87,183,220,20,104,67,36,4,130,153,146,252,151,62,220,132,35,21,98,58,24,77,17,188,27,14,152,180,117,29,129,224,241,128,5,189,252,39,78,151,2,67,152,72,251,169,248,134,0,201,254,238,177,47,13,104,5,42,17,41,45,19,157,154,89,170,161,20,241,190,73,171,217,163,169,204,61,146,241,134,157,74,253,59,198,156,53,90,123,73,78,38,185,230,240,71,38,14,137,103,161,207,196,134,140,122,128,118,198,1,89,177,17,72,255,169,161,129,80,131,121,9,14,90,159,174,92,34,60,31,78,176,43,68,113,46,3,10,189,181,144,95,247,126,79,154,10,1,165,199,181,172,13,57,148,107,174,156,49,98,132,109,64,39,84,139,169,228,232,30,83,8,176,20,77,132,130,230,225,210,33,172,178,128,6,221,115,105,190,212,116,236,60,231,195,232,247,170,37,183,87,149,224,105,167,227,30,87,200,254,107,170,217,32,140,45,53,117,190,58,140,179,160,190,62,229,120,254,167,56,200,184,59,219,161,162,183,224,253,105,181,14,47,110,0,78,131,75,254,123,173,130,63,152,242,173,122,146,142,87,61,67,125,79,173,56,239,178,148,176,55,87,202,57,104,21,211,22,231,82,101,116,16,218,146,158,62,189,12,205,240,109,74,91,198,66,91,6,74,95,207,163,125,138,189,217,15,249,201,212,171,181,39,61,100,158,233,105,238,72,189,74,223,255,255,170,175,104,121,58,235,106,85,153,78,175,252,163,44,113,59,182,114,36,52,80,204,127,60,148,176,227,46,217,221,155,1,151,29,59,100,178,180,135,151,152,80,37,220,69,72,234,172,175,249,124,150,241,150,110,103,17,116,137,49,143,11,218,229,183,235,98,58,87,25,44,76,230,149,118,111,240,65,115,220,15,208,242,214,140,174,224,73,27,113,8,103,101,91,87,169,55,120,175,97,173,72,218,141,48,2,252,215,182,129,176,83,49,177,167,99,28,223,209,99,240,46,195,200,121,151,216,150,164,112,198,92,153,91,194,197,172,175,59,120,128,238,5,163,228,63,228,232,245,12,19,54,8,76,68,162,214,79,181,234,20,20,75,165,116,3,15,72,135,111,143,194,38,0,91,24,140,239,233,30,184,137,157,203,145,185,9,197,184,162,36,189,114,158,121,238,46,201,147,100,32,27,191,9,65,112,158,102,123,6,96,100,108,111,150,181,12,78,235,33,32,162,183,190,51,149,203,124,3,165,63,251,20,110,101,140,22,244,102,26,227,69,3,14,241,249,65,61,6,43,96,139,155,34,173,65,160,150,226,73,83,43,247,151,157,189,68,76,67,17,126,152,230,187,48,147,64,130,200,111,141,182,50,205,64,91,201,63,114,113,207,119,134,89,67,96,34,211,210,144,241,244,31,5,190,102,140,19,134,22,59,239,226,73,246,237,54,20,159,201,32,253,27,7,90,232,97,11,98,74,69,149,120,117,142,42,235,180,213,250,145,132,0,69,110,178,51,2,193,8,47,15,45,226,174,197,90,12,14,132,138,201,185,39,101,142,145,220,252,9,32,226,24,162,27,142,79,100,203,211,0,77,73,188,134,89,4,90,18,37,65,185,12,58,188,171,163,122,12,248,62,1,17,125,219,88,219,113,141,114,137,183,52,220,240,94,201,208,69,112,104,181,46,238,49,107,72,122,239,219,35,15,138,159,180,232,168,129,222,120,84,68,162,120,17,42,179,36,49,214,183,82,209,203,102,222,28,226,59,36,66,64,129,39,56,221,92,7,121,199,243,216,251,2,92,43,91,94,194,105,216,29,131,221,163,9,186,146,32,161,132,179,221,83,38,205,28,163,2,64,12,169,14,242,126,8,40,110,233,157,145,214,143,170,62,70,172,204,86},
  {140,90,40,128,87,96,155,132,130,71,44,33,223,9,81,232,227,100,237,203,211,113,53,49,65,131,180,206,18,48,53,82,89,225,210,1,183,152,42,36,184,89,110,40,157,64,201,128,64,167,145,156,4,85,189,160,197,184,21,187,62,63,42,96,54,62,89,37,251,206,45,81,49,227,167,208,119,233,64,1,14,70,124,118,59,34,85,23,149,59,216,236,139,113,97,71,112,190,158,36,14,145,201,135,58,4,20,12,47,147,92,49,130,54,112,135,6,254,214,78,28,204,140,185,27,159,183,180,27,230,13,196,240,137,38,37,147,253,121,184,110,197,144,60,220,110,160,252,105,129,202,192,156,137,210,31,190,79,90,90,213,64,68,10,186,209,70,2,66,198,80,194,28,183,66,3,187,126,37,182,1,137,9,183,122,124,157,109,160,68,52,36,41,233,185,165,6,90,72,202,104,246,230,53,232,192,212,76,241,48,99,51,4,211,161,15,123,199,117,24,116,244,117,0,19,78,160,47,51,58,162,0,54,160,123,137,172,96,105,46,15,55,63,92,252,215,230,132,244,250,189,10,100,88,81,252,251,207,126,238,217,90,126,4,26,76,53,176,165,45,180,247,153,195,186,48,10,211,218,31,153,49,96,99,85,103,111,114,182,129,249,226,7,12,161,27,250,199,43,75,53,147,223,59,92,201,190,81,223,205,217,230,105,51,190,142,82,9,181,45,47,71,241,30,88,131,154,57,122,167,4,40,109,95,180,231,163,65,160,243,7,242,197,52,239,141,94,87,115,249,241,103,122,143,33,142,210,235,158,204,80,50,143,57,184,41,101,9,49,134,214,150,195,9,35,155,112,181,122,4,216,34,184,238,188,48,34,174,40,112,11,45,48,14,91,60,237,150,240,176,166,63,70,167,122,143,7,119,163,208,85,75,37,236,43,172,27,105,181,57,150,19,225,177,105,27,87,137,158,33,99,51,0,84,25,50,250,99,150,243,166,136,210,160,70,120,81,187,25,95,165,136,254,191,61,30,222,167,230,48,129,62,229,93,252,16,42,224,124,107,242,219,40,195,69,16,134,21,80,10,190,48,235,92,113,199,191,92,218,115,34,86,162,169,249,69,252,139,173,176,87,118,109,81,167,4,18,92,68,113,246,66,110,46,49,228,37,153,144,228,103,25,26,129,69,248,166,67,214,118,28,112,78,9,29,101,94,165,22,221,247,139,68,73,9,177,253,27,239,124,71,4,124,241,237,178,168,170,115,120,133,254,104,61,17,220,219,163,50,125,167,8,148,5,243,43,47,247,203,36,43,254,93,143,208,215,167,100,37,28,64,0,57,32,88,167,183,9,158,13,29,130,148,171,164,193,4,170,168,6,130,191,221,199,148,48,60,178,94,49,93,170,176,208,24,31,32,244,29,78,59,218,26,77,108,218,33,16,189,126,164,7,182,143,6,84,233,58,85,189,46,219,218,157,22,185,191,242,251,251,131,53,246,1,208,143,49,83,167,215,236,110,199,98,137,80,94,209,241,244,249,235,210,195,193,175,28,183,133,210,113,111,34,78,232,211,145,56,86,47,46,85,3,70,238,30,10,110,81,214,85,7,117,179,206,198,24,92,17,120,113,139,144,74,22,178,235,163,77,58,33,182,178,27,248,57,16,23,153,124,226,90,72,17,60,29,98,45,226,46,11,70,57,211,135,186,140,85,22,117,154,146,200,4,154,217,210,202,52,233,192,124,24,8,43,28,161,30,7,243,165,116,115,243,6,108,92,76,198,62,131,86,78,141,141,100,115,93,52,61,244,154,93,236,176,20,120,168,233,36,53,32,101,162,105,45,8,105,206,236,33,96,251,76,104,82,118,104,83,99,18,84,131,59,180,32,213,62,142,170,166,104,102,29,132,13,238,62,156,67,93,63,67,49,81,182,10,46,26,102,210,52,106,189,38,18,136,69,33,56,131,0,20,186,62,100,91,2,42,164,128,217,27,221,143,159,204,80,47,209,118,106,100,68,204,16,18,41,195,157,78,122,27,124,128,76,227,197,143,201,232,202,67,130,110,180,240,230,125,116,201,195,53,89,112,117,88,87,89,216,224,96,217,45,48,144,7,65,61,253,122,159,229,118,44,80,72,133,242,237,195,100,171,38,175,26,35,134,4,58,227,95,59,147,29,239,30,158,18,65,98,79,81,130,220,182,187,25,59,124,218,174,94,240,170,150,55,60,47,134,13,128,156,20,57,225,243,189,147,141,54,149,248,231,1,122,164,37,20,149,165,168,20,112,17,191,157,123,143,76,196,169,164,175,225,157,243,86,76,181,219,50,91,239,224,78,219,146,151,176,237,136,186,105,138,119,73,13,65,147,175,179,69,170,84,24,203,221,196,181,194,77,117,126,105,37,254,109,152,231,156,244,18,226,142,84,115,149,61,110,16,255,252,238,241,127,237,215,137,164,230,129,151,62,223,233,107,105,17,140,194,25,241,218,77,105,103,22,247,174,73,172,69,207,198,30,253,31,112,254,3,66,79,144,42,164,217,135,170,54,247,164,123,215,200,249,108,0,223,0,155,67,238,66,207,136,147,233,75,121,167,72,18,247,45,148,3,146,61,213,70,202,197,193,32,88,10,133,44,180,197,28,175,168,143,20,70,139,221,245,225,88,159,244,163,215,186,176,112,80,1,6,217,108,85,59,66,225,47,139,68,184,119,14,180,212,186,223,215,223,99,208,141,222,155,80,84,231,138,219,132,125,146,68,170,85,144,230,155,165,134,196,190,11,239,63,170,196,214,224,18,207,132,138,121,57,153,107,132,71,48,181,57,35,239,173,120,247,127,41,22,70,175,236,116,152,115,197,244,82,218,60,97,83,116,247,97,38,18,2,240,99,176,45,56,128,204,200,98,129,12,56,174,53,3,218,100,220,116,13,52,37,0,66,13,131,215,188,128,89,246,5,140,80,29,193,114,162,224,91,80,223,186,155,107,151,192,94,157,25,217,180,150,187,26,159,74,176,130,15,19,48,80,100,168,174,145,133,22,185,105,145,109,11,150,205,228,51,198,214,143,107,108,40,154,228,39,172,234,132,162,193,150,2,248,47,144,64,246,94,173,125,222,145,170,192,30,78,133,163,46,221,201,64,246,253,101,40,180,255,75,205,183,37,242,243,252,111,49,202,10,92,193,255,236,132,135,243,36,17,82,201,135,101,146,27,187,249,201,218,211,10,134,114,109,234,55,57,42,224,186,72,243,2,97,99,57,255,82,72,192,11,47,88,236,227,172,89,81,123,248,120,195,152,175,142,35,153,28,137,163,176,25,51,150,95,31,243,15,25,51,54,147,76,57,118,46,133,54,253,153,221,85,140,96,253,99,248,124,176,59,196,245,160,219,189,35,221,78,246,41,107,7,74,211,176,105,122,44,85,239,85,163,94,2,13,242,66,235,61,242,244,191,54,162,170,161,173,127,84,168,29,250,176,213,41,225,32,180,91,84,66,166,14,49,110,246,41,69,136,221,237,62,229,98,61,118,229,90,104,84,84,132,79,221,234,24,45,23,73,44,114,100,215,169,248,80,97,79,61,135,105,115,99,176,15,199,238,28,147,67,130,159,201,213,255,123,170,236,47,7,23,132,121,75,55,196,217,155,35,133,178,141,89,161,32,116,171,196,151,24,208,58,246,34,42,57,96,241,92,113,147,182,136,63,39,107,128,51,225,128,132,54,161,128,118,48,95,181,208,165,83,237,58,40,188,76,139,110,120,98,1,108,214,68,21,202,107,202,155,65,23,96,188,131,156,52,69,186,130,81,201,32,126,171,240,149,50,243,108,45,75,173,26,173,71,51,170,213,224,83,236,64,205,43,90,145,45,41,9,193,114,184,48,99,83,89,48,3,87,17,165,70,98,22,170,195,232,167,166,217,17,47,180,75,31,127,197,135,79,200,135,198,224,219,90,66,31,117,217,155,79,9,186,11,172,221,122,41,16,110,18,126,72,144,57,112,207,49,119,223,232,229,224,218,186,0,11,113,105,189,63,164,101,98,34,171,148,118,145,137,95,165,176,135,215,62,108,113,135,190,195,141,221,4,212,126,46,122,133,198,173,218,113,88,69,131,21,72,171,13,214,193,201,188,131,140,60,200,157,34,246,115,19,15,237,75,212,154,68,138,53,1,160,164,167,132,9,207,99,116,119,231,84,25,207,221,174,28,201,180,230,171,255,224,6,9,67,105,119,159,116,155,93,125,9,17,170,83,31,70,34,92,21,222,176,73,5,73,39,157,255,247,215,84,14},
} ;

static const unsigned char precomputed_core_multsntrup953_k[precomputed_core_multsntrup953_NUM][crypto_core_KEYBYTES] = {
  {1,-1,-1,0,0,0,0,0,-1,0,0,0,0,-1,0,1,0,1,0,0,-1,0,-1,0,0,0,0,1,1,-1,0,0,0,-1,1,-1,-1,0,0,0,1,-1,-1,1,0,0,-1,-1,1,1,0,1,-1,0,1,0,0,-1,1,1,-1,1,0,-1,0,1,-1,0,0,0,-1,0,-1,1,-1,-1,0,1,0,0,0,-1,-1,0,0,1,1,0,1,1,-1,1,0,-1,1,0,-1,-1,0,1,-1,1,1,-1,0,1,1,1,1,0,1,1,-1,0,-1,1,1,0,0,0,1,0,0,0,-1,-1,0,0,0,0,0,1,-1,1,0,0,0,-1,-1,0,1,1,-1,0,0,0,0,0,0,0,1,0,0,1,1,1,-1,0,1,0,0,-1,-1,1,-1,0,-1,0,0,1,1,1,-1,-1,-1,0,-1,-1,1,0,1,-1,0,0,-1,0,1,0,0,-1,1,0,1,0,-1,0,0,-1,0,0,0,1,-1,-1,0,-1,0,1,-1,-1,0,0,-1,0,0,0,1,0,-1,0,0,0,0,1,0,-1,0,0,-1,0,0,-1,1,0,0,0,-1,1,0,1,0,0,0,0,0,1,1,0,1,0,1,1,0,0,1,-1,0,0,0,1,0,0,0,0,1,0,0,-1,1,1,0,0,0,0,0,-1,0,1,-1,-1,1,0,1,-1,0,1,1,0,0,-1,1,0,-1,1,-1,0,1,0,1,0,0,0,0,1,1,0,0,-1,0,0,0,-1,-1,-1,0,-1,0,-1,0,0,0,0,0,-1,0,-1,0,1,0,0,1,-1,0,1,0,0,0,0,1,0,-1,0,1,1,-1,0,1,0,0,0,-1,1,-1,0,1,-1,0,0,-1,1,-1,0,-1,0,1,0,1,1,0,0,0,1,1,0,1,0,1,-1,-1,-1,0,1,0,1,0,1,-1,-1,0,1,-1,-1,0,-1,-1,1,0,1,-1,0,-1,0,1,0,1,1,0,0,1,1,-1,0,-1,-1,0,1,0,1,0,1,-1,1,1,0,0,0,0,0,-1,0,1,1,0,0,0,-1,0,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,-1,0,-1,0,-1,1,0,1,-1,0,0,-1,1,1,-1,1,-1,1,0,0,0,1,1,0,0,0,1,0,-1,0,-1,-1,-1,1,-1,0,-1,0,0,0,-1,-1,0,0,1,0,1,-1,-1,0,-1,0,1,0,-1,0,-1,0,0,0,0,0,1,0,-1,1,0,0,-1,0,0,0,-1,1,1,1,0,0,1,0,0,-1,1,0,-1,-1,-1,1,0,0,0,1,0,-1,0,-1,0,0,-1,0,-1,0,0,1,-1,0,0,0,1,0,-1,0,1,1,-1,0,0,-1,1,0,0,-1,0,0,1,0,-1,0,1,0,1,0,0,1,1,1,0,1,1,-1,-1,-1,1,1,0,1,0,0,0,0,0,0,0,-1,1,-1,1,0,0,0,1,0,0,0,0,-1,-1,-1,-1,1,1,-1,1,0,-1,0,0,0,-1,0,1,0,-1,0,1,-1,-1,-1,1,-1,1,-1,0,-1,1,-1,1,1,0,1,0,0,1,-1,0,0,-1,1,-1,1,0,0,0,0,0,0,0,-1,0,0,1,-1,0,0,1,0,1,0,-1,-1,0,0,1,0,0,-1,0,0,0,0,0,1,0,0,0,0,0,0,0,-1,0,1,1,1,0,0,0,0,-1,0,-1,-1,0,0,0,1,0,1,-1,0,-1,0,1,0,0,0,1,-1,-1,0,0,-1,0,0,0,1,1,0,-1,1,0,1,-1,0,0,0,-1,-1,-1,1,0,1,0,0,1,-1,0,0,1,-1,1,-1,0,1,0,-1,0,0,0,-1,0,-1,0,-1,-1,1,1,1,-1,1,-1,1,1,-1,1,-1,1,0,-1,0,-1,1,0,-1,0,0,-1,-1,-1,0,0,-1,0,0,0,-1,-1,1,0,0,0,1,0,-1,-1,0,0,0,0,0,1,0,0,1,1,0,1,-1,0,0,1,0,0,0,0,-1,0,0,1,0,0,1,1,-1,1,-1,0,0,1,1,0,1,0,-1,-1,-1,1,-1,-1,1,1,0,0,0,0,0,0,0,0,0,0,1,-1,0,0,1,-1,-1,-1,0,0,-1,0,0,1,1,1,1,-1,-1,0,0,1,0,1,0,0,1,0,-1,0,0,0,-1,-1,1,0,0,-1,-1,0,0,0,0,0,1,0,1,-1,0,0,0,-1,0,0,-1,0,1,0,0,-1,1,0,1,0,0,1,-1,1,1,-1,0,0,0,1,1,0,0,0},
  {0,1,0,-1,0,1,0,1,1,1,1,0,-1,1,-1,0,0,-1,-1,0,1,-1,0,0,-1,0,0,-1,0,0,-1,0,1,-1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,-1,0,0,-1,0,-1,0,0,-1,1,0,-1,-1,0,0,0,-1,0,-1,0,-1,0,0,0,-1,0,0,1,0,0,1,0,0,0,-1,1,0,-1,1,0,0,1,1,-1,0,0,0,1,0,0,0,-1,0,0,1,-1,-1,0,-1,-1,0,0,0,1,-1,0,1,0,-1,0,-1,-1,1,0,-1,-1,0,0,-1,0,0,1,1,0,0,0,-1,0,1,-1,-1,0,-1,0,-1,0,0,0,0,1,0,1,1,0,1,1,-1,0,1,0,1,1,-1,0,-1,1,0,0,0,1,-1,1,-1,1,1,0,0,0,0,0,0,-1,0,-1,0,0,1,0,-1,0,0,0,0,1,1,0,0,1,-1,0,0,-1,-1,0,-1,1,0,0,0,1,-1,0,1,0,0,-1,0,0,-1,0,-1,0,1,1,0,0,0,0,0,-1,0,0,0,-1,-1,-1,1,0,1,-1,-1,0,1,0,1,0,-1,0,0,0,0,-1,-1,0,0,0,0,1,0,1,-1,1,0,1,0,0,0,0,0,0,-1,1,0,0,1,-1,0,0,0,1,-1,-1,0,0,-1,0,0,-1,-1,0,0,0,0,0,0,0,1,0,-1,-1,0,-1,0,-1,-1,1,-1,0,0,1,0,-1,0,0,1,-1,1,-1,0,0,0,1,0,-1,1,1,0,-1,0,1,0,1,-1,0,0,0,0,1,-1,0,0,1,-1,0,0,1,-1,-1,-1,0,0,-1,1,-1,-1,-1,1,0,0,1,-1,0,0,-1,1,-1,0,1,0,1,1,0,0,0,0,0,-1,0,-1,0,0,1,1,0,1,1,-1,-1,0,-1,-1,0,-1,0,-1,1,0,-1,0,0,1,1,0,-1,1,0,1,-1,1,-1,-1,0,-1,0,0,-1,0,1,0,0,1,1,0,0,1,0,0,0,0,-1,0,-1,0,0,-1,0,1,0,-1,0,1,0,1,0,1,1,0,-1,1,1,-1,0,0,1,-1,1,-1,0,1,-1,0,0,-1,-1,0,0,1,1,1,0,0,0,0,0,-1,1,1,-1,1,1,1,0,-1,1,0,1,0,1,1,0,0,1,-1,1,0,-1,1,1,1,-1,1,0,1,0,0,0,-1,-1,-1,1,0,0,-1,1,-1,0,0,0,-1,0,1,1,-1,0,1,-1,-1,-1,1,1,0,1,-1,0,-1,0,0,0,0,0,-1,0,0,-1,0,1,-1,-1,0,1,0,1,0,0,0,-1,-1,-1,0,0,0,-1,-1,0,0,0,0,1,1,-1,0,-1,-1,0,0,-1,1,1,0,0,1,0,-1,0,0,1,0,0,-1,-1,0,1,-1,0,1,0,0,0,1,0,1,0,1,0,-1,1,-1,0,0,0,0,0,-1,-1,0,0,-1,-1,1,0,0,0,-1,-1,0,1,0,0,0,0,0,-1,1,1,1,0,0,0,-1,-1,-1,1,-1,-1,-1,1,0,0,-1,0,0,0,0,0,1,0,0,-1,0,0,-1,0,1,0,-1,0,1,0,0,-1,0,0,0,0,0,-1,0,0,0,-1,0,-1,0,0,-1,-1,0,0,1,1,1,-1,-1,0,1,0,-1,0,0,1,0,-1,-1,-1,0,1,-1,-1,0,1,-1,1,1,1,-1,0,1,-1,1,0,0,0,1,-1,0,1,1,0,0,-1,0,1,0,1,0,-1,0,0,0,0,0,-1,-1,-1,1,0,1,-1,0,0,1,0,-1,0,0,0,1,1,0,0,-1,1,-1,0,0,1,0,-1,-1,0,-1,-1,-1,1,0,-1,-1,-1,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,-1,0,1,1,0,0,0,0,-1,1,0,1,-1,1,0,0,-1,0,0,-1,-1,1,0,0,1,0,0,1,1,-1,1,1,0,0,1,-1,1,-1,0,1,0,-1,1,1,-1,-1,1,0,0,0,1,1,-1,0,0,0,0,1,0,0,1,1,0,0,0,1,1,0,0,0,1,-1,0,-1,1,0,0,-1,0,0,-1,-1,1,1,-1,0,1,1,0,-1,0,0,-1,0,0,-1,-1,1,0,0,0,0,0,1,-1,0,0,0,0,0,-1,0,0,0,0,1,0,1,1,1,0,1,-1,0,0,0,1,-1,1,1,1,0,0,0,0,-1,-1,-1,-1,-1},
  {0,1,1,0,0,-1,1,0,1,0,0,0,0,0,-1,-1,-1,0,0,0,0,1,1,0,-1,-1,1,0,-1,0,0,-1,0,0,0,1,1,-1,0,0,0,0,-1,-1,-1,0,0,0,0,-1,0,0,1,0,0,-1,1,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,0,-1,0,-1,0,-1,-1,0,0,-1,0,0,1,-1,1,-1,0,0,0,1,-1,0,0,0,1,1,1,1,1,-1,1,1,0,0,0,1,1,0,0,0,0,0,1,-1,0,-1,0,1,1,0,0,0,0,0,-1,-1,1,0,-1,0,0,0,0,0,-1,-1,0,0,1,1,0,0,1,1,0,0,0,0,0,-1,0,-1,1,0,1,0,1,0,1,1,1,0,0,0,1,1,0,0,1,1,1,-1,1,0,1,-1,-1,0,1,0,0,1,1,0,0,1,-1,1,0,-1,-1,1,0,0,-1,-1,0,0,1,1,1,-1,1,-1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,-1,0,-1,0,0,0,0,0,0,-1,-1,0,-1,1,-1,1,0,1,0,-1,0,-1,-1,0,0,0,0,0,1,0,1,0,1,0,-1,1,-1,0,1,-1,0,0,-1,1,-1,0,1,0,0,1,0,1,0,0,-1,0,0,0,0,-1,0,1,1,-1,-1,0,1,0,1,-1,0,0,0,1,0,-1,0,1,-1,-1,0,1,0,0,-1,0,0,0,0,1,-1,-1,0,0,-1,-1,-1,0,1,0,0,-1,0,-1,0,-1,1,0,1,-1,0,0,0,0,-1,0,0,0,0,-1,0,1,-1,-1,1,0,-1,0,0,1,-1,-1,1,1,1,-1,1,-1,1,0,-1,0,1,0,-1,-1,0,0,1,1,1,-1,0,1,0,0,0,0,0,0,-1,0,1,-1,1,-1,1,0,0,1,-1,0,1,1,1,0,0,-1,-1,0,1,1,1,0,0,0,-1,-1,0,-1,0,0,0,0,0,1,0,0,1,0,0,1,0,-1,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,-1,0,-1,0,0,-1,0,0,1,0,-1,-1,0,0,0,1,1,0,0,-1,0,1,1,1,0,0,0,0,0,-1,0,0,0,-1,1,0,1,1,1,0,1,0,-1,-1,-1,1,0,1,-1,1,-1,0,0,-1,0,-1,-1,0,0,-1,-1,-1,1,0,1,1,0,0,1,-1,0,0,0,0,1,0,1,1,0,-1,0,1,1,0,-1,1,1,0,0,1,-1,0,0,1,1,0,0,-1,-1,-1,0,-1,1,0,0,0,1,-1,0,0,0,0,0,0,0,-1,-1,0,0,-1,0,0,1,1,0,0,-1,0,1,-1,0,0,0,0,-1,0,0,0,1,0,-1,0,0,0,-1,-1,0,-1,-1,1,0,1,-1,0,-1,0,1,0,0,-1,-1,0,-1,0,1,1,1,0,-1,0,1,0,1,1,1,1,-1,-1,-1,0,-1,1,-1,0,-1,-1,0,1,0,-1,-1,-1,0,0,1,1,0,1,1,1,-1,0,1,0,1,0,-1,-1,1,0,-1,1,-1,1,0,-1,-1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,-1,0,-1,0,-1,-1,0,0,-1,0,1,-1,-1,0,1,0,1,0,0,0,0,1,1,0,0,1,-1,1,-1,-1,1,0,0,1,1,0,1,1,0,1,0,0,-1,1,1,1,-1,0,1,-1,0,-1,0,-1,-1,1,1,0,1,0,0,-1,1,1,-1,1,1,-1,0,1,0,0,-1,0,0,0,-1,0,0,-1,0,1,-1,1,0,0,1,0,0,-1,0,-1,1,1,-1,0,1,1,1,0,1,0,0,1,-1,-1,0,-1,-1,0,0,-1,0,0,1,0,0,1,0,1,1,1,0,1,0,0,0,-1,1,0,-1,1,0,-1,1,1,0,0,0,-1,0,-1,0,-1,1,1,0,-1,1,0,1,1,0,-1,1,1,0,0,0,-1,0,0,-1,0,-1,0,-1,0,1,1,1,0,0,1,-1,0,-1,0,0,1,0,-1,1,-1,0,1,1,1,0,0,-1,0,0,0,0,0,1,0,0,0,1,0,0,0,-1,0,0,0,0,0,0,1,-1,0,-1,1,0,1,1,1,1,-1,1,1,0,0,1,-1,0,1,0,1,0,-1,0,-1,0,1,-1,0,-1,1,0,0,0,1,0,-1,0,0,0,0,-1,0,0,0,1,1,0,0,0,0,0,-1,0,-1,0,-1,1,-1,0,0,1,-1,-1},
  {1,0,0,0,0,1,0,0,0,-1,0,0,-1,0,0,0,0,0,0,0,0,0,1,0,-1,0,0,0,-1,0,0,1,0,-1,0,0,-1,0,0,1,-1,1,1,0,0,1,-1,0,-1,0,-1,-1,0,0,0,1,1,1,0,-1,1,0,-1,0,0,0,0,1,-1,1,1,0,0,0,0,1,0,0,-1,0,-1,-1,0,-1,1,-1,0,0,1,0,-1,0,0,0,-1,-1,1,0,-1,-1,1,1,0,-1,0,1,0,1,-1,0,0,-1,-1,0,0,-1,0,0,0,0,-1,0,0,1,0,0,-1,-1,1,0,1,0,0,0,0,0,0,-1,0,0,-1,1,-1,0,-1,0,-1,0,0,0,-1,1,0,0,1,0,0,1,0,1,0,0,1,0,-1,0,0,0,1,0,0,0,0,1,1,-1,0,0,0,0,0,-1,-1,0,-1,0,1,0,1,0,0,1,1,1,0,0,-1,-1,0,-1,-1,0,-1,1,0,0,0,0,0,0,0,-1,0,1,-1,1,0,0,-1,1,0,-1,-1,0,1,0,-1,-1,0,-1,0,0,1,-1,-1,-1,0,-1,1,0,0,1,-1,0,0,0,0,0,0,0,0,-1,0,1,1,-1,-1,-1,1,-1,0,0,0,-1,0,0,0,-1,1,0,0,-1,0,0,0,1,0,0,0,1,0,1,0,-1,0,0,0,0,-1,1,0,0,0,-1,1,0,0,-1,1,-1,0,1,1,1,0,0,0,-1,0,-1,-1,1,1,0,1,0,-1,-1,0,0,1,-1,0,0,-1,1,-1,1,-1,0,0,-1,0,0,1,0,0,0,0,0,0,-1,-1,0,-1,-1,0,0,0,0,1,0,-1,0,0,0,1,1,-1,0,-1,1,1,0,1,0,1,1,0,0,0,0,0,1,1,-1,1,0,1,0,0,1,-1,0,1,0,0,1,0,0,-1,-1,0,0,0,1,0,0,1,1,0,1,0,0,0,1,0,0,1,0,0,0,-1,1,1,0,-1,0,0,0,0,0,1,0,0,0,0,0,0,-1,0,0,-1,0,-1,0,0,1,1,0,1,1,1,1,1,1,-1,0,-1,0,0,1,-1,1,0,0,1,1,1,-1,0,0,0,-1,0,0,0,1,0,0,0,0,0,1,0,1,-1,1,-1,-1,-1,1,1,1,0,0,0,0,0,0,0,0,0,-1,-1,0,1,-1,-1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,-1,0,1,0,0,0,0,0,1,0,1,1,-1,0,0,1,-1,0,-1,1,0,0,0,1,0,0,0,1,0,0,-1,-1,1,0,-1,0,0,0,0,1,-1,-1,0,1,0,0,0,0,1,-1,0,1,-1,0,-1,0,1,-1,1,0,0,0,-1,0,1,1,0,0,-1,0,0,0,0,1,0,1,-1,0,0,1,0,1,0,-1,1,-1,-1,1,0,0,1,1,0,-1,0,1,0,0,1,0,0,1,0,-1,0,0,0,0,0,0,1,0,0,-1,-1,-1,-1,0,0,-1,0,1,-1,0,0,-1,0,0,1,0,-1,1,0,0,-1,0,0,0,-1,-1,0,1,1,0,1,1,-1,-1,-1,0,0,0,0,0,1,1,0,0,1,-1,-1,0,1,-1,0,1,0,1,-1,1,0,0,0,0,-1,0,0,0,0,0,-1,0,0,-1,0,-1,0,1,-1,0,1,1,0,0,0,-1,0,-1,0,-1,0,0,0,1,-1,0,1,1,1,-1,1,1,0,0,-1,0,0,0,0,0,-1,-1,0,0,0,0,0,0,0,0,1,0,0,0,-1,1,1,0,0,-1,0,0,1,0,0,0,0,0,-1,-1,-1,0,-1,0,0,0,0,0,0,-1,0,0,0,1,1,0,0,0,0,-1,-1,0,0,1,-1,0,-1,0,0,1,1,0,1,0,0,1,-1,0,1,-1,-1,1,0,1,0,0,-1,-1,1,0,1,0,0,-1,0,1,0,0,0,1,-1,0,-1,1,0,0,-1,-1,-1,1,0,-1,-1,0,1,0,0,1,-1,1,0,0,-1,0,1,-1,0,0,-1,-1,1,0,-1,-1,-1,-1,1,0,-1,0,-1,1,0,0,0,0,0,0,-1,-1,-1,1,0,0,1,1,-1,-1,0,0,-1,1,0,-1,0,1,0,0,0,0,0,1,-1,0,0,0,0,0,0,-1,1,0,0,0,0,1,0,0,0,1,0,-1,0,1,-1,0,1,1,-1,-1,0,0,1,-1,0,0,0,-1,1,-1,0,-1,0,0,-1,0,0,0,0,0,1,-1,1,0,1,-1,1,0},
} ;

static const unsigned char precomputed_core_multsntrup953_c[precomputed_core_multsntrup953_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup953_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup953_h;
  unsigned char *n = test_core_multsntrup953_n;
  unsigned char *k = test_core_multsntrup953_k;
  unsigned char *c = test_core_multsntrup953_c;
  unsigned char *h2 = test_core_multsntrup953_h2;
  unsigned char *n2 = test_core_multsntrup953_n2;
  unsigned char *k2 = test_core_multsntrup953_k2;
  unsigned char *c2 = test_core_multsntrup953_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup953_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup953(impl);
    printf("core_multsntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup953_implementation(impl),ntruprime_dispatch_core_multsntrup953_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup953;
    printf("core_multsntrup953 selected implementation %s compiler %s\n",ntruprime_core_multsntrup953_implementation(),ntruprime_core_multsntrup953_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup953_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup953_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup953_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup953_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup953_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup953_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup953_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup953_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup953_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup953_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup953(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup953")) return;
  storage_core_multsntrup953_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup953_h = aligned(storage_core_multsntrup953_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup953_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup953_n = aligned(storage_core_multsntrup953_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup953_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup953_k = aligned(storage_core_multsntrup953_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup953_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup953_c = aligned(storage_core_multsntrup953_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup953_h2 = callocplus(maxalloc);
  test_core_multsntrup953_h2 = aligned(storage_core_multsntrup953_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup953_n2 = callocplus(maxalloc);
  test_core_multsntrup953_n2 = aligned(storage_core_multsntrup953_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup953_k2 = callocplus(maxalloc);
  test_core_multsntrup953_k2 = aligned(storage_core_multsntrup953_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup953_c2 = callocplus(maxalloc);
  test_core_multsntrup953_c2 = aligned(storage_core_multsntrup953_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup953 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup953();++impl)
      forked(test_core_multsntrup953_impl,impl);
    ++test_core_multsntrup953_h;
    ++test_core_multsntrup953_n;
    ++test_core_multsntrup953_k;
    ++test_core_multsntrup953_c;
    ++test_core_multsntrup953_h2;
    ++test_core_multsntrup953_n2;
    ++test_core_multsntrup953_k2;
    ++test_core_multsntrup953_c2;
  }
  free(storage_core_multsntrup953_c2);
  free(storage_core_multsntrup953_k2);
  free(storage_core_multsntrup953_n2);
  free(storage_core_multsntrup953_h2);
  free(storage_core_multsntrup953_c);
  free(storage_core_multsntrup953_k);
  free(storage_core_multsntrup953_n);
  free(storage_core_multsntrup953_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

