/*
 * libkysdk-qtwidgets's Library
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#ifndef KPROGRESSCIRCLE_H
#define KPROGRESSCIRCLE_H
#include "gui_g.h"
#include <QWidget>
#include "kprogressbar.h"

namespace kdk
{
class KProgressCirclePrivate;

class GUI_EXPORT KProgressCircle : public QWidget
{
    Q_OBJECT

public:
    explicit KProgressCircle(QWidget *parent = nullptr);
    int minimum() const;
    int maximum() const;

    int value() const;

    QString text() const;
    void setTextVisible(bool visible);
    bool isTextVisible() const;
    ProgressBarState state();
    void setState(ProgressBarState state);

Q_SIGNALS:
    void valueChanged(int value);

public Q_SLOTS:
    void reset();
    void setRange(int minimum, int maximum);
    void setMinimum(int minimum);
    void setMaximum(int maximum);
    void setValue(int value);

protected:
    void paintEvent(QPaintEvent *) override;

private:
    Q_DECLARE_PRIVATE(KProgressCircle)
    KProgressCirclePrivate* const d_ptr;
};
}


#endif // KPROGRESSCIRCLE_H
