/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.PrecisionFilter;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;

public final class SQLServerDatabaseMetaData
implements DatabaseMetaData,
Serializable {
    private SQLServerConnection connection;
    static final String urlprefix = "jdbc:sqlserver://";
    private static final String SP_COLUMN_PRIVILEGES = "{ call sp_column_privileges(?, ?, ?, ?)}";
    private static final String SP_TABLES = "{ call sp_tables(?, ?, ?, ?) }";
    private static final String SP_COLUMNS = "{ call sp_columns(?, ?, ?, ?, ?) }";
    private static final String SP_SPECIAL_COLUMNS = "{ call sp_special_columns (?, ?, ?, ?, ?, ?, ?)}";
    private static final String SP_FKEYS = "{ call sp_fkeys (?, ?, ?, ? , ? ,?)}";
    private static final String SP_STATISTICS = "{ call sp_statistics(?,?,?,?,?) }";
    private static final String SP_SPROC_COLUMNS = "{ call sp_sproc_columns(?, ?, ?,?,?) }";
    private static final String SP_STORED_PROCEDURES = "{call sp_stored_procedures(?, ?, ?) }";
    private static final String SP_TABLE_PRIVILEGES = "{call sp_table_privileges(?,?,?) }";
    private static final String SP_PKEYS = "{ call sp_pkeys (?, ?, ?)}";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String ATTR_NAME = "ATTR_NAME";
    private static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String ATTR_SIZE = "ATTR_SIZE";
    private static final String ATTR_DEF = "ATTR_DEF";
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String DEFERRABILITY = "DEFERRABILITY";
    private static final String DELETE_RULE = "DELETE_RULE";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final String FK_NAME = "FK_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String FKTABLE_CAT = "FKTABLE_CAT";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String GRANTEE = "GRANTEE";
    private static final String GRANTOR = "GRANTOR";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String IS_GRANTABLE = "IS_GRANTABLE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String LENGTH = "LENGTH";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String NULLABLE = "NULLABLE";
    private static final String NUM_INPUT_PARAMS = "NUM_INPUT_PARAMS";
    private static final String NUM_OUTPUT_PARAMS = "NUM_OUTPUT_PARAMS";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String NUM_RESULT_SETS = "NUM_RESULT_SETS";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String PAGES = "PAGES";
    private static final String PK_NAME = "PK_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String PKTABLE_CAT = "PKTABLE_CAT";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String PRECISION = "PRECISION";
    private static final String PRIVILEGE = "PRIVILEGE";
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String RADIX = "RADIX";
    private static final String REMARKS = "REMARKS";
    private static final String SCALE = "SCALE";
    private static final String SCOPE = "SCOPE";
    private static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String SS_DATA_TYPE = "SS_DATA_TYPE";
    private static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE = "TYPE";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String UPDATE_RULE = "UPDATE_RULE";
    private static final String[] getColumnPrivilegesColumnNames;
    private static final String[] getTablesColumnNames;
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char ESCAPE = '\\';
    static final char PERCENT = '%';
    static final char UNDERSCORE = '_';
    static final char[] DOUBLE_RIGHT_BRACKET;
    private static final String[] getColumnsColumnNames;
    private static final String[] getBestRowIdentifierColumnNames;
    private static final String[] pkfkColumnNames;
    private static final String[] getIndexInfoColumnNames;
    private static final String[] getPrimaryKeysColumnNames;
    private static final String[] getProcedureColumnsColumnNames;
    private static final String[] getProceduresColumnNames;
    private static final String[] getTablePrivilegesColumnNames;
    private static final String[] getVersionColumnsColumnNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SQLServerDatabaseMetaData(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
    }

    private void checkClosed() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionClosed"), null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SQLServerResultSet getResultSetFromInternalQueries(String string, String string2) throws SQLServerException {
        this.checkClosed();
        String string3 = null;
        string3 = this.switchCatalogs(string);
        SQLServerResultSet sQLServerResultSet = null;
        try {
            sQLServerResultSet = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal(string2);
            Object var6_5 = null;
            if (null == string3) return sQLServerResultSet;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == string3) throw throwable;
            this.connection.setCatalog(string3);
            throw throwable;
        }
        this.connection.setCatalog(string3);
        return sQLServerResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SQLServerResultSet getResultSetFromStoredProc(String string, String string2, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (!$assertionsDisabled && null == stringArray) {
            throw new AssertionError();
        }
        String string3 = null;
        string3 = this.switchCatalogs(string);
        SQLServerResultSet sQLServerResultSet = null;
        try {
            SQLServerCallableStatement sQLServerCallableStatement = (SQLServerCallableStatement)this.connection.prepareCall(string2);
            for (int i = 1; i <= stringArray.length; ++i) {
                sQLServerCallableStatement.setString(i, stringArray[i - 1]);
            }
            sQLServerResultSet = (SQLServerResultSet)sQLServerCallableStatement.executeQueryInternal();
            Object var9_8 = null;
            if (null == string3) return sQLServerResultSet;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (null == string3) throw throwable;
            this.connection.setCatalog(string3);
            throw throwable;
        }
        this.connection.setCatalog(string3);
        return sQLServerResultSet;
    }

    private final SQLServerResultSet getResultSetWithProvidedColumnNames(String string, String string2, String[] stringArray, String[] stringArray2) throws SQLServerException {
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromStoredProc(string, string2, stringArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            sQLServerResultSet.setColumnName(1 + i, stringArray2[i]);
        }
        return sQLServerResultSet;
    }

    private String switchCatalogs(String string) throws SQLServerException {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = null;
        string3 = this.connection.getCatalog().trim();
        if (string3.equals(string2 = string.trim())) {
            return null;
        }
        this.connection.setCatalog(string2);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public boolean allProceduresAreCallable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public ResultSet getCatalogs() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT name AS TABLE_CAT FROM master.dbo.sysdatabases order by name";
        return this.getResultSetFromInternalQueries(null, string);
    }

    public String getCatalogSeparator() throws SQLServerException {
        this.checkClosed();
        return ".";
    }

    public String getCatalogTerm() throws SQLServerException {
        this.checkClosed();
        return "database";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        string4 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        String[] stringArray = new String[]{string3, string2, string, string4};
        return this.getResultSetWithProvidedColumnNames(string, SP_COLUMN_PRIVILEGES, stringArray, getColumnPrivilegesColumnNames);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray2 = new String[4];
        stringArray2[0] = string3;
        stringArray2[1] = string2;
        stringArray2[2] = string;
        String string4 = null;
        if (stringArray != null) {
            string4 = "'";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + "''" + stringArray[i] + "''";
            }
            string4 = string4 + "'";
        }
        stringArray2[3] = string4;
        return this.getResultSetWithProvidedColumnNames(string, SP_TABLES, stringArray2, getTablesColumnNames);
    }

    private static String EscapeIDName(String string) throws SQLServerException {
        if (null == string) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\\' == c && ++i < string.length()) {
                c = string.charAt(i);
                switch (c) {
                    case '%': 
                    case '[': 
                    case '_': {
                        stringBuffer.append('[');
                        stringBuffer.append(c);
                        stringBuffer.append(']');
                        break;
                    }
                    case '\\': 
                    case ']': {
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String string5 = SQLServerDatabaseMetaData.EscapeIDName(string4);
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray = new String[]{string3, string2, string, string5, "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, SP_COLUMNS, stringArray, getColumnsColumnNames);
        sQLServerResultSet.setFilter(5, new DataTypeFilter());
        sQLServerResultSet.setFilter(7, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "R", 0 == n ? "T" : "T", bl ? "U" : "O", "2"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, SP_SPECIAL_COLUMNS, stringArray, getBestRowIdentifierColumnNames);
        sQLServerResultSet.setFilter(3, new DataTypeFilter());
        sQLServerResultSet.setFilter(5, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, string6, string5, string4};
        return this.getResultSetWithProvidedColumnNames(null, SP_FKEYS, stringArray, pkfkColumnNames);
    }

    public String getDatabaseProductName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft SQL Server";
    }

    public String getDatabaseProductVersion() throws SQLServerException {
        this.checkClosed();
        return this.connection.sqlServerVersion;
    }

    public int getDefaultTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    public int getDriverMajorVersion() {
        return Util.majorVersion();
    }

    public int getDriverMinorVersion() {
        try {
            Integer n = new Integer(Util.minorVersion());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getDriverName() throws SQLServerException {
        this.checkClosed();
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        return string;
    }

    public String getDriverVersion() throws SQLServerException {
        int n = this.getDriverMinorVersion();
        String string = this.getDriverMajorVersion() + ".";
        string = string + "" + n;
        string = string + ".";
        string = string + 2828;
        string = string + ".";
        string = string + 100;
        return string;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, null, null, null};
        return this.getResultSetWithProvidedColumnNames(string, SP_FKEYS, stringArray, pkfkColumnNames);
    }

    public String getExtraNameCharacters() throws SQLServerException {
        this.checkClosed();
        return "$#@";
    }

    public String getIdentifierQuoteString() throws SQLServerException {
        this.checkClosed();
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{null, null, null, string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, SP_FKEYS, stringArray, pkfkColumnNames);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "%", bl ? "Y" : "N"};
        return this.getResultSetWithProvidedColumnNames(string, SP_STATISTICS, stringArray, getIndexInfoColumnNames);
    }

    public int getMaxBinaryLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxCharLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLServerException {
        this.checkClosed();
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLServerException {
        this.checkClosed();
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLServerException {
        this.checkClosed();
        return 1024;
    }

    public int getMaxConnections() throws SQLServerException {
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            try {
                String string = "sp_configure 'user connections'";
                SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, string);
                if (!sQLServerResultSet.next()) {
                    return 0;
                }
                return sQLServerResultSet.getInt("maximum");
            }
            catch (SQLServerException sQLServerException) {
                return 0;
            }
        }
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxIndexLength() throws SQLServerException {
        this.checkClosed();
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxRowSize() throws SQLServerException {
        this.checkClosed();
        return 8060;
    }

    public int getMaxSchemaNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxStatementLength() throws SQLServerException {
        this.checkClosed();
        return 65536 * this.connection.getTDSPacketSize();
    }

    public int getMaxStatements() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getMaxTableNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLServerException {
        this.checkClosed();
        return 256;
    }

    public int getMaxUserNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    public String getNumericFunctions() throws SQLServerException {
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
        }
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, SP_PKEYS, stringArray, getPrimaryKeysColumnNames);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3 = SQLServerDatabaseMetaData.EscapeIDName(string3), string2, string, string4 = SQLServerDatabaseMetaData.EscapeIDName(string4), "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, SP_SPROC_COLUMNS, stringArray, getProcedureColumnsColumnNames);
        sQLServerResultSet.setFilter(6, new DataTypeFilter());
        sQLServerResultSet.setFilter(8, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{SQLServerDatabaseMetaData.EscapeIDName(string3), string2, string};
        return this.getResultSetWithProvidedColumnNames(string, SP_STORED_PROCEDURES, stringArray, getProceduresColumnNames);
    }

    public String getProcedureTerm() throws SQLServerException {
        this.checkClosed();
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLServerException {
        String string;
        this.checkClosed();
        if (this.connection.isYukonOrLater()) {
            string = "select sys.database_principals.name 'TABLE_SCHEM', sys.database_principals.default_schema_name 'TABLE_CATALOG' from sys.database_principals";
            string = string + " where not sid is null order by sys.database_principals.name";
        } else {
            string = "select sysusers.name 'TABLE_SCHEM' from sysusers where not ";
            string = string + "sid";
            string = string + " is null order by sysusers.name";
        }
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, string);
        return sQLServerResultSet;
    }

    public String getSchemaTerm() throws SQLServerException {
        this.checkClosed();
        return "schema";
    }

    public String getSearchStringEscape() throws SQLServerException {
        this.checkClosed();
        return "\\";
    }

    public String getSQLKeywords() throws SQLServerException {
        this.checkClosed();
        return "BACKUP,BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMPUTE,CONTAINS,CONTAINSTABLE,DATABASE,DBCC,DENY,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,EXIT,FILE,FILLFACTOR,FREETEXT,FREETEXTTABLE,FUNCTION,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,NOCHECK,NONCLUSTERED,OFF,OFFSETS,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OVER,PERCENT,PLAN,PRINT,PROC,RAISERROR,READTEXT,RECONFIGURE,REPLICATION,RESTORE,RETURN,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SETUSER,SHUTDOWN,STATISTICS,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLServerException {
        this.checkClosed();
        return "ASCII,CHAR,CONCAT, DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLServerException {
        this.checkClosed();
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        string3 = SQLServerDatabaseMetaData.EscapeIDName(string3);
        string2 = SQLServerDatabaseMetaData.EscapeIDName(string2);
        String[] stringArray = new String[]{string3, string2, string};
        return this.getResultSetWithProvidedColumnNames(string, SP_TABLE_PRIVILEGES, stringArray, getTablePrivilegesColumnNames);
    }

    public ResultSet getTableTypes() throws SQLServerException {
        this.checkClosed();
        String string = "SELECT 'VIEW' 'TABLE_TYPE' UNION SELECT 'TABLE' UNION SELECT 'SYSTEM TABLE'";
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, string);
        return sQLServerResultSet;
    }

    public String getTimeDateFunctions() throws SQLServerException {
        this.checkClosed();
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLServerException {
        this.checkClosed();
        SQLServerResultSet sQLServerResultSet = this.getResultSetFromInternalQueries(null, "sp_datatype_info @ODBCVer=3");
        sQLServerResultSet.setColumnName(11, "FIXED_PREC_SCALE");
        sQLServerResultSet.setFilter(2, new DataTypeFilter());
        sQLServerResultSet.setFilter(3, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public String getURL() throws SQLServerException {
        this.checkClosed();
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.connection.activeConnectionProperties;
        String string = null;
        String string2 = null;
        String string3 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.equals("integratedSecurity") || string4.equals("user") || string4.equals("password")) continue;
            String string5 = properties.getProperty(string4);
            if (string4.equals("serverName")) {
                string = string5;
                continue;
            }
            if (string4.equals("instanceName")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("portNumber")) {
                string2 = string5;
                continue;
            }
            stringBuffer.append(string4);
            stringBuffer.append("=");
            stringBuffer.append(string5);
            stringBuffer.append(";");
        }
        stringBuffer.insert(0, ";");
        stringBuffer.insert(0, string2);
        stringBuffer.insert(0, ":");
        if (null != string3) {
            stringBuffer.insert(0, string3);
            stringBuffer.insert(0, "\\");
        }
        stringBuffer.insert(0, string);
        stringBuffer.insert(0, urlprefix);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLServerException {
        String string;
        SQLServerStatement sQLServerStatement;
        block9: {
            SQLServerResultSet sQLServerResultSet;
            block7: {
                String string2;
                block8: {
                    this.checkClosed();
                    sQLServerStatement = null;
                    sQLServerResultSet = null;
                    string = "";
                    try {
                        sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                        sQLServerResultSet = sQLServerStatement.executeQueryInternal("select system_user");
                        if (sQLServerResultSet.next()) break block7;
                        string2 = null;
                        Object var6_5 = null;
                        if (sQLServerResultSet == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (sQLServerResultSet != null) {
                            sQLServerResultSet.close();
                        }
                        if (sQLServerStatement != null) {
                            sQLServerStatement.close();
                        }
                        throw throwable;
                    }
                    sQLServerResultSet.close();
                }
                if (sQLServerStatement != null) {
                    sQLServerStatement.close();
                }
                return string2;
            }
            string = sQLServerResultSet.getString(1);
            Object var6_6 = null;
            if (sQLServerResultSet == null) break block9;
            sQLServerResultSet.close();
        }
        if (sQLServerStatement != null) {
            sQLServerStatement.close();
        }
        return string;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        String[] stringArray = new String[]{string3, string2, string, "V", "T", "U", "3"};
        SQLServerResultSet sQLServerResultSet = this.getResultSetWithProvidedColumnNames(string, SP_SPECIAL_COLUMNS, stringArray, getVersionColumnsColumnNames);
        sQLServerResultSet.setFilter(3, new DataTypeFilter());
        sQLServerResultSet.setFilter(5, new PrecisionFilter());
        return sQLServerResultSet;
    }

    public boolean isCatalogAtStart() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLServerException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnion() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsUnionAll() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean usesLocalFiles() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        this.checkConcurrencyType(n2);
        switch (n) {
            case 1003: 
            case 1005: 
            case 1006: 
            case 2004: {
                return true;
            }
            case 1004: 
            case 2003: {
                return 1007 == n2;
            }
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 1005 == n || 1005 == n || 2004 == n;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return n == 1006 || 1003 == n || 2004 == n;
    }

    public boolean updatesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return 1005 == n;
    }

    private void checkResultType(int n) throws SQLServerException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    private void checkConcurrencyType(int n) throws SQLServerException {
        switch (n) {
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: {
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    public boolean insertsAreDetected(int n) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(n);
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLServerException {
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as CLASS_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as REMARKS, cast(0 as smallint) as BASE_TYPE where 0 = 1");
    }

    public Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection.getConnection();
    }

    public int getSQLStateType() throws SQLServerException {
        this.checkClosed();
        if (this.connection != null && this.connection.xopenStates) {
            return 1;
        }
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getDatabaseMinorVersion() throws SQLServerException {
        this.checkClosed();
        String string = this.connection.sqlServerVersion;
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n > 0 && n2 > 0) {
            string = string.substring(n + 1, n2);
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getJDBCMajorVersion() throws SQLServerException {
        this.checkClosed();
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return 1;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLServerException {
        this.checkClosed();
        if (1 == n || 2 == n) {
            return true;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{new Integer(n)};
        throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLServerException {
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as ATTR_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as ATTR_TYPE_NAME, cast(0 as int) as ATTR_SIZE, cast(0 as int) as DECIMAL_DIGITS, cast(0 as int) as NUM_PREC_RADIX, cast(0 as int) as NULLABLE, cast(NULL as char(1)) as REMARKS, cast(NULL as char(1)) as ATTR_DEF, cast(0 as int) as SQL_DATA_TYPE, cast(0 as int) as SQL_DATETIME_SUB, cast(0 as int) as CHAR_OCTET_LENGTH, cast(0 as int) as ORDINAL_POSITION, cast(NULL as char(1)) as IS_NULLABLE, cast(NULL as char(1)) as SCOPE_CATALOG, cast(NULL as char(1)) as SCOPE_SCHEMA, cast(NULL as char(1)) as SCOPE_TABLE, cast(0 as smallint) as SOURCE_DATA_TYPE where 0 = 1");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTABLE_NAME where 0 = 1");
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLServerException {
        this.checkClosed();
        return this.getResultSetFromInternalQueries(string, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTYPE_CAT, cast(NULL as char(1)) as SUPERTYPE_SCHEM, cast(NULL as char(1)) as SUPERTYPE_NAME where 0 = 1");
    }

    public boolean supportsGetGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public boolean supportsNamedParameters() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsSavepoints() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return true;
    }

    static {
        $assertionsDisabled = !SQLServerDatabaseMetaData.class.desiredAssertionStatus();
        getColumnPrivilegesColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE};
        getTablesColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS};
        DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
        getColumnsColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE};
        getBestRowIdentifierColumnNames = new String[]{SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN};
        pkfkColumnNames = new String[]{PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY};
        getIndexInfoColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, INDEX_QUALIFIER, INDEX_NAME, TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION};
        getPrimaryKeysColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME};
        getProcedureColumnsColumnNames = new String[]{PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, LENGTH, SCALE, RADIX, NULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SS_DATA_TYPE};
        getProceduresColumnNames = new String[]{PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, NUM_INPUT_PARAMS, NUM_OUTPUT_PARAMS, NUM_RESULT_SETS, REMARKS, PROCEDURE_TYPE};
        getTablePrivilegesColumnNames = new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE};
        getVersionColumnsColumnNames = new String[]{SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN};
    }
}

