#if !defined(__POSTBANNER_HPP)
#define __POSTBANNER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__DECORATOR_HPP)
#include <Decorator.hpp>
#endif

#if   !defined(__BANNERCOMPONENT_HPP)
#include <BannerComponent.hpp>
#endif

/**
PostBanner is a BannerComponent Decorator that adds information
to the banner.
*/

DECLARE_CLASS( PostBanner );

class PostBanner : public BannerComponent,
   public CORELINUX(Decorator<BannerComponentPtr>)
{
public:

   //
   // Constructors and Destructor
   //
                     /**
                     Default constructor requires a banner and an
                     implementation.
                     @param string const reference
                     @param BannerComponent pointer to implementation
                     */
                  
                     PostBanner( const string &,BannerComponentPtr );
                  
                     /**
                     Copy constructor copies theBanner and
                     the implementation.
                     @param PostBanner const reference
                     */
                  
                     PostBanner( PostBannerCref );
         
            /// Virtual destructor
         
   virtual           ~PostBanner( void );
         
            /**
            Assignmnet operator copies theBanner and
            the implementation.
            @param PostBanner const reference
            @return PostBanner reference (*this)
            */
         
            PostBannerRef   operator=( PostBannerCref );
         
            /**
            Equality operator 
            @param PostBanner const reference
            @return bool - true if theBanner is same
            */
            
            bool  operator==( PostBannerCref ) const;
            
   //
   // Accessors
   //
            
            /**
            Retrieves the banner, only our task is to
            Post-pend the constructed banner first.
            */
            
   virtual  string   getBanner( void ) const;
         
            /**
            drawBanner displays theBanner
            @param ostream - stream output
            @param bool true if endl is appended
            */
         
   virtual  void     drawBanner
               ( 
                  ostream &aStream , 
                  bool doEndl=false 
               ) const;
         
         
protected:
         
            /**
            Default constructor not allowed.
            @exception Exception 
            */
         
            PostBanner( void ) 
               throw(CORELINUX(Exception));


};

#endif // if !defined(__POSTBANNER_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:21 $
   $Locker:  $
*/


