#if !defined (__STATE_HPP)
#define __STATE_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{

   DECLARE_CLASS( Context );
   DECLARE_CLASS( State );

   /**
   Allow an object to alter its behavior when its internal state changes.
   The object will appear to change its class. State is best served
   as a flyweight and singleton.
   */

   class State
   {
   public:
                           /// Default Constructor
                     
                           State( void );

                           /// Virtual Destructor  

      virtual              ~State( void );

      //
      // Operator overloads
      //
               /**
               Equality operator overload
               @param State const reference
               @return true if equal, false otherwise
               */

               bool        operator==( StateCref ) const;

      //
      // Mutators
      //
               /// Called by context 

      virtual  void  handle( void ) = 0;

   protected:
                           /** Copy Constructor
                           @param State const reference
                           @exception Assertion to help enforce singleton
                           */
            
                           State( StateCref ) throw ( Assertion );

               /**
               Assignment operator overload
               @param  State const reference
               @return State reference to self
               @exception Assertion to help enforce singleton
               */
            
               StateRef  operator=( StateCref ) throw ( Assertion );

               /// Sets context state change

               void  setCurrentState( ContextPtr, StatePtr ) 
                  throw ( NullPointerException );

   };

}
          
#endif   // if !defined(__STATE_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/17 03:43:30 $
   $Locker:  $
*/


