### NAME

x25519-cli - command-line interface for the lib25519 implementation of the X25519 encryption system

### SYNOPSIS

Key generation:

        x25519-keypair 5>publickey 9>secretkey

Shared-secret generation for Alice:

        x25519-dh 8<alicesecret 4<bobpublic 7>sharedsecret

### DESCRIPTION

lib25519 is an implementation
of the X25519 encryption system
and the Ed25519 signature system.
The command-line interface for lib25519
provides two X25519 tools,
documented here,
and three Ed25519 tools,
documented separately.

Each tool exits nonzero on failure (e.g., running out of memory), 0 on success.

These tools allow lib25519
to be easily used from shell scripts.
Other languages can also use lib25519 via these tools,
but languages typically have good support for FFI
and can use the C interface directly.

### KEY GENERATION

Alice runs the `x25519-keypair` command.
This command randomly generates
Alice's secret key and Alice's corresponding public key.
It writes the public key to file descriptor 5,
and then writes the secret key to file descriptor 9.

### SHARED-SECRET GENERATION

Alice runs the `x25519-dh` command.
This command reads Alice's secret key from file descriptor 8.
It then reads Bob's public key from file descriptor 4.
It then writes a secret shared between Alice and Bob to file descriptor 7.

### SEE ALSO

**ed25519-cli**(1), **lib25519**(3)
