.\" @(#)$RCSfile: Cns_queryclass.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/08/14 13:09:29 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 2000-2003 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_QUERYCLASS 3 "$Date: 2003/08/14 13:09:29 $" CASTOR "Cns Library Functions"
.SH NAME
Cns_queryclass \- query about a fileclass definition in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_queryclass (char *" server ,
.BI "int " classid ,
.BI "char *" class_name ,
.BI "struct Cns_fileclass *" Cns_fileclass )
.SH DESCRIPTION
.B Cns_queryclass
queries about a fileclass definition in the name server.
The fileclass can be identified by
.I classid
or by
.IR class_name .
If both are specified, they must point at the same class.
.TP
.I server
specifies the CASTOR Name Server where the fileclass is currently defined.
.TP
.I Cns_fileclass
is a pointer to the structure which will receive the fileclass description:
.PP
.nf
.ft CW
struct Cns_fileclass {
        int     classid;
        char    name[CA_MAXCLASNAMELEN+1];
        uid_t   uid;
        gid_t   gid;
        int     min_filesize;   /* in Mbytes */
        int     max_filesize;   /* in Mbytes */
        int     flags;
        int     maxdrives;
        int     max_segsize;    /* in Mbytes */
        int     migr_time_interval;
        int     mintime_beforemigr;
        int     nbcopies;
        int     retenp_on_disk;
        char    stager[CA_MAXSHORTHOSTLEN+1];
        int     nbtppools;
        char    *tppools;
};
.ft
.fi
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named fileclass does not exist.
.TP
.B EINVAL
.I classid
and
.I class_name
do not point at same class entry or the length of
.I class_name
exceeds
.BR CA_MAXCLASNAMELEN .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_enterclass(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
