/***************************************************************************
                          chatinformation.h  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATINFORMATION_H
#define CHATINFORMATION_H

#include <QString>


// Forward declarations
class ContactList;
class MsnNotificationConnection;



/**
 * The container for switchboard connections information.
 *
 * This data class holds all information about a switchboard request, either made by the Notification Server or
 * asked by the ChatMaster.
 *
 * @author Mike K. Bennett
 * @ingroup NetworkCore
 */
class ChatInformation
{

  public:

    enum ConnectionType
    {
      CONNECTION_CHAT,          // The connection will be immediately used for a chat
      CONNECTION_BACKGROUND,    // The connection will be used for background transfers (can be still used to chat)
      CONNECTION_REFRESH,       // The connection will replace an existing disconnected switchboard
      CONNECTION_OFFLINE        // The connection will be a fake connection, to start an offline message conversation
    };


  public:
    // The constructor for a user-started chat
                                ChatInformation( MsnNotificationConnection *parent, const QString& handle,
                                                 int transactionId, ConnectionType type );
    // The constructor for a contact-started chat
                                ChatInformation( MsnNotificationConnection *parent, const QString& handle,
                                                 const QString &ip, quint16 port, const QString &authorization,
                                                 const QString &chatId, ConnectionType type );
    // The destructor
                               ~ChatInformation();
    // Return the switchboard authorization
    const QString&              getAuthorization() const;
    // Return the contact-started chat verification id
    const QString&              getChatId() const;
    // Return the handle of the contact this is a chat with
    const QString&              getContactHandle() const;
    // Return the switchboard server ip
    const QString&              getIp() const;
    // Return the notification connection that spawned this object
    MsnNotificationConnection  *getNotificationConnection() const;
    // Return the switchboard server port
    quint16                     getPort() const;
    // Return the time of when the SB transfer request has been sent
    int                         getTime() const;
    // Return the transaction ID used in the "XFR" command.
    int                         getTransactionId() const;
    // Return the type of connection we're establishing
    ConnectionType              getType() const;
    // Return whether the user started the chat
    bool                        getUserStartedChat() const;
    // Set server information
    void                        setServerInformation( const QString& ip, const quint16& port, const QString& authorization );


  private: // Private attributes
    // The authorization used to connect to the switchboard server
    QString                     authorization_;
    // The id of the chat, used for authenticating a contact-started chat
    QString                     chatId_;
    // Type of connection
    ConnectionType              connectionType_;
    // The handle of the contact being chatted with
    QString                     contactHandle_;
    // The switchboard server's ip
    QString                     ip_;
    // The notification connection that spawned this object
    MsnNotificationConnection  *notificationConnection_;
    // The switchboard server's port
    quint16                     port_;
    // The time when the SB transfer request was issued to the notification server
    uint                        requestTime_;
    // The transaction ID used in the "XFR" command.
    int                         transactionId_;
    // Whether the user (true) or the contact (false) started the chat
    bool                        userStartedChat_;

};

#endif
