# - Try to find NSS
# Once done this will define
#
#  NSS_FOUND - system has NSS
#  NSS_INCLUDE_DIRS - the NSS include directory
#  NSS_LIBRARIES - Link these to use NSS
#  NSS_DEFINITIONS - Compiler switches required for using NSS
#
#  Copyright (c) 2010 Andreas Schneider <asn@redhat.com>
#
#  Redistribution and use is allowed according to the terms of the New
#  BSD license.
#  For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

if (SANDBOX)
  # Bypass the cache: we want to use files from the directory above.
  set(NSS_FOUND TRUE)

  # Read the internal build directory from the dist directory
  set(DIST_DIR "${CMAKE_SOURCE_DIR}/../dist")
  file(READ "${DIST_DIR}/latest" LATEST_BUILD)
  string(STRIP "${LATEST_BUILD}" LATEST_BUILD)

  message(STATUS "NSS sandbox build directory: ${LATEST_BUILD}")

  # Directly set the NSS include and library directories
  set(NSS_INCLUDE_DIRS "${DIST_DIR}/public/nss")
  set(NSS_LIBRARIES "${DIST_DIR}/${LATEST_BUILD}/lib")
  list(APPEND JSS_LD_FLAGS "-Wl,-rpath,${DIST_DIR}/${LATEST_BUILD}/lib")
elseif (NSS_LIBRARIES AND NSS_INCLUDE_DIRS)
  # in cache already
  set(NSS_FOUND TRUE)
else (NSS_LIBRARIES AND NSS_INCLUDE_DIRS)
  find_package(PkgConfig)
  if (PKG_CONFIG_FOUND)
    pkg_check_modules(_NSS nss)
  endif (PKG_CONFIG_FOUND)

  find_path(NSS_INCLUDE_DIR
    NAMES
      nss.h
    PATHS
      ${_NSS_INCLUDEDIR}
      /usr/include
      /usr/local/include
      /opt/local/include
      /sw/include
    PATH_SUFFIXES
      nss3
      nss
  )

  find_library(SSL3_LIBRARY
    NAMES
      ssl3
    PATHS
      ${_NSS_LIBDIR}
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  find_library(SMIME3_LIBRARY
    NAMES
      smime3
    PATHS
      ${_NSS_LIBDIR}
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  find_library(NSS3_LIBRARY
    NAMES
      nss3
    PATHS
      ${_NSS_LIBDIR}
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  find_library(NSSUTIL3_LIBRARY
    NAMES
      nssutil3
    PATHS
      ${_NSS_LIBDIR}
      /usr/lib
      /usr/local/lib
      /opt/local/lib
      /sw/lib
  )

  set(NSS_INCLUDE_DIRS
    ${NSS_INCLUDE_DIR}
  )

  if(SSL3_LIBRARY)
    get_filename_component(SSL3_LIBRARY "${SSL3_LIBRARY}" DIRECTORY)
    set(NSS_LIBRARIES
        ${NSS_LIBRARIES}
        ${SSL3_LIBRARY}
    )
  endif()

  if(SMIME3_LIBRARY)
    get_filename_component(SMIME3_LIBRARY "${SMIME3_LIBRARY}" DIRECTORY)
    set(NSS_LIBRARIES
        ${NSS_LIBRARIES}
        ${SMIME3_LIBRARY}
    )
  endif()

  if(NSS3_LIBRARY)
    get_filename_component(NSS3_LIBRARY "${NSS3_LIBRARY}" DIRECTORY)
    set(NSS_LIBRARIES
        ${NSS_LIBRARIES}
        ${NSS3_LIBRARY}
    )
  endif()

  if(NSSUTIL3_LIBRARY)
    get_filename_component(NSSUTIL3_LIBRARY "${NSSUTIL3_LIBRARY}" DIRECTORY)
    set(NSS_LIBRARIES
        ${NSS_LIBRARIES}
        ${NSSUTIL3_LIBRARY}
    )
  endif()

  list(REMOVE_DUPLICATES NSS_LIBRARIES)

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(NSS DEFAULT_MSG NSS_LIBRARIES NSS_INCLUDE_DIRS)

  # show the NSS_INCLUDE_DIRS and NSS_LIBRARIES variables only in the advanced view
  mark_as_advanced(NSS_INCLUDE_DIRS NSS_LIBRARIES)

endif()
