// test_mis.v - Testbench for mis.bvrl
// 01-22-01 E. Brombaugh

/*
 * Copyright (c) 2001 Eric Brombaugh <ebrombau@intersil.com>
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

/*
 * The mis'' module was generated by the synopsis module compiler
 * and is typical of the modules it generates. The testbench was hand
 * coded. This file was merged into a single file using the Verilog
 * preprocessor.
 */

`timescale 1ns / 10 ps
module mis( y, a, b );
input [3:0] a;
input [3:0] b;
output [12:0] y;
wire  dpa_zero, dpa_one;
wire [5:0] const__1_24_;
wire [7:0] C0;
wire [6:0] const__2_33_;
wire [7:0] C1;
wire [12:0] y_1_;
assign dpa_zero= 1024'h0;
assign dpa_one= 1024'h1;
assign const__1_24_=- 1024'h18;
assign const__2_33_=- 1024'h21;

/* mis.mcl:4 module mis (y, a, b); */

/* mis.mcl:5 input signed [3:0] a, b; */

/* mis.mcl:10 C0 = -24; */

assign C0= ((const__1_24_[4:0]-(const__1_24_[5]<<5)));

/* mis.mcl:11 C1 = -33; */

assign C1= ((const__2_33_[5:0]-(const__2_33_[6]<<6)));

/* mis.mcl:13 y = C0*a + C1*b; */

assign y_1_= ((C0[6:0]-(C0[7]<<7))*(a[2:0]-(a[3]<<3))+
    (C1[6:0]-(C1[7]<<7))*(b[2:0]-(b[3]<<3)));

/* mis.mcl:6 output signed [12:0] y; */

assign y = y_1_[12:0];

/* mis.mcl:4 module mis (y, a, b); */

/* mis.mcl:13 y = C0*a + C1*b; */

/*User Defined Aliases */
endmodule

module test_mis;
  reg [10:0] count;

  reg clk;
  reg [3:0] a, b;

  wire [12:0] y;

  mis u1(y, a, b);

  initial
  begin
    count = 0;
    clk = 0;
    a = 0;
    b = 0;
  end

  always
    #10 clk = ~clk;

  always @(posedge clk)
  begin
    a = count[3:0];
    b = count[7:4];

    #10
    $display("%h %h %h", a, b, y);

    count = count + 1;
    if(count == 0)
      $finish(0);
  end
endmodule
