#!/bin/sh -e

VERSION=$2
TAR=../icu4j_$VERSION.orig.tar.xz
DIR=icu4j-$VERSION
TAG=$(echo "release-${VERSION}" | sed -re 's,\.,-,g')

echo $TAG
echo "svn export http://source.icu-project.org/repos/icu/${TAG}/icu4j/"

svn export http://source.icu-project.org/repos/icu/tags/${TAG}/icu4j/ $DIR
XZ_OPT=--best tar -c -J -f $TAR $DIR
rm -rf $DIR ../$TAG
