///////
   //    HtmlStatement.cc
   //    HtmlStatement Class definitions
   //
   //    Class for Html statements
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlStatement.cc,v 1.11 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "HtmlStatement.h"

// Static variables initialization
int HtmlStatement::debug = 0;

// Static map of tags
HtmlStatement::ElementsMap HtmlStatement::TagMap;

///////
   //    Construction
///////

HtmlStatement::HtmlStatement()
: IDUrl(0),
   TagPosition(0),
   Tag(),
   LowercaseTag(),
   Statement(),
   Row(1),
   Col(1),
   LinkTagPosition(0),
   _tag_label(Tag_Unknown),
   _closing_tag(false),
   _empty_tag(false)
{
}

///////
   //    Destruction
///////

HtmlStatement::~HtmlStatement ()
{
}

///////
   //    Reset the schedule content
///////

void HtmlStatement::Reset()
{
   IDUrl = 0;
   TagPosition = 0;
   Tag.clear();
   Statement.clear();
   Row = 1;
   Col = 1;
   LinkTagPosition = 0;
   _tag_label = Tag_Unknown;
   _closing_tag = false;
   _empty_tag = false;
}


///////
   //    Output HtmlStatement object
///////

ostream& operator<<(ostream& output, const HtmlStatement& s)

{
   output << s.IDUrl << " / " << s.TagPosition;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Tag : " << s.Tag << " Row: " << s.Row
   	  << " Col: " << s.Col
      << " - Statement <"
      << s.Statement << ">)";
   
   return output;
}

void HtmlStatement::SetTag (const std::string &t)
{
    Tag = t;
    LowercaseTag.clear();
    for (std::string::const_iterator c(t.begin());
	    c != t.end(); ++c) {
	if (*c == '/') {
	    // Found a closing tag character
	    _closing_tag = true;
	    continue;
	}

	LowercaseTag.push_back(tolower(*c));
    }

    // Assign the tag label
    ElementsMap::const_iterator e(TagMap.find(LowercaseTag));
    if (e == TagMap.end()) {
	_tag_label = Tag_Unknown;
	TagMap.insert(std::make_pair(LowercaseTag, _tag_label)); // cache
	//std::cout << "Map " << LowercaseTag << " to UNKNOWN" << std::endl;
    }
    else {
	_tag_label = e->second;
	//std::cout << "Map " << LowercaseTag << " to " << e->second << std::endl;
    }

}

// Initialise the map of tags
void HtmlStatement::initElementsMap()
{
    if (TagMap.empty()) {
	TagMap.insert(std::make_pair("a", Tag_A));
	TagMap.insert(std::make_pair("area", Tag_AREA));
	TagMap.insert(std::make_pair("meta", Tag_META));
	TagMap.insert(std::make_pair("html", Tag_HTML));
	TagMap.insert(std::make_pair("frame", Tag_FRAME));
	TagMap.insert(std::make_pair("embed", Tag_EMBED));
	TagMap.insert(std::make_pair("object", Tag_OBJECT));
	TagMap.insert(std::make_pair("img", Tag_IMG));
	TagMap.insert(std::make_pair("link", Tag_LINK));
	TagMap.insert(std::make_pair("input", Tag_INPUT));
	TagMap.insert(std::make_pair("base", Tag_BASE));
	TagMap.insert(std::make_pair("head", Tag_HEAD));
	TagMap.insert(std::make_pair("script", Tag_SCRIPT));
	TagMap.insert(std::make_pair("title", Tag_TITLE));
	TagMap.insert(std::make_pair("h1", Tag_H1));
	TagMap.insert(std::make_pair("h2", Tag_H2));
	TagMap.insert(std::make_pair("h3", Tag_H3));
	TagMap.insert(std::make_pair("h4", Tag_H4));
	TagMap.insert(std::make_pair("h5", Tag_H5));
	TagMap.insert(std::make_pair("h6", Tag_H6));
	TagMap.insert(std::make_pair("b", Tag_B));
	TagMap.insert(std::make_pair("i", Tag_I));
	TagMap.insert(std::make_pair("blink", Tag_BLINK));
	TagMap.insert(std::make_pair("marquee", Tag_MARQUEE));
    }
}

