<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.recursivearrayiterator.php
 * )
 *
 * This iterator allows unsetting and modifying values and keys while
 * iterating over Arrays and Objects in the same way as the ArrayIterator.
 * Additionally it is possible to iterate over the current iterator entry.
 *
 */
class RecursiveArrayIterator
  extends ArrayIterator
  implements RecursiveIterator {

  const CHILD_ARRAYS_ONLY = 4;

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://php.net/manual/en/recursivearrayiterator.getchildren.php )
   *
   * Returns an iterator for the current iterator entry.
   *
   * @return     mixed   An iterator for the current entry, if it is an array
   *                     or object.
   */
  public function getChildren() {
    return new RecursiveArrayIterator(
      $this->hasChildren() ? $this->current() : null,
      $this->getFlags()
    );
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://php.net/manual/en/recursivearrayiterator.haschildren.php )
   *
   * Returns whether current entry is an array or an object for which an
   * iterator can be obtained via RecursiveArrayIterator::getChildren().
   *
   * @return     mixed   Returns TRUE if the current entry is an array or an
   *                     object, otherwise FALSE is returned.
   */
  public function hasChildren() {
    return
      is_array($this->current()) ||
      (is_object($this->current()) &&
       ($this->getFlags() & self::CHILD_ARRAYS_ONLY) == 0);
  }

}
