-- | <http://www.unicode.org/charts/PDF/U1D100.pdf>
module Music.Theory.Unicode where

type Unicode_Table = [(Int,String)]

-- > putStrLn (map (toEnum . fst) (concat unicode))
unicode :: [Unicode_Table]
unicode = [accidentals,notes,rests,clefs]

accidentals :: Unicode_Table
accidentals =
    [(0x1D12A,"MUSICAL SYMBOL DOUBLE SHARP")
    ,(0x1D12B,"MUSICAL SYMBOL DOUBLE FLAT")
    ,(0x1D12C,"MUSICAL SYMBOL FLAT UP")
    ,(0x1D12D,"MUSICAL SYMBOL FLAT DOWN")
    ,(0x1D12E,"MUSICAL SYMBOL NATURAL UP")
    ,(0x1D12F,"MUSICAL SYMBOL NATURAL DOWN")
    ,(0x1D130,"MUSICAL SYMBOL SHARP UP")
    ,(0x1D131,"MUSICAL SYMBOL SHARP DOWN")
    ,(0x1D132,"MUSICAL SYMBOL QUARTER TONE SHARP")
    ,(0x1D133,"MUSICAL SYMBOL QUARTER TONE FLAT")]

notes :: Unicode_Table
notes =
    [(0x1D15C,"MUSICAL SYMBOL BREVE")
    ,(0x1D15D,"MUSICAL SYMBOL WHOLE NOTE")
    ,(0x1D15E,"MUSICAL SYMBOL HALF NOTE")
    ,(0x1D15F,"MUSICAL SYMBOL QUARTER NOTE")
    ,(0x1D160,"MUSICAL SYMBOL EIGHTH NOTE")
    ,(0x1D161,"MUSICAL SYMBOL SIXTEENTH NOTE")
    ,(0x1D162,"MUSICAL SYMBOL THIRTY-SECOND NOTE")
    ,(0x1D163,"MUSICAL SYMBOL SIXTY-FOURTH NOTE")
    ,(0x1D164,"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE")]

rests :: Unicode_Table
rests =
    [(0x1D13B,"MUSICAL SYMBOL WHOLE REST")
    ,(0x1D13C,"MUSICAL SYMBOL HALF REST")
    ,(0x1D13D,"MUSICAL SYMBOL QUARTER REST")
    ,(0x1D13E,"MUSICAL SYMBOL EIGHTH REST")
    ,(0x1D13F,"MUSICAL SYMBOL SIXTEENTH REST")
    ,(0x1D140,"MUSICAL SYMBOL THIRTY-SECOND REST")
    ,(0x1D141,"MUSICAL SYMBOL SIXTY-FOURTH REST")
    ,(0x1D142,"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST")]

clefs :: Unicode_Table
clefs =
    [(0x1D11E,"MUSICAL SYMBOL G CLEF")
    ,(0x1D11F,"MUSICAL SYMBOL G CLEF OTTAVA ALTA")
    ,(0x1D120,"MUSICAL SYMBOL G CLEF OTTAVA BASSA")
    ,(0x1D121,"MUSICAL SYMBOL C CLEF")
    ,(0x1D122,"MUSICAL SYMBOL F CLEF")
    ,(0x1D123,"MUSICAL SYMBOL F CLEF OTTAVA ALTA")
    ,(0x1D124,"MUSICAL SYMBOL F CLEF OTTAVA BASSA")
    ,(0x1D125,"MUSICAL SYMBOL DRUM CLEF-1")
    ,(0x1D126,"MUSICAL SYMBOL DRUM CLEF-2")]
