{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/md5.h>
#include <nettle/md2.h>
#include <nettle/md4.h>
#include <nettle/ripemd160.h>
#include <nettle/sha1.h>
#include <nettle/gosthash94.h>

module Bindings.Nettle.Hash.Legacy where
#strict_import

#num MD5_DIGEST_SIZE
#num MD5_DATA_SIZE

#starttype struct md5_ctx
#stoptype

#ccall md5_init , Ptr <struct md5_ctx> -> IO ()
#ccall md5_update , Ptr <struct md5_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall md5_digest , Ptr <struct md5_ctx> -> CUInt -> Ptr CUChar -> IO ()

#num MD2_DIGEST_SIZE
#num MD2_DATA_SIZE

#starttype struct md2_ctx
#stoptype

#ccall md2_init , Ptr <struct md2_ctx> -> IO ()
#ccall md2_update , Ptr <struct md2_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall md2_digest , Ptr <struct md2_ctx> -> CUInt -> Ptr CUChar -> IO ()

#num MD4_DIGEST_SIZE
#num MD4_DATA_SIZE

#starttype struct md4_ctx
#stoptype

#ccall md4_init , Ptr <struct md4_ctx> -> IO ()
#ccall md4_update , Ptr <struct md4_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall md4_digest , Ptr <struct md4_ctx> -> CUInt -> Ptr CUChar -> IO ()

#num RIPEMD160_DIGEST_SIZE
#num RIPEMD160_DATA_SIZE

#starttype struct ripemd160_ctx
#stoptype

#ccall ripemd160_init , Ptr <struct ripemd160_ctx> -> IO ()
#ccall ripemd160_update , Ptr <struct ripemd160_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall ripemd160_digest , Ptr <struct ripemd160_ctx> -> CUInt -> Ptr CUChar -> IO ()

#num SHA1_DIGEST_SIZE
#num SHA1_DATA_SIZE

#starttype struct sha1_ctx
#stoptype

#ccall sha1_init , Ptr <struct sha1_ctx> -> IO ()
#ccall sha1_update , Ptr <struct sha1_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha1_digest , Ptr <struct sha1_ctx> -> CUInt -> Ptr CUChar -> IO ()

#num GOSTHASH94_DIGEST_SIZE
#num GOSTHASH94_DATA_SIZE

#starttype struct gosthash94_ctx
#stoptype

#ccall gosthash94_init , Ptr <struct gosthash94_ctx> -> IO ()
#ccall gosthash94_update , Ptr <struct gosthash94_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall gosthash94_digest , Ptr <struct gosthash94_ctx> -> CUInt -> Ptr CUChar -> IO ()
