// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/dashboard/v1/common.proto

package dashboard

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Aligner describes how to bring the data points in a single
// time series into temporal alignment.
type Aggregation_Aligner int32

const (
	// No alignment. Raw data is returned. Not valid if cross-time
	// series reduction is requested. The value type of the result is
	// the same as the value type of the input.
	Aggregation_ALIGN_NONE Aggregation_Aligner = 0
	// Align and convert to delta metric type. This alignment is valid
	// for cumulative metrics and delta metrics. Aligning an existing
	// delta metric to a delta metric requires that the alignment
	// period be increased. The value type of the result is the same
	// as the value type of the input.
	//
	// One can think of this aligner as a rate but without time units; that
	// is, the output is conceptually (second_point - first_point).
	Aggregation_ALIGN_DELTA Aggregation_Aligner = 1
	// Align and convert to a rate. This alignment is valid for
	// cumulative metrics and delta metrics with numeric values. The output is a
	// gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	//
	// One can think of this aligner as conceptually providing the slope of
	// the line that passes through the value at the start and end of the
	// window. In other words, this is conceptually ((y1 - y0)/(t1 - t0)),
	// and the output unit is one that has a "/time" dimension.
	//
	// If, by rate, you are looking for percentage change, see the
	// `ALIGN_PERCENT_CHANGE` aligner option.
	Aggregation_ALIGN_RATE Aggregation_Aligner = 2
	// Align by interpolating between adjacent points around the
	// period boundary. This alignment is valid for gauge
	// metrics with numeric values. The value type of the result is the same
	// as the value type of the input.
	Aggregation_ALIGN_INTERPOLATE Aggregation_Aligner = 3
	// Align by shifting the oldest data point before the period
	// boundary to the boundary. This alignment is valid for gauge
	// metrics. The value type of the result is the same as the
	// value type of the input.
	Aggregation_ALIGN_NEXT_OLDER Aggregation_Aligner = 4
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the minimum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MIN Aggregation_Aligner = 10
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the maximum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MAX Aggregation_Aligner = 11
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the average or arithmetic mean of all
	// data points in the period. This alignment is valid for gauge and delta
	// metrics with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_MEAN Aggregation_Aligner = 12
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// or Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT Aggregation_Aligner = 13
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the sum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// and distribution values. The value type of the output is the
	// same as the value type of the input.
	Aggregation_ALIGN_SUM Aggregation_Aligner = 14
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the standard deviation of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_STDDEV Aggregation_Aligner = 15
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of True-valued data points in the
	// period. This alignment is valid for gauge metrics with
	// Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT_TRUE Aggregation_Aligner = 16
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of False-valued data points in the
	// period. This alignment is valid for gauge metrics with
	// Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT_FALSE Aggregation_Aligner = 24
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the fraction of True-valued data points in the
	// period. This alignment is valid for gauge metrics with Boolean values.
	// The output value is in the range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_FRACTION_TRUE Aggregation_Aligner = 17
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 99th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_99 Aggregation_Aligner = 18
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 95th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_95 Aggregation_Aligner = 19
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 50th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_50 Aggregation_Aligner = 20
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 5th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_05 Aggregation_Aligner = 21
	// Align and convert to a percentage change. This alignment is valid for
	// gauge and delta metrics with numeric values. This alignment conceptually
	// computes the equivalent of "((current - previous)/previous)*100"
	// where previous value is determined based on the alignmentPeriod.
	// In the event that previous is 0 the calculated value is infinity with the
	// exception that if both (current - previous) and previous are 0 the
	// calculated value is 0.
	// A 10 minute moving mean is computed at each point of the time window
	// prior to the above calculation to smooth the metric and prevent false
	// positives from very short lived spikes.
	// Only applicable for data that is >= 0. Any values < 0 are treated as
	// no data. While delta metrics are accepted by this alignment special care
	// should be taken that the values for the metric will always be positive.
	// The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENT_CHANGE Aggregation_Aligner = 23
)

var Aggregation_Aligner_name = map[int32]string{
	0:  "ALIGN_NONE",
	1:  "ALIGN_DELTA",
	2:  "ALIGN_RATE",
	3:  "ALIGN_INTERPOLATE",
	4:  "ALIGN_NEXT_OLDER",
	10: "ALIGN_MIN",
	11: "ALIGN_MAX",
	12: "ALIGN_MEAN",
	13: "ALIGN_COUNT",
	14: "ALIGN_SUM",
	15: "ALIGN_STDDEV",
	16: "ALIGN_COUNT_TRUE",
	24: "ALIGN_COUNT_FALSE",
	17: "ALIGN_FRACTION_TRUE",
	18: "ALIGN_PERCENTILE_99",
	19: "ALIGN_PERCENTILE_95",
	20: "ALIGN_PERCENTILE_50",
	21: "ALIGN_PERCENTILE_05",
	23: "ALIGN_PERCENT_CHANGE",
}

var Aggregation_Aligner_value = map[string]int32{
	"ALIGN_NONE":           0,
	"ALIGN_DELTA":          1,
	"ALIGN_RATE":           2,
	"ALIGN_INTERPOLATE":    3,
	"ALIGN_NEXT_OLDER":     4,
	"ALIGN_MIN":            10,
	"ALIGN_MAX":            11,
	"ALIGN_MEAN":           12,
	"ALIGN_COUNT":          13,
	"ALIGN_SUM":            14,
	"ALIGN_STDDEV":         15,
	"ALIGN_COUNT_TRUE":     16,
	"ALIGN_COUNT_FALSE":    24,
	"ALIGN_FRACTION_TRUE":  17,
	"ALIGN_PERCENTILE_99":  18,
	"ALIGN_PERCENTILE_95":  19,
	"ALIGN_PERCENTILE_50":  20,
	"ALIGN_PERCENTILE_05":  21,
	"ALIGN_PERCENT_CHANGE": 23,
}

func (x Aggregation_Aligner) String() string {
	return proto.EnumName(Aggregation_Aligner_name, int32(x))
}

func (Aggregation_Aligner) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0, 0}
}

// A Reducer describes how to aggregate data points from multiple
// time series into a single time series.
type Aggregation_Reducer int32

const (
	// No cross-time series reduction. The output of the aligner is
	// returned.
	Aggregation_REDUCE_NONE Aggregation_Reducer = 0
	// Reduce by computing the mean across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric or distribution values. The value type of the
	// output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_MEAN Aggregation_Reducer = 1
	// Reduce by computing the minimum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MIN Aggregation_Reducer = 2
	// Reduce by computing the maximum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MAX Aggregation_Reducer = 3
	// Reduce by computing the sum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric and distribution values. The value type of
	// the output is the same as the value type of the input.
	Aggregation_REDUCE_SUM Aggregation_Reducer = 4
	// Reduce by computing the standard deviation across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics with numeric or distribution values. The value type of
	// the output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_STDDEV Aggregation_Reducer = 5
	// Reduce by computing the count of data points across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics of numeric, Boolean, distribution, and string value
	// type. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT Aggregation_Reducer = 6
	// Reduce by computing the count of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The value type of
	// the output is [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT_TRUE Aggregation_Reducer = 7
	// Reduce by computing the count of False-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The value type of
	// the output is [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT_FALSE Aggregation_Reducer = 15
	// Reduce by computing the fraction of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The output value is in the
	// range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_FRACTION_TRUE Aggregation_Reducer = 8
	// Reduce by computing 99th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_99 Aggregation_Reducer = 9
	// Reduce by computing 95th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_95 Aggregation_Reducer = 10
	// Reduce by computing 50th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_50 Aggregation_Reducer = 11
	// Reduce by computing 5th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_05 Aggregation_Reducer = 12
)

var Aggregation_Reducer_name = map[int32]string{
	0:  "REDUCE_NONE",
	1:  "REDUCE_MEAN",
	2:  "REDUCE_MIN",
	3:  "REDUCE_MAX",
	4:  "REDUCE_SUM",
	5:  "REDUCE_STDDEV",
	6:  "REDUCE_COUNT",
	7:  "REDUCE_COUNT_TRUE",
	15: "REDUCE_COUNT_FALSE",
	8:  "REDUCE_FRACTION_TRUE",
	9:  "REDUCE_PERCENTILE_99",
	10: "REDUCE_PERCENTILE_95",
	11: "REDUCE_PERCENTILE_50",
	12: "REDUCE_PERCENTILE_05",
}

var Aggregation_Reducer_value = map[string]int32{
	"REDUCE_NONE":          0,
	"REDUCE_MEAN":          1,
	"REDUCE_MIN":           2,
	"REDUCE_MAX":           3,
	"REDUCE_SUM":           4,
	"REDUCE_STDDEV":        5,
	"REDUCE_COUNT":         6,
	"REDUCE_COUNT_TRUE":    7,
	"REDUCE_COUNT_FALSE":   15,
	"REDUCE_FRACTION_TRUE": 8,
	"REDUCE_PERCENTILE_99": 9,
	"REDUCE_PERCENTILE_95": 10,
	"REDUCE_PERCENTILE_50": 11,
	"REDUCE_PERCENTILE_05": 12,
}

func (x Aggregation_Reducer) String() string {
	return proto.EnumName(Aggregation_Reducer_name, int32(x))
}

func (Aggregation_Reducer) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0, 1}
}

// The value reducers that can be applied to a PickTimeSeriesFilter.
type PickTimeSeriesFilter_Method int32

const (
	// Not allowed in well-formed requests.
	PickTimeSeriesFilter_METHOD_UNSPECIFIED PickTimeSeriesFilter_Method = 0
	// Select the mean of all values.
	PickTimeSeriesFilter_METHOD_MEAN PickTimeSeriesFilter_Method = 1
	// Select the maximum value.
	PickTimeSeriesFilter_METHOD_MAX PickTimeSeriesFilter_Method = 2
	// Select the minimum value.
	PickTimeSeriesFilter_METHOD_MIN PickTimeSeriesFilter_Method = 3
	// Compute the sum of all values.
	PickTimeSeriesFilter_METHOD_SUM PickTimeSeriesFilter_Method = 4
	// Select the most recent value.
	PickTimeSeriesFilter_METHOD_LATEST PickTimeSeriesFilter_Method = 5
)

var PickTimeSeriesFilter_Method_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "METHOD_MEAN",
	2: "METHOD_MAX",
	3: "METHOD_MIN",
	4: "METHOD_SUM",
	5: "METHOD_LATEST",
}

var PickTimeSeriesFilter_Method_value = map[string]int32{
	"METHOD_UNSPECIFIED": 0,
	"METHOD_MEAN":        1,
	"METHOD_MAX":         2,
	"METHOD_MIN":         3,
	"METHOD_SUM":         4,
	"METHOD_LATEST":      5,
}

func (x PickTimeSeriesFilter_Method) String() string {
	return proto.EnumName(PickTimeSeriesFilter_Method_name, int32(x))
}

func (PickTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1, 0}
}

// Describes the ranking directions.
type PickTimeSeriesFilter_Direction int32

const (
	// Not allowed in well-formed requests.
	PickTimeSeriesFilter_DIRECTION_UNSPECIFIED PickTimeSeriesFilter_Direction = 0
	// Pass the highest ranking inputs.
	PickTimeSeriesFilter_TOP PickTimeSeriesFilter_Direction = 1
	// Pass the lowest ranking inputs.
	PickTimeSeriesFilter_BOTTOM PickTimeSeriesFilter_Direction = 2
)

var PickTimeSeriesFilter_Direction_name = map[int32]string{
	0: "DIRECTION_UNSPECIFIED",
	1: "TOP",
	2: "BOTTOM",
}

var PickTimeSeriesFilter_Direction_value = map[string]int32{
	"DIRECTION_UNSPECIFIED": 0,
	"TOP":                   1,
	"BOTTOM":                2,
}

func (x PickTimeSeriesFilter_Direction) String() string {
	return proto.EnumName(PickTimeSeriesFilter_Direction_name, int32(x))
}

func (PickTimeSeriesFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1, 1}
}

// The filter methods that can be applied to a stream.
type StatisticalTimeSeriesFilter_Method int32

const (
	// Not allowed in well-formed requests.
	StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED StatisticalTimeSeriesFilter_Method = 0
	// Compute the outlier score of each stream.
	StatisticalTimeSeriesFilter_METHOD_CLUSTER_OUTLIER StatisticalTimeSeriesFilter_Method = 1
)

var StatisticalTimeSeriesFilter_Method_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "METHOD_CLUSTER_OUTLIER",
}

var StatisticalTimeSeriesFilter_Method_value = map[string]int32{
	"METHOD_UNSPECIFIED":     0,
	"METHOD_CLUSTER_OUTLIER": 1,
}

func (x StatisticalTimeSeriesFilter_Method) String() string {
	return proto.EnumName(StatisticalTimeSeriesFilter_Method_name, int32(x))
}

func (StatisticalTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{2, 0}
}

// Describes how to combine multiple time series to provide different views of
// the data.  Aggregation consists of an alignment step on individual time
// series (`alignment_period` and `per_series_aligner`) followed by an optional
// reduction step of the data across the aligned time series
// (`cross_series_reducer` and `group_by_fields`).  For more details, see
// [Aggregation](/monitoring/api/learn_more#aggregation).
type Aggregation struct {
	// The alignment period for per-[time series][TimeSeries]
	// alignment. If present, `alignmentPeriod` must be at least 60
	// seconds.  After per-time series alignment, each time series will
	// contain data points only on the period boundaries. If
	// `perSeriesAligner` is not specified or equals `ALIGN_NONE`, then
	// this field is ignored. If `perSeriesAligner` is specified and
	// does not equal `ALIGN_NONE`, then this field must be defined;
	// otherwise an error is returned.
	AlignmentPeriod *duration.Duration `protobuf:"bytes,1,opt,name=alignment_period,json=alignmentPeriod,proto3" json:"alignment_period,omitempty"`
	// The approach to be used to align individual time series. Not all
	// alignment functions may be applied to all time series, depending
	// on the metric type and value type of the original time
	// series. Alignment may change the metric type or the value type of
	// the time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	PerSeriesAligner Aggregation_Aligner `protobuf:"varint,2,opt,name=per_series_aligner,json=perSeriesAligner,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Aligner" json:"per_series_aligner,omitempty"`
	// The approach to be used to combine time series. Not all reducer
	// functions may be applied to all time series, depending on the
	// metric type and the value type of the original time
	// series. Reduction may change the metric type of value type of the
	// time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	CrossSeriesReducer Aggregation_Reducer `protobuf:"varint,4,opt,name=cross_series_reducer,json=crossSeriesReducer,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Reducer" json:"cross_series_reducer,omitempty"`
	// The set of fields to preserve when `crossSeriesReducer` is
	// specified. The `groupByFields` determine how the time series are
	// partitioned into subsets prior to applying the aggregation
	// function. Each subset contains time series that have the same
	// value for each of the grouping fields. Each individual time
	// series is a member of exactly one subset. The
	// `crossSeriesReducer` is applied to each subset of time series.
	// It is not possible to reduce across different resource types, so
	// this field implicitly contains `resource.type`.  Fields not
	// specified in `groupByFields` are aggregated away.  If
	// `groupByFields` is not specified and all the time series have
	// the same resource type, then the time series are aggregated into
	// a single output time series. If `crossSeriesReducer` is not
	// defined, this field is ignored.
	GroupByFields        []string `protobuf:"bytes,5,rep,name=group_by_fields,json=groupByFields,proto3" json:"group_by_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Aggregation) Reset()         { *m = Aggregation{} }
func (m *Aggregation) String() string { return proto.CompactTextString(m) }
func (*Aggregation) ProtoMessage()    {}
func (*Aggregation) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{0}
}

func (m *Aggregation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Aggregation.Unmarshal(m, b)
}
func (m *Aggregation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Aggregation.Marshal(b, m, deterministic)
}
func (m *Aggregation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Aggregation.Merge(m, src)
}
func (m *Aggregation) XXX_Size() int {
	return xxx_messageInfo_Aggregation.Size(m)
}
func (m *Aggregation) XXX_DiscardUnknown() {
	xxx_messageInfo_Aggregation.DiscardUnknown(m)
}

var xxx_messageInfo_Aggregation proto.InternalMessageInfo

func (m *Aggregation) GetAlignmentPeriod() *duration.Duration {
	if m != nil {
		return m.AlignmentPeriod
	}
	return nil
}

func (m *Aggregation) GetPerSeriesAligner() Aggregation_Aligner {
	if m != nil {
		return m.PerSeriesAligner
	}
	return Aggregation_ALIGN_NONE
}

func (m *Aggregation) GetCrossSeriesReducer() Aggregation_Reducer {
	if m != nil {
		return m.CrossSeriesReducer
	}
	return Aggregation_REDUCE_NONE
}

func (m *Aggregation) GetGroupByFields() []string {
	if m != nil {
		return m.GroupByFields
	}
	return nil
}

// Describes a ranking-based time series filter. Each input time series is
// ranked with an aligner. The filter lets through up to `num_time_series` time
// series, selecting them based on the relative ranking.
type PickTimeSeriesFilter struct {
	// `rankingMethod` is applied to each time series independently to produce the
	// value which will be used to compare the time series to other time series.
	RankingMethod PickTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to return.
	NumTimeSeries int32 `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
	// How to use the ranking to select time series that pass through the filter.
	Direction            PickTimeSeriesFilter_Direction `protobuf:"varint,3,opt,name=direction,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Direction" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *PickTimeSeriesFilter) Reset()         { *m = PickTimeSeriesFilter{} }
func (m *PickTimeSeriesFilter) String() string { return proto.CompactTextString(m) }
func (*PickTimeSeriesFilter) ProtoMessage()    {}
func (*PickTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{1}
}

func (m *PickTimeSeriesFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PickTimeSeriesFilter.Unmarshal(m, b)
}
func (m *PickTimeSeriesFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PickTimeSeriesFilter.Marshal(b, m, deterministic)
}
func (m *PickTimeSeriesFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PickTimeSeriesFilter.Merge(m, src)
}
func (m *PickTimeSeriesFilter) XXX_Size() int {
	return xxx_messageInfo_PickTimeSeriesFilter.Size(m)
}
func (m *PickTimeSeriesFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PickTimeSeriesFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PickTimeSeriesFilter proto.InternalMessageInfo

func (m *PickTimeSeriesFilter) GetRankingMethod() PickTimeSeriesFilter_Method {
	if m != nil {
		return m.RankingMethod
	}
	return PickTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (m *PickTimeSeriesFilter) GetNumTimeSeries() int32 {
	if m != nil {
		return m.NumTimeSeries
	}
	return 0
}

func (m *PickTimeSeriesFilter) GetDirection() PickTimeSeriesFilter_Direction {
	if m != nil {
		return m.Direction
	}
	return PickTimeSeriesFilter_DIRECTION_UNSPECIFIED
}

// A filter that ranks streams based on their statistical relation to other
// streams in a request.
type StatisticalTimeSeriesFilter struct {
	// `rankingMethod` is applied to a set of time series, and then the produced
	// value for each individual time series is used to compare a given time
	// series to others.
	// These are methods that cannot be applied stream-by-stream, but rather
	// require the full context of a request to evaluate time series.
	RankingMethod StatisticalTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to output.
	NumTimeSeries        int32    `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatisticalTimeSeriesFilter) Reset()         { *m = StatisticalTimeSeriesFilter{} }
func (m *StatisticalTimeSeriesFilter) String() string { return proto.CompactTextString(m) }
func (*StatisticalTimeSeriesFilter) ProtoMessage()    {}
func (*StatisticalTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_adfe4653047f7180, []int{2}
}

func (m *StatisticalTimeSeriesFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Unmarshal(m, b)
}
func (m *StatisticalTimeSeriesFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Marshal(b, m, deterministic)
}
func (m *StatisticalTimeSeriesFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatisticalTimeSeriesFilter.Merge(m, src)
}
func (m *StatisticalTimeSeriesFilter) XXX_Size() int {
	return xxx_messageInfo_StatisticalTimeSeriesFilter.Size(m)
}
func (m *StatisticalTimeSeriesFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_StatisticalTimeSeriesFilter.DiscardUnknown(m)
}

var xxx_messageInfo_StatisticalTimeSeriesFilter proto.InternalMessageInfo

func (m *StatisticalTimeSeriesFilter) GetRankingMethod() StatisticalTimeSeriesFilter_Method {
	if m != nil {
		return m.RankingMethod
	}
	return StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (m *StatisticalTimeSeriesFilter) GetNumTimeSeries() int32 {
	if m != nil {
		return m.NumTimeSeries
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.monitoring.dashboard.v1.Aggregation_Aligner", Aggregation_Aligner_name, Aggregation_Aligner_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.Aggregation_Reducer", Aggregation_Reducer_name, Aggregation_Reducer_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.PickTimeSeriesFilter_Method", PickTimeSeriesFilter_Method_name, PickTimeSeriesFilter_Method_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.PickTimeSeriesFilter_Direction", PickTimeSeriesFilter_Direction_name, PickTimeSeriesFilter_Direction_value)
	proto.RegisterEnum("google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter_Method", StatisticalTimeSeriesFilter_Method_name, StatisticalTimeSeriesFilter_Method_value)
	proto.RegisterType((*Aggregation)(nil), "google.monitoring.dashboard.v1.Aggregation")
	proto.RegisterType((*PickTimeSeriesFilter)(nil), "google.monitoring.dashboard.v1.PickTimeSeriesFilter")
	proto.RegisterType((*StatisticalTimeSeriesFilter)(nil), "google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter")
}

func init() {
	proto.RegisterFile("google/monitoring/dashboard/v1/common.proto", fileDescriptor_adfe4653047f7180)
}

var fileDescriptor_adfe4653047f7180 = []byte{
	// 835 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x5d, 0x8b, 0xdb, 0x46,
	0x14, 0xad, 0xed, 0xfd, 0x88, 0xaf, 0xd7, 0xf6, 0xec, 0xc4, 0xbb, 0x71, 0x52, 0x28, 0x8b, 0x1e,
	0xca, 0x42, 0x41, 0xde, 0x6c, 0xf0, 0x43, 0xd8, 0x52, 0x90, 0xad, 0xf1, 0x46, 0x60, 0x4b, 0x66,
	0x2c, 0x97, 0xa5, 0x14, 0x84, 0x6c, 0x4f, 0x14, 0x11, 0x4b, 0x32, 0x63, 0x39, 0x10, 0xe8, 0x7b,
	0x1f, 0xfa, 0x6b, 0x4a, 0xff, 0x57, 0x7f, 0x43, 0xd1, 0xcc, 0xc8, 0xb2, 0xa9, 0x37, 0x4b, 0x9b,
	0xc7, 0x7b, 0xce, 0xbd, 0xe7, 0x5e, 0x9d, 0x99, 0xab, 0x81, 0x1f, 0x82, 0x24, 0x09, 0x96, 0xac,
	0x13, 0x25, 0x71, 0x98, 0x26, 0x3c, 0x8c, 0x83, 0xce, 0xc2, 0x5f, 0x7f, 0x98, 0x25, 0x3e, 0x5f,
	0x74, 0x3e, 0xbd, 0xee, 0xcc, 0x93, 0x28, 0x4a, 0x62, 0x7d, 0xc5, 0x93, 0x34, 0xc1, 0xdf, 0xc9,
	0x64, 0xbd, 0x48, 0xd6, 0xb7, 0xc9, 0xfa, 0xa7, 0xd7, 0xaf, 0x14, 0xdf, 0x11, 0xd9, 0xb3, 0xcd,
	0xfb, 0xce, 0x62, 0xc3, 0xfd, 0x34, 0xcc, 0xeb, 0xb5, 0xdf, 0x9f, 0x41, 0xcd, 0x08, 0x02, 0xce,
	0x02, 0x81, 0x62, 0x13, 0x90, 0xbf, 0x0c, 0x83, 0x38, 0x62, 0x71, 0xea, 0xad, 0x18, 0x0f, 0x93,
	0x45, 0xbb, 0x74, 0x55, 0xba, 0xae, 0xdd, 0xbe, 0xd4, 0x55, 0xab, 0x5c, 0x4a, 0x37, 0x95, 0x14,
	0x6d, 0x6e, 0x4b, 0xc6, 0xa2, 0x02, 0xfb, 0x80, 0x57, 0x8c, 0x7b, 0x6b, 0xc6, 0x43, 0xb6, 0xf6,
	0x04, 0xcb, 0x78, 0xbb, 0x7c, 0x55, 0xba, 0x6e, 0xdc, 0xbe, 0xd1, 0xbf, 0x3c, 0xb2, 0xbe, 0x33,
	0x8e, 0x6e, 0xc8, 0x52, 0x8a, 0x56, 0x8c, 0x4f, 0x84, 0x9a, 0x42, 0x30, 0x83, 0xd6, 0x9c, 0x27,
	0xeb, 0x75, 0xde, 0x84, 0xb3, 0xc5, 0x66, 0xce, 0x78, 0xfb, 0xe8, 0xbf, 0x37, 0xa1, 0xb2, 0x94,
	0x62, 0x21, 0x28, 0xdb, 0x28, 0x0c, 0x7f, 0x0f, 0xcd, 0x80, 0x27, 0x9b, 0x95, 0x37, 0xfb, 0xec,
	0xbd, 0x0f, 0xd9, 0x72, 0xb1, 0x6e, 0x1f, 0x5f, 0x55, 0xae, 0xab, 0xb4, 0x2e, 0xe0, 0xde, 0xe7,
	0x81, 0x00, 0xb5, 0x3f, 0x2a, 0x70, 0x9a, 0x8f, 0xd6, 0x00, 0x30, 0x86, 0xd6, 0xbd, 0xed, 0xd9,
	0x8e, 0x4d, 0xd0, 0x37, 0xb8, 0x09, 0x35, 0x19, 0x9b, 0x64, 0xe8, 0x1a, 0xa8, 0x54, 0x24, 0x50,
	0xc3, 0x25, 0xa8, 0x8c, 0x2f, 0xe0, 0x5c, 0xc6, 0x96, 0xed, 0x12, 0x3a, 0x76, 0x86, 0x19, 0x5c,
	0xc1, 0x2d, 0x40, 0x4a, 0x87, 0x3c, 0xb8, 0x9e, 0x33, 0x34, 0x09, 0x45, 0x47, 0xb8, 0x0e, 0x55,
	0x89, 0x8e, 0x2c, 0x1b, 0xc1, 0x4e, 0x68, 0x3c, 0xa0, 0x5a, 0x21, 0x3d, 0x22, 0x86, 0x8d, 0xce,
	0x8a, 0xde, 0x7d, 0x67, 0x6a, 0xbb, 0xa8, 0x5e, 0xe4, 0x4f, 0xa6, 0x23, 0xd4, 0xc0, 0x08, 0xce,
	0x54, 0xe8, 0x9a, 0x26, 0xf9, 0x19, 0x35, 0x8b, 0xae, 0xa2, 0xc2, 0x73, 0xe9, 0x94, 0x20, 0x54,
	0x8c, 0x28, 0xd1, 0x81, 0x31, 0x9c, 0x10, 0xd4, 0xc6, 0x2f, 0xe0, 0xb9, 0x84, 0x07, 0xd4, 0xe8,
	0xbb, 0x96, 0x63, 0xcb, 0xfc, 0xf3, 0x82, 0x18, 0x13, 0xda, 0x27, 0xb6, 0x6b, 0x0d, 0x89, 0xf7,
	0xf6, 0x2d, 0xc2, 0x87, 0x89, 0x2e, 0x7a, 0x7e, 0x90, 0xe8, 0xde, 0xa0, 0xd6, 0x41, 0xe2, 0xa6,
	0x8b, 0x2e, 0x70, 0x1b, 0x5a, 0x7b, 0x84, 0xd7, 0x7f, 0x67, 0xd8, 0xf7, 0x04, 0xbd, 0xd0, 0xfe,
	0x2c, 0xc3, 0x69, 0x7e, 0x82, 0x4d, 0xa8, 0x51, 0x62, 0x4e, 0xfb, 0x64, 0xe7, 0x38, 0x14, 0x20,
	0x3c, 0x12, 0xc7, 0x91, 0x03, 0x96, 0x8d, 0xca, 0xbb, 0xb1, 0xf1, 0x80, 0x2a, 0x3b, 0x71, 0xe6,
	0xd9, 0x11, 0x3e, 0x87, 0x7a, 0x1e, 0x4b, 0xd3, 0x8e, 0x33, 0x1b, 0x15, 0x24, 0x7d, 0x3e, 0xc9,
	0x0c, 0xdb, 0x45, 0xa4, 0x2f, 0xa7, 0xf8, 0x12, 0xf0, 0x1e, 0x2c, 0x8d, 0x6c, 0x66, 0xdf, 0xa2,
	0xf0, 0x7d, 0x27, 0x9f, 0xed, 0x30, 0xfb, 0x56, 0x56, 0x1f, 0x61, 0xba, 0x08, 0x0e, 0x33, 0xdd,
	0x1b, 0x54, 0x3b, 0xcc, 0xdc, 0x74, 0xd1, 0x99, 0xf6, 0x57, 0x05, 0x5a, 0xe3, 0x70, 0xfe, 0xd1,
	0x0d, 0x23, 0x26, 0x77, 0x60, 0x10, 0x2e, 0x53, 0xc6, 0xf1, 0x0c, 0x1a, 0xdc, 0x8f, 0x3f, 0x86,
	0x71, 0xe0, 0x45, 0x2c, 0xfd, 0xa0, 0x7e, 0x08, 0x8d, 0xdb, 0xbb, 0xa7, 0x76, 0xec, 0x90, 0x9a,
	0x3e, 0x12, 0x12, 0xb4, 0xae, 0x24, 0x65, 0x98, 0xad, 0x59, 0xbc, 0x89, 0xbc, 0x34, 0x8c, 0x98,
	0x5a, 0x68, 0xf1, 0xb7, 0x38, 0xa6, 0xf5, 0x78, 0x13, 0x15, 0x1a, 0xf8, 0x57, 0xa8, 0x2e, 0x42,
	0xce, 0xe6, 0xd9, 0xde, 0xb6, 0x2b, 0x62, 0x8c, 0x9f, 0xfe, 0xd7, 0x18, 0x66, 0xae, 0x42, 0x0b,
	0x41, 0x2d, 0x85, 0x13, 0x35, 0xcf, 0x25, 0xe0, 0x11, 0x71, 0xdf, 0x39, 0xa6, 0x37, 0xb5, 0x27,
	0x63, 0xd2, 0xb7, 0x06, 0x16, 0x31, 0xe5, 0xdd, 0x51, 0x78, 0x71, 0x77, 0x72, 0xc0, 0x78, 0x90,
	0x77, 0x27, 0x8f, 0x2d, 0x5b, 0xde, 0x1d, 0x15, 0x6f, 0xef, 0x8e, 0x8a, 0xb3, 0x25, 0x9f, 0xb8,
	0xe8, 0x58, 0xbb, 0x83, 0xea, 0x76, 0x1a, 0xfc, 0x12, 0x2e, 0x4c, 0x8b, 0x12, 0x79, 0x03, 0xf6,
	0x7b, 0x9f, 0x42, 0xc5, 0x75, 0xc6, 0xa8, 0x84, 0x01, 0x4e, 0x7a, 0x8e, 0xeb, 0x3a, 0x23, 0x54,
	0xd6, 0xfe, 0x2e, 0xc1, 0xb7, 0x93, 0xd4, 0x4f, 0xc3, 0x75, 0x1a, 0xce, 0xfd, 0xe5, 0xbf, 0x0e,
	0x2f, 0x7c, 0xe4, 0xf0, 0x7a, 0x4f, 0xb9, 0xf6, 0x05, 0xd1, 0xaf, 0x3b, 0x43, 0xed, 0xc7, 0x27,
	0x5d, 0x7e, 0x05, 0x97, 0x0a, 0xef, 0x0f, 0xa7, 0x13, 0x97, 0x50, 0xcf, 0x99, 0xba, 0x43, 0x8b,
	0x50, 0x54, 0xea, 0xfd, 0x06, 0xda, 0x3c, 0x89, 0x9e, 0x98, 0xbe, 0x57, 0xeb, 0x8b, 0x47, 0x72,
	0x9c, 0x3d, 0x55, 0xe3, 0xd2, 0x2f, 0xf7, 0x2a, 0x3d, 0x48, 0x96, 0x7e, 0x1c, 0xe8, 0x09, 0x0f,
	0x3a, 0x01, 0x8b, 0xc5, 0x43, 0xd6, 0x91, 0x94, 0xbf, 0x0a, 0xd7, 0x8f, 0xbd, 0xb8, 0x77, 0xdb,
	0x60, 0x76, 0x22, 0x6a, 0xde, 0xfc, 0x13, 0x00, 0x00, 0xff, 0xff, 0x28, 0x91, 0xa0, 0x2b, 0xa4,
	0x07, 0x00, 0x00,
}
