package kubernetesconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AKSIdentityType enumerates the values for aks identity type.
type AKSIdentityType string

const (
	// AKSIdentityTypeSystemAssigned ...
	AKSIdentityTypeSystemAssigned AKSIdentityType = "SystemAssigned"
	// AKSIdentityTypeUserAssigned ...
	AKSIdentityTypeUserAssigned AKSIdentityType = "UserAssigned"
)

// PossibleAKSIdentityTypeValues returns an array of possible values for the AKSIdentityType const type.
func PossibleAKSIdentityTypeValues() []AKSIdentityType {
	return []AKSIdentityType{AKSIdentityTypeSystemAssigned, AKSIdentityTypeUserAssigned}
}

// ComplianceStateType enumerates the values for compliance state type.
type ComplianceStateType string

const (
	// ComplianceStateTypeCompliant ...
	ComplianceStateTypeCompliant ComplianceStateType = "Compliant"
	// ComplianceStateTypeFailed ...
	ComplianceStateTypeFailed ComplianceStateType = "Failed"
	// ComplianceStateTypeInstalled ...
	ComplianceStateTypeInstalled ComplianceStateType = "Installed"
	// ComplianceStateTypeNoncompliant ...
	ComplianceStateTypeNoncompliant ComplianceStateType = "Noncompliant"
	// ComplianceStateTypePending ...
	ComplianceStateTypePending ComplianceStateType = "Pending"
)

// PossibleComplianceStateTypeValues returns an array of possible values for the ComplianceStateType const type.
func PossibleComplianceStateTypeValues() []ComplianceStateType {
	return []ComplianceStateType{ComplianceStateTypeCompliant, ComplianceStateTypeFailed, ComplianceStateTypeInstalled, ComplianceStateTypeNoncompliant, ComplianceStateTypePending}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// FluxComplianceState enumerates the values for flux compliance state.
type FluxComplianceState string

const (
	// FluxComplianceStateCompliant ...
	FluxComplianceStateCompliant FluxComplianceState = "Compliant"
	// FluxComplianceStateNonCompliant ...
	FluxComplianceStateNonCompliant FluxComplianceState = "Non-Compliant"
	// FluxComplianceStatePending ...
	FluxComplianceStatePending FluxComplianceState = "Pending"
	// FluxComplianceStateSuspended ...
	FluxComplianceStateSuspended FluxComplianceState = "Suspended"
	// FluxComplianceStateUnknown ...
	FluxComplianceStateUnknown FluxComplianceState = "Unknown"
)

// PossibleFluxComplianceStateValues returns an array of possible values for the FluxComplianceState const type.
func PossibleFluxComplianceStateValues() []FluxComplianceState {
	return []FluxComplianceState{FluxComplianceStateCompliant, FluxComplianceStateNonCompliant, FluxComplianceStatePending, FluxComplianceStateSuspended, FluxComplianceStateUnknown}
}

// KustomizationValidationType enumerates the values for kustomization validation type.
type KustomizationValidationType string

const (
	// KustomizationValidationTypeClient ...
	KustomizationValidationTypeClient KustomizationValidationType = "client"
	// KustomizationValidationTypeNone ...
	KustomizationValidationTypeNone KustomizationValidationType = "none"
	// KustomizationValidationTypeServer ...
	KustomizationValidationTypeServer KustomizationValidationType = "server"
)

// PossibleKustomizationValidationTypeValues returns an array of possible values for the KustomizationValidationType const type.
func PossibleKustomizationValidationTypeValues() []KustomizationValidationType {
	return []KustomizationValidationType{KustomizationValidationTypeClient, KustomizationValidationTypeNone, KustomizationValidationTypeServer}
}

// LevelType enumerates the values for level type.
type LevelType string

const (
	// LevelTypeError ...
	LevelTypeError LevelType = "Error"
	// LevelTypeInformation ...
	LevelTypeInformation LevelType = "Information"
	// LevelTypeWarning ...
	LevelTypeWarning LevelType = "Warning"
)

// PossibleLevelTypeValues returns an array of possible values for the LevelType const type.
func PossibleLevelTypeValues() []LevelType {
	return []LevelType{LevelTypeError, LevelTypeInformation, LevelTypeWarning}
}

// MessageLevelType enumerates the values for message level type.
type MessageLevelType string

const (
	// MessageLevelTypeError ...
	MessageLevelTypeError MessageLevelType = "Error"
	// MessageLevelTypeInformation ...
	MessageLevelTypeInformation MessageLevelType = "Information"
	// MessageLevelTypeWarning ...
	MessageLevelTypeWarning MessageLevelType = "Warning"
)

// PossibleMessageLevelTypeValues returns an array of possible values for the MessageLevelType const type.
func PossibleMessageLevelTypeValues() []MessageLevelType {
	return []MessageLevelType{MessageLevelTypeError, MessageLevelTypeInformation, MessageLevelTypeWarning}
}

// OperatorScopeType enumerates the values for operator scope type.
type OperatorScopeType string

const (
	// OperatorScopeTypeCluster ...
	OperatorScopeTypeCluster OperatorScopeType = "cluster"
	// OperatorScopeTypeNamespace ...
	OperatorScopeTypeNamespace OperatorScopeType = "namespace"
)

// PossibleOperatorScopeTypeValues returns an array of possible values for the OperatorScopeType const type.
func PossibleOperatorScopeTypeValues() []OperatorScopeType {
	return []OperatorScopeType{OperatorScopeTypeCluster, OperatorScopeTypeNamespace}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// OperatorTypeFlux ...
	OperatorTypeFlux OperatorType = "Flux"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{OperatorTypeFlux}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// PrivateEndpointServiceConnectionStatusApproved ...
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	// PrivateEndpointServiceConnectionStatusPending ...
	PrivateEndpointServiceConnectionStatusPending PrivateEndpointServiceConnectionStatus = "Pending"
	// PrivateEndpointServiceConnectionStatusRejected ...
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{PrivateEndpointServiceConnectionStatusApproved, PrivateEndpointServiceConnectionStatusPending, PrivateEndpointServiceConnectionStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ProvisioningStateType enumerates the values for provisioning state type.
type ProvisioningStateType string

const (
	// ProvisioningStateTypeAccepted ...
	ProvisioningStateTypeAccepted ProvisioningStateType = "Accepted"
	// ProvisioningStateTypeDeleting ...
	ProvisioningStateTypeDeleting ProvisioningStateType = "Deleting"
	// ProvisioningStateTypeFailed ...
	ProvisioningStateTypeFailed ProvisioningStateType = "Failed"
	// ProvisioningStateTypeRunning ...
	ProvisioningStateTypeRunning ProvisioningStateType = "Running"
	// ProvisioningStateTypeSucceeded ...
	ProvisioningStateTypeSucceeded ProvisioningStateType = "Succeeded"
)

// PossibleProvisioningStateTypeValues returns an array of possible values for the ProvisioningStateType const type.
func PossibleProvisioningStateTypeValues() []ProvisioningStateType {
	return []ProvisioningStateType{ProvisioningStateTypeAccepted, ProvisioningStateTypeDeleting, ProvisioningStateTypeFailed, ProvisioningStateTypeRunning, ProvisioningStateTypeSucceeded}
}

// PublicNetworkAccessType enumerates the values for public network access type.
type PublicNetworkAccessType string

const (
	// PublicNetworkAccessTypeDisabled Does not allow Azure Arc agents to communicate with Azure Arc services
	// over public (internet) endpoints. The agents must use the private link.
	PublicNetworkAccessTypeDisabled PublicNetworkAccessType = "Disabled"
	// PublicNetworkAccessTypeEnabled Allows Azure Arc agents to communicate with Azure Arc services over both
	// public (internet) and private endpoints.
	PublicNetworkAccessTypeEnabled PublicNetworkAccessType = "Enabled"
)

// PossiblePublicNetworkAccessTypeValues returns an array of possible values for the PublicNetworkAccessType const type.
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return []PublicNetworkAccessType{PublicNetworkAccessTypeDisabled, PublicNetworkAccessTypeEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeSystemAssigned}
}

// ScopeType enumerates the values for scope type.
type ScopeType string

const (
	// ScopeTypeCluster ...
	ScopeTypeCluster ScopeType = "cluster"
	// ScopeTypeNamespace ...
	ScopeTypeNamespace ScopeType = "namespace"
)

// PossibleScopeTypeValues returns an array of possible values for the ScopeType const type.
func PossibleScopeTypeValues() []ScopeType {
	return []ScopeType{ScopeTypeCluster, ScopeTypeNamespace}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierFree ...
	SkuTierFree SkuTier = "Free"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierFree, SkuTierPremium, SkuTierStandard}
}

// SourceKindType enumerates the values for source kind type.
type SourceKindType string

const (
	// SourceKindTypeBucket ...
	SourceKindTypeBucket SourceKindType = "Bucket"
	// SourceKindTypeGitRepository ...
	SourceKindTypeGitRepository SourceKindType = "GitRepository"
)

// PossibleSourceKindTypeValues returns an array of possible values for the SourceKindType const type.
func PossibleSourceKindTypeValues() []SourceKindType {
	return []SourceKindType{SourceKindTypeBucket, SourceKindTypeGitRepository}
}
