// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAddCustomAttributes struct {
}

func (*awsAwsjson11_serializeOpAddCustomAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddCustomAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddCustomAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AddCustomAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddCustomAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminAddUserToGroup struct {
}

func (*awsAwsjson11_serializeOpAdminAddUserToGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminAddUserToGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminAddUserToGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminAddUserToGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminAddUserToGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminConfirmSignUp struct {
}

func (*awsAwsjson11_serializeOpAdminConfirmSignUp) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminConfirmSignUp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminConfirmSignUpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminConfirmSignUp")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminConfirmSignUpInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminCreateUser struct {
}

func (*awsAwsjson11_serializeOpAdminCreateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminCreateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminCreateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminCreateUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminCreateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminDeleteUser struct {
}

func (*awsAwsjson11_serializeOpAdminDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminDeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminDeleteUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminDeleteUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminDeleteUserAttributes struct {
}

func (*awsAwsjson11_serializeOpAdminDeleteUserAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminDeleteUserAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminDeleteUserAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminDeleteUserAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminDeleteUserAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminDisableProviderForUser struct {
}

func (*awsAwsjson11_serializeOpAdminDisableProviderForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminDisableProviderForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminDisableProviderForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminDisableProviderForUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminDisableProviderForUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminDisableUser struct {
}

func (*awsAwsjson11_serializeOpAdminDisableUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminDisableUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminDisableUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminDisableUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminDisableUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminEnableUser struct {
}

func (*awsAwsjson11_serializeOpAdminEnableUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminEnableUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminEnableUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminEnableUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminEnableUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminForgetDevice struct {
}

func (*awsAwsjson11_serializeOpAdminForgetDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminForgetDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminForgetDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminForgetDevice")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminForgetDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminGetDevice struct {
}

func (*awsAwsjson11_serializeOpAdminGetDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminGetDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminGetDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminGetDevice")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminGetDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminGetUser struct {
}

func (*awsAwsjson11_serializeOpAdminGetUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminGetUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminGetUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminGetUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminGetUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminInitiateAuth struct {
}

func (*awsAwsjson11_serializeOpAdminInitiateAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminInitiateAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminInitiateAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminInitiateAuth")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminInitiateAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminLinkProviderForUser struct {
}

func (*awsAwsjson11_serializeOpAdminLinkProviderForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminLinkProviderForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminLinkProviderForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminLinkProviderForUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminLinkProviderForUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminListDevices struct {
}

func (*awsAwsjson11_serializeOpAdminListDevices) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminListDevices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminListDevicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminListDevices")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminListDevicesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminListGroupsForUser struct {
}

func (*awsAwsjson11_serializeOpAdminListGroupsForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminListGroupsForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminListGroupsForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminListGroupsForUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminListGroupsForUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminListUserAuthEvents struct {
}

func (*awsAwsjson11_serializeOpAdminListUserAuthEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminListUserAuthEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminListUserAuthEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminListUserAuthEvents")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminListUserAuthEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminRemoveUserFromGroup struct {
}

func (*awsAwsjson11_serializeOpAdminRemoveUserFromGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminRemoveUserFromGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminRemoveUserFromGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminRemoveUserFromGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminRemoveUserFromGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminResetUserPassword struct {
}

func (*awsAwsjson11_serializeOpAdminResetUserPassword) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminResetUserPassword) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminResetUserPasswordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminResetUserPassword")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminResetUserPasswordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminRespondToAuthChallenge struct {
}

func (*awsAwsjson11_serializeOpAdminRespondToAuthChallenge) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminRespondToAuthChallenge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminRespondToAuthChallengeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminRespondToAuthChallenge")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminRespondToAuthChallengeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminSetUserMFAPreference struct {
}

func (*awsAwsjson11_serializeOpAdminSetUserMFAPreference) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminSetUserMFAPreference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminSetUserMFAPreferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminSetUserMFAPreference")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminSetUserMFAPreferenceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminSetUserPassword struct {
}

func (*awsAwsjson11_serializeOpAdminSetUserPassword) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminSetUserPassword) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminSetUserPasswordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminSetUserPassword")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminSetUserPasswordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminSetUserSettings struct {
}

func (*awsAwsjson11_serializeOpAdminSetUserSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminSetUserSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminSetUserSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminSetUserSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminSetUserSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminUpdateAuthEventFeedback struct {
}

func (*awsAwsjson11_serializeOpAdminUpdateAuthEventFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminUpdateAuthEventFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminUpdateAuthEventFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminUpdateAuthEventFeedback")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminUpdateAuthEventFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminUpdateDeviceStatus struct {
}

func (*awsAwsjson11_serializeOpAdminUpdateDeviceStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminUpdateDeviceStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminUpdateDeviceStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminUpdateDeviceStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminUpdateDeviceStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminUpdateUserAttributes struct {
}

func (*awsAwsjson11_serializeOpAdminUpdateUserAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminUpdateUserAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminUpdateUserAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminUpdateUserAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminUpdateUserAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAdminUserGlobalSignOut struct {
}

func (*awsAwsjson11_serializeOpAdminUserGlobalSignOut) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAdminUserGlobalSignOut) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdminUserGlobalSignOutInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AdminUserGlobalSignOut")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAdminUserGlobalSignOutInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAssociateSoftwareToken struct {
}

func (*awsAwsjson11_serializeOpAssociateSoftwareToken) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAssociateSoftwareToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateSoftwareTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.AssociateSoftwareToken")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAssociateSoftwareTokenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpChangePassword struct {
}

func (*awsAwsjson11_serializeOpChangePassword) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpChangePassword) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChangePasswordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ChangePassword")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentChangePasswordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpConfirmDevice struct {
}

func (*awsAwsjson11_serializeOpConfirmDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpConfirmDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfirmDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ConfirmDevice")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentConfirmDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpConfirmForgotPassword struct {
}

func (*awsAwsjson11_serializeOpConfirmForgotPassword) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpConfirmForgotPassword) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfirmForgotPasswordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ConfirmForgotPassword")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentConfirmForgotPasswordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpConfirmSignUp struct {
}

func (*awsAwsjson11_serializeOpConfirmSignUp) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpConfirmSignUp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfirmSignUpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ConfirmSignUp")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentConfirmSignUpInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateGroup struct {
}

func (*awsAwsjson11_serializeOpCreateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateIdentityProvider struct {
}

func (*awsAwsjson11_serializeOpCreateIdentityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateIdentityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIdentityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateIdentityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateIdentityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateResourceServer struct {
}

func (*awsAwsjson11_serializeOpCreateResourceServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateResourceServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateResourceServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateResourceServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateResourceServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUserImportJob struct {
}

func (*awsAwsjson11_serializeOpCreateUserImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUserImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateUserImportJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUserImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUserPool struct {
}

func (*awsAwsjson11_serializeOpCreateUserPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUserPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateUserPool")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUserPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUserPoolClient struct {
}

func (*awsAwsjson11_serializeOpCreateUserPoolClient) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUserPoolClient) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserPoolClientInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateUserPoolClient")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUserPoolClientInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateUserPoolDomain struct {
}

func (*awsAwsjson11_serializeOpCreateUserPoolDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateUserPoolDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserPoolDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.CreateUserPoolDomain")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateUserPoolDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteGroup struct {
}

func (*awsAwsjson11_serializeOpDeleteGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteIdentityProvider struct {
}

func (*awsAwsjson11_serializeOpDeleteIdentityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteIdentityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteIdentityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteIdentityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteResourceServer struct {
}

func (*awsAwsjson11_serializeOpDeleteResourceServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteResourceServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourceServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteResourceServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteResourceServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUser struct {
}

func (*awsAwsjson11_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUserAttributes struct {
}

func (*awsAwsjson11_serializeOpDeleteUserAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUserAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteUserAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUserPool struct {
}

func (*awsAwsjson11_serializeOpDeleteUserPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUserPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteUserPool")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUserPoolClient struct {
}

func (*awsAwsjson11_serializeOpDeleteUserPoolClient) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUserPoolClient) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserPoolClientInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteUserPoolClient")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserPoolClientInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteUserPoolDomain struct {
}

func (*awsAwsjson11_serializeOpDeleteUserPoolDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteUserPoolDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserPoolDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DeleteUserPoolDomain")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteUserPoolDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeIdentityProvider struct {
}

func (*awsAwsjson11_serializeOpDescribeIdentityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeIdentityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIdentityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeIdentityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeIdentityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeResourceServer struct {
}

func (*awsAwsjson11_serializeOpDescribeResourceServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeResourceServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeResourceServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeResourceServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeResourceServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeRiskConfiguration struct {
}

func (*awsAwsjson11_serializeOpDescribeRiskConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeRiskConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRiskConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeRiskConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeRiskConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeUserImportJob struct {
}

func (*awsAwsjson11_serializeOpDescribeUserImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeUserImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeUserImportJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeUserImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeUserPool struct {
}

func (*awsAwsjson11_serializeOpDescribeUserPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeUserPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeUserPool")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeUserPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeUserPoolClient struct {
}

func (*awsAwsjson11_serializeOpDescribeUserPoolClient) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeUserPoolClient) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserPoolClientInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeUserPoolClient")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeUserPoolClientInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeUserPoolDomain struct {
}

func (*awsAwsjson11_serializeOpDescribeUserPoolDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeUserPoolDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserPoolDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.DescribeUserPoolDomain")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeUserPoolDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpForgetDevice struct {
}

func (*awsAwsjson11_serializeOpForgetDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpForgetDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ForgetDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ForgetDevice")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentForgetDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpForgotPassword struct {
}

func (*awsAwsjson11_serializeOpForgotPassword) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpForgotPassword) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ForgotPasswordInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ForgotPassword")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentForgotPasswordInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCSVHeader struct {
}

func (*awsAwsjson11_serializeOpGetCSVHeader) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCSVHeader) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCSVHeaderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetCSVHeader")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCSVHeaderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetDevice struct {
}

func (*awsAwsjson11_serializeOpGetDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetDevice")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetGroup struct {
}

func (*awsAwsjson11_serializeOpGetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetIdentityProviderByIdentifier struct {
}

func (*awsAwsjson11_serializeOpGetIdentityProviderByIdentifier) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetIdentityProviderByIdentifier) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityProviderByIdentifierInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetIdentityProviderByIdentifier")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetIdentityProviderByIdentifierInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetLogDeliveryConfiguration struct {
}

func (*awsAwsjson11_serializeOpGetLogDeliveryConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetLogDeliveryConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLogDeliveryConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetLogDeliveryConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetLogDeliveryConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSigningCertificate struct {
}

func (*awsAwsjson11_serializeOpGetSigningCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSigningCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSigningCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetSigningCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSigningCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUICustomization struct {
}

func (*awsAwsjson11_serializeOpGetUICustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUICustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUICustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetUICustomization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUICustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUser struct {
}

func (*awsAwsjson11_serializeOpGetUser) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetUser")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUserAttributeVerificationCode struct {
}

func (*awsAwsjson11_serializeOpGetUserAttributeVerificationCode) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUserAttributeVerificationCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserAttributeVerificationCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetUserAttributeVerificationCode")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUserAttributeVerificationCodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetUserPoolMfaConfig struct {
}

func (*awsAwsjson11_serializeOpGetUserPoolMfaConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetUserPoolMfaConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserPoolMfaConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GetUserPoolMfaConfig")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetUserPoolMfaConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGlobalSignOut struct {
}

func (*awsAwsjson11_serializeOpGlobalSignOut) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGlobalSignOut) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GlobalSignOutInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.GlobalSignOut")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGlobalSignOutInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpInitiateAuth struct {
}

func (*awsAwsjson11_serializeOpInitiateAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpInitiateAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InitiateAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.InitiateAuth")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentInitiateAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDevices struct {
}

func (*awsAwsjson11_serializeOpListDevices) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDevices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDevicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListDevices")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDevicesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListGroups struct {
}

func (*awsAwsjson11_serializeOpListGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListIdentityProviders struct {
}

func (*awsAwsjson11_serializeOpListIdentityProviders) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListIdentityProviders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentityProvidersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListIdentityProviders")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListIdentityProvidersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListResourceServers struct {
}

func (*awsAwsjson11_serializeOpListResourceServers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListResourceServers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListResourceServersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListResourceServers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListResourceServersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUserImportJobs struct {
}

func (*awsAwsjson11_serializeOpListUserImportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUserImportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserImportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListUserImportJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUserImportJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUserPoolClients struct {
}

func (*awsAwsjson11_serializeOpListUserPoolClients) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUserPoolClients) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserPoolClientsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListUserPoolClients")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUserPoolClientsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUserPools struct {
}

func (*awsAwsjson11_serializeOpListUserPools) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUserPools) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserPoolsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListUserPools")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUserPoolsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUsers struct {
}

func (*awsAwsjson11_serializeOpListUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListUsers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUsersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListUsersInGroup struct {
}

func (*awsAwsjson11_serializeOpListUsersInGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListUsersInGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsersInGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ListUsersInGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListUsersInGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpResendConfirmationCode struct {
}

func (*awsAwsjson11_serializeOpResendConfirmationCode) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpResendConfirmationCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResendConfirmationCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.ResendConfirmationCode")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentResendConfirmationCodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRespondToAuthChallenge struct {
}

func (*awsAwsjson11_serializeOpRespondToAuthChallenge) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRespondToAuthChallenge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RespondToAuthChallengeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.RespondToAuthChallenge")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRespondToAuthChallengeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRevokeToken struct {
}

func (*awsAwsjson11_serializeOpRevokeToken) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRevokeToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.RevokeToken")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRevokeTokenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetLogDeliveryConfiguration struct {
}

func (*awsAwsjson11_serializeOpSetLogDeliveryConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetLogDeliveryConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLogDeliveryConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetLogDeliveryConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetLogDeliveryConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetRiskConfiguration struct {
}

func (*awsAwsjson11_serializeOpSetRiskConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetRiskConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetRiskConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetRiskConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetRiskConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetUICustomization struct {
}

func (*awsAwsjson11_serializeOpSetUICustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetUICustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetUICustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetUICustomization")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetUICustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetUserMFAPreference struct {
}

func (*awsAwsjson11_serializeOpSetUserMFAPreference) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetUserMFAPreference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetUserMFAPreferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetUserMFAPreference")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetUserMFAPreferenceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetUserPoolMfaConfig struct {
}

func (*awsAwsjson11_serializeOpSetUserPoolMfaConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetUserPoolMfaConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetUserPoolMfaConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetUserPoolMfaConfig")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetUserPoolMfaConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetUserSettings struct {
}

func (*awsAwsjson11_serializeOpSetUserSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetUserSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetUserSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SetUserSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetUserSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSignUp struct {
}

func (*awsAwsjson11_serializeOpSignUp) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSignUp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SignUpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.SignUp")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSignUpInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartUserImportJob struct {
}

func (*awsAwsjson11_serializeOpStartUserImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartUserImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartUserImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.StartUserImportJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartUserImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopUserImportJob struct {
}

func (*awsAwsjson11_serializeOpStopUserImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopUserImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopUserImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.StopUserImportJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopUserImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateAuthEventFeedback struct {
}

func (*awsAwsjson11_serializeOpUpdateAuthEventFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateAuthEventFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAuthEventFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateAuthEventFeedback")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateAuthEventFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDeviceStatus struct {
}

func (*awsAwsjson11_serializeOpUpdateDeviceStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDeviceStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDeviceStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateDeviceStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDeviceStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateGroup struct {
}

func (*awsAwsjson11_serializeOpUpdateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateIdentityProvider struct {
}

func (*awsAwsjson11_serializeOpUpdateIdentityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateIdentityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIdentityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateIdentityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateIdentityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateResourceServer struct {
}

func (*awsAwsjson11_serializeOpUpdateResourceServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateResourceServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateResourceServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateResourceServer")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateResourceServerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUserAttributes struct {
}

func (*awsAwsjson11_serializeOpUpdateUserAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUserAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateUserAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUserAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUserPool struct {
}

func (*awsAwsjson11_serializeOpUpdateUserPool) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUserPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateUserPool")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUserPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUserPoolClient struct {
}

func (*awsAwsjson11_serializeOpUpdateUserPoolClient) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUserPoolClient) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserPoolClientInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateUserPoolClient")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUserPoolClientInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateUserPoolDomain struct {
}

func (*awsAwsjson11_serializeOpUpdateUserPoolDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateUserPoolDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserPoolDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.UpdateUserPoolDomain")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateUserPoolDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpVerifySoftwareToken struct {
}

func (*awsAwsjson11_serializeOpVerifySoftwareToken) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpVerifySoftwareToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifySoftwareTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.VerifySoftwareToken")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentVerifySoftwareTokenInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpVerifyUserAttribute struct {
}

func (*awsAwsjson11_serializeOpVerifyUserAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpVerifyUserAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyUserAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSCognitoIdentityProviderService.VerifyUserAttribute")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentVerifyUserAttributeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAccountRecoverySettingType(v *types.AccountRecoverySettingType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RecoveryMechanisms != nil {
		ok := object.Key("RecoveryMechanisms")
		if err := awsAwsjson11_serializeDocumentRecoveryMechanismsType(v.RecoveryMechanisms, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAccountTakeoverActionsType(v *types.AccountTakeoverActionsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HighAction != nil {
		ok := object.Key("HighAction")
		if err := awsAwsjson11_serializeDocumentAccountTakeoverActionType(v.HighAction, ok); err != nil {
			return err
		}
	}

	if v.LowAction != nil {
		ok := object.Key("LowAction")
		if err := awsAwsjson11_serializeDocumentAccountTakeoverActionType(v.LowAction, ok); err != nil {
			return err
		}
	}

	if v.MediumAction != nil {
		ok := object.Key("MediumAction")
		if err := awsAwsjson11_serializeDocumentAccountTakeoverActionType(v.MediumAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAccountTakeoverActionType(v *types.AccountTakeoverActionType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EventAction) > 0 {
		ok := object.Key("EventAction")
		ok.String(string(v.EventAction))
	}

	{
		ok := object.Key("Notify")
		ok.Boolean(v.Notify)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAccountTakeoverRiskConfigurationType(v *types.AccountTakeoverRiskConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentAccountTakeoverActionsType(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.NotifyConfiguration != nil {
		ok := object.Key("NotifyConfiguration")
		if err := awsAwsjson11_serializeDocumentNotifyConfigurationType(v.NotifyConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAdminCreateUserConfigType(v *types.AdminCreateUserConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowAdminCreateUserOnly {
		ok := object.Key("AllowAdminCreateUserOnly")
		ok.Boolean(v.AllowAdminCreateUserOnly)
	}

	if v.InviteMessageTemplate != nil {
		ok := object.Key("InviteMessageTemplate")
		if err := awsAwsjson11_serializeDocumentMessageTemplateType(v.InviteMessageTemplate, ok); err != nil {
			return err
		}
	}

	if v.UnusedAccountValidityDays != 0 {
		ok := object.Key("UnusedAccountValidityDays")
		ok.Integer(v.UnusedAccountValidityDays)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAliasAttributesListType(v []types.AliasAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentAnalyticsConfigurationType(v *types.AnalyticsConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationArn != nil {
		ok := object.Key("ApplicationArn")
		ok.String(*v.ApplicationArn)
	}

	if v.ApplicationId != nil {
		ok := object.Key("ApplicationId")
		ok.String(*v.ApplicationId)
	}

	if v.ExternalId != nil {
		ok := object.Key("ExternalId")
		ok.String(*v.ExternalId)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.UserDataShared {
		ok := object.Key("UserDataShared")
		ok.Boolean(v.UserDataShared)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAnalyticsMetadataType(v *types.AnalyticsMetadataType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsEndpointId != nil {
		ok := object.Key("AnalyticsEndpointId")
		ok.String(*v.AnalyticsEndpointId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAttributeListType(v []types.AttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAttributeType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttributeMappingType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttributeNameListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttributesRequireVerificationBeforeUpdateType(v []types.VerifiedAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttributeType(v *types.AttributeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAuthParametersType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentBlockedIPRangeListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCallbackURLsListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentChallengeResponsesType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentClientMetadataType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentClientPermissionListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchLogsConfigurationType(v *types.CloudWatchLogsConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogGroupArn != nil {
		ok := object.Key("LogGroupArn")
		ok.String(*v.LogGroupArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCompromisedCredentialsActionsType(v *types.CompromisedCredentialsActionsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EventAction) > 0 {
		ok := object.Key("EventAction")
		ok.String(string(v.EventAction))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCompromisedCredentialsRiskConfigurationType(v *types.CompromisedCredentialsRiskConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson11_serializeDocumentCompromisedCredentialsActionsType(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.EventFilter != nil {
		ok := object.Key("EventFilter")
		if err := awsAwsjson11_serializeDocumentEventFiltersType(v.EventFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentContextDataType(v *types.ContextDataType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncodedData != nil {
		ok := object.Key("EncodedData")
		ok.String(*v.EncodedData)
	}

	if v.HttpHeaders != nil {
		ok := object.Key("HttpHeaders")
		if err := awsAwsjson11_serializeDocumentHttpHeaderList(v.HttpHeaders, ok); err != nil {
			return err
		}
	}

	if v.IpAddress != nil {
		ok := object.Key("IpAddress")
		ok.String(*v.IpAddress)
	}

	if v.ServerName != nil {
		ok := object.Key("ServerName")
		ok.String(*v.ServerName)
	}

	if v.ServerPath != nil {
		ok := object.Key("ServerPath")
		ok.String(*v.ServerPath)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomAttributesListType(v []types.SchemaAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSchemaAttributeType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCustomDomainConfigType(v *types.CustomDomainConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("CertificateArn")
		ok.String(*v.CertificateArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomEmailLambdaVersionConfigType(v *types.CustomEmailLambdaVersionConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaArn != nil {
		ok := object.Key("LambdaArn")
		ok.String(*v.LambdaArn)
	}

	if len(v.LambdaVersion) > 0 {
		ok := object.Key("LambdaVersion")
		ok.String(string(v.LambdaVersion))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCustomSMSLambdaVersionConfigType(v *types.CustomSMSLambdaVersionConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaArn != nil {
		ok := object.Key("LambdaArn")
		ok.String(*v.LambdaArn)
	}

	if len(v.LambdaVersion) > 0 {
		ok := object.Key("LambdaVersion")
		ok.String(string(v.LambdaVersion))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeliveryMediumListType(v []types.DeliveryMediumType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeviceConfigurationType(v *types.DeviceConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChallengeRequiredOnNewDevice {
		ok := object.Key("ChallengeRequiredOnNewDevice")
		ok.Boolean(v.ChallengeRequiredOnNewDevice)
	}

	if v.DeviceOnlyRememberedOnUserPrompt {
		ok := object.Key("DeviceOnlyRememberedOnUserPrompt")
		ok.Boolean(v.DeviceOnlyRememberedOnUserPrompt)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeviceSecretVerifierConfigType(v *types.DeviceSecretVerifierConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordVerifier != nil {
		ok := object.Key("PasswordVerifier")
		ok.String(*v.PasswordVerifier)
	}

	if v.Salt != nil {
		ok := object.Key("Salt")
		ok.String(*v.Salt)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEmailConfigurationType(v *types.EmailConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationSet != nil {
		ok := object.Key("ConfigurationSet")
		ok.String(*v.ConfigurationSet)
	}

	if len(v.EmailSendingAccount) > 0 {
		ok := object.Key("EmailSendingAccount")
		ok.String(string(v.EmailSendingAccount))
	}

	if v.From != nil {
		ok := object.Key("From")
		ok.String(*v.From)
	}

	if v.ReplyToEmailAddress != nil {
		ok := object.Key("ReplyToEmailAddress")
		ok.String(*v.ReplyToEmailAddress)
	}

	if v.SourceArn != nil {
		ok := object.Key("SourceArn")
		ok.String(*v.SourceArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventFiltersType(v []types.EventFilterType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentExplicitAuthFlowsListType(v []types.ExplicitAuthFlowsType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentHttpHeader(v *types.HttpHeader, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeaderName != nil {
		ok := object.Key("headerName")
		ok.String(*v.HeaderName)
	}

	if v.HeaderValue != nil {
		ok := object.Key("headerValue")
		ok.String(*v.HeaderValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHttpHeaderList(v []types.HttpHeader, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentHttpHeader(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentIdpIdentifiersListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLambdaConfigType(v *types.LambdaConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreateAuthChallenge != nil {
		ok := object.Key("CreateAuthChallenge")
		ok.String(*v.CreateAuthChallenge)
	}

	if v.CustomEmailSender != nil {
		ok := object.Key("CustomEmailSender")
		if err := awsAwsjson11_serializeDocumentCustomEmailLambdaVersionConfigType(v.CustomEmailSender, ok); err != nil {
			return err
		}
	}

	if v.CustomMessage != nil {
		ok := object.Key("CustomMessage")
		ok.String(*v.CustomMessage)
	}

	if v.CustomSMSSender != nil {
		ok := object.Key("CustomSMSSender")
		if err := awsAwsjson11_serializeDocumentCustomSMSLambdaVersionConfigType(v.CustomSMSSender, ok); err != nil {
			return err
		}
	}

	if v.DefineAuthChallenge != nil {
		ok := object.Key("DefineAuthChallenge")
		ok.String(*v.DefineAuthChallenge)
	}

	if v.KMSKeyID != nil {
		ok := object.Key("KMSKeyID")
		ok.String(*v.KMSKeyID)
	}

	if v.PostAuthentication != nil {
		ok := object.Key("PostAuthentication")
		ok.String(*v.PostAuthentication)
	}

	if v.PostConfirmation != nil {
		ok := object.Key("PostConfirmation")
		ok.String(*v.PostConfirmation)
	}

	if v.PreAuthentication != nil {
		ok := object.Key("PreAuthentication")
		ok.String(*v.PreAuthentication)
	}

	if v.PreSignUp != nil {
		ok := object.Key("PreSignUp")
		ok.String(*v.PreSignUp)
	}

	if v.PreTokenGeneration != nil {
		ok := object.Key("PreTokenGeneration")
		ok.String(*v.PreTokenGeneration)
	}

	if v.PreTokenGenerationConfig != nil {
		ok := object.Key("PreTokenGenerationConfig")
		if err := awsAwsjson11_serializeDocumentPreTokenGenerationVersionConfigType(v.PreTokenGenerationConfig, ok); err != nil {
			return err
		}
	}

	if v.UserMigration != nil {
		ok := object.Key("UserMigration")
		ok.String(*v.UserMigration)
	}

	if v.VerifyAuthChallengeResponse != nil {
		ok := object.Key("VerifyAuthChallengeResponse")
		ok.String(*v.VerifyAuthChallengeResponse)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLogConfigurationListType(v []types.LogConfigurationType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentLogConfigurationType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLogConfigurationType(v *types.LogConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsConfiguration != nil {
		ok := object.Key("CloudWatchLogsConfiguration")
		if err := awsAwsjson11_serializeDocumentCloudWatchLogsConfigurationType(v.CloudWatchLogsConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.EventSource) > 0 {
		ok := object.Key("EventSource")
		ok.String(string(v.EventSource))
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("LogLevel")
		ok.String(string(v.LogLevel))
	}

	return nil
}

func awsAwsjson11_serializeDocumentLogoutURLsListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentMessageTemplateType(v *types.MessageTemplateType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmailMessage != nil {
		ok := object.Key("EmailMessage")
		ok.String(*v.EmailMessage)
	}

	if v.EmailSubject != nil {
		ok := object.Key("EmailSubject")
		ok.String(*v.EmailSubject)
	}

	if v.SMSMessage != nil {
		ok := object.Key("SMSMessage")
		ok.String(*v.SMSMessage)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMFAOptionListType(v []types.MFAOptionType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMFAOptionType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentMFAOptionType(v *types.MFAOptionType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if len(v.DeliveryMedium) > 0 {
		ok := object.Key("DeliveryMedium")
		ok.String(string(v.DeliveryMedium))
	}

	return nil
}

func awsAwsjson11_serializeDocumentNotifyConfigurationType(v *types.NotifyConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockEmail != nil {
		ok := object.Key("BlockEmail")
		if err := awsAwsjson11_serializeDocumentNotifyEmailType(v.BlockEmail, ok); err != nil {
			return err
		}
	}

	if v.From != nil {
		ok := object.Key("From")
		ok.String(*v.From)
	}

	if v.MfaEmail != nil {
		ok := object.Key("MfaEmail")
		if err := awsAwsjson11_serializeDocumentNotifyEmailType(v.MfaEmail, ok); err != nil {
			return err
		}
	}

	if v.NoActionEmail != nil {
		ok := object.Key("NoActionEmail")
		if err := awsAwsjson11_serializeDocumentNotifyEmailType(v.NoActionEmail, ok); err != nil {
			return err
		}
	}

	if v.ReplyTo != nil {
		ok := object.Key("ReplyTo")
		ok.String(*v.ReplyTo)
	}

	if v.SourceArn != nil {
		ok := object.Key("SourceArn")
		ok.String(*v.SourceArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNotifyEmailType(v *types.NotifyEmailType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HtmlBody != nil {
		ok := object.Key("HtmlBody")
		ok.String(*v.HtmlBody)
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		ok.String(*v.Subject)
	}

	if v.TextBody != nil {
		ok := object.Key("TextBody")
		ok.String(*v.TextBody)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNumberAttributeConstraintsType(v *types.NumberAttributeConstraintsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxValue != nil {
		ok := object.Key("MaxValue")
		ok.String(*v.MaxValue)
	}

	if v.MinValue != nil {
		ok := object.Key("MinValue")
		ok.String(*v.MinValue)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOAuthFlowsType(v []types.OAuthFlowType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentPasswordPolicyType(v *types.PasswordPolicyType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MinimumLength != nil {
		ok := object.Key("MinimumLength")
		ok.Integer(*v.MinimumLength)
	}

	if v.RequireLowercase {
		ok := object.Key("RequireLowercase")
		ok.Boolean(v.RequireLowercase)
	}

	if v.RequireNumbers {
		ok := object.Key("RequireNumbers")
		ok.Boolean(v.RequireNumbers)
	}

	if v.RequireSymbols {
		ok := object.Key("RequireSymbols")
		ok.Boolean(v.RequireSymbols)
	}

	if v.RequireUppercase {
		ok := object.Key("RequireUppercase")
		ok.Boolean(v.RequireUppercase)
	}

	if v.TemporaryPasswordValidityDays != 0 {
		ok := object.Key("TemporaryPasswordValidityDays")
		ok.Integer(v.TemporaryPasswordValidityDays)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPreTokenGenerationVersionConfigType(v *types.PreTokenGenerationVersionConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaArn != nil {
		ok := object.Key("LambdaArn")
		ok.String(*v.LambdaArn)
	}

	if len(v.LambdaVersion) > 0 {
		ok := object.Key("LambdaVersion")
		ok.String(string(v.LambdaVersion))
	}

	return nil
}

func awsAwsjson11_serializeDocumentProviderDetailsType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentProviderUserIdentifierType(v *types.ProviderUserIdentifierType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProviderAttributeName != nil {
		ok := object.Key("ProviderAttributeName")
		ok.String(*v.ProviderAttributeName)
	}

	if v.ProviderAttributeValue != nil {
		ok := object.Key("ProviderAttributeValue")
		ok.String(*v.ProviderAttributeValue)
	}

	if v.ProviderName != nil {
		ok := object.Key("ProviderName")
		ok.String(*v.ProviderName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRecoveryMechanismsType(v []types.RecoveryOptionType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRecoveryOptionType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRecoveryOptionType(v *types.RecoveryOptionType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.Integer(*v.Priority)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceServerScopeListType(v []types.ResourceServerScopeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentResourceServerScopeType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentResourceServerScopeType(v *types.ResourceServerScopeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ScopeDescription != nil {
		ok := object.Key("ScopeDescription")
		ok.String(*v.ScopeDescription)
	}

	if v.ScopeName != nil {
		ok := object.Key("ScopeName")
		ok.String(*v.ScopeName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRiskExceptionConfigurationType(v *types.RiskExceptionConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedIPRangeList != nil {
		ok := object.Key("BlockedIPRangeList")
		if err := awsAwsjson11_serializeDocumentBlockedIPRangeListType(v.BlockedIPRangeList, ok); err != nil {
			return err
		}
	}

	if v.SkippedIPRangeList != nil {
		ok := object.Key("SkippedIPRangeList")
		if err := awsAwsjson11_serializeDocumentSkippedIPRangeListType(v.SkippedIPRangeList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSchemaAttributesListType(v []types.SchemaAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSchemaAttributeType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSchemaAttributeType(v *types.SchemaAttributeType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttributeDataType) > 0 {
		ok := object.Key("AttributeDataType")
		ok.String(string(v.AttributeDataType))
	}

	if v.DeveloperOnlyAttribute != nil {
		ok := object.Key("DeveloperOnlyAttribute")
		ok.Boolean(*v.DeveloperOnlyAttribute)
	}

	if v.Mutable != nil {
		ok := object.Key("Mutable")
		ok.Boolean(*v.Mutable)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NumberAttributeConstraints != nil {
		ok := object.Key("NumberAttributeConstraints")
		if err := awsAwsjson11_serializeDocumentNumberAttributeConstraintsType(v.NumberAttributeConstraints, ok); err != nil {
			return err
		}
	}

	if v.Required != nil {
		ok := object.Key("Required")
		ok.Boolean(*v.Required)
	}

	if v.StringAttributeConstraints != nil {
		ok := object.Key("StringAttributeConstraints")
		if err := awsAwsjson11_serializeDocumentStringAttributeConstraintsType(v.StringAttributeConstraints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentScopeListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSearchedAttributeNamesListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSkippedIPRangeListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSmsConfigurationType(v *types.SmsConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExternalId != nil {
		ok := object.Key("ExternalId")
		ok.String(*v.ExternalId)
	}

	if v.SnsCallerArn != nil {
		ok := object.Key("SnsCallerArn")
		ok.String(*v.SnsCallerArn)
	}

	if v.SnsRegion != nil {
		ok := object.Key("SnsRegion")
		ok.String(*v.SnsRegion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSmsMfaConfigType(v *types.SmsMfaConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SmsAuthenticationMessage != nil {
		ok := object.Key("SmsAuthenticationMessage")
		ok.String(*v.SmsAuthenticationMessage)
	}

	if v.SmsConfiguration != nil {
		ok := object.Key("SmsConfiguration")
		if err := awsAwsjson11_serializeDocumentSmsConfigurationType(v.SmsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSMSMfaSettingsType(v *types.SMSMfaSettingsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PreferredMfa {
		ok := object.Key("PreferredMfa")
		ok.Boolean(v.PreferredMfa)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSoftwareTokenMfaConfigType(v *types.SoftwareTokenMfaConfigType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSoftwareTokenMfaSettingsType(v *types.SoftwareTokenMfaSettingsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.PreferredMfa {
		ok := object.Key("PreferredMfa")
		ok.Boolean(v.PreferredMfa)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStringAttributeConstraintsType(v *types.StringAttributeConstraintsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxLength != nil {
		ok := object.Key("MaxLength")
		ok.String(*v.MaxLength)
	}

	if v.MinLength != nil {
		ok := object.Key("MinLength")
		ok.String(*v.MinLength)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSupportedIdentityProvidersListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTokenValidityUnitsType(v *types.TokenValidityUnitsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccessToken) > 0 {
		ok := object.Key("AccessToken")
		ok.String(string(v.AccessToken))
	}

	if len(v.IdToken) > 0 {
		ok := object.Key("IdToken")
		ok.String(string(v.IdToken))
	}

	if len(v.RefreshToken) > 0 {
		ok := object.Key("RefreshToken")
		ok.String(string(v.RefreshToken))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserAttributeUpdateSettingsType(v *types.UserAttributeUpdateSettingsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributesRequireVerificationBeforeUpdate != nil {
		ok := object.Key("AttributesRequireVerificationBeforeUpdate")
		if err := awsAwsjson11_serializeDocumentAttributesRequireVerificationBeforeUpdateType(v.AttributesRequireVerificationBeforeUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserContextDataType(v *types.UserContextDataType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncodedData != nil {
		ok := object.Key("EncodedData")
		ok.String(*v.EncodedData)
	}

	if v.IpAddress != nil {
		ok := object.Key("IpAddress")
		ok.String(*v.IpAddress)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUsernameAttributesListType(v []types.UsernameAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentUsernameConfigurationType(v *types.UsernameConfigurationType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaseSensitive != nil {
		ok := object.Key("CaseSensitive")
		ok.Boolean(*v.CaseSensitive)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserPoolAddOnsType(v *types.UserPoolAddOnsType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdvancedSecurityMode) > 0 {
		ok := object.Key("AdvancedSecurityMode")
		ok.String(string(v.AdvancedSecurityMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserPoolPolicyType(v *types.UserPoolPolicyType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PasswordPolicy != nil {
		ok := object.Key("PasswordPolicy")
		if err := awsAwsjson11_serializeDocumentPasswordPolicyType(v.PasswordPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentUserPoolTagsListType(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentUserPoolTagsType(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentVerificationMessageTemplateType(v *types.VerificationMessageTemplateType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultEmailOption) > 0 {
		ok := object.Key("DefaultEmailOption")
		ok.String(string(v.DefaultEmailOption))
	}

	if v.EmailMessage != nil {
		ok := object.Key("EmailMessage")
		ok.String(*v.EmailMessage)
	}

	if v.EmailMessageByLink != nil {
		ok := object.Key("EmailMessageByLink")
		ok.String(*v.EmailMessageByLink)
	}

	if v.EmailSubject != nil {
		ok := object.Key("EmailSubject")
		ok.String(*v.EmailSubject)
	}

	if v.EmailSubjectByLink != nil {
		ok := object.Key("EmailSubjectByLink")
		ok.String(*v.EmailSubjectByLink)
	}

	if v.SmsMessage != nil {
		ok := object.Key("SmsMessage")
		ok.String(*v.SmsMessage)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVerifiedAttributesListType(v []types.VerifiedAttributeType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAddCustomAttributesInput(v *AddCustomAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomAttributes != nil {
		ok := object.Key("CustomAttributes")
		if err := awsAwsjson11_serializeDocumentCustomAttributesListType(v.CustomAttributes, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminAddUserToGroupInput(v *AdminAddUserToGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminConfirmSignUpInput(v *AdminConfirmSignUpInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminCreateUserInput(v *AdminCreateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.DesiredDeliveryMediums != nil {
		ok := object.Key("DesiredDeliveryMediums")
		if err := awsAwsjson11_serializeDocumentDeliveryMediumListType(v.DesiredDeliveryMediums, ok); err != nil {
			return err
		}
	}

	if v.ForceAliasCreation {
		ok := object.Key("ForceAliasCreation")
		ok.Boolean(v.ForceAliasCreation)
	}

	if len(v.MessageAction) > 0 {
		ok := object.Key("MessageAction")
		ok.String(string(v.MessageAction))
	}

	if v.TemporaryPassword != nil {
		ok := object.Key("TemporaryPassword")
		ok.String(*v.TemporaryPassword)
	}

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	if v.ValidationData != nil {
		ok := object.Key("ValidationData")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.ValidationData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminDeleteUserAttributesInput(v *AdminDeleteUserAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserAttributeNames != nil {
		ok := object.Key("UserAttributeNames")
		if err := awsAwsjson11_serializeDocumentAttributeNameListType(v.UserAttributeNames, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminDeleteUserInput(v *AdminDeleteUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminDisableProviderForUserInput(v *AdminDisableProviderForUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.User != nil {
		ok := object.Key("User")
		if err := awsAwsjson11_serializeDocumentProviderUserIdentifierType(v.User, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminDisableUserInput(v *AdminDisableUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminEnableUserInput(v *AdminEnableUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminForgetDeviceInput(v *AdminForgetDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminGetDeviceInput(v *AdminGetDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminGetUserInput(v *AdminGetUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminInitiateAuthInput(v *AdminInitiateAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.AuthFlow) > 0 {
		ok := object.Key("AuthFlow")
		ok.String(string(v.AuthFlow))
	}

	if v.AuthParameters != nil {
		ok := object.Key("AuthParameters")
		if err := awsAwsjson11_serializeDocumentAuthParametersType(v.AuthParameters, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.ContextData != nil {
		ok := object.Key("ContextData")
		if err := awsAwsjson11_serializeDocumentContextDataType(v.ContextData, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminLinkProviderForUserInput(v *AdminLinkProviderForUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationUser != nil {
		ok := object.Key("DestinationUser")
		if err := awsAwsjson11_serializeDocumentProviderUserIdentifierType(v.DestinationUser, ok); err != nil {
			return err
		}
	}

	if v.SourceUser != nil {
		ok := object.Key("SourceUser")
		if err := awsAwsjson11_serializeDocumentProviderUserIdentifierType(v.SourceUser, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminListDevicesInput(v *AdminListDevicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.PaginationToken != nil {
		ok := object.Key("PaginationToken")
		ok.String(*v.PaginationToken)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminListGroupsForUserInput(v *AdminListGroupsForUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminListUserAuthEventsInput(v *AdminListUserAuthEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminRemoveUserFromGroupInput(v *AdminRemoveUserFromGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminResetUserPasswordInput(v *AdminResetUserPasswordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminRespondToAuthChallengeInput(v *AdminRespondToAuthChallengeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.ChallengeName) > 0 {
		ok := object.Key("ChallengeName")
		ok.String(string(v.ChallengeName))
	}

	if v.ChallengeResponses != nil {
		ok := object.Key("ChallengeResponses")
		if err := awsAwsjson11_serializeDocumentChallengeResponsesType(v.ChallengeResponses, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.ContextData != nil {
		ok := object.Key("ContextData")
		if err := awsAwsjson11_serializeDocumentContextDataType(v.ContextData, ok); err != nil {
			return err
		}
	}

	if v.Session != nil {
		ok := object.Key("Session")
		ok.String(*v.Session)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminSetUserMFAPreferenceInput(v *AdminSetUserMFAPreferenceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SMSMfaSettings != nil {
		ok := object.Key("SMSMfaSettings")
		if err := awsAwsjson11_serializeDocumentSMSMfaSettingsType(v.SMSMfaSettings, ok); err != nil {
			return err
		}
	}

	if v.SoftwareTokenMfaSettings != nil {
		ok := object.Key("SoftwareTokenMfaSettings")
		if err := awsAwsjson11_serializeDocumentSoftwareTokenMfaSettingsType(v.SoftwareTokenMfaSettings, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminSetUserPasswordInput(v *AdminSetUserPasswordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Permanent {
		ok := object.Key("Permanent")
		ok.Boolean(v.Permanent)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminSetUserSettingsInput(v *AdminSetUserSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MFAOptions != nil {
		ok := object.Key("MFAOptions")
		if err := awsAwsjson11_serializeDocumentMFAOptionListType(v.MFAOptions, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminUpdateAuthEventFeedbackInput(v *AdminUpdateAuthEventFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventId != nil {
		ok := object.Key("EventId")
		ok.String(*v.EventId)
	}

	if len(v.FeedbackValue) > 0 {
		ok := object.Key("FeedbackValue")
		ok.String(string(v.FeedbackValue))
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminUpdateDeviceStatusInput(v *AdminUpdateDeviceStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	if len(v.DeviceRememberedStatus) > 0 {
		ok := object.Key("DeviceRememberedStatus")
		ok.String(string(v.DeviceRememberedStatus))
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminUpdateUserAttributesInput(v *AdminUpdateUserAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAdminUserGlobalSignOutInput(v *AdminUserGlobalSignOutInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAssociateSoftwareTokenInput(v *AssociateSoftwareTokenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.Session != nil {
		ok := object.Key("Session")
		ok.String(*v.Session)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentChangePasswordInput(v *ChangePasswordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.PreviousPassword != nil {
		ok := object.Key("PreviousPassword")
		ok.String(*v.PreviousPassword)
	}

	if v.ProposedPassword != nil {
		ok := object.Key("ProposedPassword")
		ok.String(*v.ProposedPassword)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentConfirmDeviceInput(v *ConfirmDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	if v.DeviceName != nil {
		ok := object.Key("DeviceName")
		ok.String(*v.DeviceName)
	}

	if v.DeviceSecretVerifierConfig != nil {
		ok := object.Key("DeviceSecretVerifierConfig")
		if err := awsAwsjson11_serializeDocumentDeviceSecretVerifierConfigType(v.DeviceSecretVerifierConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentConfirmForgotPasswordInput(v *ConfirmForgotPasswordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationCode != nil {
		ok := object.Key("ConfirmationCode")
		ok.String(*v.ConfirmationCode)
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.SecretHash != nil {
		ok := object.Key("SecretHash")
		ok.String(*v.SecretHash)
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentConfirmSignUpInput(v *ConfirmSignUpInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationCode != nil {
		ok := object.Key("ConfirmationCode")
		ok.String(*v.ConfirmationCode)
	}

	if v.ForceAliasCreation {
		ok := object.Key("ForceAliasCreation")
		ok.Boolean(v.ForceAliasCreation)
	}

	if v.SecretHash != nil {
		ok := object.Key("SecretHash")
		ok.String(*v.SecretHash)
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateGroupInput(v *CreateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.Precedence != nil {
		ok := object.Key("Precedence")
		ok.Integer(*v.Precedence)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateIdentityProviderInput(v *CreateIdentityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeMapping != nil {
		ok := object.Key("AttributeMapping")
		if err := awsAwsjson11_serializeDocumentAttributeMappingType(v.AttributeMapping, ok); err != nil {
			return err
		}
	}

	if v.IdpIdentifiers != nil {
		ok := object.Key("IdpIdentifiers")
		if err := awsAwsjson11_serializeDocumentIdpIdentifiersListType(v.IdpIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.ProviderDetails != nil {
		ok := object.Key("ProviderDetails")
		if err := awsAwsjson11_serializeDocumentProviderDetailsType(v.ProviderDetails, ok); err != nil {
			return err
		}
	}

	if v.ProviderName != nil {
		ok := object.Key("ProviderName")
		ok.String(*v.ProviderName)
	}

	if len(v.ProviderType) > 0 {
		ok := object.Key("ProviderType")
		ok.String(string(v.ProviderType))
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateResourceServerInput(v *CreateResourceServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Scopes != nil {
		ok := object.Key("Scopes")
		if err := awsAwsjson11_serializeDocumentResourceServerScopeListType(v.Scopes, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUserImportJobInput(v *CreateUserImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsRoleArn != nil {
		ok := object.Key("CloudWatchLogsRoleArn")
		ok.String(*v.CloudWatchLogsRoleArn)
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUserPoolClientInput(v *CreateUserPoolClientInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessTokenValidity != nil {
		ok := object.Key("AccessTokenValidity")
		ok.Integer(*v.AccessTokenValidity)
	}

	if v.AllowedOAuthFlows != nil {
		ok := object.Key("AllowedOAuthFlows")
		if err := awsAwsjson11_serializeDocumentOAuthFlowsType(v.AllowedOAuthFlows, ok); err != nil {
			return err
		}
	}

	if v.AllowedOAuthFlowsUserPoolClient {
		ok := object.Key("AllowedOAuthFlowsUserPoolClient")
		ok.Boolean(v.AllowedOAuthFlowsUserPoolClient)
	}

	if v.AllowedOAuthScopes != nil {
		ok := object.Key("AllowedOAuthScopes")
		if err := awsAwsjson11_serializeDocumentScopeListType(v.AllowedOAuthScopes, ok); err != nil {
			return err
		}
	}

	if v.AnalyticsConfiguration != nil {
		ok := object.Key("AnalyticsConfiguration")
		if err := awsAwsjson11_serializeDocumentAnalyticsConfigurationType(v.AnalyticsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AuthSessionValidity != nil {
		ok := object.Key("AuthSessionValidity")
		ok.Integer(*v.AuthSessionValidity)
	}

	if v.CallbackURLs != nil {
		ok := object.Key("CallbackURLs")
		if err := awsAwsjson11_serializeDocumentCallbackURLsListType(v.CallbackURLs, ok); err != nil {
			return err
		}
	}

	if v.ClientName != nil {
		ok := object.Key("ClientName")
		ok.String(*v.ClientName)
	}

	if v.DefaultRedirectURI != nil {
		ok := object.Key("DefaultRedirectURI")
		ok.String(*v.DefaultRedirectURI)
	}

	if v.EnablePropagateAdditionalUserContextData != nil {
		ok := object.Key("EnablePropagateAdditionalUserContextData")
		ok.Boolean(*v.EnablePropagateAdditionalUserContextData)
	}

	if v.EnableTokenRevocation != nil {
		ok := object.Key("EnableTokenRevocation")
		ok.Boolean(*v.EnableTokenRevocation)
	}

	if v.ExplicitAuthFlows != nil {
		ok := object.Key("ExplicitAuthFlows")
		if err := awsAwsjson11_serializeDocumentExplicitAuthFlowsListType(v.ExplicitAuthFlows, ok); err != nil {
			return err
		}
	}

	if v.GenerateSecret {
		ok := object.Key("GenerateSecret")
		ok.Boolean(v.GenerateSecret)
	}

	if v.IdTokenValidity != nil {
		ok := object.Key("IdTokenValidity")
		ok.Integer(*v.IdTokenValidity)
	}

	if v.LogoutURLs != nil {
		ok := object.Key("LogoutURLs")
		if err := awsAwsjson11_serializeDocumentLogoutURLsListType(v.LogoutURLs, ok); err != nil {
			return err
		}
	}

	if len(v.PreventUserExistenceErrors) > 0 {
		ok := object.Key("PreventUserExistenceErrors")
		ok.String(string(v.PreventUserExistenceErrors))
	}

	if v.ReadAttributes != nil {
		ok := object.Key("ReadAttributes")
		if err := awsAwsjson11_serializeDocumentClientPermissionListType(v.ReadAttributes, ok); err != nil {
			return err
		}
	}

	if v.RefreshTokenValidity != 0 {
		ok := object.Key("RefreshTokenValidity")
		ok.Integer(v.RefreshTokenValidity)
	}

	if v.SupportedIdentityProviders != nil {
		ok := object.Key("SupportedIdentityProviders")
		if err := awsAwsjson11_serializeDocumentSupportedIdentityProvidersListType(v.SupportedIdentityProviders, ok); err != nil {
			return err
		}
	}

	if v.TokenValidityUnits != nil {
		ok := object.Key("TokenValidityUnits")
		if err := awsAwsjson11_serializeDocumentTokenValidityUnitsType(v.TokenValidityUnits, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	if v.WriteAttributes != nil {
		ok := object.Key("WriteAttributes")
		if err := awsAwsjson11_serializeDocumentClientPermissionListType(v.WriteAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUserPoolDomainInput(v *CreateUserPoolDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomDomainConfig != nil {
		ok := object.Key("CustomDomainConfig")
		if err := awsAwsjson11_serializeDocumentCustomDomainConfigType(v.CustomDomainConfig, ok); err != nil {
			return err
		}
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateUserPoolInput(v *CreateUserPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountRecoverySetting != nil {
		ok := object.Key("AccountRecoverySetting")
		if err := awsAwsjson11_serializeDocumentAccountRecoverySettingType(v.AccountRecoverySetting, ok); err != nil {
			return err
		}
	}

	if v.AdminCreateUserConfig != nil {
		ok := object.Key("AdminCreateUserConfig")
		if err := awsAwsjson11_serializeDocumentAdminCreateUserConfigType(v.AdminCreateUserConfig, ok); err != nil {
			return err
		}
	}

	if v.AliasAttributes != nil {
		ok := object.Key("AliasAttributes")
		if err := awsAwsjson11_serializeDocumentAliasAttributesListType(v.AliasAttributes, ok); err != nil {
			return err
		}
	}

	if v.AutoVerifiedAttributes != nil {
		ok := object.Key("AutoVerifiedAttributes")
		if err := awsAwsjson11_serializeDocumentVerifiedAttributesListType(v.AutoVerifiedAttributes, ok); err != nil {
			return err
		}
	}

	if len(v.DeletionProtection) > 0 {
		ok := object.Key("DeletionProtection")
		ok.String(string(v.DeletionProtection))
	}

	if v.DeviceConfiguration != nil {
		ok := object.Key("DeviceConfiguration")
		if err := awsAwsjson11_serializeDocumentDeviceConfigurationType(v.DeviceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EmailConfiguration != nil {
		ok := object.Key("EmailConfiguration")
		if err := awsAwsjson11_serializeDocumentEmailConfigurationType(v.EmailConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EmailVerificationMessage != nil {
		ok := object.Key("EmailVerificationMessage")
		ok.String(*v.EmailVerificationMessage)
	}

	if v.EmailVerificationSubject != nil {
		ok := object.Key("EmailVerificationSubject")
		ok.String(*v.EmailVerificationSubject)
	}

	if v.LambdaConfig != nil {
		ok := object.Key("LambdaConfig")
		if err := awsAwsjson11_serializeDocumentLambdaConfigType(v.LambdaConfig, ok); err != nil {
			return err
		}
	}

	if len(v.MfaConfiguration) > 0 {
		ok := object.Key("MfaConfiguration")
		ok.String(string(v.MfaConfiguration))
	}

	if v.Policies != nil {
		ok := object.Key("Policies")
		if err := awsAwsjson11_serializeDocumentUserPoolPolicyType(v.Policies, ok); err != nil {
			return err
		}
	}

	if v.PoolName != nil {
		ok := object.Key("PoolName")
		ok.String(*v.PoolName)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		if err := awsAwsjson11_serializeDocumentSchemaAttributesListType(v.Schema, ok); err != nil {
			return err
		}
	}

	if v.SmsAuthenticationMessage != nil {
		ok := object.Key("SmsAuthenticationMessage")
		ok.String(*v.SmsAuthenticationMessage)
	}

	if v.SmsConfiguration != nil {
		ok := object.Key("SmsConfiguration")
		if err := awsAwsjson11_serializeDocumentSmsConfigurationType(v.SmsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmsVerificationMessage != nil {
		ok := object.Key("SmsVerificationMessage")
		ok.String(*v.SmsVerificationMessage)
	}

	if v.UserAttributeUpdateSettings != nil {
		ok := object.Key("UserAttributeUpdateSettings")
		if err := awsAwsjson11_serializeDocumentUserAttributeUpdateSettingsType(v.UserAttributeUpdateSettings, ok); err != nil {
			return err
		}
	}

	if v.UsernameAttributes != nil {
		ok := object.Key("UsernameAttributes")
		if err := awsAwsjson11_serializeDocumentUsernameAttributesListType(v.UsernameAttributes, ok); err != nil {
			return err
		}
	}

	if v.UsernameConfiguration != nil {
		ok := object.Key("UsernameConfiguration")
		if err := awsAwsjson11_serializeDocumentUsernameConfigurationType(v.UsernameConfiguration, ok); err != nil {
			return err
		}
	}

	if v.UserPoolAddOns != nil {
		ok := object.Key("UserPoolAddOns")
		if err := awsAwsjson11_serializeDocumentUserPoolAddOnsType(v.UserPoolAddOns, ok); err != nil {
			return err
		}
	}

	if v.UserPoolTags != nil {
		ok := object.Key("UserPoolTags")
		if err := awsAwsjson11_serializeDocumentUserPoolTagsType(v.UserPoolTags, ok); err != nil {
			return err
		}
	}

	if v.VerificationMessageTemplate != nil {
		ok := object.Key("VerificationMessageTemplate")
		if err := awsAwsjson11_serializeDocumentVerificationMessageTemplateType(v.VerificationMessageTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteGroupInput(v *DeleteGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteIdentityProviderInput(v *DeleteIdentityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProviderName != nil {
		ok := object.Key("ProviderName")
		ok.String(*v.ProviderName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteResourceServerInput(v *DeleteResourceServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserAttributesInput(v *DeleteUserAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.UserAttributeNames != nil {
		ok := object.Key("UserAttributeNames")
		if err := awsAwsjson11_serializeDocumentAttributeNameListType(v.UserAttributeNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserInput(v *DeleteUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserPoolClientInput(v *DeleteUserPoolClientInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserPoolDomainInput(v *DeleteUserPoolDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteUserPoolInput(v *DeleteUserPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeIdentityProviderInput(v *DescribeIdentityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProviderName != nil {
		ok := object.Key("ProviderName")
		ok.String(*v.ProviderName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeResourceServerInput(v *DescribeResourceServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeRiskConfigurationInput(v *DescribeRiskConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeUserImportJobInput(v *DescribeUserImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeUserPoolClientInput(v *DescribeUserPoolClientInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeUserPoolDomainInput(v *DescribeUserPoolDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeUserPoolInput(v *DescribeUserPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentForgetDeviceInput(v *ForgetDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentForgotPasswordInput(v *ForgotPasswordInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.SecretHash != nil {
		ok := object.Key("SecretHash")
		ok.String(*v.SecretHash)
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCSVHeaderInput(v *GetCSVHeaderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetDeviceInput(v *GetDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetGroupInput(v *GetGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetIdentityProviderByIdentifierInput(v *GetIdentityProviderByIdentifierInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdpIdentifier != nil {
		ok := object.Key("IdpIdentifier")
		ok.String(*v.IdpIdentifier)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetLogDeliveryConfigurationInput(v *GetLogDeliveryConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSigningCertificateInput(v *GetSigningCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUICustomizationInput(v *GetUICustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUserAttributeVerificationCodeInput(v *GetUserAttributeVerificationCodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUserInput(v *GetUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetUserPoolMfaConfigInput(v *GetUserPoolMfaConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGlobalSignOutInput(v *GlobalSignOutInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentInitiateAuthInput(v *InitiateAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.AuthFlow) > 0 {
		ok := object.Key("AuthFlow")
		ok.String(string(v.AuthFlow))
	}

	if v.AuthParameters != nil {
		ok := object.Key("AuthParameters")
		if err := awsAwsjson11_serializeDocumentAuthParametersType(v.AuthParameters, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDevicesInput(v *ListDevicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.PaginationToken != nil {
		ok := object.Key("PaginationToken")
		ok.String(*v.PaginationToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListGroupsInput(v *ListGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListIdentityProvidersInput(v *ListIdentityProvidersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListResourceServersInput(v *ListResourceServersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUserImportJobsInput(v *ListUserImportJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.PaginationToken != nil {
		ok := object.Key("PaginationToken")
		ok.String(*v.PaginationToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUserPoolClientsInput(v *ListUserPoolClientsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUserPoolsInput(v *ListUserPoolsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUsersInGroupInput(v *ListUsersInGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListUsersInput(v *ListUsersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributesToGet != nil {
		ok := object.Key("AttributesToGet")
		if err := awsAwsjson11_serializeDocumentSearchedAttributeNamesListType(v.AttributesToGet, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("Filter")
		ok.String(*v.Filter)
	}

	if v.Limit != nil {
		ok := object.Key("Limit")
		ok.Integer(*v.Limit)
	}

	if v.PaginationToken != nil {
		ok := object.Key("PaginationToken")
		ok.String(*v.PaginationToken)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentResendConfirmationCodeInput(v *ResendConfirmationCodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.SecretHash != nil {
		ok := object.Key("SecretHash")
		ok.String(*v.SecretHash)
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRespondToAuthChallengeInput(v *RespondToAuthChallengeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.ChallengeName) > 0 {
		ok := object.Key("ChallengeName")
		ok.String(string(v.ChallengeName))
	}

	if v.ChallengeResponses != nil {
		ok := object.Key("ChallengeResponses")
		if err := awsAwsjson11_serializeDocumentChallengeResponsesType(v.ChallengeResponses, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.Session != nil {
		ok := object.Key("Session")
		ok.String(*v.Session)
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRevokeTokenInput(v *RevokeTokenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("ClientSecret")
		ok.String(*v.ClientSecret)
	}

	if v.Token != nil {
		ok := object.Key("Token")
		ok.String(*v.Token)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetLogDeliveryConfigurationInput(v *SetLogDeliveryConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogConfigurations != nil {
		ok := object.Key("LogConfigurations")
		if err := awsAwsjson11_serializeDocumentLogConfigurationListType(v.LogConfigurations, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetRiskConfigurationInput(v *SetRiskConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountTakeoverRiskConfiguration != nil {
		ok := object.Key("AccountTakeoverRiskConfiguration")
		if err := awsAwsjson11_serializeDocumentAccountTakeoverRiskConfigurationType(v.AccountTakeoverRiskConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.CompromisedCredentialsRiskConfiguration != nil {
		ok := object.Key("CompromisedCredentialsRiskConfiguration")
		if err := awsAwsjson11_serializeDocumentCompromisedCredentialsRiskConfigurationType(v.CompromisedCredentialsRiskConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RiskExceptionConfiguration != nil {
		ok := object.Key("RiskExceptionConfiguration")
		if err := awsAwsjson11_serializeDocumentRiskExceptionConfigurationType(v.RiskExceptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetUICustomizationInput(v *SetUICustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.CSS != nil {
		ok := object.Key("CSS")
		ok.String(*v.CSS)
	}

	if v.ImageFile != nil {
		ok := object.Key("ImageFile")
		ok.Base64EncodeBytes(v.ImageFile)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetUserMFAPreferenceInput(v *SetUserMFAPreferenceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.SMSMfaSettings != nil {
		ok := object.Key("SMSMfaSettings")
		if err := awsAwsjson11_serializeDocumentSMSMfaSettingsType(v.SMSMfaSettings, ok); err != nil {
			return err
		}
	}

	if v.SoftwareTokenMfaSettings != nil {
		ok := object.Key("SoftwareTokenMfaSettings")
		if err := awsAwsjson11_serializeDocumentSoftwareTokenMfaSettingsType(v.SoftwareTokenMfaSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetUserPoolMfaConfigInput(v *SetUserPoolMfaConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MfaConfiguration) > 0 {
		ok := object.Key("MfaConfiguration")
		ok.String(string(v.MfaConfiguration))
	}

	if v.SmsMfaConfiguration != nil {
		ok := object.Key("SmsMfaConfiguration")
		if err := awsAwsjson11_serializeDocumentSmsMfaConfigType(v.SmsMfaConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SoftwareTokenMfaConfiguration != nil {
		ok := object.Key("SoftwareTokenMfaConfiguration")
		if err := awsAwsjson11_serializeDocumentSoftwareTokenMfaConfigType(v.SoftwareTokenMfaConfiguration, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetUserSettingsInput(v *SetUserSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.MFAOptions != nil {
		ok := object.Key("MFAOptions")
		if err := awsAwsjson11_serializeDocumentMFAOptionListType(v.MFAOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSignUpInput(v *SignUpInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyticsMetadata != nil {
		ok := object.Key("AnalyticsMetadata")
		if err := awsAwsjson11_serializeDocumentAnalyticsMetadataType(v.AnalyticsMetadata, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.SecretHash != nil {
		ok := object.Key("SecretHash")
		ok.String(*v.SecretHash)
	}

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	if v.UserContextData != nil {
		ok := object.Key("UserContextData")
		if err := awsAwsjson11_serializeDocumentUserContextDataType(v.UserContextData, ok); err != nil {
			return err
		}
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.ValidationData != nil {
		ok := object.Key("ValidationData")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.ValidationData, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartUserImportJobInput(v *StartUserImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopUserImportJobInput(v *StopUserImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentUserPoolTagsType(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentUserPoolTagsListType(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateAuthEventFeedbackInput(v *UpdateAuthEventFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventId != nil {
		ok := object.Key("EventId")
		ok.String(*v.EventId)
	}

	if v.FeedbackToken != nil {
		ok := object.Key("FeedbackToken")
		ok.String(*v.FeedbackToken)
	}

	if len(v.FeedbackValue) > 0 {
		ok := object.Key("FeedbackValue")
		ok.String(string(v.FeedbackValue))
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDeviceStatusInput(v *UpdateDeviceStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.DeviceKey != nil {
		ok := object.Key("DeviceKey")
		ok.String(*v.DeviceKey)
	}

	if len(v.DeviceRememberedStatus) > 0 {
		ok := object.Key("DeviceRememberedStatus")
		ok.String(string(v.DeviceRememberedStatus))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateGroupInput(v *UpdateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.Precedence != nil {
		ok := object.Key("Precedence")
		ok.Integer(*v.Precedence)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateIdentityProviderInput(v *UpdateIdentityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeMapping != nil {
		ok := object.Key("AttributeMapping")
		if err := awsAwsjson11_serializeDocumentAttributeMappingType(v.AttributeMapping, ok); err != nil {
			return err
		}
	}

	if v.IdpIdentifiers != nil {
		ok := object.Key("IdpIdentifiers")
		if err := awsAwsjson11_serializeDocumentIdpIdentifiersListType(v.IdpIdentifiers, ok); err != nil {
			return err
		}
	}

	if v.ProviderDetails != nil {
		ok := object.Key("ProviderDetails")
		if err := awsAwsjson11_serializeDocumentProviderDetailsType(v.ProviderDetails, ok); err != nil {
			return err
		}
	}

	if v.ProviderName != nil {
		ok := object.Key("ProviderName")
		ok.String(*v.ProviderName)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateResourceServerInput(v *UpdateResourceServerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Scopes != nil {
		ok := object.Key("Scopes")
		if err := awsAwsjson11_serializeDocumentResourceServerScopeListType(v.Scopes, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUserAttributesInput(v *UpdateUserAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.ClientMetadata != nil {
		ok := object.Key("ClientMetadata")
		if err := awsAwsjson11_serializeDocumentClientMetadataType(v.ClientMetadata, ok); err != nil {
			return err
		}
	}

	if v.UserAttributes != nil {
		ok := object.Key("UserAttributes")
		if err := awsAwsjson11_serializeDocumentAttributeListType(v.UserAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUserPoolClientInput(v *UpdateUserPoolClientInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessTokenValidity != nil {
		ok := object.Key("AccessTokenValidity")
		ok.Integer(*v.AccessTokenValidity)
	}

	if v.AllowedOAuthFlows != nil {
		ok := object.Key("AllowedOAuthFlows")
		if err := awsAwsjson11_serializeDocumentOAuthFlowsType(v.AllowedOAuthFlows, ok); err != nil {
			return err
		}
	}

	if v.AllowedOAuthFlowsUserPoolClient {
		ok := object.Key("AllowedOAuthFlowsUserPoolClient")
		ok.Boolean(v.AllowedOAuthFlowsUserPoolClient)
	}

	if v.AllowedOAuthScopes != nil {
		ok := object.Key("AllowedOAuthScopes")
		if err := awsAwsjson11_serializeDocumentScopeListType(v.AllowedOAuthScopes, ok); err != nil {
			return err
		}
	}

	if v.AnalyticsConfiguration != nil {
		ok := object.Key("AnalyticsConfiguration")
		if err := awsAwsjson11_serializeDocumentAnalyticsConfigurationType(v.AnalyticsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AuthSessionValidity != nil {
		ok := object.Key("AuthSessionValidity")
		ok.Integer(*v.AuthSessionValidity)
	}

	if v.CallbackURLs != nil {
		ok := object.Key("CallbackURLs")
		if err := awsAwsjson11_serializeDocumentCallbackURLsListType(v.CallbackURLs, ok); err != nil {
			return err
		}
	}

	if v.ClientId != nil {
		ok := object.Key("ClientId")
		ok.String(*v.ClientId)
	}

	if v.ClientName != nil {
		ok := object.Key("ClientName")
		ok.String(*v.ClientName)
	}

	if v.DefaultRedirectURI != nil {
		ok := object.Key("DefaultRedirectURI")
		ok.String(*v.DefaultRedirectURI)
	}

	if v.EnablePropagateAdditionalUserContextData != nil {
		ok := object.Key("EnablePropagateAdditionalUserContextData")
		ok.Boolean(*v.EnablePropagateAdditionalUserContextData)
	}

	if v.EnableTokenRevocation != nil {
		ok := object.Key("EnableTokenRevocation")
		ok.Boolean(*v.EnableTokenRevocation)
	}

	if v.ExplicitAuthFlows != nil {
		ok := object.Key("ExplicitAuthFlows")
		if err := awsAwsjson11_serializeDocumentExplicitAuthFlowsListType(v.ExplicitAuthFlows, ok); err != nil {
			return err
		}
	}

	if v.IdTokenValidity != nil {
		ok := object.Key("IdTokenValidity")
		ok.Integer(*v.IdTokenValidity)
	}

	if v.LogoutURLs != nil {
		ok := object.Key("LogoutURLs")
		if err := awsAwsjson11_serializeDocumentLogoutURLsListType(v.LogoutURLs, ok); err != nil {
			return err
		}
	}

	if len(v.PreventUserExistenceErrors) > 0 {
		ok := object.Key("PreventUserExistenceErrors")
		ok.String(string(v.PreventUserExistenceErrors))
	}

	if v.ReadAttributes != nil {
		ok := object.Key("ReadAttributes")
		if err := awsAwsjson11_serializeDocumentClientPermissionListType(v.ReadAttributes, ok); err != nil {
			return err
		}
	}

	if v.RefreshTokenValidity != 0 {
		ok := object.Key("RefreshTokenValidity")
		ok.Integer(v.RefreshTokenValidity)
	}

	if v.SupportedIdentityProviders != nil {
		ok := object.Key("SupportedIdentityProviders")
		if err := awsAwsjson11_serializeDocumentSupportedIdentityProvidersListType(v.SupportedIdentityProviders, ok); err != nil {
			return err
		}
	}

	if v.TokenValidityUnits != nil {
		ok := object.Key("TokenValidityUnits")
		if err := awsAwsjson11_serializeDocumentTokenValidityUnitsType(v.TokenValidityUnits, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	if v.WriteAttributes != nil {
		ok := object.Key("WriteAttributes")
		if err := awsAwsjson11_serializeDocumentClientPermissionListType(v.WriteAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUserPoolDomainInput(v *UpdateUserPoolDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomDomainConfig != nil {
		ok := object.Key("CustomDomainConfig")
		if err := awsAwsjson11_serializeDocumentCustomDomainConfigType(v.CustomDomainConfig, ok); err != nil {
			return err
		}
	}

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateUserPoolInput(v *UpdateUserPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountRecoverySetting != nil {
		ok := object.Key("AccountRecoverySetting")
		if err := awsAwsjson11_serializeDocumentAccountRecoverySettingType(v.AccountRecoverySetting, ok); err != nil {
			return err
		}
	}

	if v.AdminCreateUserConfig != nil {
		ok := object.Key("AdminCreateUserConfig")
		if err := awsAwsjson11_serializeDocumentAdminCreateUserConfigType(v.AdminCreateUserConfig, ok); err != nil {
			return err
		}
	}

	if v.AutoVerifiedAttributes != nil {
		ok := object.Key("AutoVerifiedAttributes")
		if err := awsAwsjson11_serializeDocumentVerifiedAttributesListType(v.AutoVerifiedAttributes, ok); err != nil {
			return err
		}
	}

	if len(v.DeletionProtection) > 0 {
		ok := object.Key("DeletionProtection")
		ok.String(string(v.DeletionProtection))
	}

	if v.DeviceConfiguration != nil {
		ok := object.Key("DeviceConfiguration")
		if err := awsAwsjson11_serializeDocumentDeviceConfigurationType(v.DeviceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EmailConfiguration != nil {
		ok := object.Key("EmailConfiguration")
		if err := awsAwsjson11_serializeDocumentEmailConfigurationType(v.EmailConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EmailVerificationMessage != nil {
		ok := object.Key("EmailVerificationMessage")
		ok.String(*v.EmailVerificationMessage)
	}

	if v.EmailVerificationSubject != nil {
		ok := object.Key("EmailVerificationSubject")
		ok.String(*v.EmailVerificationSubject)
	}

	if v.LambdaConfig != nil {
		ok := object.Key("LambdaConfig")
		if err := awsAwsjson11_serializeDocumentLambdaConfigType(v.LambdaConfig, ok); err != nil {
			return err
		}
	}

	if len(v.MfaConfiguration) > 0 {
		ok := object.Key("MfaConfiguration")
		ok.String(string(v.MfaConfiguration))
	}

	if v.Policies != nil {
		ok := object.Key("Policies")
		if err := awsAwsjson11_serializeDocumentUserPoolPolicyType(v.Policies, ok); err != nil {
			return err
		}
	}

	if v.SmsAuthenticationMessage != nil {
		ok := object.Key("SmsAuthenticationMessage")
		ok.String(*v.SmsAuthenticationMessage)
	}

	if v.SmsConfiguration != nil {
		ok := object.Key("SmsConfiguration")
		if err := awsAwsjson11_serializeDocumentSmsConfigurationType(v.SmsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SmsVerificationMessage != nil {
		ok := object.Key("SmsVerificationMessage")
		ok.String(*v.SmsVerificationMessage)
	}

	if v.UserAttributeUpdateSettings != nil {
		ok := object.Key("UserAttributeUpdateSettings")
		if err := awsAwsjson11_serializeDocumentUserAttributeUpdateSettingsType(v.UserAttributeUpdateSettings, ok); err != nil {
			return err
		}
	}

	if v.UserPoolAddOns != nil {
		ok := object.Key("UserPoolAddOns")
		if err := awsAwsjson11_serializeDocumentUserPoolAddOnsType(v.UserPoolAddOns, ok); err != nil {
			return err
		}
	}

	if v.UserPoolId != nil {
		ok := object.Key("UserPoolId")
		ok.String(*v.UserPoolId)
	}

	if v.UserPoolTags != nil {
		ok := object.Key("UserPoolTags")
		if err := awsAwsjson11_serializeDocumentUserPoolTagsType(v.UserPoolTags, ok); err != nil {
			return err
		}
	}

	if v.VerificationMessageTemplate != nil {
		ok := object.Key("VerificationMessageTemplate")
		if err := awsAwsjson11_serializeDocumentVerificationMessageTemplateType(v.VerificationMessageTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentVerifySoftwareTokenInput(v *VerifySoftwareTokenInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.FriendlyDeviceName != nil {
		ok := object.Key("FriendlyDeviceName")
		ok.String(*v.FriendlyDeviceName)
	}

	if v.Session != nil {
		ok := object.Key("Session")
		ok.String(*v.Session)
	}

	if v.UserCode != nil {
		ok := object.Key("UserCode")
		ok.String(*v.UserCode)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentVerifyUserAttributeInput(v *VerifyUserAttributeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessToken != nil {
		ok := object.Key("AccessToken")
		ok.String(*v.AccessToken)
	}

	if v.AttributeName != nil {
		ok := object.Key("AttributeName")
		ok.String(*v.AttributeName)
	}

	if v.Code != nil {
		ok := object.Key("Code")
		ok.String(*v.Code)
	}

	return nil
}
