# Custom structured data format definitions

Files in this folder describe structured data formats that are generated by
GNSS-SDR. They use [Protocol Buffers](https://developers.google.com/protocol-buffers/)'
[proto3](https://developers.google.com/protocol-buffers/docs/proto3) syntax.

From those files, the protocol buffer compiler creates classes that implement
automatic encoding and parsing of the protocol buffer data with an efficient
binary format. The generated classes provide getters and setters for the fields
that make up a protocol buffer and take care of the details of reading and
writing it as a unit. Importantly, the protocol buffer format supports the idea
of extending the format over time in such a way that the code can still read
data encoded with the old format.

Just grab these files if you are developing a client application for GNSS-SDR.
You are free to use C++, Java, Python, C#, Dart, Go or Ruby, among other
languages. A tutorial to create a simple application using Protocol Buffers and
a `.proto` file in C++ is available at
https://gnss-sdr.org/docs/tutorials/monitoring-software-receiver-internal-status/
