
import gobject
import gtk

import glitch, glitch.gtk
from glitch.limbo.lights import LightSwitch, AmbientLight
from glitch.limbo.material import Material
from glitch.limbo.objects import Cube

def tick():
    global theta
    theta = (theta + 5) % 360
    rotate.angle = theta
    view1.refresh()
    view2.refresh()
    return True

if __name__ == '__main__':
    theta = 0
    rotate = glitch.Rotate(y=1, children=[Cube()])
    scene = LightSwitch(children=[
        AmbientLight(2, 2, 2, children=[
            Material(1.0, 0.5, 0.5, children=[rotate])])])

    view1 = glitch.gtk.GtkCamera(eye=[0, 0, 2], children=[scene])
    view2 = glitch.gtk.GtkCamera(eye=[0, 2, 0.01], children=[scene])

    w1 = gtk.Window()
    w1.add(view1)
    w1.show_all()

    w2 = gtk.Window()
    w2.add(view2)
    w2.show_all()

    gobject.timeout_add(1000/30, tick)

    w1.connect('destroy', lambda w: gtk.main_quit())
    w2.connect('destroy', lambda w: gtk.main_quit())
    gtk.main()

