// Code generated by protoc-gen-go. DO NOT EDIT.
// source: operations.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type UserCommitFilesActionHeader_ActionType int32

const (
	UserCommitFilesActionHeader_CREATE     UserCommitFilesActionHeader_ActionType = 0
	UserCommitFilesActionHeader_CREATE_DIR UserCommitFilesActionHeader_ActionType = 1
	UserCommitFilesActionHeader_UPDATE     UserCommitFilesActionHeader_ActionType = 2
	UserCommitFilesActionHeader_MOVE       UserCommitFilesActionHeader_ActionType = 3
	UserCommitFilesActionHeader_DELETE     UserCommitFilesActionHeader_ActionType = 4
)

var UserCommitFilesActionHeader_ActionType_name = map[int32]string{
	0: "CREATE",
	1: "CREATE_DIR",
	2: "UPDATE",
	3: "MOVE",
	4: "DELETE",
}
var UserCommitFilesActionHeader_ActionType_value = map[string]int32{
	"CREATE":     0,
	"CREATE_DIR": 1,
	"UPDATE":     2,
	"MOVE":       3,
	"DELETE":     4,
}

func (x UserCommitFilesActionHeader_ActionType) String() string {
	return proto.EnumName(UserCommitFilesActionHeader_ActionType_name, int32(x))
}
func (UserCommitFilesActionHeader_ActionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor7, []int{17, 0}
}

type UserCreateBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	BranchName []byte      `protobuf:"bytes,2,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	StartPoint []byte      `protobuf:"bytes,4,opt,name=start_point,json=startPoint,proto3" json:"start_point,omitempty"`
}

func (m *UserCreateBranchRequest) Reset()                    { *m = UserCreateBranchRequest{} }
func (m *UserCreateBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCreateBranchRequest) ProtoMessage()               {}
func (*UserCreateBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *UserCreateBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCreateBranchRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCreateBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCreateBranchRequest) GetStartPoint() []byte {
	if m != nil {
		return m.StartPoint
	}
	return nil
}

type UserCreateBranchResponse struct {
	Branch *Branch `protobuf:"bytes,1,opt,name=branch" json:"branch,omitempty"`
	// Error returned by the pre-receive hook. If no error was thrown,
	// it's the empty string ("")
	PreReceiveError string `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCreateBranchResponse) Reset()                    { *m = UserCreateBranchResponse{} }
func (m *UserCreateBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCreateBranchResponse) ProtoMessage()               {}
func (*UserCreateBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

func (m *UserCreateBranchResponse) GetBranch() *Branch {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserCreateBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserDeleteBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	BranchName []byte      `protobuf:"bytes,2,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
}

func (m *UserDeleteBranchRequest) Reset()                    { *m = UserDeleteBranchRequest{} }
func (m *UserDeleteBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteBranchRequest) ProtoMessage()               {}
func (*UserDeleteBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{2} }

func (m *UserDeleteBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserDeleteBranchRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserDeleteBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type UserDeleteBranchResponse struct {
	PreReceiveError string `protobuf:"bytes,1,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserDeleteBranchResponse) Reset()                    { *m = UserDeleteBranchResponse{} }
func (m *UserDeleteBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteBranchResponse) ProtoMessage()               {}
func (*UserDeleteBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{3} }

func (m *UserDeleteBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserDeleteTagRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagName    []byte      `protobuf:"bytes,2,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`
	User       *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
}

func (m *UserDeleteTagRequest) Reset()                    { *m = UserDeleteTagRequest{} }
func (m *UserDeleteTagRequest) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteTagRequest) ProtoMessage()               {}
func (*UserDeleteTagRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{4} }

func (m *UserDeleteTagRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserDeleteTagRequest) GetTagName() []byte {
	if m != nil {
		return m.TagName
	}
	return nil
}

func (m *UserDeleteTagRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type UserDeleteTagResponse struct {
	PreReceiveError string `protobuf:"bytes,1,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserDeleteTagResponse) Reset()                    { *m = UserDeleteTagResponse{} }
func (m *UserDeleteTagResponse) String() string            { return proto.CompactTextString(m) }
func (*UserDeleteTagResponse) ProtoMessage()               {}
func (*UserDeleteTagResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{5} }

func (m *UserDeleteTagResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCreateTagRequest struct {
	Repository     *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	TagName        []byte      `protobuf:"bytes,2,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`
	User           *User       `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	TargetRevision []byte      `protobuf:"bytes,4,opt,name=target_revision,json=targetRevision,proto3" json:"target_revision,omitempty"`
	Message        []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *UserCreateTagRequest) Reset()                    { *m = UserCreateTagRequest{} }
func (m *UserCreateTagRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCreateTagRequest) ProtoMessage()               {}
func (*UserCreateTagRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{6} }

func (m *UserCreateTagRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCreateTagRequest) GetTagName() []byte {
	if m != nil {
		return m.TagName
	}
	return nil
}

func (m *UserCreateTagRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCreateTagRequest) GetTargetRevision() []byte {
	if m != nil {
		return m.TargetRevision
	}
	return nil
}

func (m *UserCreateTagRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

type UserCreateTagResponse struct {
	Tag             *Tag   `protobuf:"bytes,1,opt,name=tag" json:"tag,omitempty"`
	Exists          bool   `protobuf:"varint,2,opt,name=exists" json:"exists,omitempty"`
	PreReceiveError string `protobuf:"bytes,3,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCreateTagResponse) Reset()                    { *m = UserCreateTagResponse{} }
func (m *UserCreateTagResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCreateTagResponse) ProtoMessage()               {}
func (*UserCreateTagResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{7} }

func (m *UserCreateTagResponse) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *UserCreateTagResponse) GetExists() bool {
	if m != nil {
		return m.Exists
	}
	return false
}

func (m *UserCreateTagResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserMergeBranchRequest struct {
	// First message
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User       *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	CommitId   string      `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	Branch     []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	Message    []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// Second message
	// Tell the server to apply the merge to the branch
	Apply bool `protobuf:"varint,6,opt,name=apply" json:"apply,omitempty"`
}

func (m *UserMergeBranchRequest) Reset()                    { *m = UserMergeBranchRequest{} }
func (m *UserMergeBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserMergeBranchRequest) ProtoMessage()               {}
func (*UserMergeBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{8} }

func (m *UserMergeBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserMergeBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserMergeBranchRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserMergeBranchRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserMergeBranchRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserMergeBranchRequest) GetApply() bool {
	if m != nil {
		return m.Apply
	}
	return false
}

type UserMergeBranchResponse struct {
	// First message
	// The merge commit the branch will be updated to. The caller can still abort the merge.
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Second message
	// If set, the merge has been applied to the branch.
	BranchUpdate *OperationBranchUpdate `protobuf:"bytes,3,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
}

func (m *UserMergeBranchResponse) Reset()                    { *m = UserMergeBranchResponse{} }
func (m *UserMergeBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserMergeBranchResponse) ProtoMessage()               {}
func (*UserMergeBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{9} }

func (m *UserMergeBranchResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserMergeBranchResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

type OperationBranchUpdate struct {
	// If this string is non-empty the branch has been updated.
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// Used for cache invalidation in GitLab
	RepoCreated bool `protobuf:"varint,2,opt,name=repo_created,json=repoCreated" json:"repo_created,omitempty"`
	// Used for cache invalidation in GitLab
	BranchCreated bool `protobuf:"varint,3,opt,name=branch_created,json=branchCreated" json:"branch_created,omitempty"`
}

func (m *OperationBranchUpdate) Reset()                    { *m = OperationBranchUpdate{} }
func (m *OperationBranchUpdate) String() string            { return proto.CompactTextString(m) }
func (*OperationBranchUpdate) ProtoMessage()               {}
func (*OperationBranchUpdate) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{10} }

func (m *OperationBranchUpdate) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *OperationBranchUpdate) GetRepoCreated() bool {
	if m != nil {
		return m.RepoCreated
	}
	return false
}

func (m *OperationBranchUpdate) GetBranchCreated() bool {
	if m != nil {
		return m.BranchCreated
	}
	return false
}

type UserFFBranchRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User       *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	CommitId   string      `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	Branch     []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
}

func (m *UserFFBranchRequest) Reset()                    { *m = UserFFBranchRequest{} }
func (m *UserFFBranchRequest) String() string            { return proto.CompactTextString(m) }
func (*UserFFBranchRequest) ProtoMessage()               {}
func (*UserFFBranchRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{11} }

func (m *UserFFBranchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserFFBranchRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserFFBranchRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *UserFFBranchRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

type UserFFBranchResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserFFBranchResponse) Reset()                    { *m = UserFFBranchResponse{} }
func (m *UserFFBranchResponse) String() string            { return proto.CompactTextString(m) }
func (*UserFFBranchResponse) ProtoMessage()               {}
func (*UserFFBranchResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{12} }

func (m *UserFFBranchResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserFFBranchResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCherryPickRequest struct {
	Repository      *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User            *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Commit          *GitCommit  `protobuf:"bytes,3,opt,name=commit" json:"commit,omitempty"`
	BranchName      []byte      `protobuf:"bytes,4,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	Message         []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	StartBranchName []byte      `protobuf:"bytes,6,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository *Repository `protobuf:"bytes,7,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserCherryPickRequest) Reset()                    { *m = UserCherryPickRequest{} }
func (m *UserCherryPickRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCherryPickRequest) ProtoMessage()               {}
func (*UserCherryPickRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{13} }

func (m *UserCherryPickRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCherryPickRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCherryPickRequest) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *UserCherryPickRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCherryPickRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserCherryPickRequest) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserCherryPickRequest) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserCherryPickResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	CreateTreeError string                 `protobuf:"bytes,2,opt,name=create_tree_error,json=createTreeError" json:"create_tree_error,omitempty"`
	CommitError     string                 `protobuf:"bytes,3,opt,name=commit_error,json=commitError" json:"commit_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,4,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCherryPickResponse) Reset()                    { *m = UserCherryPickResponse{} }
func (m *UserCherryPickResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCherryPickResponse) ProtoMessage()               {}
func (*UserCherryPickResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{14} }

func (m *UserCherryPickResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserCherryPickResponse) GetCreateTreeError() string {
	if m != nil {
		return m.CreateTreeError
	}
	return ""
}

func (m *UserCherryPickResponse) GetCommitError() string {
	if m != nil {
		return m.CommitError
	}
	return ""
}

func (m *UserCherryPickResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserRevertRequest struct {
	Repository      *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User            *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Commit          *GitCommit  `protobuf:"bytes,3,opt,name=commit" json:"commit,omitempty"`
	BranchName      []byte      `protobuf:"bytes,4,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	Message         []byte      `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	StartBranchName []byte      `protobuf:"bytes,6,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository *Repository `protobuf:"bytes,7,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserRevertRequest) Reset()                    { *m = UserRevertRequest{} }
func (m *UserRevertRequest) String() string            { return proto.CompactTextString(m) }
func (*UserRevertRequest) ProtoMessage()               {}
func (*UserRevertRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{15} }

func (m *UserRevertRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserRevertRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserRevertRequest) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *UserRevertRequest) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserRevertRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *UserRevertRequest) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserRevertRequest) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserRevertResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	CreateTreeError string                 `protobuf:"bytes,2,opt,name=create_tree_error,json=createTreeError" json:"create_tree_error,omitempty"`
	CommitError     string                 `protobuf:"bytes,3,opt,name=commit_error,json=commitError" json:"commit_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,4,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserRevertResponse) Reset()                    { *m = UserRevertResponse{} }
func (m *UserRevertResponse) String() string            { return proto.CompactTextString(m) }
func (*UserRevertResponse) ProtoMessage()               {}
func (*UserRevertResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{16} }

func (m *UserRevertResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserRevertResponse) GetCreateTreeError() string {
	if m != nil {
		return m.CreateTreeError
	}
	return ""
}

func (m *UserRevertResponse) GetCommitError() string {
	if m != nil {
		return m.CommitError
	}
	return ""
}

func (m *UserRevertResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserCommitFilesActionHeader struct {
	Action        UserCommitFilesActionHeader_ActionType `protobuf:"varint,1,opt,name=action,enum=gitaly.UserCommitFilesActionHeader_ActionType" json:"action,omitempty"`
	FilePath      []byte                                 `protobuf:"bytes,2,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	PreviousPath  []byte                                 `protobuf:"bytes,3,opt,name=previous_path,json=previousPath,proto3" json:"previous_path,omitempty"`
	Base64Content bool                                   `protobuf:"varint,4,opt,name=base64_content,json=base64Content" json:"base64_content,omitempty"`
}

func (m *UserCommitFilesActionHeader) Reset()                    { *m = UserCommitFilesActionHeader{} }
func (m *UserCommitFilesActionHeader) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesActionHeader) ProtoMessage()               {}
func (*UserCommitFilesActionHeader) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{17} }

func (m *UserCommitFilesActionHeader) GetAction() UserCommitFilesActionHeader_ActionType {
	if m != nil {
		return m.Action
	}
	return UserCommitFilesActionHeader_CREATE
}

func (m *UserCommitFilesActionHeader) GetFilePath() []byte {
	if m != nil {
		return m.FilePath
	}
	return nil
}

func (m *UserCommitFilesActionHeader) GetPreviousPath() []byte {
	if m != nil {
		return m.PreviousPath
	}
	return nil
}

func (m *UserCommitFilesActionHeader) GetBase64Content() bool {
	if m != nil {
		return m.Base64Content
	}
	return false
}

type UserCommitFilesAction struct {
	// Types that are valid to be assigned to UserCommitFilesActionPayload:
	//	*UserCommitFilesAction_Header
	//	*UserCommitFilesAction_Content
	UserCommitFilesActionPayload isUserCommitFilesAction_UserCommitFilesActionPayload `protobuf_oneof:"user_commit_files_action_payload"`
}

func (m *UserCommitFilesAction) Reset()                    { *m = UserCommitFilesAction{} }
func (m *UserCommitFilesAction) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesAction) ProtoMessage()               {}
func (*UserCommitFilesAction) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{18} }

type isUserCommitFilesAction_UserCommitFilesActionPayload interface {
	isUserCommitFilesAction_UserCommitFilesActionPayload()
}

type UserCommitFilesAction_Header struct {
	Header *UserCommitFilesActionHeader `protobuf:"bytes,1,opt,name=header,oneof"`
}
type UserCommitFilesAction_Content struct {
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*UserCommitFilesAction_Header) isUserCommitFilesAction_UserCommitFilesActionPayload()  {}
func (*UserCommitFilesAction_Content) isUserCommitFilesAction_UserCommitFilesActionPayload() {}

func (m *UserCommitFilesAction) GetUserCommitFilesActionPayload() isUserCommitFilesAction_UserCommitFilesActionPayload {
	if m != nil {
		return m.UserCommitFilesActionPayload
	}
	return nil
}

func (m *UserCommitFilesAction) GetHeader() *UserCommitFilesActionHeader {
	if x, ok := m.GetUserCommitFilesActionPayload().(*UserCommitFilesAction_Header); ok {
		return x.Header
	}
	return nil
}

func (m *UserCommitFilesAction) GetContent() []byte {
	if x, ok := m.GetUserCommitFilesActionPayload().(*UserCommitFilesAction_Content); ok {
		return x.Content
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserCommitFilesAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserCommitFilesAction_OneofMarshaler, _UserCommitFilesAction_OneofUnmarshaler, _UserCommitFilesAction_OneofSizer, []interface{}{
		(*UserCommitFilesAction_Header)(nil),
		(*UserCommitFilesAction_Content)(nil),
	}
}

func _UserCommitFilesAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserCommitFilesAction)
	// user_commit_files_action_payload
	switch x := m.UserCommitFilesActionPayload.(type) {
	case *UserCommitFilesAction_Header:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *UserCommitFilesAction_Content:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Content)
	case nil:
	default:
		return fmt.Errorf("UserCommitFilesAction.UserCommitFilesActionPayload has unexpected type %T", x)
	}
	return nil
}

func _UserCommitFilesAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserCommitFilesAction)
	switch tag {
	case 1: // user_commit_files_action_payload.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesActionHeader)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesActionPayload = &UserCommitFilesAction_Header{msg}
		return true, err
	case 2: // user_commit_files_action_payload.content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.UserCommitFilesActionPayload = &UserCommitFilesAction_Content{x}
		return true, err
	default:
		return false, nil
	}
}

func _UserCommitFilesAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserCommitFilesAction)
	// user_commit_files_action_payload
	switch x := m.UserCommitFilesActionPayload.(type) {
	case *UserCommitFilesAction_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserCommitFilesAction_Content:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Content)))
		n += len(x.Content)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UserCommitFilesRequestHeader struct {
	Repository        *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User              *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	BranchName        []byte      `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3" json:"branch_name,omitempty"`
	CommitMessage     []byte      `protobuf:"bytes,4,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
	CommitAuthorName  []byte      `protobuf:"bytes,5,opt,name=commit_author_name,json=commitAuthorName,proto3" json:"commit_author_name,omitempty"`
	CommitAuthorEmail []byte      `protobuf:"bytes,6,opt,name=commit_author_email,json=commitAuthorEmail,proto3" json:"commit_author_email,omitempty"`
	StartBranchName   []byte      `protobuf:"bytes,7,opt,name=start_branch_name,json=startBranchName,proto3" json:"start_branch_name,omitempty"`
	StartRepository   *Repository `protobuf:"bytes,8,opt,name=start_repository,json=startRepository" json:"start_repository,omitempty"`
}

func (m *UserCommitFilesRequestHeader) Reset()                    { *m = UserCommitFilesRequestHeader{} }
func (m *UserCommitFilesRequestHeader) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesRequestHeader) ProtoMessage()               {}
func (*UserCommitFilesRequestHeader) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{19} }

func (m *UserCommitFilesRequestHeader) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetBranchName() []byte {
	if m != nil {
		return m.BranchName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitMessage() []byte {
	if m != nil {
		return m.CommitMessage
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitAuthorName() []byte {
	if m != nil {
		return m.CommitAuthorName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetCommitAuthorEmail() []byte {
	if m != nil {
		return m.CommitAuthorEmail
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetStartBranchName() []byte {
	if m != nil {
		return m.StartBranchName
	}
	return nil
}

func (m *UserCommitFilesRequestHeader) GetStartRepository() *Repository {
	if m != nil {
		return m.StartRepository
	}
	return nil
}

type UserCommitFilesRequest struct {
	// Types that are valid to be assigned to UserCommitFilesRequestPayload:
	//	*UserCommitFilesRequest_Header
	//	*UserCommitFilesRequest_Action
	UserCommitFilesRequestPayload isUserCommitFilesRequest_UserCommitFilesRequestPayload `protobuf_oneof:"user_commit_files_request_payload"`
}

func (m *UserCommitFilesRequest) Reset()                    { *m = UserCommitFilesRequest{} }
func (m *UserCommitFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesRequest) ProtoMessage()               {}
func (*UserCommitFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{20} }

type isUserCommitFilesRequest_UserCommitFilesRequestPayload interface {
	isUserCommitFilesRequest_UserCommitFilesRequestPayload()
}

type UserCommitFilesRequest_Header struct {
	Header *UserCommitFilesRequestHeader `protobuf:"bytes,1,opt,name=header,oneof"`
}
type UserCommitFilesRequest_Action struct {
	Action *UserCommitFilesAction `protobuf:"bytes,2,opt,name=action,oneof"`
}

func (*UserCommitFilesRequest_Header) isUserCommitFilesRequest_UserCommitFilesRequestPayload() {}
func (*UserCommitFilesRequest_Action) isUserCommitFilesRequest_UserCommitFilesRequestPayload() {}

func (m *UserCommitFilesRequest) GetUserCommitFilesRequestPayload() isUserCommitFilesRequest_UserCommitFilesRequestPayload {
	if m != nil {
		return m.UserCommitFilesRequestPayload
	}
	return nil
}

func (m *UserCommitFilesRequest) GetHeader() *UserCommitFilesRequestHeader {
	if x, ok := m.GetUserCommitFilesRequestPayload().(*UserCommitFilesRequest_Header); ok {
		return x.Header
	}
	return nil
}

func (m *UserCommitFilesRequest) GetAction() *UserCommitFilesAction {
	if x, ok := m.GetUserCommitFilesRequestPayload().(*UserCommitFilesRequest_Action); ok {
		return x.Action
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserCommitFilesRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserCommitFilesRequest_OneofMarshaler, _UserCommitFilesRequest_OneofUnmarshaler, _UserCommitFilesRequest_OneofSizer, []interface{}{
		(*UserCommitFilesRequest_Header)(nil),
		(*UserCommitFilesRequest_Action)(nil),
	}
}

func _UserCommitFilesRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserCommitFilesRequest)
	// user_commit_files_request_payload
	switch x := m.UserCommitFilesRequestPayload.(type) {
	case *UserCommitFilesRequest_Header:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *UserCommitFilesRequest_Action:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Action); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserCommitFilesRequest.UserCommitFilesRequestPayload has unexpected type %T", x)
	}
	return nil
}

func _UserCommitFilesRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserCommitFilesRequest)
	switch tag {
	case 1: // user_commit_files_request_payload.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesRequestHeader)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesRequestPayload = &UserCommitFilesRequest_Header{msg}
		return true, err
	case 2: // user_commit_files_request_payload.action
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserCommitFilesAction)
		err := b.DecodeMessage(msg)
		m.UserCommitFilesRequestPayload = &UserCommitFilesRequest_Action{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserCommitFilesRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserCommitFilesRequest)
	// user_commit_files_request_payload
	switch x := m.UserCommitFilesRequestPayload.(type) {
	case *UserCommitFilesRequest_Header:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserCommitFilesRequest_Action:
		s := proto.Size(x.Action)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type UserCommitFilesResponse struct {
	BranchUpdate    *OperationBranchUpdate `protobuf:"bytes,1,opt,name=branch_update,json=branchUpdate" json:"branch_update,omitempty"`
	IndexError      string                 `protobuf:"bytes,2,opt,name=index_error,json=indexError" json:"index_error,omitempty"`
	PreReceiveError string                 `protobuf:"bytes,3,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
}

func (m *UserCommitFilesResponse) Reset()                    { *m = UserCommitFilesResponse{} }
func (m *UserCommitFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*UserCommitFilesResponse) ProtoMessage()               {}
func (*UserCommitFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{21} }

func (m *UserCommitFilesResponse) GetBranchUpdate() *OperationBranchUpdate {
	if m != nil {
		return m.BranchUpdate
	}
	return nil
}

func (m *UserCommitFilesResponse) GetIndexError() string {
	if m != nil {
		return m.IndexError
	}
	return ""
}

func (m *UserCommitFilesResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

type UserRebaseRequest struct {
	Repository       *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	User             *User       `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	RebaseId         string      `protobuf:"bytes,3,opt,name=rebase_id,json=rebaseId" json:"rebase_id,omitempty"`
	Branch           []byte      `protobuf:"bytes,4,opt,name=branch,proto3" json:"branch,omitempty"`
	BranchSha        string      `protobuf:"bytes,5,opt,name=branch_sha,json=branchSha" json:"branch_sha,omitempty"`
	RemoteRepository *Repository `protobuf:"bytes,6,opt,name=remote_repository,json=remoteRepository" json:"remote_repository,omitempty"`
	RemoteBranch     []byte      `protobuf:"bytes,7,opt,name=remote_branch,json=remoteBranch,proto3" json:"remote_branch,omitempty"`
}

func (m *UserRebaseRequest) Reset()                    { *m = UserRebaseRequest{} }
func (m *UserRebaseRequest) String() string            { return proto.CompactTextString(m) }
func (*UserRebaseRequest) ProtoMessage()               {}
func (*UserRebaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{22} }

func (m *UserRebaseRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *UserRebaseRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *UserRebaseRequest) GetRebaseId() string {
	if m != nil {
		return m.RebaseId
	}
	return ""
}

func (m *UserRebaseRequest) GetBranch() []byte {
	if m != nil {
		return m.Branch
	}
	return nil
}

func (m *UserRebaseRequest) GetBranchSha() string {
	if m != nil {
		return m.BranchSha
	}
	return ""
}

func (m *UserRebaseRequest) GetRemoteRepository() *Repository {
	if m != nil {
		return m.RemoteRepository
	}
	return nil
}

func (m *UserRebaseRequest) GetRemoteBranch() []byte {
	if m != nil {
		return m.RemoteBranch
	}
	return nil
}

type UserRebaseResponse struct {
	RebaseSha       string `protobuf:"bytes,1,opt,name=rebase_sha,json=rebaseSha" json:"rebase_sha,omitempty"`
	PreReceiveError string `protobuf:"bytes,2,opt,name=pre_receive_error,json=preReceiveError" json:"pre_receive_error,omitempty"`
	GitError        string `protobuf:"bytes,3,opt,name=git_error,json=gitError" json:"git_error,omitempty"`
}

func (m *UserRebaseResponse) Reset()                    { *m = UserRebaseResponse{} }
func (m *UserRebaseResponse) String() string            { return proto.CompactTextString(m) }
func (*UserRebaseResponse) ProtoMessage()               {}
func (*UserRebaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{23} }

func (m *UserRebaseResponse) GetRebaseSha() string {
	if m != nil {
		return m.RebaseSha
	}
	return ""
}

func (m *UserRebaseResponse) GetPreReceiveError() string {
	if m != nil {
		return m.PreReceiveError
	}
	return ""
}

func (m *UserRebaseResponse) GetGitError() string {
	if m != nil {
		return m.GitError
	}
	return ""
}

func init() {
	proto.RegisterType((*UserCreateBranchRequest)(nil), "gitaly.UserCreateBranchRequest")
	proto.RegisterType((*UserCreateBranchResponse)(nil), "gitaly.UserCreateBranchResponse")
	proto.RegisterType((*UserDeleteBranchRequest)(nil), "gitaly.UserDeleteBranchRequest")
	proto.RegisterType((*UserDeleteBranchResponse)(nil), "gitaly.UserDeleteBranchResponse")
	proto.RegisterType((*UserDeleteTagRequest)(nil), "gitaly.UserDeleteTagRequest")
	proto.RegisterType((*UserDeleteTagResponse)(nil), "gitaly.UserDeleteTagResponse")
	proto.RegisterType((*UserCreateTagRequest)(nil), "gitaly.UserCreateTagRequest")
	proto.RegisterType((*UserCreateTagResponse)(nil), "gitaly.UserCreateTagResponse")
	proto.RegisterType((*UserMergeBranchRequest)(nil), "gitaly.UserMergeBranchRequest")
	proto.RegisterType((*UserMergeBranchResponse)(nil), "gitaly.UserMergeBranchResponse")
	proto.RegisterType((*OperationBranchUpdate)(nil), "gitaly.OperationBranchUpdate")
	proto.RegisterType((*UserFFBranchRequest)(nil), "gitaly.UserFFBranchRequest")
	proto.RegisterType((*UserFFBranchResponse)(nil), "gitaly.UserFFBranchResponse")
	proto.RegisterType((*UserCherryPickRequest)(nil), "gitaly.UserCherryPickRequest")
	proto.RegisterType((*UserCherryPickResponse)(nil), "gitaly.UserCherryPickResponse")
	proto.RegisterType((*UserRevertRequest)(nil), "gitaly.UserRevertRequest")
	proto.RegisterType((*UserRevertResponse)(nil), "gitaly.UserRevertResponse")
	proto.RegisterType((*UserCommitFilesActionHeader)(nil), "gitaly.UserCommitFilesActionHeader")
	proto.RegisterType((*UserCommitFilesAction)(nil), "gitaly.UserCommitFilesAction")
	proto.RegisterType((*UserCommitFilesRequestHeader)(nil), "gitaly.UserCommitFilesRequestHeader")
	proto.RegisterType((*UserCommitFilesRequest)(nil), "gitaly.UserCommitFilesRequest")
	proto.RegisterType((*UserCommitFilesResponse)(nil), "gitaly.UserCommitFilesResponse")
	proto.RegisterType((*UserRebaseRequest)(nil), "gitaly.UserRebaseRequest")
	proto.RegisterType((*UserRebaseResponse)(nil), "gitaly.UserRebaseResponse")
	proto.RegisterEnum("gitaly.UserCommitFilesActionHeader_ActionType", UserCommitFilesActionHeader_ActionType_name, UserCommitFilesActionHeader_ActionType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OperationService service

type OperationServiceClient interface {
	UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error)
	UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error)
	UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error)
	UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error)
	UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserMergeBranchClient, error)
	UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error)
	UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error)
	UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error)
	UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserCommitFilesClient, error)
	UserRebase(ctx context.Context, in *UserRebaseRequest, opts ...grpc.CallOption) (*UserRebaseResponse, error)
}

type operationServiceClient struct {
	cc *grpc.ClientConn
}

func NewOperationServiceClient(cc *grpc.ClientConn) OperationServiceClient {
	return &operationServiceClient{cc}
}

func (c *operationServiceClient) UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error) {
	out := new(UserCreateBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCreateBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error) {
	out := new(UserDeleteBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserDeleteBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error) {
	out := new(UserCreateTagResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCreateTag", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error) {
	out := new(UserDeleteTagResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserDeleteTag", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserMergeBranchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OperationService_serviceDesc.Streams[0], c.cc, "/gitaly.OperationService/UserMergeBranch", opts...)
	if err != nil {
		return nil, err
	}
	x := &operationServiceUserMergeBranchClient{stream}
	return x, nil
}

type OperationService_UserMergeBranchClient interface {
	Send(*UserMergeBranchRequest) error
	Recv() (*UserMergeBranchResponse, error)
	grpc.ClientStream
}

type operationServiceUserMergeBranchClient struct {
	grpc.ClientStream
}

func (x *operationServiceUserMergeBranchClient) Send(m *UserMergeBranchRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *operationServiceUserMergeBranchClient) Recv() (*UserMergeBranchResponse, error) {
	m := new(UserMergeBranchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *operationServiceClient) UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error) {
	out := new(UserFFBranchResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserFFBranch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error) {
	out := new(UserCherryPickResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserCherryPick", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error) {
	out := new(UserRevertResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserRevert", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (OperationService_UserCommitFilesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OperationService_serviceDesc.Streams[1], c.cc, "/gitaly.OperationService/UserCommitFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &operationServiceUserCommitFilesClient{stream}
	return x, nil
}

type OperationService_UserCommitFilesClient interface {
	Send(*UserCommitFilesRequest) error
	CloseAndRecv() (*UserCommitFilesResponse, error)
	grpc.ClientStream
}

type operationServiceUserCommitFilesClient struct {
	grpc.ClientStream
}

func (x *operationServiceUserCommitFilesClient) Send(m *UserCommitFilesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *operationServiceUserCommitFilesClient) CloseAndRecv() (*UserCommitFilesResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(UserCommitFilesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *operationServiceClient) UserRebase(ctx context.Context, in *UserRebaseRequest, opts ...grpc.CallOption) (*UserRebaseResponse, error) {
	out := new(UserRebaseResponse)
	err := grpc.Invoke(ctx, "/gitaly.OperationService/UserRebase", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OperationService service

type OperationServiceServer interface {
	UserCreateBranch(context.Context, *UserCreateBranchRequest) (*UserCreateBranchResponse, error)
	UserDeleteBranch(context.Context, *UserDeleteBranchRequest) (*UserDeleteBranchResponse, error)
	UserCreateTag(context.Context, *UserCreateTagRequest) (*UserCreateTagResponse, error)
	UserDeleteTag(context.Context, *UserDeleteTagRequest) (*UserDeleteTagResponse, error)
	UserMergeBranch(OperationService_UserMergeBranchServer) error
	UserFFBranch(context.Context, *UserFFBranchRequest) (*UserFFBranchResponse, error)
	UserCherryPick(context.Context, *UserCherryPickRequest) (*UserCherryPickResponse, error)
	UserRevert(context.Context, *UserRevertRequest) (*UserRevertResponse, error)
	UserCommitFiles(OperationService_UserCommitFilesServer) error
	UserRebase(context.Context, *UserRebaseRequest) (*UserRebaseResponse, error)
}

func RegisterOperationServiceServer(s *grpc.Server, srv OperationServiceServer) {
	s.RegisterService(&_OperationService_serviceDesc, srv)
}

func _OperationService_UserCreateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCreateBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, req.(*UserCreateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserDeleteBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, req.(*UserDeleteBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateTag(ctx, req.(*UserCreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserDeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, req.(*UserDeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserMergeBranch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserMergeBranch(&operationServiceUserMergeBranchServer{stream})
}

type OperationService_UserMergeBranchServer interface {
	Send(*UserMergeBranchResponse) error
	Recv() (*UserMergeBranchRequest, error)
	grpc.ServerStream
}

type operationServiceUserMergeBranchServer struct {
	grpc.ServerStream
}

func (x *operationServiceUserMergeBranchServer) Send(m *UserMergeBranchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *operationServiceUserMergeBranchServer) Recv() (*UserMergeBranchRequest, error) {
	m := new(UserMergeBranchRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _OperationService_UserFFBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserFFBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserFFBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserFFBranch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserFFBranch(ctx, req.(*UserFFBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCherryPick_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCherryPickRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCherryPick(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserCherryPick",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCherryPick(ctx, req.(*UserCherryPickRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserRevert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRevertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRevert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserRevert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRevert(ctx, req.(*UserRevertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCommitFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserCommitFiles(&operationServiceUserCommitFilesServer{stream})
}

type OperationService_UserCommitFilesServer interface {
	SendAndClose(*UserCommitFilesResponse) error
	Recv() (*UserCommitFilesRequest, error)
	grpc.ServerStream
}

type operationServiceUserCommitFilesServer struct {
	grpc.ServerStream
}

func (x *operationServiceUserCommitFilesServer) SendAndClose(m *UserCommitFilesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *operationServiceUserCommitFilesServer) Recv() (*UserCommitFilesRequest, error) {
	m := new(UserCommitFilesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _OperationService_UserRebase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRebaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRebase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.OperationService/UserRebase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRebase(ctx, req.(*UserRebaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OperationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.OperationService",
	HandlerType: (*OperationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UserCreateBranch",
			Handler:    _OperationService_UserCreateBranch_Handler,
		},
		{
			MethodName: "UserDeleteBranch",
			Handler:    _OperationService_UserDeleteBranch_Handler,
		},
		{
			MethodName: "UserCreateTag",
			Handler:    _OperationService_UserCreateTag_Handler,
		},
		{
			MethodName: "UserDeleteTag",
			Handler:    _OperationService_UserDeleteTag_Handler,
		},
		{
			MethodName: "UserFFBranch",
			Handler:    _OperationService_UserFFBranch_Handler,
		},
		{
			MethodName: "UserCherryPick",
			Handler:    _OperationService_UserCherryPick_Handler,
		},
		{
			MethodName: "UserRevert",
			Handler:    _OperationService_UserRevert_Handler,
		},
		{
			MethodName: "UserRebase",
			Handler:    _OperationService_UserRebase_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UserMergeBranch",
			Handler:       _OperationService_UserMergeBranch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UserCommitFiles",
			Handler:       _OperationService_UserCommitFiles_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "operations.proto",
}

func init() { proto.RegisterFile("operations.proto", fileDescriptor7) }

var fileDescriptor7 = []byte{
	// 1357 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x58, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0xf7, 0xda, 0xee, 0xc6, 0x79, 0x76, 0x1c, 0x7b, 0xfa, 0x81, 0xeb, 0x36, 0x4d, 0xba, 0xa5,
	0x50, 0x2a, 0x64, 0xa1, 0x80, 0xe0, 0x54, 0x50, 0x3e, 0x1c, 0xd2, 0x42, 0xda, 0xb0, 0x4d, 0x0a,
	0xb7, 0xd5, 0xc4, 0x1e, 0xec, 0x15, 0xb6, 0x77, 0x99, 0x9d, 0x44, 0x35, 0x42, 0x88, 0x0b, 0x70,
	0xe5, 0xc4, 0x81, 0x13, 0x12, 0x37, 0x6e, 0x5c, 0x38, 0x70, 0xe0, 0xc4, 0x89, 0x6b, 0x0f, 0xfc,
	0x3b, 0x68, 0x66, 0xde, 0xda, 0xbb, 0xeb, 0xdd, 0x28, 0x81, 0x44, 0x54, 0x88, 0xdb, 0xee, 0x7b,
	0x6f, 0xde, 0xbc, 0xf7, 0x7b, 0x1f, 0xf3, 0x66, 0xa0, 0xe6, 0xf9, 0x8c, 0x53, 0xe1, 0x7a, 0xa3,
	0xa0, 0xe5, 0x73, 0x4f, 0x78, 0xc4, 0xec, 0xb9, 0x82, 0x0e, 0xc6, 0xcd, 0x4a, 0xd0, 0xa7, 0x9c,
	0x75, 0x35, 0xd5, 0xfa, 0xd9, 0x80, 0x17, 0xf6, 0x03, 0xc6, 0x37, 0x38, 0xa3, 0x82, 0xad, 0x73,
	0x3a, 0xea, 0xf4, 0x6d, 0xf6, 0xe9, 0x21, 0x0b, 0x04, 0x59, 0x05, 0xe0, 0xcc, 0xf7, 0x02, 0x57,
	0x78, 0x7c, 0xdc, 0x30, 0x56, 0x8c, 0x3b, 0xe5, 0x55, 0xd2, 0xd2, 0x6a, 0x5a, 0xf6, 0x84, 0x63,
	0x47, 0xa4, 0xc8, 0x32, 0x94, 0x0f, 0x94, 0x12, 0x67, 0x44, 0x87, 0xac, 0x91, 0x5f, 0x31, 0xee,
	0x54, 0x6c, 0xd0, 0xa4, 0x87, 0x74, 0xc8, 0xc8, 0x0a, 0x14, 0x0f, 0x03, 0xc6, 0x1b, 0x05, 0xa5,
	0xae, 0x12, 0xaa, 0x93, 0x36, 0xd8, 0x8a, 0x23, 0x55, 0x04, 0x82, 0x72, 0xe1, 0xf8, 0x9e, 0x3b,
	0x12, 0x8d, 0xa2, 0x56, 0xa1, 0x48, 0xbb, 0x92, 0x62, 0x8d, 0xa0, 0x31, 0x6b, 0x72, 0xe0, 0x7b,
	0xa3, 0x80, 0x91, 0x97, 0xc0, 0xd4, 0x9b, 0xa1, 0xbd, 0xd5, 0x70, 0x03, 0x94, 0x43, 0x2e, 0xb9,
	0x0b, 0x75, 0x9f, 0x33, 0x87, 0xb3, 0x0e, 0x73, 0x8f, 0x98, 0xc3, 0x38, 0xf7, 0xb8, 0xb2, 0x76,
	0xde, 0x5e, 0xf4, 0x39, 0xb3, 0x35, 0xbd, 0x2d, 0xc9, 0xd6, 0xb7, 0x88, 0xd1, 0x26, 0x1b, 0xb0,
	0xe7, 0x03, 0x23, 0x6b, 0x4b, 0x43, 0x10, 0xb7, 0x08, 0x21, 0x48, 0x75, 0xcd, 0x48, 0x77, 0xed,
	0x1b, 0x03, 0x2e, 0x4d, 0x15, 0xed, 0xd1, 0xde, 0x3f, 0xf1, 0xeb, 0x2a, 0x94, 0x04, 0xed, 0x45,
	0x9d, 0x9a, 0x13, 0xb4, 0x77, 0x42, 0x8f, 0x36, 0xe0, 0x72, 0xc2, 0x90, 0xbf, 0xe1, 0xce, 0x1f,
	0xe8, 0x8e, 0x4e, 0x8d, 0x7f, 0xd1, 0x1d, 0xf2, 0x32, 0x2c, 0x0a, 0xca, 0x7b, 0x4c, 0x38, 0x9c,
	0x1d, 0xb9, 0x81, 0xeb, 0x8d, 0x30, 0x91, 0xab, 0x9a, 0x6c, 0x23, 0x95, 0x34, 0x60, 0x6e, 0xc8,
	0x82, 0x80, 0xf6, 0x58, 0xe3, 0x82, 0xde, 0x04, 0x7f, 0xad, 0xcf, 0x34, 0x22, 0x11, 0x5f, 0x10,
	0x91, 0x25, 0x28, 0x08, 0xda, 0x43, 0x2f, 0xca, 0xe1, 0xe6, 0x52, 0x42, 0xd2, 0xc9, 0x15, 0x30,
	0xd9, 0x53, 0x37, 0x10, 0x81, 0xb2, 0xba, 0x64, 0xe3, 0x5f, 0x3a, 0x90, 0x85, 0x74, 0x20, 0x9f,
	0x19, 0x70, 0x45, 0x6e, 0xbe, 0xc3, 0x78, 0xef, 0x0c, 0x32, 0x3e, 0xc4, 0x2b, 0x9f, 0x89, 0xd7,
	0x35, 0x98, 0xef, 0x78, 0xc3, 0xa1, 0x2b, 0x1c, 0xb7, 0x8b, 0x46, 0x95, 0x34, 0xe1, 0x7e, 0x57,
	0x7a, 0x84, 0x45, 0xad, 0x31, 0x0c, 0x8b, 0x38, 0x13, 0x3b, 0x72, 0x09, 0x2e, 0x50, 0xdf, 0x1f,
	0x8c, 0x1b, 0xa6, 0x82, 0x40, 0xff, 0x58, 0x5f, 0x62, 0x21, 0xc7, 0xbc, 0x42, 0x50, 0x63, 0x06,
	0x18, 0x09, 0x03, 0xd6, 0x61, 0x01, 0x2b, 0xf6, 0xd0, 0xef, 0x52, 0xc1, 0x30, 0xf0, 0x4b, 0xa1,
	0x23, 0x8f, 0xc2, 0x66, 0xab, 0x95, 0xee, 0x2b, 0x21, 0xbb, 0x72, 0x10, 0xf9, 0x7b, 0x50, 0x2c,
	0xe5, 0x6b, 0x05, 0xeb, 0x0b, 0xb8, 0x9c, 0x2a, 0x7c, 0xfc, 0xfe, 0x37, 0xa1, 0x22, 0xd1, 0x74,
	0x3a, 0x2a, 0x17, 0xba, 0x18, 0xd8, 0xb2, 0xa4, 0xe9, 0xf4, 0xe8, 0x92, 0xdb, 0x50, 0x45, 0x13,
	0x43, 0xa1, 0x82, 0x12, 0x42, 0xc3, 0x51, 0xcc, 0xfa, 0xc1, 0x80, 0x8b, 0x12, 0x82, 0xad, 0xad,
	0xe7, 0x35, 0xaa, 0xd6, 0xd7, 0x58, 0xc4, 0x53, 0x13, 0x31, 0x44, 0x33, 0x51, 0x30, 0x4e, 0x1d,
	0x85, 0x53, 0xf5, 0xfd, 0xdf, 0xf2, 0x58, 0x81, 0x7d, 0xc6, 0xf9, 0x78, 0xd7, 0xed, 0x7c, 0x72,
	0xbe, 0x68, 0xbd, 0x02, 0xa6, 0x06, 0x07, 0xd3, 0xab, 0x1e, 0xca, 0xbc, 0xeb, 0x8a, 0x0d, 0xc5,
	0xb0, 0x51, 0x20, 0x79, 0x84, 0x14, 0x67, 0x8e, 0x90, 0xec, 0xd2, 0xb8, 0x0b, 0x75, 0x7d, 0xbc,
	0x46, 0x15, 0x98, 0x4a, 0x66, 0x51, 0x31, 0xd6, 0xa7, 0x5a, 0xee, 0x41, 0x4d, 0xcb, 0x46, 0xbc,
	0x9d, 0xcb, 0xf4, 0x56, 0x2f, 0x9f, 0x12, 0xac, 0x3f, 0xb1, 0x8b, 0x44, 0x01, 0x3c, 0xdb, 0x58,
	0xea, 0x5c, 0x77, 0x04, 0x67, 0x89, 0x58, 0x6a, 0xc6, 0x1e, 0x67, 0x3a, 0x96, 0xb2, 0x82, 0x30,
	0x13, 0xa3, 0x7d, 0xaf, 0xac, 0x69, 0x5a, 0x24, 0x35, 0x35, 0x8a, 0xe9, 0xa9, 0xf1, 0x6b, 0x1e,
	0xea, 0x2a, 0x72, 0xec, 0x88, 0x49, 0x97, 0xff, 0x4f, 0x8b, 0x53, 0xa4, 0xc5, 0x33, 0x03, 0x48,
	0x14, 0xbc, 0xff, 0x46, 0x4a, 0x7c, 0x9f, 0x87, 0x6b, 0x2a, 0xd9, 0xd5, 0xfa, 0x2d, 0x77, 0xc0,
	0x82, 0xb5, 0x8e, 0x34, 0x77, 0x9b, 0xd1, 0x2e, 0xe3, 0x64, 0x0b, 0x4c, 0xaa, 0xfe, 0x95, 0x5f,
	0xd5, 0xd5, 0x56, 0x34, 0xd4, 0x19, 0x8b, 0x5a, 0xfa, 0x67, 0x6f, 0xec, 0x33, 0x1b, 0x57, 0xcb,
	0x9e, 0xfa, 0xb1, 0x3b, 0x60, 0x8e, 0x4f, 0x45, 0x1f, 0xe7, 0x92, 0x92, 0x24, 0xec, 0x52, 0xd1,
	0x27, 0xb7, 0x60, 0xc1, 0x97, 0x03, 0x87, 0x77, 0x18, 0x68, 0x81, 0x82, 0x12, 0xa8, 0x84, 0x44,
	0x25, 0x24, 0x8f, 0x0a, 0x1a, 0xb0, 0x37, 0xdf, 0x70, 0x3a, 0xde, 0x48, 0x30, 0x9c, 0xb1, 0xe5,
	0x51, 0xa1, 0xa8, 0x1b, 0x9a, 0x68, 0x3d, 0x00, 0x98, 0x6e, 0x4f, 0x00, 0xcc, 0x0d, 0xbb, 0xbd,
	0xb6, 0xd7, 0xae, 0xe5, 0x48, 0x15, 0x40, 0x7f, 0x3b, 0x9b, 0xf7, 0xed, 0x9a, 0x21, 0x79, 0xfb,
	0xbb, 0x9b, 0x92, 0x97, 0x27, 0x25, 0x28, 0xee, 0x3c, 0x7a, 0xd2, 0xae, 0x15, 0x24, 0x75, 0xb3,
	0xfd, 0x7e, 0x7b, 0xaf, 0x5d, 0x2b, 0x5a, 0xdf, 0x19, 0xd8, 0x4a, 0x93, 0x7e, 0x92, 0x7b, 0x60,
	0xf6, 0x95, 0xaf, 0x18, 0xee, 0x5b, 0x27, 0x80, 0x65, 0x3b, 0x67, 0xe3, 0x22, 0xd2, 0x84, 0xb9,
	0xd0, 0x09, 0x85, 0xc5, 0x76, 0xce, 0x0e, 0x09, 0xeb, 0x16, 0xac, 0xc8, 0x02, 0x72, 0x30, 0xca,
	0x12, 0xa4, 0xc0, 0xd1, 0x28, 0x3a, 0x3e, 0x1d, 0x0f, 0x3c, 0xda, 0xb5, 0xbe, 0x2a, 0xc0, 0xf5,
	0xc4, 0x4e, 0x58, 0xcd, 0x18, 0xb6, 0xf3, 0xa9, 0xe9, 0x44, 0xa1, 0x16, 0x66, 0x0a, 0xf5, 0x36,
	0x54, 0xd1, 0xec, 0xb0, 0x5e, 0x75, 0x31, 0x2f, 0x68, 0xea, 0x0e, 0x56, 0xed, 0xab, 0x40, 0x50,
	0x8c, 0x1e, 0x8a, 0xbe, 0xc7, 0xb5, 0x3a, 0x5d, 0xda, 0x35, 0xcd, 0x59, 0x53, 0x0c, 0xa5, 0xb4,
	0x05, 0x17, 0xe3, 0xd2, 0x6c, 0x48, 0xdd, 0x01, 0x56, 0x79, 0x3d, 0x2a, 0xde, 0x96, 0x8c, 0xf4,
	0x9e, 0x30, 0x77, 0xf2, 0x9e, 0x50, 0x3a, 0x79, 0x4f, 0xf8, 0x25, 0x3c, 0x2a, 0x66, 0xe2, 0x40,
	0xde, 0x4e, 0x64, 0xc8, 0x8b, 0x19, 0x19, 0x12, 0x8b, 0x5b, 0x24, 0x45, 0xde, 0x9a, 0x14, 0x5e,
	0x3e, 0xde, 0x50, 0xd2, 0x33, 0x2c, 0x17, 0x56, 0xda, 0xfa, 0x2d, 0xb8, 0x39, 0x9b, 0x3f, 0x5c,
	0xef, 0x32, 0x49, 0xa0, 0x9f, 0xc2, 0x0b, 0x74, 0xd4, 0x90, 0x33, 0xec, 0x68, 0xcb, 0x50, 0x76,
	0x47, 0x5d, 0xf6, 0x34, 0xd6, 0xcb, 0x40, 0x91, 0x8e, 0xe9, 0x51, 0x19, 0x63, 0xfd, 0x8f, 0x93,
	0x63, 0x4b, 0x96, 0xfa, 0xb9, 0xcf, 0x7e, 0x5c, 0x6d, 0x13, 0x99, 0xfd, 0x34, 0xe1, 0x98, 0x89,
	0x7e, 0x09, 0xb0, 0x08, 0x9c, 0xa0, 0x4f, 0x55, 0x1e, 0xcf, 0xdb, 0xf3, 0x9a, 0xf2, 0xb8, 0x4f,
	0xc9, 0x3b, 0x50, 0xe7, 0x6c, 0xe8, 0x09, 0x16, 0xcd, 0x32, 0x33, 0xd3, 0xe0, 0x9a, 0x16, 0x9e,
	0x52, 0x64, 0x7f, 0x44, 0x05, 0xb8, 0xbd, 0xce, 0xe6, 0x8a, 0x26, 0xea, 0x30, 0x58, 0x9f, 0x87,
	0xc7, 0x93, 0x06, 0x69, 0x72, 0xeb, 0x02, 0xf4, 0x47, 0x9a, 0xa6, 0x27, 0x74, 0xf4, 0x50, 0x9a,
	0x76, 0x8a, 0xc1, 0x52, 0x42, 0xd3, 0x4b, 0x1c, 0x3b, 0xa5, 0x1e, 0x9e, 0x39, 0xab, 0xbf, 0x9b,
	0x50, 0x9b, 0x24, 0xc6, 0x63, 0xc6, 0x8f, 0xdc, 0x0e, 0x23, 0x1f, 0x42, 0x2d, 0xf9, 0xe4, 0x41,
	0x96, 0x63, 0x79, 0x3c, 0xfb, 0x7e, 0xd3, 0x5c, 0xc9, 0x16, 0xd0, 0x3e, 0x59, 0xb9, 0x50, 0x71,
	0xf4, 0x21, 0x21, 0xae, 0x38, 0xe5, 0xd1, 0x23, 0xae, 0x38, 0xed, 0x0d, 0xc2, 0xca, 0x91, 0x87,
	0xb0, 0x10, 0xbb, 0xbd, 0x92, 0xeb, 0xb3, 0xd6, 0x4c, 0x2f, 0xe8, 0xcd, 0xa5, 0x0c, 0x6e, 0x52,
	0xdf, 0xe4, 0x7d, 0x20, 0xae, 0x2f, 0xf9, 0x7e, 0x11, 0xd7, 0x37, 0xf3, 0xa8, 0x60, 0xe5, 0xc8,
	0x47, 0xb0, 0x98, 0xb8, 0x0a, 0x92, 0x1b, 0xd1, 0x35, 0xb3, 0x37, 0xdf, 0xe6, 0x72, 0x26, 0x3f,
	0xd4, 0x7a, 0xc7, 0x78, 0xcd, 0x20, 0xef, 0x41, 0x25, 0x7a, 0x7d, 0x21, 0xd7, 0xa2, 0xcb, 0x12,
	0xf7, 0xae, 0xe6, 0xf5, 0x74, 0xe6, 0xc4, 0xcc, 0x0f, 0xa0, 0x1a, 0x9f, 0xa0, 0x49, 0x1c, 0xa9,
	0xe4, 0xd5, 0xa4, 0x79, 0x23, 0x8b, 0x3d, 0x51, 0xd9, 0x06, 0x98, 0x4e, 0x5f, 0xe4, 0x6a, 0xac,
	0x74, 0xa3, 0xe3, 0x6c, 0xb3, 0x99, 0xc6, 0x9a, 0xa8, 0x79, 0xa2, 0x01, 0x8c, 0xf4, 0xbd, 0x38,
	0x80, 0xb3, 0x9d, 0x39, 0x0e, 0x60, 0x4a, 0xc3, 0x94, 0x00, 0x4e, 0xcd, 0x93, 0x95, 0x95, 0x34,
	0x2f, 0xd2, 0xb6, 0x92, 0xe6, 0x45, 0x8b, 0xd5, 0xca, 0x1d, 0x98, 0xea, 0x7d, 0xf3, 0xf5, 0xbf,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x39, 0x0c, 0xa6, 0xa6, 0x09, 0x15, 0x00, 0x00,
}
