/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::SphereDrag

Description
    Drag model based on assumption of solid spheres

\*---------------------------------------------------------------------------*/

#ifndef SphereDrag_H
#define SphereDrag_H

#include <lagrangianIntermediate/DragModel.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
/*---------------------------------------------------------------------------*\
                           Class SphereDrag Declaration
\*---------------------------------------------------------------------------*/

template<class CloudType>
class SphereDrag
:
    public DragModel<CloudType>
{
public:

    //- Runtime type information
    TypeName("SphereDrag");


    // Constructors

        //- Construct from dictionary
        SphereDrag
        (
            const dictionary& dict,
            CloudType& owner
        );


    //- Destructor
    virtual ~SphereDrag();


    // Member Functions

        //- Flag to indicate whether model activates drag model
        bool active() const;

        //- Return drag coefficient
        scalar Cd(const scalar Re) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
#   include <lagrangianIntermediate/SphereDrag.C>
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
