# Flare

Flare (Free Libre Action Roleplaying Engine) is a simple game engine built to handle a very specific kind of game: single-player 2D action RPGs. Flare is not a reimplementation of an existing game or engine. It is a tribute to and exploration of the action RPG genre.

Rather than building a very abstract, robust game engine, the goal of this project is to build several real games and harvest an engine from the common, reusable code.
This is the first game made with the flare-engine featuring a fantasy dungeon crawl game. Currently this game is actively developed.

Flare uses simple file formats (INI style config files) for most of the game data, allowing anyone to easily modify game contents. Open formats are preferred (png, ogg). The game code is C++.



## Copyright and License

Most of Flare is Copyright © 2010-2013 Clint Bellanger. Contributors retain copyrights to their original contributions.

All of Flare's source code is released under the GNU GPL version 3. Later versions are permitted.

All of Flare's art and data files are released under CC-BY-SA 3.0. Later versions are permitted.

The Liberation Sans fonts version 2 are released under the SIL Open Font License, Version 1.1.

The GNU Unifont font is released under GPL v2, with the exception that embedding the font in a document does not in itself bind that document to the terms of the GPL.


## Links

* Homepage  http://flarerpg.org
* Source    https://github.com/clintbellanger/flare-engine
* Forums    http://opengameart.org/forums/flare
* Email     clintbellanger@gmail.com


## Installation

Please see INSTALL.engine for further steps.

## Running Flare

If the program is installing system-wide (i.e., you typed 'make install' and it worked), you can run it just by executing the 'flare' command.

If you did not perform the installation step, you should find the binary in in the top directory, and run it from there, like this:

    ./flare

Also, in newer versions, the game can be launched from an icon in your main menu in your GUI environment (KDE, GNOME, etc.).

If you're running flare from your operating system's gui file browser (e.g. Windows Explorer or OSX Finder), you'll want to use one of the provided launchers.  This helps the flare executable use its own working directory, so it can see all those data folders.



## Settings

Settings are stored in one of these places:

    $XDG_CONFIG_HOME/flare
    $HOME/.config/flare
    ./config

Here you can enable fullscreen, change the game resolution, enable mouse-move, and change keybindings. The settings files are created the first time you run Flare.



## Save Files

Save files are stored in one of these places:

    $XDG_DATA_HOME/flare
    $HOME/.local/share/flare
    ./saves

If permissions are correct, the game is automatically saved when you exit.
