/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.ArrowSlider;
import visad.util.BaseRGBMap;
import visad.util.ColorMapWidget;
import visad.util.ColorPreview;

public class LabeledColorWidget
extends JPanel
implements ActionListener {
    ColorMapWidget wrappedWidget;
    private float[][] original;
    private float[][] grey = null;

    public LabeledColorWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(smap, null, true);
    }

    public LabeledColorWidget(ScalarMap smap, float min, float max) throws VisADException, RemoteException {
        this(smap, null, true);
    }

    public LabeledColorWidget(ScalarMap smap, float[][] table) throws VisADException, RemoteException {
        this(smap, table, true);
    }

    public LabeledColorWidget(ScalarMap smap, float min, float max, float[][] table) throws VisADException, RemoteException {
        this(smap, table, true);
    }

    public LabeledColorWidget(ScalarMap smap, float[][] in_table, boolean update) throws VisADException, RemoteException {
        this(new ColorMapWidget(smap, in_table, update));
    }

    public LabeledColorWidget(ColorMapWidget w) {
        this.wrappedWidget = w;
        this.original = ColorMapWidget.copy_table(this.wrappedWidget.control.getTable());
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", this.wrappedWidget);
        JPanel buttons = this.buildButtons();
        if (buttons != null) {
            this.add("South", buttons);
        }
    }

    private JPanel buildButtons() {
        JButton reset = new JButton("Reset");
        reset.setActionCommand("reset");
        reset.addActionListener(this);
        JButton grey = new JButton("Grey Scale");
        grey.setActionCommand("grey");
        grey.addActionListener(this);
        boolean newPanel = false;
        JPanel panel = this.wrappedWidget.getButtonPanel();
        if (panel == null) {
            panel = new JPanel();
            panel.setLayout(new FlowLayout(1, 5, 5));
            newPanel = true;
        }
        panel.add((Component)reset, 0);
        panel.add((Component)grey, 1);
        return newPanel ? panel : null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("reset")) {
            try {
                this.wrappedWidget.setTable(this.original);
            }
            catch (RemoteException re) {
            }
            catch (VisADException ve) {}
        } else if (evt.getActionCommand().equals("grey")) {
            if (this.grey == null && this.original != null && this.original[0] != null) {
                int num = this.original.length;
                int len = this.original[0].length;
                this.grey = new float[num][len];
                float a = 1.0f / ((float)len - 1.0f);
                for (int j = 0; j < len; ++j) {
                    float f = (float)j * a;
                    this.grey[2][j] = f;
                    this.grey[1][j] = f;
                    this.grey[0][j] = f;
                    if (num <= 3) continue;
                    this.grey[3][j] = 1.0f;
                }
            }
            if (this.grey != null) {
                try {
                    this.wrappedWidget.setTable(this.grey);
                }
                catch (RemoteException re) {
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
        }
    }

    public Dimension getMaximumSize() {
        return this.wrappedWidget.getMaximumSize();
    }

    public void setMaximumSize(Dimension size) {
        this.wrappedWidget.setMaximumSize(size);
    }

    public Dimension getMinimumSize() {
        return this.wrappedWidget.getMinimumSize();
    }

    public void setMinimumSize(Dimension size) {
        this.wrappedWidget.setMinimumSize(size);
    }

    public Dimension getPreferredSize() {
        return this.wrappedWidget.getPreferredSize();
    }

    public void setPreferredSize(Dimension size) {
        this.wrappedWidget.setPreferredSize(size);
    }

    public BaseRGBMap getBaseMap() {
        return this.wrappedWidget.baseMap;
    }

    public ColorPreview getPreview() {
        return this.wrappedWidget.preview;
    }

    public ArrowSlider getSlider() {
        return this.wrappedWidget.slider;
    }

    public void setTable(float[][] table) {
        this.wrappedWidget.setTableView(table);
    }

    public float[][] getTable() {
        return this.wrappedWidget.getTableView();
    }

    public static void main(String[] args) {
        try {
            RealType vis = RealType.getRealType("vis");
            ScalarMap visMap = new ScalarMap(vis, Display.RGBA);
            visMap.setRange(0.0, 1.0);
            RealType ir = RealType.getRealType("ir");
            ScalarMap irMap = new ScalarMap(vis, Display.RGB);
            irMap.setRange(0.0, 1.0);
            DisplayImplJ2D dpy = new DisplayImplJ2D("2d");
            dpy.addMap(visMap);
            dpy.addMap(irMap);
            JFrame f = new JFrame("0");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new LabeledColorWidget(visMap));
            f.pack();
            f.setVisible(true);
            f = new JFrame("1");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new LabeledColorWidget(visMap, null));
            f.pack();
            f.setVisible(true);
            f = new JFrame("!Updated");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new LabeledColorWidget(visMap, null, false));
            f.pack();
            f.setVisible(true);
            f = new JFrame("!Immediate");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            ColorMapWidget cmw = new ColorMapWidget(visMap, (float[][])null, false, false);
            f.getContentPane().add(new LabeledColorWidget(cmw));
            f.pack();
            f.setVisible(true);
            int num = 3;
            int len = 256;
            float[][] table = new float[3][256];
            float step = 0.003921569f;
            float total = 1.0f;
            for (int j = 0; j < 256; ++j) {
                float f2 = total;
                table[2][j] = f2;
                table[1][j] = f2;
                table[0][j] = f2;
                total -= 0.003921569f;
            }
            f = new JFrame("Table");
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new ColorMapWidget(irMap, table));
            f.pack();
            f.setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            visMap.setRange(-10.0, 10.0);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
    }
}

