/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Gridded2DSet;
import visad.VisADException;

public class Stream2D {
    static float LENGTH = 0.015f;

    static void stream_trace(float[] ugrid, float[] vgrid, int nr, int nc, float dir, float[][] vr2, float[][] vc2, int[] numv, byte[] markarrow, byte[] markstart, byte[] markend, int nrarrow, int ncarrow, int nrstart, int ncstart, int nrend, int ncend, float row, float col, float stepFactor, float rowlength, float collength, int irend, int icend, Gridded2DSet spatial_set, float[][] spatial_values, int[] offgrid, float cell_fraction) throws VisADException {
        int num = numv[0];
        int nend = 0;
        float[] vr = vr2[0];
        float[] vc = vc2[0];
        float[] vec_row = new float[2];
        float[] vec_col = new float[2];
        while (true) {
            int ira;
            int ica;
            int ir = (int)row;
            int ic = (int)col;
            float a = row - (float)ir;
            float c = col - (float)ic;
            float ac = a * c;
            float ad = a * (1.0f - c);
            float bc = (1.0f - a) * c;
            float bd = (1.0f - a) * (1.0f - c);
            float ubd = ugrid[ir * nc + ic];
            float ubc = ugrid[ir * nc + ic + 1];
            float uad = ugrid[(ir + 1) * nc + ic];
            float uac = ugrid[(ir + 1) * nc + (ic + 1)];
            float vbd = vgrid[ir * nc + ic];
            float vbc = vgrid[ir * nc + (ic + 1)];
            float vad = vgrid[(ir + 1) * nc + ic];
            float vac = vgrid[(ir + 1) * nc + (ic + 1)];
            if (ubd != ubd || ubc != ubc || uad != uad || uac != uac || vbd != vbd || vbc != vbc || vad != vad || vac != vac) break;
            float u = bd * ubd + bc * ubc + ad * uad + ac * uac;
            float v = bd * vbd + bc * vbc + ad * vad + ac * vac;
            float prevrow = row;
            float prevcol = col;
            float[][] loc = new float[2][1];
            loc[1][0] = row;
            loc[0][0] = col;
            float mag = (float)Math.sqrt(u * u + v * v);
            int[] lens = spatial_set.getLengths();
            int lenX = lens[0];
            int ii = (int)row * lenX + (int)col;
            float del_x = spatial_values[0][ii + 1] - spatial_values[0][ii];
            float del_y = spatial_values[1][ii + 1] - spatial_values[1][ii];
            if (del_x != del_x || del_y != del_y || u != u || v != v) break;
            float mag_col = (float)Math.sqrt(del_x * del_x + del_y * del_y);
            vec_col[0] = del_x / mag_col;
            vec_col[1] = del_y / mag_col;
            del_x = spatial_values[0][ii + lenX] - spatial_values[0][ii];
            del_y = spatial_values[1][ii + lenX] - spatial_values[1][ii];
            float mag_row = (float)Math.sqrt(del_x * del_x + del_y * del_y);
            vec_row[0] = del_x / mag_row;
            vec_row[1] = del_y / mag_row;
            float dist = 1.0f;
            float step = stepFactor * cell_fraction * (dist / mag);
            float[] fArray = loc[0];
            fArray[0] = fArray[0] + step * dir * (u * vec_col[0] + v * vec_col[1]);
            float[] fArray2 = loc[1];
            fArray2[0] = fArray2[0] + step * dir * (u * vec_row[0] + v * vec_row[1]);
            row = loc[1][0];
            col = loc[0][0];
            if (row < 0.0f || col < 0.0f || row >= (float)(nr - 1) || col >= (float)(nc - 1) || row != row || col != col) {
                offgrid[0] = offgrid[0] + 1;
                break;
            }
            int ire = (int)((double)((float)nrend * row) / ((double)nr - 1.0));
            int ice = (int)((double)((float)ncend * col) / ((double)nc - 1.0));
            if (ire != irend || ice != icend) {
                icend = ice;
                irend = ire;
                if (markend[icend * nrend + irend] == 1) break;
                markend[icend * nrend + irend] = 1;
                nend = 0;
            }
            if ((double)(++nend) > 2.5 * (double)((float)nr / (cell_fraction * (float)nrend))) break;
            if (num >= vr.length - 4) {
                float[] tmp = new float[vr.length + 50];
                System.arraycopy(vr, 0, tmp, 0, vr.length);
                vr = tmp;
                tmp = new float[vc.length + 50];
                System.arraycopy(vc, 0, tmp, 0, vc.length);
                vc = tmp;
            }
            vr[num] = prevrow;
            vc[num++] = prevcol;
            vr[num] = row;
            vc[num++] = col;
            int ics = (int)((double)((float)ncstart * col) / ((double)nc - 1.0));
            int irs = (int)((double)((float)nrstart * row) / ((double)nr - 1.0));
            if (markstart[ics * nrstart + irs] == 0) {
                markstart[ics * nrstart + irs] = 1;
            }
            if (markarrow[(ica = (int)((double)((float)ncarrow * col) / ((double)nc - 1.0))) * nrstart + (ira = (int)((double)((float)nrarrow * row) / ((double)nr - 1.0)))] != 0) continue;
            markarrow[ica * nrstart + ira] = 1;
            double rv = dir * (row - prevrow);
            double cv = dir * (col - prevcol);
            double vl = Math.sqrt(rv * rv + cv * cv);
            if ((vl *= 3.0) > 1.0E-9) {
                rv /= vl;
                cv /= vl;
            }
            if (num >= vr.length - 6) {
                float[] tmp = new float[vr.length + 50];
                System.arraycopy(vr, 0, tmp, 0, vr.length);
                vr = tmp;
                tmp = new float[vc.length + 50];
                System.arraycopy(vc, 0, tmp, 0, vc.length);
                vc = tmp;
            }
            vr[num] = row;
            vc[num++] = col;
            vr[num] = row - (float)(rv + cv) * rowlength;
            vc[num++] = col + (float)(rv - cv) * collength;
            vr[num] = row;
            vc[num++] = col;
            vr[num] = row + (float)(cv - rv) * rowlength;
            vc[num++] = col - (float)(cv + rv) * collength;
        }
        numv[0] = num;
        vr2[0] = vr;
        vc2[0] = vc;
    }

    public static int stream(float[] ugrid, float[] vgrid, int nr, int nc, float density, float stepFactor, float arrowScale, float[][][] vr, float[][][] vc, int[][] numv, int[] numl, Gridded2DSet spatial_set, float packingFactor, float cntrWeight, int n_pass, float reduction) throws VisADException {
        int kk;
        float cell_fraction = 0.05f;
        int n_lines = 0;
        int[] num = new int[1];
        if ((double)density < 0.5) {
            density = 0.5f;
        }
        if (density > (float)nr / 15.0f) {
            density = (float)nr / 15.0f;
        }
        if (density > (float)nc / 15.0f) {
            density = (float)nc / 15.0f;
        }
        int nrarrow = (int)(15.0f * density);
        int ncarrow = (int)(15.0f * density);
        int nrstart = (int)(15.0f * density);
        int ncstart = (int)(15.0f * density);
        if (nrarrow > nr) {
            nrarrow = nr;
        }
        if (ncarrow > nc) {
            ncarrow = nc;
        }
        if (nrstart > nr) {
            nrstart = nr;
        }
        if (ncstart > nc) {
            ncstart = nc;
        }
        int nrend = 4 * nrstart;
        int ncend = 4 * ncstart;
        if (nrend > nr) {
            nrend = nr;
        }
        if (ncend > nc) {
            ncend = nc;
        }
        float n_start_per_cell = 0.5f;
        float n_end_per_cell = 4.0f;
        n_start_per_cell = 30.0f * density / (float)((nc + nr) / 2);
        n_end_per_cell = packingFactor * 8.0f * n_start_per_cell;
        nrarrow = nrstart = (int)(n_start_per_cell * (float)nr);
        ncarrow = ncstart = (int)(n_start_per_cell * (float)nc);
        nrend = (int)(n_end_per_cell * (float)nr);
        ncend = (int)(n_end_per_cell * (float)nc);
        float rowlength = LENGTH * (float)nr / density;
        float collength = LENGTH * (float)nc / density;
        rowlength *= arrowScale;
        collength *= arrowScale;
        numv[0] = new int[50];
        vr[0] = new float[50][];
        vc[0] = new float[50][];
        byte[] markarrow = new byte[nrarrow * ncarrow];
        byte[] markstart = new byte[nrstart * ncstart];
        byte[] markend = new byte[nrend * ncend];
        for (kk = 0; kk < nrstart * ncstart; ++kk) {
            markstart[kk] = 0;
            markarrow[kk] = 1;
        }
        for (kk = 0; kk < nrend * ncend; ++kk) {
            markend[kk] = 0;
        }
        for (int ir = 1; ir < nrarrow; ir += 3) {
            for (int ic = 1; ic < ncarrow; ic += 3) {
                markarrow[ic * nrarrow + ir] = 0;
            }
        }
        float step = 1.0f;
        float[][] spatial_values = spatial_set.getSamples(false);
        if (cntrWeight > 6.0f) {
            cntrWeight = 6.0f;
        }
        float ww = (6.0f - cntrWeight) / 4.0f;
        for (int pass = 0; pass < n_pass; ++pass) {
            float[] new_ugrid = new float[ugrid.length];
            float[] new_vgrid = new float[vgrid.length];
            System.arraycopy(ugrid, 0, new_ugrid, 0, new_ugrid.length);
            System.arraycopy(vgrid, 0, new_vgrid, 0, new_vgrid.length);
            for (int iir = 1; iir < nr - 1; ++iir) {
                for (int iic = 1; iic < nc - 1; ++iic) {
                    int kk2 = iir * nc + iic;
                    float suu = ugrid[kk2];
                    float sua = ugrid[kk2 - 1];
                    float sub = ugrid[kk2 + 1];
                    float suc = ugrid[kk2 + nc];
                    float sud = ugrid[kk2 - nc];
                    new_ugrid[kk2] = (cntrWeight * suu + ww * sua + ww * sub + ww * suc + ww * sud) / 6.0f;
                    float svv = vgrid[kk2];
                    float sva = vgrid[kk2 - 1];
                    float svb = vgrid[kk2 + 1];
                    float svc = vgrid[kk2 + nc];
                    float svd = vgrid[kk2 - nc];
                    new_vgrid[kk2] = (cntrWeight * svv + ww * sva + ww * svb + ww * svc + ww * svd) / 6.0f;
                }
            }
            ugrid = new_ugrid;
            vgrid = new_vgrid;
        }
        int cnt = 0;
        int[] offgrid = new int[1];
        for (int icstart = 0; icstart < ncstart; ++icstart) {
            for (int irstart = 0; irstart < nrstart; ++irstart) {
                float[] ftmp;
                int[] tmp;
                cnt = 0;
                if (markstart[icstart * nrstart + irstart] != 0) continue;
                markstart[icstart * nrstart + irstart] = 1;
                float row = ((float)nr - 1.0f) * ((float)irstart + 0.5f) / (float)nrstart;
                float col = ((float)nc - 1.0f) * ((float)icstart + 0.5f) / (float)ncstart;
                int irend = (int)((float)nrend * row / ((float)nr - 1.0f));
                int icend = (int)((float)ncend * col / ((float)nc - 1.0f));
                markend[icend * nrend + irend] = 1;
                if (n_lines == vr[0].length) {
                    float[][] f_tmp = new float[vr[0].length + 50][];
                    System.arraycopy(vr[0], 0, f_tmp, 0, vr[0].length);
                    vr[0] = f_tmp;
                    f_tmp = new float[vc[0].length + 50][];
                    System.arraycopy(vc[0], 0, f_tmp, 0, vc[0].length);
                    vc[0] = f_tmp;
                }
                float[][] vr2 = new float[1][];
                float[][] vc2 = new float[1][];
                vr2[0] = new float[200];
                vc2[0] = new float[200];
                vr[0][n_lines] = vr2[0];
                vc[0][n_lines] = vc2[0];
                float dir = 1.0f;
                num[0] = 0;
                offgrid[0] = 0;
                Stream2D.stream_trace(ugrid, vgrid, nr, nc, dir, vr2, vc2, num, markarrow, markstart, markend, nrarrow, ncarrow, nrstart, ncstart, nrend, ncend, row, col, stepFactor, rowlength, collength, irend, icend, spatial_set, spatial_values, offgrid, cell_fraction);
                vr[0][n_lines] = vr2[0];
                vc[0][n_lines] = vc2[0];
                cnt += num[0];
                if (num[0] > 0) {
                    if (n_lines == numv[0].length) {
                        tmp = new int[numv[0].length + 50];
                        System.arraycopy(numv[0], 0, tmp, 0, numv[0].length);
                        numv[0] = tmp;
                    }
                    ftmp = new float[num[0]];
                    System.arraycopy(vr[0][n_lines], 0, ftmp, 0, ftmp.length);
                    vr[0][n_lines] = ftmp;
                    ftmp = new float[num[0]];
                    System.arraycopy(vc[0][n_lines], 0, ftmp, 0, ftmp.length);
                    vc[0][n_lines] = ftmp;
                    numv[0][n_lines] = num[0];
                    ++n_lines;
                }
                if (n_lines == vr[0].length) {
                    float[][] f_tmp = new float[vr[0].length + 50][];
                    System.arraycopy(vr[0], 0, f_tmp, 0, vr[0].length);
                    vr[0] = f_tmp;
                    f_tmp = new float[vc[0].length + 50][];
                    System.arraycopy(vc[0], 0, f_tmp, 0, vc[0].length);
                    vc[0] = f_tmp;
                }
                vr2 = new float[1][];
                vc2 = new float[1][];
                vr2[0] = new float[200];
                vc2[0] = new float[200];
                vr[0][n_lines] = vr2[0];
                vc[0][n_lines] = vc2[0];
                dir = -1.0f;
                num[0] = 0;
                Stream2D.stream_trace(ugrid, vgrid, nr, nc, dir, vr2, vc2, num, markarrow, markstart, markend, nrarrow, ncarrow, nrstart, ncstart, nrend, ncend, row, col, stepFactor, rowlength, collength, irend, icend, spatial_set, spatial_values, offgrid, cell_fraction);
                vr[0][n_lines] = vr2[0];
                vc[0][n_lines] = vc2[0];
                cnt += num[0];
                if (num[0] > 0) {
                    if (n_lines == numv[0].length) {
                        tmp = new int[numv[0].length + 50];
                        System.arraycopy(numv[0], 0, tmp, 0, numv[0].length);
                        numv[0] = tmp;
                    }
                    ftmp = new float[num[0]];
                    System.arraycopy(vr[0][n_lines], 0, ftmp, 0, ftmp.length);
                    vr[0][n_lines] = ftmp;
                    ftmp = new float[num[0]];
                    System.arraycopy(vc[0][n_lines], 0, ftmp, 0, ftmp.length);
                    vc[0][n_lines] = ftmp;
                    numv[0][n_lines] = num[0];
                    ++n_lines;
                }
                if (!((float)cnt < (float)((nr + nc) / 2) / cell_fraction * reduction) || reduction == 1.0f || offgrid[0] != 0) continue;
                n_lines -= 2;
            }
        }
        int[] tmp = new int[n_lines];
        System.arraycopy(numv[0], 0, tmp, 0, n_lines);
        numv[0] = tmp;
        numl[0] = n_lines;
        return 1;
    }
}

