/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.nc2.Structure;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class BufrCdm
extends TableConfigurerImpl {
    private final String BufrConvention = "BUFR/CDM";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals("BUFR/CDM")) {
            return true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals("BUFR/CDM")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case stationTimeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case stationProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("invalid ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig obsTable = new TableConfig(Table.Type.Structure, "obs");
        Structure obsStruct = (Structure)ds.findVariable("obs");
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.lat = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        obsTable.lon = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        obsTable.elev = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Height.toString());
        obsTable.time = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Time.toString());
        return obsTable;
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig stnTable = new TableConfig(Table.Type.Construct, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.structName = "obs";
        TableConfig timeTable = new TableConfig(Table.Type.ParentId, "obs");
        Structure stnStruct = (Structure)ds.findVariable("obs");
        timeTable.lat = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        timeTable.lon = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        timeTable.stnAlt = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Height.toString());
        timeTable.stnId = Evaluator.getNameOfVariableWithAttribute(stnStruct, "standard_name", "station_id");
        timeTable.stnWmoId = Evaluator.getNameOfVariableWithAttribute(stnStruct, "standard_name", "station_WMO_id");
        if (timeTable.stnId == null) {
            timeTable.stnId = timeTable.stnWmoId;
        }
        timeTable.parentIndex = timeTable.stnId;
        timeTable.time = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Time.toString());
        timeTable.structName = "obs";
        stnTable.addChild(timeTable);
        return stnTable;
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig topTable = new TableConfig(Table.Type.Top, "singleTrajectory");
        TableConfig obsTable = new TableConfig(Table.Type.Structure, "obs");
        Structure obsStruct = (Structure)ds.findVariable("obs");
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.lat = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        obsTable.lon = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        obsTable.elev = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Height.toString());
        obsTable.time = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Time.toString());
        topTable.addChild(obsTable);
        return topTable;
    }

    protected TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig profileTable = new TableConfig(Table.Type.Structure, "profile");
        profileTable.featureType = FeatureType.PROFILE;
        profileTable.structName = "obs";
        Structure profileStruct = (Structure)ds.findVariable("obs");
        profileTable.lat = Evaluator.getNameOfVariableWithAttribute(profileStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        profileTable.lon = Evaluator.getNameOfVariableWithAttribute(profileStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        profileTable.time = Evaluator.getNameOfVariableWithAttribute(profileStruct, "_CoordinateAxisType", AxisType.Time.toString());
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, "struct5");
        Structure obsStruct = (Structure)profileStruct.findVariable("struct5");
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.elev = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Pressure.toString());
        profileTable.addChild(obsTable);
        return profileTable;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig stnTable = new TableConfig(Table.Type.Construct, "station");
        stnTable.featureType = FeatureType.STATION_PROFILE;
        stnTable.structName = "obs";
        TableConfig timeTable = new TableConfig(Table.Type.ParentId, "obs");
        Structure stnStruct = (Structure)ds.findVariable("obs");
        timeTable.lat = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        timeTable.lon = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        timeTable.stnAlt = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Height.toString());
        timeTable.stnId = Evaluator.getNameOfVariableWithAttribute(stnStruct, "standard_name", "station_id");
        timeTable.stnWmoId = Evaluator.getNameOfVariableWithAttribute(stnStruct, "standard_name", "station_WMO_id");
        if (timeTable.stnId == null) {
            timeTable.stnId = timeTable.stnWmoId;
        }
        timeTable.parentIndex = timeTable.stnId;
        timeTable.time = Evaluator.getNameOfVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Time.toString());
        timeTable.structName = "obs";
        stnTable.addChild(timeTable);
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, "levels");
        Structure obsStruct = (Structure)stnStruct.findVariable("seq1");
        if (obsStruct == null) {
            obsStruct = (Structure)stnStruct.findVariable("struct1");
        }
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.elev = Evaluator.getNameOfVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Height.toString());
        timeTable.addChild(obsTable);
        return stnTable;
    }
}

