/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.wavelet;

import ucar.jpeg.jj2000.j2k.NotImplementedError;

public class WTDecompSpec {
    public static final int WT_DECOMP_DYADIC = 0;
    public static final int WT_DECOMP_SPACL = 2;
    public static final int WT_DECOMP_PACKET = 1;
    public static final byte DEC_SPEC_MAIN_DEF = 0;
    public static final byte DEC_SPEC_COMP_DEF = 1;
    public static final byte DEC_SPEC_TILE_DEF = 2;
    public static final byte DEC_SPEC_TILE_COMP = 3;
    private byte[] specValType;
    private int mainDefDecompType;
    private int mainDefLevels;
    private int[] compMainDefDecompType;
    private int[] compMainDefLevels;

    public WTDecompSpec(int nc, int dec, int lev) {
        this.mainDefDecompType = dec;
        this.mainDefLevels = lev;
        this.specValType = new byte[nc];
    }

    public void setMainCompDefDecompType(int n, int dec, int lev) {
        if (dec < 0 && lev < 0) {
            throw new IllegalArgumentException();
        }
        this.specValType[n] = 1;
        if (this.compMainDefDecompType == null) {
            this.compMainDefDecompType = new int[this.specValType.length];
            this.compMainDefLevels = new int[this.specValType.length];
        }
        this.compMainDefDecompType[n] = dec >= 0 ? dec : this.mainDefDecompType;
        this.compMainDefLevels[n] = lev >= 0 ? lev : this.mainDefLevels;
        throw new NotImplementedError("Currently, in JJ2000, all components and tiles must have the same decomposition type and number of levels");
    }

    public byte getDecSpecType(int n) {
        return this.specValType[n];
    }

    public int getMainDefDecompType() {
        return this.mainDefDecompType;
    }

    public int getMainDefLevels() {
        return this.mainDefLevels;
    }

    public int getDecompType(int n) {
        switch (this.specValType[n]) {
            case 0: {
                return this.mainDefDecompType;
            }
            case 1: {
                return this.compMainDefDecompType[n];
            }
            case 2: {
                throw new NotImplementedError();
            }
            case 3: {
                throw new NotImplementedError();
            }
        }
        throw new Error("Internal JJ2000 error");
    }

    public int getLevels(int n) {
        switch (this.specValType[n]) {
            case 0: {
                return this.mainDefLevels;
            }
            case 1: {
                return this.compMainDefLevels[n];
            }
            case 2: {
                throw new NotImplementedError();
            }
            case 3: {
                throw new NotImplementedError();
            }
        }
        throw new Error("Internal JJ2000 error");
    }
}

