/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.wiring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.beans.factory.wiring.ClassNameBeanWiringInfoResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BeanConfigurerSupport
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile BeanWiringInfoResolver beanWiringInfoResolver;
    private volatile ConfigurableListableBeanFactory beanFactory;

    public void setBeanWiringInfoResolver(BeanWiringInfoResolver beanWiringInfoResolver) {
        this.beanWiringInfoResolver = beanWiringInfoResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("Bean configurer aspect needs to run in a ConfigurableListableBeanFactory: " + beanFactory);
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        if (this.beanWiringInfoResolver == null) {
            this.beanWiringInfoResolver = this.createDefaultBeanWiringInfoResolver();
        }
    }

    protected BeanWiringInfoResolver createDefaultBeanWiringInfoResolver() {
        return new ClassNameBeanWiringInfoResolver();
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.beanFactory, "BeanFactory must be set");
    }

    public void destroy() {
        this.beanFactory = null;
        this.beanWiringInfoResolver = null;
    }

    public void configureBean(Object beanInstance) {
        if (this.beanWiringInfoResolver == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(ClassUtils.getShortName(this.getClass()) + " has not been set up " + "and is unable to configure bean instances. Proceeding without injection.");
            }
            return;
        }
        BeanWiringInfo bwi = this.beanWiringInfoResolver.resolveWiringInfo(beanInstance);
        if (bwi == null) {
            return;
        }
        if (this.beanFactory == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BeanFactory has not been set on " + ClassUtils.getShortName(this.getClass()) + ": " + "Make sure this configurer runs in a Spring container. Proceeding without injection.");
            }
            return;
        }
        try {
            if (bwi.indicatesAutowiring() || bwi.isDefaultBeanName() && !this.beanFactory.containsBean(bwi.getBeanName())) {
                this.beanFactory.autowireBeanProperties(beanInstance, bwi.getAutowireMode(), bwi.getDependencyCheck());
                Object result = this.beanFactory.initializeBean(beanInstance, bwi.getBeanName());
                this.checkExposedObject(result, beanInstance);
            } else {
                Object result = this.beanFactory.configureBean(beanInstance, bwi.getBeanName());
                this.checkExposedObject(result, beanInstance);
            }
        }
        catch (BeanCreationException ex) {
            BeanCreationException bce;
            Throwable rootCause = ex.getMostSpecificCause();
            if (rootCause instanceof BeanCurrentlyInCreationException && this.beanFactory.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                String msg = ClassUtils.getShortName(this.getClass()) + " failed to create target bean '" + bce.getBeanName() + "' while configuring object of type [" + beanInstance.getClass().getName() + "] (probably due to a circular reference). " + "Proceeding without injection.";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(msg, ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info(msg);
                }
                return;
            }
            throw ex;
        }
    }

    private void checkExposedObject(Object exposedObject, Object originalBeanInstance) {
        if (exposedObject != originalBeanInstance) {
            throw new IllegalStateException("Post-processor tried to replace bean instance of type [" + originalBeanInstance.getClass().getName() + "] with (proxy) object of type [" + exposedObject.getClass().getName() + "] - not supported for aspect-configured classes!");
        }
    }
}

