/*
 * Bamboo - A Vietnamese Input method editor
 * Copyright (C) Luong Thanh Lam <ltlam93@gmail.com>
 *
 * This software is licensed under the MIT license. For more information,
 * see <https://github.com/BambooEngine/bamboo-core/blob/master/LICENSE>.
 */

package bamboo

type charsetDefinition map[rune]string

var charsetDefinitions = map[string]charsetDefinition{
	"TCVN3 (ABC)": {
		'đ': "®",
		'â': "©",
		'ă': "¨",
		'ê': "ª",
		'ô': "«",
		'ơ': "¬",
		'ư': "\u00ad",
		'á': "¸",
		'à': "µ",
		'ả': "¶",
		'ã': "·",
		'ạ': "¹",
		'ấ': "Ê",
		'ầ': "Ç",
		'ẩ': "È",
		'ẫ': "É",
		'ậ': "Ë",
		'ắ': "¾",
		'ằ': "»",
		'ẳ': "¼",
		'ẵ': "½",
		'ặ': "Æ",
		'é': "Ð",
		'è': "Ì",
		'ẻ': "Î",
		'ẽ': "Ï",
		'ẹ': "Ñ",
		'ế': "Õ",
		'ề': "Ò",
		'ể': "Ó",
		'ễ': "Ô",
		'ệ': "Ö",
		'í': "Ý",
		'ì': "×",
		'ỉ': "Ø",
		'ĩ': "Ü",
		'ị': "Þ",
		'ó': "ã",
		'ò': "ß",
		'ỏ': "á",
		'õ': "â",
		'ọ': "ä",
		'ố': "è",
		'ồ': "å",
		'ổ': "æ",
		'ỗ': "ç",
		'ộ': "é",
		'ớ': "í",
		'ờ': "ê",
		'ở': "ë",
		'ỡ': "ì",
		'ợ': "î",
		'ú': "ó",
		'ù': "ï",
		'ủ': "ñ",
		'ũ': "ò",
		'ụ': "ô",
		'ứ': "ø",
		'ừ': "õ",
		'ử': "ö",
		'ữ': "÷",
		'ự': "ù",
		'ý': "ý",
		'ỳ': "ú",
		'ỷ': "û",
		'ỹ': "ü",
		'ỵ': "þ",
		'Đ': "§",
		'Â': "¢",
		'Ă': "¡",
		'Ê': "£",
		'Ô': "¤",
		'Ơ': "¥",
		'Ư': "¦",
		'Á': "¸",
		'À': "µ",
		'Ả': "¶",
		'Ã': "·",
		'Ạ': "¹",
		'Ấ': "Ê",
		'Ầ': "Ç",
		'Ẩ': "È",
		'Ẫ': "É",
		'Ậ': "Ë",
		'Ắ': "¾",
		'Ằ': "»",
		'Ẳ': "¼",
		'Ẵ': "½",
		'Ặ': "Æ",
		'É': "Ð",
		'È': "Ì",
		'Ẻ': "Î",
		'Ẽ': "Ï",
		'Ẹ': "Ñ",
		'Ế': "Õ",
		'Ề': "Ò",
		'Ể': "Ó",
		'Ễ': "Ô",
		'Ệ': "Ö",
		'Í': "Ý",
		'Ì': "×",
		'Ỉ': "Ø",
		'Ĩ': "Ü",
		'Ị': "Þ",
		'Ó': "ã",
		'Ò': "ß",
		'Ỏ': "á",
		'Õ': "â",
		'Ọ': "ä",
		'Ố': "è",
		'Ồ': "å",
		'Ổ': "æ",
		'Ỗ': "ç",
		'Ộ': "é",
		'Ớ': "í",
		'Ờ': "ê",
		'Ở': "ë",
		'Ỡ': "ì",
		'Ợ': "î",
		'Ú': "ó",
		'Ù': "ï",
		'Ủ': "ñ",
		'Ũ': "ò",
		'Ụ': "ô",
		'Ứ': "ø",
		'Ừ': "õ",
		'Ử': "ö",
		'Ữ': "÷",
		'Ự': "ù",
		'Ý': "ý",
		'Ỳ': "ú",
		'Ỷ': "û",
		'Ỹ': "ü",
		'Ỵ': "þ",
	},
	"VNI Windows": {
		'đ': "ñ",
		'â': "aâ",
		'ă': "aê",
		'ê': "eâ",
		'ô': "oâ",
		'ơ': "ô",
		'ư': "ö",
		'á': "aù",
		'à': "aø",
		'ả': "aû",
		'ã': "aõ",
		'ạ': "aï",
		'ấ': "aá",
		'ầ': "aà",
		'ẩ': "aå",
		'ẫ': "aã",
		'ậ': "aä",
		'ắ': "aé",
		'ằ': "aè",
		'ẳ': "aú",
		'ẵ': "aü",
		'ặ': "aë",
		'é': "eù",
		'è': "eø",
		'ẻ': "eû",
		'ẽ': "eõ",
		'ẹ': "eï",
		'ế': "eá",
		'ề': "eà",
		'ể': "eå",
		'ễ': "eã",
		'ệ': "eä",
		'í': "í",
		'ì': "ì",
		'ỉ': "æ",
		'ĩ': "ó",
		'ị': "ò",
		'ó': "où",
		'ò': "oø",
		'ỏ': "oû",
		'õ': "oõ",
		'ọ': "oï",
		'ố': "oá",
		'ồ': "oà",
		'ổ': "oå",
		'ỗ': "oã",
		'ộ': "oä",
		'ớ': "ôù",
		'ờ': "ôø",
		'ở': "ôû",
		'ỡ': "ôõ",
		'ợ': "ôï",
		'ú': "uù",
		'ù': "uø",
		'ủ': "uû",
		'ũ': "uõ",
		'ụ': "uï",
		'ứ': "öù",
		'ừ': "öø",
		'ử': "öû",
		'ữ': "öõ",
		'ự': "öï",
		'ý': "yù",
		'ỳ': "yø",
		'ỷ': "yû",
		'ỹ': "yõ",
		'ỵ': "î",
		'Đ': "Ñ",
		'Â': "AÂ",
		'Ă': "AÊ",
		'Ê': "EÂ",
		'Ô': "OÂ",
		'Ơ': "Ô",
		'Ư': "Ö",
		'Á': "AÙ",
		'À': "AØ",
		'Ả': "AÛ",
		'Ã': "AÕ",
		'Ạ': "AÏ",
		'Ấ': "AÁ",
		'Ầ': "AÀ",
		'Ẩ': "AÅ",
		'Ẫ': "AÃ",
		'Ậ': "AÄ",
		'Ắ': "AÉ",
		'Ằ': "AÈ",
		'Ẳ': "AÚ",
		'Ẵ': "AÜ",
		'Ặ': "AË",
		'É': "EÙ",
		'È': "EØ",
		'Ẻ': "EÛ",
		'Ẽ': "EÕ",
		'Ẹ': "EÏ",
		'Ế': "EÁ",
		'Ề': "EÀ",
		'Ể': "EÅ",
		'Ễ': "EÃ",
		'Ệ': "EÄ",
		'Í': "Í",
		'Ì': "Ì",
		'Ỉ': "Æ",
		'Ĩ': "Ó",
		'Ị': "Ò",
		'Ó': "OÙ",
		'Ò': "OØ",
		'Ỏ': "OÛ",
		'Õ': "OÕ",
		'Ọ': "OÏ",
		'Ố': "OÁ",
		'Ồ': "OÀ",
		'Ổ': "OÅ",
		'Ỗ': "OÃ",
		'Ộ': "OÄ",
		'Ớ': "ÔÙ",
		'Ờ': "ÔØ",
		'Ở': "ÔÛ",
		'Ỡ': "ÔÕ",
		'Ợ': "ÔÏ",
		'Ú': "UÙ",
		'Ù': "UØ",
		'Ủ': "UÛ",
		'Ũ': "UÕ",
		'Ụ': "UÏ",
		'Ứ': "ÖÙ",
		'Ừ': "ÖØ",
		'Ử': "ÖÛ",
		'Ữ': "ÖÕ",
		'Ự': "ÖÏ",
		'Ý': "YÙ",
		'Ỳ': "YØ",
		'Ỷ': "YÛ",
		'Ỹ': "YÕ",
		'Ỵ': "Î",
	},
	"Unicode tổ hợp": {
		'đ': "đ",
		'â': "â",
		'ă': "ă",
		'ê': "ê",
		'ô': "ô",
		'ơ': "ơ",
		'ư': "ư",
		'á': "á",
		'à': "à",
		'ả': "ả",
		'ã': "ã",
		'ạ': "ạ",
		'ấ': "ấ",
		'ầ': "ầ",
		'ẩ': "ẩ",
		'ẫ': "ẫ",
		'ậ': "ậ",
		'ắ': "ắ",
		'ằ': "ằ",
		'ẳ': "ẳ",
		'ẵ': "ẵ",
		'ặ': "ặ",
		'é': "é",
		'è': "è",
		'ẻ': "ẻ",
		'ẽ': "ẽ",
		'ẹ': "ẹ",
		'ế': "ế",
		'ề': "ề",
		'ể': "ể",
		'ễ': "ễ",
		'ệ': "ệ",
		'í': "í",
		'ì': "ì",
		'ỉ': "ỉ",
		'ĩ': "ĩ",
		'ị': "ị",
		'ó': "ó",
		'ò': "ò",
		'ỏ': "ỏ",
		'õ': "õ",
		'ọ': "ọ",
		'ố': "ố",
		'ồ': "ồ",
		'ổ': "ổ",
		'ỗ': "ỗ",
		'ộ': "ộ",
		'ớ': "ớ",
		'ờ': "ờ",
		'ở': "ở",
		'ỡ': "ỡ",
		'ợ': "ợ",
		'ú': "ú",
		'ù': "ù",
		'ủ': "ủ",
		'ũ': "ũ",
		'ụ': "ụ",
		'ứ': "ứ",
		'ừ': "ừ",
		'ử': "ử",
		'ữ': "ữ",
		'ự': "ự",
		'ý': "ý",
		'ỳ': "ỳ",
		'ỷ': "ỷ",
		'ỹ': "ỹ",
		'ỵ': "ỵ",
		'Đ': "Đ",
		'Â': "Â",
		'Ă': "Ă",
		'Ê': "Ê",
		'Ô': "Ô",
		'Ơ': "Ơ",
		'Ư': "Ư",
		'Á': "Á",
		'À': "À",
		'Ả': "Ả",
		'Ã': "Ã",
		'Ạ': "Ạ",
		'Ấ': "Ấ",
		'Ầ': "Ầ",
		'Ẩ': "Ẩ",
		'Ẫ': "Ẫ",
		'Ậ': "Ậ",
		'Ắ': "Ắ",
		'Ằ': "Ằ",
		'Ẳ': "Ẳ",
		'Ẵ': "Ẵ",
		'Ặ': "Ặ",
		'É': "É",
		'È': "È",
		'Ẻ': "Ẻ",
		'Ẽ': "Ẽ",
		'Ẹ': "Ẹ",
		'Ế': "Ế",
		'Ề': "Ề",
		'Ể': "Ể",
		'Ễ': "Ễ",
		'Ệ': "Ệ",
		'Í': "Í",
		'Ì': "Ì",
		'Ỉ': "Ỉ",
		'Ĩ': "Ĩ",
		'Ị': "Ị",
		'Ó': "Ó",
		'Ò': "Ò",
		'Ỏ': "Ỏ",
		'Õ': "Õ",
		'Ọ': "Ọ",
		'Ố': "Ố",
		'Ồ': "Ồ",
		'Ổ': "Ổ",
		'Ỗ': "Ỗ",
		'Ộ': "Ộ",
		'Ớ': "Ớ",
		'Ờ': "Ờ",
		'Ở': "Ở",
		'Ỡ': "Ỡ",
		'Ợ': "Ợ",
		'Ú': "Ú",
		'Ù': "Ù",
		'Ủ': "Ủ",
		'Ũ': "Ũ",
		'Ụ': "Ụ",
		'Ứ': "Ứ",
		'Ừ': "Ừ",
		'Ử': "Ử",
		'Ữ': "Ữ",
		'Ự': "Ự",
		'Ý': "Ý",
		'Ỳ': "Ỳ",
		'Ỷ': "Ỷ",
		'Ỹ': "Ỹ",
		'Ỵ': "Ỵ",
	},
	"Windows 1258 codepage": {
		'đ': "ð",
		'â': "â",
		'ă': "ã",
		'ê': "ê",
		'ô': "ô",
		'ơ': "õ",
		'ư': "ý",
		'á': "aì",
		'à': "aÌ",
		'ả': "aÒ",
		'ã': "aÞ",
		'ạ': "aò",
		'ấ': "âì",
		'ầ': "âÌ",
		'ẩ': "âÒ",
		'ẫ': "âÞ",
		'ậ': "âò",
		'ắ': "ãì",
		'ằ': "ãÌ",
		'ẳ': "ãÒ",
		'ẵ': "ãÞ",
		'ặ': "ãò",
		'é': "eì",
		'è': "eÌ",
		'ẻ': "eÒ",
		'ẽ': "eÞ",
		'ẹ': "eò",
		'ế': "êì",
		'ề': "êÌ",
		'ể': "êÒ",
		'ễ': "êÞ",
		'ệ': "êò",
		'í': "iì",
		'ì': "iÌ",
		'ỉ': "iÒ",
		'ĩ': "iÞ",
		'ị': "iò",
		'ó': "oì",
		'ò': "oÌ",
		'ỏ': "oÒ",
		'õ': "oÞ",
		'ọ': "oò",
		'ố': "ôì",
		'ồ': "ôÌ",
		'ổ': "ôÒ",
		'ỗ': "ôÞ",
		'ộ': "ôò",
		'ớ': "õì",
		'ờ': "õÌ",
		'ở': "õÒ",
		'ỡ': "õÞ",
		'ợ': "õò",
		'ú': "uì",
		'ù': "uÌ",
		'ủ': "uÒ",
		'ũ': "uÞ",
		'ụ': "uò",
		'ứ': "ýì",
		'ừ': "ýÌ",
		'ử': "ýÒ",
		'ữ': "ýÞ",
		'ự': "ýò",
		'ý': "yì",
		'ỳ': "yÌ",
		'ỷ': "yÒ",
		'ỹ': "yÞ",
		'ỵ': "yò",
		'Đ': "Đ",
		'Â': "Â",
		'Ă': "Ã",
		'Ê': "Ê",
		'Ô': "Ô",
		'Ơ': "Õ",
		'Ư': "Ý",
		'Á': "Aì",
		'À': "AÌ",
		'Ả': "AÒ",
		'Ã': "AÞ",
		'Ạ': "Aò",
		'Ấ': "Âì",
		'Ầ': "ÂÌ",
		'Ẩ': "ÂÒ",
		'Ẫ': "ÂÞ",
		'Ậ': "Âò",
		'Ắ': "Ãì",
		'Ằ': "ÃÌ",
		'Ẳ': "ÃÒ",
		'Ẵ': "ÃÞ",
		'Ặ': "Ãò",
		'É': "Eì",
		'È': "EÌ",
		'Ẻ': "EÒ",
		'Ẽ': "EÞ",
		'Ẹ': "Eò",
		'Ế': "Êì",
		'Ề': "ÊÌ",
		'Ể': "ÊÒ",
		'Ễ': "ÊÞ",
		'Ệ': "Êò",
		'Í': "Iì",
		'Ì': "IÌ",
		'Ỉ': "IÒ",
		'Ĩ': "IÞ",
		'Ị': "Iò",
		'Ó': "Oì",
		'Ò': "OÌ",
		'Ỏ': "OÒ",
		'Õ': "OÞ",
		'Ọ': "Oò",
		'Ố': "Ôì",
		'Ồ': "ÔÌ",
		'Ổ': "ÔÒ",
		'Ỗ': "ÔÞ",
		'Ộ': "Ôò",
		'Ớ': "Õì",
		'Ờ': "ÕÌ",
		'Ở': "ÕÒ",
		'Ỡ': "ÕÞ",
		'Ợ': "Õò",
		'Ú': "Uì",
		'Ù': "UÌ",
		'Ủ': "UÒ",
		'Ũ': "UÞ",
		'Ụ': "Uò",
		'Ứ': "=Ýì",
		'Ừ': "ÝÌ",
		'Ử': "ÝÒ",
		'Ữ': "ÝÞ",
		'Ự': "Ýò",
		'Ý': "Yì",
		'Ỳ': "YÌ",
		'Ỷ': "YÒ",
		'Ỹ': "YÞ",
		'Ỵ': "Yò",
	},
	"VIQR": {
		'đ': "dd",
		'â': "a^",
		'ă': "a(",
		'ê': "e^",
		'ô': "o^",
		'ơ': "o+",
		'ư': "u+",
		'á': "a'",
		'à': "a`",
		'ả': "a?",
		'ã': "a~",
		'ạ': "a.",
		'ấ': "a^'",
		'ầ': "a^`",
		'ẩ': "a^?",
		'ẫ': "a^~",
		'ậ': "a^.",
		'ắ': "a('",
		'ằ': "a(`",
		'ẳ': "a(?",
		'ẵ': "a(~",
		'ặ': "a(.",
		'é': "e'",
		'è': "e`",
		'ẻ': "e?",
		'ẽ': "e~",
		'ẹ': "e.",
		'ế': "e^'",
		'ề': "e^`",
		'ể': "e^?",
		'ễ': "e^~",
		'ệ': "e^.",
		'í': "i'",
		'ì': "i`",
		'ỉ': "i?",
		'ĩ': "i~",
		'ị': "i.",
		'ó': "o'",
		'ò': "o`",
		'ỏ': "o?",
		'õ': "o~",
		'ọ': "o.",
		'ố': "o^'",
		'ồ': "o^`",
		'ổ': "o^?",
		'ỗ': "o^~",
		'ộ': "o^.",
		'ớ': "o+'",
		'ờ': "o+`",
		'ở': "o+?",
		'ỡ': "o+~",
		'ợ': "o+.",
		'ú': "u'",
		'ù': "u`",
		'ủ': "u?",
		'ũ': "u~",
		'ụ': "u.",
		'ứ': "u+'",
		'ừ': "u+`",
		'ử': "u+?",
		'ữ': "u+~",
		'ự': "u+.",
		'ý': "y'",
		'ỳ': "y`",
		'ỷ': "y?",
		'ỹ': "y~",
		'ỵ': "y.",
		'Đ': "DD",
		'Â': "A^",
		'Ă': "A(",
		'Ê': "E^",
		'Ô': "O^",
		'Ơ': "O+",
		'Ư': "U+",
		'Á': "A'",
		'À': "A`",
		'Ả': "A?",
		'Ã': "A~",
		'Ạ': "A.",
		'Ấ': "A^'",
		'Ầ': "A^`",
		'Ẩ': "A^?",
		'Ẫ': "A^~",
		'Ậ': "A^.",
		'Ắ': "A('",
		'Ằ': "A(`",
		'Ẳ': "A(?",
		'Ẵ': "A(~",
		'Ặ': "A(.",
		'É': "E'",
		'È': "E`",
		'Ẻ': "E?",
		'Ẽ': "E~",
		'Ẹ': "E.",
		'Ế': "E^'",
		'Ề': "E^`",
		'Ể': "E^?",
		'Ễ': "E^~",
		'Ệ': "E^.",
		'Í': "I'",
		'Ì': "I`",
		'Ỉ': "I?",
		'Ĩ': "I~",
		'Ị': "I.",
		'Ó': "O'",
		'Ò': "O`",
		'Ỏ': "O?",
		'Õ': "O~",
		'Ọ': "O.",
		'Ố': "O^'",
		'Ồ': "O^`",
		'Ổ': "O^?",
		'Ỗ': "O^~",
		'Ộ': "O^.",
		'Ớ': "O+'",
		'Ờ': "O+`",
		'Ở': "O+?",
		'Ỡ': "O+~",
		'Ợ': "O+.",
		'Ú': "U'",
		'Ù': "U`",
		'Ủ': "U?",
		'Ũ': "U~",
		'Ụ': "U.",
		'Ứ': "U+'",
		'Ừ': "U+`",
		'Ử': "U+?",
		'Ữ': "U+~",
		'Ự': "U+.",
		'Ý': "Y'",
		'Ỳ': "Y`",
		'Ỷ': "Y?",
		'Ỹ': "Y~",
		'Ỵ': "Y.",
	},
	"VISCII": {
		'đ': "ð",
		'â': "â",
		'ă': "å",
		'ê': "ê",
		'ô': "ô",
		'ơ': "½",
		'ư': "ß",
		'á': "á",
		'à': "à",
		'ả': "ä",
		'ã': "ã",
		'ạ': "Õ",
		'ấ': "¤",
		'ầ': "¥",
		'ẩ': "¦",
		'ẫ': "ç",
		'ậ': "§",
		'ắ': "¡",
		'ằ': "¢",
		'ẳ': "Æ",
		'ẵ': "Ç",
		'ặ': "£",
		'é': "é",
		'è': "è",
		'ẻ': "ë",
		'ẽ': "¨",
		'ẹ': "©",
		'ế': "ª",
		'ề': "«",
		'ể': "¬",
		'ễ': "\u00ad",
		'ệ': "®",
		'í': "í",
		'ì': "ì",
		'ỉ': "ï",
		'ĩ': "î",
		'ị': "¸",
		'ó': "ó",
		'ò': "ò",
		'ỏ': "ö",
		'õ': "õ",
		'ọ': "÷",
		'ố': "¯",
		'ồ': "°",
		'ổ': "±",
		'ỗ': "²",
		'ộ': "µ",
		'ớ': "¾",
		'ờ': "¶",
		'ở': "·",
		'ỡ': "Þ",
		'ợ': "þ",
		'ú': "ú",
		'ù': "ù",
		'ủ': "ü",
		'ũ': "û",
		'ụ': "ø",
		'ứ': "Ñ",
		'ừ': "×",
		'ử': "Ø",
		'ữ': "æ",
		'ự': "ñ",
		'ý': "ý",
		'ỳ': "Ï",
		'ỷ': "Ö",
		'ỹ': "Û",
		'ỵ': "Ü",
		'Đ': "Ð",
		'Â': "Â",
		'Ă': "Å",
		'Ê': "Ê",
		'Ô': "Ô",
		'Ơ': "´",
		'Ư': "¿",
		'Á': "Á",
		'À': "À",
		'Ả': "Ä",
		'Ã': "Ã",
		'Ạ': "€",
		'Ấ': "„",
		'Ầ': "…",
		'Ẩ': "†",
		'Ẫ': "ç",
		'Ậ': "‡",
		'Ắ': "\u0081",
		'Ằ': "‚",
		'Ẳ': "Æ",
		'Ẵ': "Ç",
		'Ặ': "ƒ",
		'É': "É",
		'È': "È",
		'Ẻ': "Ë",
		'Ẽ': "ˆ",
		'Ẹ': "‰",
		'Ế': "Š",
		'Ề': "‹",
		'Ể': "Œ",
		'Ễ': "\u008d",
		'Ệ': "Ž",
		'Í': "Í",
		'Ì': "Ì",
		'Ỉ': "›",
		'Ĩ': "Î",
		'Ị': "˜",
		'Ó': "Ó",
		'Ò': "Ò",
		'Ỏ': "™",
		'Õ': "õ",
		'Ọ': "š",
		'Ố': "\u008f",
		'Ồ': "\u0090",
		'Ổ': "‘",
		'Ỗ': "’",
		'Ộ': "“",
		'Ớ': "•",
		'Ờ': "–",
		'Ở': "—",
		'Ỡ': "³",
		'Ợ': "”",
		'Ú': "Ú",
		'Ù': "Ù",
		'Ủ': "œ",
		'Ũ': "\u009d",
		'Ụ': "ž",
		'Ứ': "º",
		'Ừ': "»",
		'Ử': "¼",
		'Ữ': "ÿ",
		'Ự': "¹",
		'Ý': "Ý",
		'Ỳ': "Ÿ",
		'Ỷ': "Ö",
		'Ỹ': "Û",
		'Ỵ': "Ü",
	},
	"VPS": {
		'đ': "Ç",
		'â': "â",
		'ă': "æ",
		'ê': "ê",
		'ô': "ô",
		'ơ': "Ö",
		'ư': "Ü",
		'á': "á",
		'à': "à",
		'ả': "ä",
		'ã': "ã",
		'ạ': "å",
		'ấ': "Ã",
		'ầ': "À",
		'ẩ': "Ä",
		'ẫ': "Å",
		'ậ': "Æ",
		'ắ': "¡",
		'ằ': "¢",
		'ẳ': "£",
		'ẵ': "¤",
		'ặ': "¥",
		'é': "é",
		'è': "è",
		'ẻ': "È",
		'ẽ': "ë",
		'ẹ': "Ë",
		'ế': "‰",
		'ề': "Š",
		'ể': "‹",
		'ễ': "Í",
		'ệ': "Œ",
		'í': "í",
		'ì': "ì",
		'ỉ': "Ì",
		'ĩ': "ï",
		'ị': "Î",
		'ó': "ó",
		'ò': "ò",
		'ỏ': "Õ",
		'õ': "õ",
		'ọ': "†",
		'ố': "Ó",
		'ồ': "Ò",
		'ổ': "°",
		'ỗ': "‡",
		'ộ': "¶",
		'ớ': "§",
		'ờ': "©",
		'ở': "ª",
		'ỡ': "«",
		'ợ': "®",
		'ú': "ú",
		'ù': "ù",
		'ủ': "û",
		'ũ': "Û",
		'ụ': "ø",
		'ứ': "Ù",
		'ừ': "Ø",
		'ử': "º",
		'ữ': "»",
		'ự': "¿",
		'ý': "š",
		'ỳ': "ÿ",
		'ỷ': "›",
		'ỹ': "Ï",
		'ỵ': "œ",
		'Đ': "ñ",
		'Â': "Â",
		'Ă': "ˆ",
		'Ê': "Ê",
		'Ô': "Ô",
		'Ơ': "÷",
		'Ư': "Ð",
		'Á': "Á",
		'À': "€",
		'Ả': "\u0081",
		'Ã': "‚",
		'Ạ': "å",
		'Ấ': "ƒ",
		'Ầ': "„",
		'Ẩ': "…",
		'Ẫ': "Å",
		'Ậ': "Æ",
		'Ắ': "\u008d",
		'Ằ': "Ž",
		'Ẳ': "\u008f",
		'Ẵ': "ð",
		'Ặ': "¥",
		'É': "É",
		'È': "×",
		'Ẻ': "Þ",
		'Ẽ': "þ",
		'Ẹ': "Ë",
		'Ế': "\u0090",
		'Ề': "“",
		'Ể': "”",
		'Ễ': "•",
		'Ệ': "Œ",
		'Í': "´",
		'Ì': "µ",
		'Ỉ': "·",
		'Ĩ': "¸",
		'Ị': "Î",
		'Ó': "¹",
		'Ò': "¼",
		'Ỏ': "½",
		'Õ': "¾",
		'Ọ': "†",
		'Ố': "–",
		'Ồ': "—",
		'Ổ': "˜",
		'Ỗ': "™",
		'Ộ': "¶",
		'Ớ': "\u009d",
		'Ờ': "ž",
		'Ở': "Ÿ",
		'Ỡ': "¦",
		'Ợ': "®",
		'Ú': "Ú",
		'Ù': "¨",
		'Ủ': "Ñ",
		'Ũ': "¬",
		'Ụ': "ø",
		'Ứ': "\u00ad",
		'Ừ': "¯",
		'Ử': "±",
		'Ữ': "»",
		'Ự': "¿",
		'Ý': "Ý",
		'Ỳ': "²",
		'Ỷ': "ý",
		'Ỹ': "³",
		'Ỵ': "œ",
	},
	"BKHCM 2": {
		'đ': "à",
		'â': "ê",
		'ă': "ù",
		'ê': "ï",
		'ô': "ö",
		'ơ': "ú",
		'ư': "û",
		'á': "aá",
		'à': "aâ",
		'ả': "aã",
		'ã': "aä",
		'ạ': "aå",
		'ấ': "êë",
		'ầ': "êì",
		'ẩ': "êí",
		'ẫ': "êî",
		'ậ': "êå",
		'ắ': "ùæ",
		'ằ': "ùç",
		'ẳ': "ùè",
		'ẵ': "ùé",
		'ặ': "ùå",
		'é': "eá",
		'è': "eâ",
		'ẻ': "eã",
		'ẽ': "eä",
		'ẹ': "eå",
		'ế': "ïë",
		'ề': "ïì",
		'ể': "ïí",
		'ễ': "ïî",
		'ệ': "ïå",
		'í': "ñ",
		'ì': "ò",
		'ỉ': "ó",
		'ĩ': "ô",
		'ị': "õ",
		'ó': "oá",
		'ò': "oâ",
		'ỏ': "oã",
		'õ': "oä",
		'ọ': "oå",
		'ố': "öë",
		'ồ': "öì",
		'ổ': "öí",
		'ỗ': "öî",
		'ộ': "öå",
		'ớ': "úá",
		'ờ': "úâ",
		'ở': "úã",
		'ỡ': "úä",
		'ợ': "úå",
		'ú': "uá",
		'ù': "uâ",
		'ủ': "uã",
		'ũ': "uä",
		'ụ': "uå",
		'ứ': "ûá",
		'ừ': "ûâ",
		'ử': "ûã",
		'ữ': "ûä",
		'ự': "ûå",
		'ý': "yá",
		'ỳ': "yâ",
		'ỷ': "yã",
		'ỹ': "yä",
		'ỵ': "yå",
		'Đ': "À",
		'Â': "Ê",
		'Ă': "Ù",
		'Ê': "Ï",
		'Ô': "Ö",
		'Ơ': "Ú",
		'Ư': "Û",
		'Á': "AÁ",
		'À': "AÂ",
		'Ả': "AÃ",
		'Ã': "AÄ",
		'Ạ': "AÅ",
		'Ấ': "ÊË",
		'Ầ': "ÊÌ",
		'Ẩ': "ÊÍ",
		'Ẫ': "ÊÎ",
		'Ậ': "ÊÅ",
		'Ắ': "ÙÆ",
		'Ằ': "ÙÇ",
		'Ẳ': "ÙÈ",
		'Ẵ': "ÙÉ",
		'Ặ': "ÙÅ",
		'É': "EÁ",
		'È': "EÂ",
		'Ẻ': "EÃ",
		'Ẽ': "EÄ",
		'Ẹ': "EÅ",
		'Ế': "ÏË",
		'Ề': "ÏÌ",
		'Ể': "ÏÍ",
		'Ễ': "ÏÎ",
		'Ệ': "Ïå",
		'Í': "Ñ",
		'Ì': "Ò",
		'Ỉ': "Ó",
		'Ĩ': "Ô",
		'Ị': "Õ",
		'Ó': "OÁ",
		'Ò': "OÂ",
		'Ỏ': "OÃ",
		'Õ': "OÄ",
		'Ọ': "OÅ",
		'Ố': "ÖË",
		'Ồ': "ÖÌ",
		'Ổ': "ÖÍ",
		'Ỗ': "ÖÎ",
		'Ộ': "ÖÅ",
		'Ớ': "ÚÁ",
		'Ờ': "ÚÂ",
		'Ở': "ÚÃ",
		'Ỡ': "ÚÄ",
		'Ợ': "ÚÅ",
		'Ú': "UÁ",
		'Ù': "UÂ",
		'Ủ': "UÃ",
		'Ũ': "UÄ",
		'Ụ': "UÅ",
		'Ứ': "ÛÁ",
		'Ừ': "ÛÂ",
		'Ử': "ÛÃ",
		'Ữ': "ÛÄ",
		'Ự': "ÛÅ",
		'Ý': "YÁ",
		'Ỳ': "YÂ",
		'Ỷ': "YÃ",
		'Ỹ': "YÄ",
		'Ỵ': "YÅ",
	},
	"BKHCM 1": {
		'đ': "½",
		'â': "Ý",
		'ă': "×",
		'ê': "ã",
		'ô': "é",
		'ơ': "ï",
		'ư': "õ",
		'á': "¾",
		'à': "¿",
		'ả': "À",
		'ã': "Á",
		'ạ': "Â",
		'ấ': "Þ",
		'ầ': "ß",
		'ẩ': "à",
		'ẫ': "á",
		'ậ': "â",
		'ắ': "Ø",
		'ằ': "Ù",
		'ẳ': "Ú",
		'ẵ': "Û",
		'ặ': "Ü",
		'é': "Ã",
		'è': "Ä",
		'ẻ': "Å",
		'ẽ': "Æ",
		'ẹ': "Ç",
		'ế': "ä",
		'ề': "å",
		'ể': "æ",
		'ễ': "ç",
		'ệ': "è",
		'í': "È",
		'ì': "É",
		'ỉ': "Ê",
		'ĩ': "Ë",
		'ị': "Ì",
		'ó': "Í",
		'ò': "Î",
		'ỏ': "Ï",
		'õ': "Ð",
		'ọ': "Ñ",
		'ố': "ê",
		'ồ': "ë",
		'ổ': "ì",
		'ỗ': "í",
		'ộ': "î",
		'ớ': "ð",
		'ờ': "ñ",
		'ở': "ò",
		'ỡ': "ó",
		'ợ': "ô",
		'ú': "Ò",
		'ù': "Ó",
		'ủ': "Ô",
		'ũ': "Õ",
		'ụ': "Ö",
		'ứ': "ö",
		'ừ': "÷",
		'ử': "ø",
		'ữ': "ù",
		'ự': "ú",
		'ý': "û",
		'ỳ': "ü",
		'ỷ': "ý",
		'ỹ': "þ",
		'ỵ': "ÿ",
		'Đ': "}",
		'Â': "Ÿ",
		'Ă': "™",
		'Ê': "¥",
		'Ô': "«",
		'Ơ': "±",
		'Ư': "·",
		'Á': "€",
		'À': "\u0081",
		'Ả': "‚",
		'Ã': "ƒ",
		'Ạ': "„",
		'Ấ': "~",
		'Ầ': "¡",
		'Ẩ': "¢",
		'Ẫ': "£",
		'Ậ': "¤",
		'Ắ': "š",
		'Ằ': "›",
		'Ẳ': "œ",
		'Ẵ': "\u009d",
		'Ặ': "˜",
		'É': "…",
		'È': "†",
		'Ẻ': "‡",
		'Ẽ': "ˆ",
		'Ẹ': "‰",
		'Ế': "¦",
		'Ề': "§",
		'Ể': "¨",
		'Ễ': "©",
		'Ệ': "ª",
		'Í': "Š",
		'Ì': "‹",
		'Ỉ': "Œ",
		'Ĩ': "\u008d",
		'Ị': "Ž",
		'Ó': "\u008f",
		'Ò': "\u0090",
		'Ỏ': "‘",
		'Õ': "’",
		'Ọ': "“",
		'Ố': "¬",
		'Ồ': "\u00ad",
		'Ổ': "®",
		'Ỗ': "¯",
		'Ộ': "°",
		'Ớ': "²",
		'Ờ': "³",
		'Ở': "´",
		'Ỡ': "µ",
		'Ợ': "¶",
		'Ú': "”",
		'Ù': "•",
		'Ủ': "–",
		'Ũ': "—",
		'Ụ': "˜",
		'Ứ': "¸",
		'Ừ': "¹",
		'Ử': "º",
		'Ữ': "»",
		'Ự': "¼",
		'Ý': "{",
		'Ỳ': "^",
		'Ỷ': "`",
		'Ỹ': "|",
		'Ỵ': "Ž",
	},
	"Vietware X": {
		'đ': "â",
		'â': "á",
		'ă': "à",
		'ê': "ã",
		'ô': "ä",
		'ơ': "å",
		'ư': "æ",
		'á': "aï",
		'à': "aì",
		'ả': "aí",
		'ã': "aî",
		'ạ': "aû",
		'ấ': "áú",
		'ầ': "áö",
		'ẩ': "áø",
		'ẫ': "áù",
		'ậ': "áû",
		'ắ': "àõ",
		'ằ': "àò",
		'ẳ': "àó",
		'ẵ': "àô",
		'ặ': "àû",
		'é': "eï",
		'è': "eì",
		'ẻ': "eí",
		'ẽ': "eî",
		'ẹ': "eû",
		'ế': "ãú",
		'ề': "ãö",
		'ể': "ãø",
		'ễ': "ãù",
		'ệ': "ãû",
		'í': "ê",
		'ì': "ç",
		'ỉ': "è",
		'ĩ': "é",
		'ị': "ë",
		'ó': "oï",
		'ò': "oì",
		'ỏ': "oí",
		'õ': "oî",
		'ọ': "oü",
		'ố': "äú",
		'ồ': "äö",
		'ổ': "äø",
		'ỗ': "äù",
		'ộ': "äü",
		'ớ': "åï",
		'ờ': "åì",
		'ở': "åí",
		'ỡ': "åî",
		'ợ': "åü",
		'ú': "uï",
		'ù': "uì",
		'ủ': "uí",
		'ũ': "uî",
		'ụ': "uû",
		'ứ': "æï",
		'ừ': "æì",
		'ử': "æí",
		'ữ': "æî",
		'ự': "æû",
		'ý': "yï",
		'ỳ': "yì",
		'ỷ': "yí",
		'ỹ': "yî",
		'ỵ': "yñ",
		'Đ': "Â",
		'Â': "Á",
		'Ă': "À",
		'Ê': "Ã",
		'Ô': "Ä",
		'Ơ': "Å",
		'Ư': "Æ",
		'Á': "AÏ",
		'À': "AÌ",
		'Ả': "AÍ",
		'Ã': "AÎ",
		'Ạ': "AÛ",
		'Ấ': "ÁÚ",
		'Ầ': "ÁÖ",
		'Ẩ': "ÁØ",
		'Ẫ': "ÁÙ",
		'Ậ': "ÁÛ",
		'Ắ': "ÀÕ",
		'Ằ': "ÀÒ",
		'Ẳ': "ÀÓ",
		'Ẵ': "ÀÔ",
		'Ặ': "ÀÛ",
		'É': "EÏ",
		'È': "EÌ",
		'Ẻ': "EÍ",
		'Ẽ': "EÎ",
		'Ẹ': "EÛ",
		'Ế': "ÃÚ",
		'Ề': "ÃÖ",
		'Ể': "ÃØ",
		'Ễ': "ÃÙ",
		'Ệ': "ÃÛ",
		'Í': "Ê",
		'Ì': "Ç",
		'Ỉ': "È",
		'Ĩ': "É",
		'Ị': "Ë",
		'Ó': "OÏ",
		'Ò': "OÌ",
		'Ỏ': "OÍ",
		'Õ': "OÎ",
		'Ọ': "OÜ",
		'Ố': "ÄÚ",
		'Ồ': "ÄÖ",
		'Ổ': "ÄØ",
		'Ỗ': "ÄÙ",
		'Ộ': "ÄÜ",
		'Ớ': "ÅÏ",
		'Ờ': "ÅÌ",
		'Ở': "ÅÍ",
		'Ỡ': "ÅÎ",
		'Ợ': "ÅÜ",
		'Ú': "UÏ",
		'Ù': "UÌ",
		'Ủ': "UÍ",
		'Ũ': "UÎ",
		'Ụ': "UÛ",
		'Ứ': "ÆÏ",
		'Ừ': "ÆÌ",
		'Ử': "ÆÍ",
		'Ữ': "ÆÎ",
		'Ự': "ÆÛ",
		'Ý': "YÏ",
		'Ỳ': "YÌ",
		'Ỷ': "YÍ",
		'Ỹ': "YÎ",
		'Ỵ': "YÑ",
	},
	"Vietware Full": {
		'đ': "¢",
		'â': "¡",
		'ă': "Ÿ",
		'ê': "£",
		'ô': "¤",
		'ơ': "¥",
		'ư': "§",
		'á': "À",
		'à': "ª",
		'ả': "¶",
		'ã': "º",
		'ạ': "Á",
		'ấ': "Ê",
		'ầ': "Ç",
		'ẩ': "È",
		'ẫ': "É",
		'ậ': "Ë",
		'ắ': "Å",
		'ằ': "Â",
		'ẳ': "Ã",
		'ẵ': "Ä",
		'ặ': "Æ",
		'é': "Ï",
		'è': "Ì",
		'ẻ': "Í",
		'ẽ': "Î",
		'ẹ': "Ñ",
		'ế': "Õ",
		'ề': "Ò",
		'ể': "Ó",
		'ễ': "Ô",
		'ệ': "Ö",
		'í': "Û",
		'ì': "Ø",
		'ỉ': "Ù",
		'ĩ': "Ú",
		'ị': "Ü",
		'ó': "â",
		'ò': "ß",
		'ỏ': "à",
		'õ': "á",
		'ọ': "ã",
		'ố': "ç",
		'ồ': "ä",
		'ổ': "å",
		'ỗ': "æ",
		'ộ': "è",
		'ớ': "ì",
		'ờ': "é",
		'ở': "ê",
		'ỡ': "ë",
		'ợ': "í",
		'ú': "ò",
		'ù': "î",
		'ủ': "ï",
		'ũ': "ñ",
		'ụ': "ó",
		'ứ': "÷",
		'ừ': "ô",
		'ử': "õ",
		'ữ': "ö",
		'ự': "ø",
		'ý': "ü",
		'ỳ': "ù",
		'ỷ': "ú",
		'ỹ': "û",
		'ỵ': "ÿ",
		'Đ': "˜",
		'Â': "—",
		'Ă': "–",
		'Ê': "™",
		'Ô': "š",
		'Ơ': "›",
		'Ư': "œ",
		'Á': "À",
		'À': "ª",
		'Ả': "¶",
		'Ã': "º",
		'Ạ': "Á",
		'Ấ': "Ê",
		'Ầ': "Ç",
		'Ẩ': "È",
		'Ẫ': "É",
		'Ậ': "Ë",
		'Ắ': "Å",
		'Ằ': "Â",
		'Ẳ': "Ã",
		'Ẵ': "Ä",
		'Ặ': "Æ",
		'É': "Ï",
		'È': "Ì",
		'Ẻ': "Í",
		'Ẽ': "Î",
		'Ẹ': "Ñ",
		'Ế': "Õ",
		'Ề': "Ò",
		'Ể': "Ó",
		'Ễ': "Ô",
		'Ệ': "Ö",
		'Í': "Û",
		'Ì': "Ø",
		'Ỉ': "Ù",
		'Ĩ': "Ú",
		'Ị': "Ü",
		'Ó': "â",
		'Ò': "ß",
		'Ỏ': "à",
		'Õ': "á",
		'Ọ': "ã",
		'Ố': "ç",
		'Ồ': "ä",
		'Ổ': "å",
		'Ỗ': "æ",
		'Ộ': "è",
		'Ớ': "ì",
		'Ờ': "é",
		'Ở': "ê",
		'Ỡ': "ë",
		'Ợ': "í",
		'Ú': "ò",
		'Ù': "î",
		'Ủ': "ï",
		'Ũ': "ñ",
		'Ụ': "ó",
		'Ứ': "÷",
		'Ừ': "ô",
		'Ử': "õ",
		'Ữ': "ö",
		'Ự': "ø",
		'Ý': "ü",
		'Ỳ': "ù",
		'Ỷ': "ú",
		'Ỹ': "û",
		'Ỵ': "ÿ",
	},
	"UTF-8": {
		'đ': "Ä‘",
		'â': "Ã¢",
		'ă': "Äƒ",
		'ê': "Ãª",
		'ô': "Ã´",
		'ơ': "Æ¡",
		'ư': "Æ°",
		'á': "Ã¡",
		'à': "Ã ",
		'ả': "áº£",
		'ã': "Ã£",
		'ạ': "áº¡",
		'ấ': "áº¥",
		'ầ': "áº§",
		'ẩ': "áº©",
		'ẫ': "áº«",
		'ậ': "áº\u00ad",
		'ắ': "áº¯",
		'ằ': "áº±",
		'ẳ': "áº³",
		'ẵ': "áºµ",
		'ặ': "áº·",
		'é': "Ã©",
		'è': "Ã¨",
		'ẻ': "áº»",
		'ẽ': "áº½",
		'ẹ': "áº¹",
		'ế': "áº¿",
		'ề': "á»\u0081",
		'ể': "á»ƒ",
		'ễ': "á»…",
		'ệ': "á»‡",
		'í': "Ã\u00ad",
		'ì': "Ã¬",
		'ỉ': "á»‰",
		'ĩ': "Ä©",
		'ị': "á»‹",
		'ó': "Ã³",
		'ò': "Ã²",
		'ỏ': "á»\u008f",
		'õ': "Ãµ",
		'ọ': "á»\u008d",
		'ố': "á»‘",
		'ồ': "á»“",
		'ổ': "á»•",
		'ỗ': "á»—",
		'ộ': "á»™",
		'ớ': "á»›",
		'ờ': "á»\u009d",
		'ở': "á»Ÿ",
		'ỡ': "á»¡",
		'ợ': "á»£",
		'ú': "Ãº",
		'ù': "Ã¹",
		'ủ': "á»§",
		'ũ': "Å©",
		'ụ': "á»¥",
		'ứ': "á»©",
		'ừ': "á»«",
		'ử': "á»\u00ad",
		'ữ': "á»¯",
		'ự': "á»±",
		'ý': "Ã½",
		'ỳ': "á»³",
		'ỷ': "á»·",
		'ỹ': "á»¹",
		'ỵ': "á»µ",
		'Đ': "Ä\u0090",
		'Â': "Ã‚",
		'Ă': "Ä‚",
		'Ê': "ÃŠ",
		'Ô': "Ã”",
		'Ơ': "Æ ",
		'Ư': "Æ¯",
		'Á': "Ã\u0081",
		'À': "Ã€",
		'Ả': "áº¢",
		'Ã': "Ãƒ",
		'Ạ': "áº ",
		'Ấ': "áº¤",
		'Ầ': "áº¦",
		'Ẩ': "áº¨",
		'Ẫ': "áºª",
		'Ậ': "áº¬",
		'Ắ': "áº®",
		'Ằ': "áº°",
		'Ẳ': "áº²",
		'Ẵ': "áº´",
		'Ặ': "áº¶",
		'É': "Ã‰",
		'È': "Ãˆ",
		'Ẻ': "áºº",
		'Ẽ': "áº¼",
		'Ẹ': "áº¸",
		'Ế': "áº¾",
		'Ề': "á»€",
		'Ể': "á»‚",
		'Ễ': "á»„",
		'Ệ': "á»†",
		'Í': "Ã\u008d",
		'Ì': "ÃŒ",
		'Ỉ': "á»ˆ",
		'Ĩ': "Ä¨",
		'Ị': "á»Š",
		'Ó': "Ã“",
		'Ò': "Ã’",
		'Ỏ': "á»Ž",
		'Õ': "Ã•",
		'Ọ': "á»Œ",
		'Ố': "á»\u0090",
		'Ồ': "á»’",
		'Ổ': "á»”",
		'Ỗ': "á»–",
		'Ộ': "á»˜",
		'Ớ': "á»š",
		'Ờ': "á»œ",
		'Ở': "á»ž",
		'Ỡ': "á» ",
		'Ợ': "á»¢",
		'Ú': "Ãš",
		'Ù': "Ã™",
		'Ủ': "á»¦",
		'Ũ': "Å¨",
		'Ụ': "á»¤",
		'Ứ': "á»¨",
		'Ừ': "á»ª",
		'Ử': "á»¬",
		'Ữ': "á»®",
		'Ự': "á»°",
		'Ý': "Ã\u009d",
		'Ỳ': "á»²",
		'Ỷ': "á»¶",
		'Ỹ': "á»¸",
		'Ỵ': "á»´",
	},
	"NCR Decimal": {
		'đ': "&#273;",
		'â': "&#226;",
		'ă': "&#259;",
		'ê': "&#234;",
		'ô': "&#244;",
		'ơ': "&#417;",
		'ư': "&#432;",
		'á': "&#225;",
		'à': "&#224;",
		'ả': "&#7843;",
		'ã': "&#227;",
		'ạ': "&#7841;",
		'ấ': "&#7845;",
		'ầ': "&#7847;",
		'ẩ': "&#7849;",
		'ẫ': "&#7851;",
		'ậ': "&#7853;",
		'ắ': "&#7855;",
		'ằ': "&#7857;",
		'ẳ': "&#7859;",
		'ẵ': "&#7861;",
		'ặ': "&#7863;",
		'é': "&#233;",
		'è': "&#232;",
		'ẻ': "&#7867;",
		'ẽ': "&#7869;",
		'ẹ': "&#7865;",
		'ế': "&#7871;",
		'ề': "&#7873;",
		'ể': "&#7875;",
		'ễ': "&#7877;",
		'ệ': "&#7879;",
		'í': "&#237;",
		'ì': "&#236;",
		'ỉ': "&#7881;",
		'ĩ': "&#297;",
		'ị': "&#7883;",
		'ó': "&#243;",
		'ò': "&#242;",
		'ỏ': "&#7887;",
		'õ': "&#245;",
		'ọ': "&#7885;",
		'ố': "&#7889;",
		'ồ': "&#7891;",
		'ổ': "&#7893;",
		'ỗ': "&#7895;",
		'ộ': "&#7897;",
		'ớ': "&#7899;",
		'ờ': "&#7901;",
		'ở': "&#7903;",
		'ỡ': "&#7905;",
		'ợ': "&#7907;",
		'ú': "&#250;",
		'ù': "&#249;",
		'ủ': "&#7911;",
		'ũ': "&#361;",
		'ụ': "&#7909;",
		'ứ': "&#7913;",
		'ừ': "&#7915;",
		'ử': "&#7917;",
		'ữ': "&#7919;",
		'ự': "&#7921;",
		'ý': "&#253;",
		'ỳ': "&#7923;",
		'ỷ': "&#7927;",
		'ỹ': "&#7929;",
		'ỵ': "&#7925;",
		'Đ': "&#272;",
		'Â': "&#194;",
		'Ă': "&#258;",
		'Ê': "&#202;",
		'Ô': "&#212;",
		'Ơ': "&#416;",
		'Ư': "&#431;",
		'Á': "&#193;",
		'À': "&#192;",
		'Ả': "&#7842;",
		'Ã': "&#195;",
		'Ạ': "&#7840;",
		'Ấ': "&#7844;",
		'Ầ': "&#7846;",
		'Ẩ': "&#7848;",
		'Ẫ': "&#7850;",
		'Ậ': "&#7852;",
		'Ắ': "&#7854;",
		'Ằ': "&#7856;",
		'Ẳ': "&#7858;",
		'Ẵ': "&#7860;",
		'Ặ': "&#7862;",
		'É': "&#201;",
		'È': "&#200;",
		'Ẻ': "&#7866;",
		'Ẽ': "&#7868;",
		'Ẹ': "&#7864;",
		'Ế': "&#7870;",
		'Ề': "&#7872;",
		'Ể': "&#7874;",
		'Ễ': "&#7876;",
		'Ệ': "&#7878;",
		'Í': "&#205;",
		'Ì': "&#204;",
		'Ỉ': "&#7880;",
		'Ĩ': "&#296;",
		'Ị': "&#7882;",
		'Ó': "&#211;",
		'Ò': "&#210;",
		'Ỏ': "&#7886;",
		'Õ': "&#213;",
		'Ọ': "&#7884;",
		'Ố': "&#7888;",
		'Ồ': "&#7890;",
		'Ổ': "&#7892;",
		'Ỗ': "&#7894;",
		'Ộ': "&#7896;",
		'Ớ': "&#7898;",
		'Ờ': "&#7900;",
		'Ở': "&#7902;",
		'Ỡ': "&#7904;",
		'Ợ': "&#7906;",
		'Ú': "&#218;",
		'Ù': "&#217;",
		'Ủ': "&#7910;",
		'Ũ': "&#360;",
		'Ụ': "&#7908;",
		'Ứ': "&#7912;",
		'Ừ': "&#7914;",
		'Ử': "&#7916;",
		'Ữ': "&#7918;",
		'Ự': "&#7920;",
		'Ý': "&#221;",
		'Ỳ': "&#7922;",
		'Ỷ': "&#7926;",
		'Ỹ': "&#7928;",
		'Ỵ': "&#7924;",
	},
	"NCR Hex": {
		'đ': "&#x111;",
		'ă': "&#x103;",
		'ơ': "&#x1A1;",
		'ư': "&#x1B0;",
		'ả': "&#x1EA3;",
		'ạ': "&#x1EA1;",
		'ấ': "&#x1EA5;",
		'ầ': "&#x1EA7;",
		'ẩ': "&#x1EA9;",
		'ẫ': "&#x1EAB;",
		'ậ': "&#x1EAD;",
		'ắ': "&#x1EAF;",
		'ằ': "&#x1EB1;",
		'ẳ': "&#x1EB3;",
		'ẵ': "&#x1EB5;",
		'ặ': "&#x1EB7;",
		'ẻ': "&#x1EBB;",
		'ẽ': "&#x1EBD;",
		'ẹ': "&#x1EB9;",
		'ế': "&#x1EBF;",
		'ề': "&#x1EC1;",
		'ể': "&#x1EC3;",
		'ễ': "&#x1EC5;",
		'ệ': "&#x1EC7;",
		'ỉ': "&#x1EC9;",
		'ĩ': "&#x129;",
		'ị': "&#x1ECB;",
		'ỏ': "&#x1ECF;",
		'ọ': "&#x1ECD;",
		'ố': "&#x1ED1;",
		'ồ': "&#x1ED3;",
		'ổ': "&#x1ED5;",
		'ỗ': "&#x1ED7;",
		'ộ': "&#x1ED9;",
		'ớ': "&#x1EDB;",
		'ờ': "&#x1EDD;",
		'ở': "&#x1EDF;",
		'ỡ': "&#x1EE1;",
		'ợ': "&#x1EE3;",
		'ủ': "&#x1EE7;",
		'ũ': "&#x169;",
		'ụ': "&#x1EE5;",
		'ứ': "&#x1EE9;",
		'ừ': "&#x1EEB;",
		'ử': "&#x1EED;",
		'ữ': "&#x1EEF;",
		'ự': "&#x1EF1;",
		'ỳ': "&#x1EF3;",
		'ỷ': "&#x1EF7;",
		'ỹ': "&#x1EF9;",
		'ỵ': "&#x1EF5;",
		'Đ': "&#x110;",
		'Ă': "&#x102;",
		'Ơ': "&#x1A0;",
		'Ư': "&#x1AF;",
		'Ả': "&#x1EA2;",
		'Ạ': "&#x1EA0;",
		'Ấ': "&#x1EA4;",
		'Ầ': "&#x1EA6;",
		'Ẩ': "&#x1EA8;",
		'Ẫ': "&#x1EAA;",
		'Ậ': "&#x1EAC;",
		'Ắ': "&#x1EAE;",
		'Ằ': "&#x1EB0;",
		'Ẳ': "&#x1EB2;",
		'Ẵ': "&#x1EB4;",
		'Ặ': "&#x1EB6;",
		'Ẻ': "&#x1EBA;",
		'Ẽ': "&#x1EBC;",
		'Ẹ': "&#x1EB8;",
		'Ế': "&#x1EBE;",
		'Ề': "&#x1EC0;",
		'Ể': "&#x1EC2;",
		'Ễ': "&#x1EC4;",
		'Ệ': "&#x1EC6;",
		'Ỉ': "&#x1EC8;",
		'Ĩ': "&#x128;",
		'Ị': "&#x1ECA;",
		'Ỏ': "&#x1ECE;",
		'Ọ': "&#x1ECC;",
		'Ố': "&#x1ED0;",
		'Ồ': "&#x1ED2;",
		'Ổ': "&#x1ED4;",
		'Ỗ': "&#x1ED6;",
		'Ộ': "&#x1ED8;",
		'Ớ': "&#x1EDA;",
		'Ờ': "&#x1EDC;",
		'Ở': "&#x1EDE;",
		'Ỡ': "&#x1EE0;",
		'Ợ': "&#x1EE2;",
		'Ủ': "&#x1EE6;",
		'Ũ': "&#x168;",
		'Ụ': "&#x1EE4;",
		'Ứ': "&#x1EE8;",
		'Ừ': "&#x1EEA;",
		'Ử': "&#x1EEC;",
		'Ữ': "&#x1EEE;",
		'Ự': "&#x1EF0;",
		'Ỳ': "&#x1EF2;",
		'Ỷ': "&#x1EF6;",
		'Ỹ': "&#x1EF8;",
		'Ỵ': "&#x1EF4;",
	},
	"Unicode C string Hex": {
		'đ': `\x111`,
		'â': `\xE2`,
		'ă': `\x103`,
		'ê': `\xEA`,
		'ô': `\xF4`,
		'ơ': `\x1A1`,
		'ư': `\x1B0`,
		'á': `\xE1`,
		'à': `\xE0`,
		'ả': `\x1EA3`,
		'ã': `\xE3`,
		'ạ': `\x1EA1`,
		'ấ': `\x1EA5`,
		'ầ': `\x1EA7`,
		'ẩ': `\x1EA9`,
		'ẫ': `\x1EAB`,
		'ậ': `\x1EAD`,
		'ắ': `\x1EAF`,
		'ằ': `\x1EB1`,
		'ẳ': `\x1EB3`,
		'ẵ': `\x1EB5`,
		'ặ': `\x1EB7`,
		'é': `\xE9`,
		'è': `\xE8`,
		'ẻ': `\x1EBB`,
		'ẽ': `\x1EBD`,
		'ẹ': `\x1EB9`,
		'ế': `\x1EBF`,
		'ề': `\x1EC1`,
		'ể': `\x1EC3`,
		'ễ': `\x1EC5`,
		'ệ': `\x1EC7`,
		'í': `\xED`,
		'ì': `\xEC`,
		'ỉ': `\x1EC9`,
		'ĩ': `\x129`,
		'ị': `\x1ECB`,
		'ó': `\xF3`,
		'ò': `\xF2`,
		'ỏ': `\x1ECF`,
		'õ': `\xF5`,
		'ọ': `\x1ECD`,
		'ố': `\x1ED1`,
		'ồ': `\x1ED3`,
		'ổ': `\x1ED5`,
		'ỗ': `\x1ED7`,
		'ộ': `\x1ED9`,
		'ớ': `\x1EDB`,
		'ờ': `\x1EDD`,
		'ở': `\x1EDF`,
		'ỡ': `\x1EE1`,
		'ợ': `\x1EE3`,
		'ú': `\xFA`,
		'ù': `\xF9`,
		'ủ': `\x1EE7`,
		'ũ': `\x169`,
		'ụ': `\x1EE5`,
		'ứ': `\x1EE9`,
		'ừ': `\x1EEB`,
		'ử': `\x1EED`,
		'ữ': `\x1EEF`,
		'ự': `\x1EF1`,
		'ý': `\xFD`,
		'ỳ': `\x1EF3`,
		'ỷ': `\x1EF7`,
		'ỹ': `\x1EF9`,
		'ỵ': `\x1EF5`,
		'Đ': `\x110`,
		'Â': `\xC2`,
		'Ă': `\x102`,
		'Ê': `\xCA`,
		'Ô': `\xD4`,
		'Ơ': `\x1A0`,
		'Ư': `\x1AF`,
		'Á': `\xC1`,
		'À': `\xC0`,
		'Ả': `\x1EA2`,
		'Ã': `\xC3`,
		'Ạ': `\x1EA0`,
		'Ấ': `\x1EA4`,
		'Ầ': `\x1EA6`,
		'Ẩ': `\x1EA8`,
		'Ẫ': `\x1EAA`,
		'Ậ': `\x1EAC`,
		'Ắ': `\x1EAE`,
		'Ằ': `\x1EB0`,
		'Ẳ': `\x1EB2`,
		'Ẵ': `\x1EB4`,
		'Ặ': `\x1EB6`,
		'É': `\xC9`,
		'È': `\xC8`,
		'Ẻ': `\x1EBA`,
		'Ẽ': `\x1EBC`,
		'Ẹ': `\x1EB8`,
		'Ế': `\x1EBE`,
		'Ề': `\x1EC0`,
		'Ể': `\x1EC2`,
		'Ễ': `\x1EC4`,
		'Ệ': `\x1EC6`,
		'Í': `\xCD`,
		'Ì': `\xCC`,
		'Ỉ': `\x1EC8`,
		'Ĩ': `\x128`,
		'Ị': `\x1ECA`,
		'Ó': `\xD3`,
		'Ò': `\xD2`,
		'Ỏ': `\x1ECE`,
		'Õ': `\xD5`,
		'Ọ': `\x1ECC`,
		'Ố': `\x1ED0`,
		'Ồ': `\x1ED2`,
		'Ổ': `\x1ED4`,
		'Ỗ': `\x1ED6`,
		'Ộ': `\x1ED8`,
		'Ớ': `\x1EDA`,
		'Ờ': `\x1EDC`,
		'Ở': `\x1EDE`,
		'Ỡ': `\x1EE0`,
		'Ợ': `\x1EE2`,
		'Ú': `\xDA`,
		'Ù': `\xD9`,
		'Ủ': `\x1EE6`,
		'Ũ': `\x168`,
		'Ụ': `\x1EE4`,
		'Ứ': `\x1EE8`,
		'Ừ': `\x1EEA`,
		'Ử': `\x1EEC`,
		'Ữ': `\x1EEE`,
		'Ự': `\x1EF0`,
		'Ý': `\xDD`,
		'Ỳ': `\x1EF2`,
		'Ỷ': `\x1EF6`,
		'Ỹ': `\x1EF8`,
		'Ỵ': `\x1EF4`,
	},
	"Unicode C string Decimal": {
		'đ': `\u273`,
		'â': `\u226`,
		'ă': `\u259`,
		'ê': `\u234`,
		'ô': `\u244`,
		'ơ': `\u417`,
		'ư': `\u432`,
		'á': `\u225`,
		'à': `\u224`,
		'ả': `\u7843`,
		'ã': `\u227`,
		'ạ': `\u7841`,
		'ấ': `\u7845`,
		'ầ': `\u7847`,
		'ẩ': `\u7849`,
		'ẫ': `\u7851`,
		'ậ': `\u7853`,
		'ắ': `\u7855`,
		'ằ': `\u7857`,
		'ẳ': `\u7859`,
		'ẵ': `\u7861`,
		'ặ': `\u7863`,
		'é': `\u233`,
		'è': `\u232`,
		'ẻ': `\u7867`,
		'ẽ': `\u7869`,
		'ẹ': `\u7865`,
		'ế': `\u7871`,
		'ề': `\u7873`,
		'ể': `\u7875`,
		'ễ': `\u7877`,
		'ệ': `\u7879`,
		'í': `\u237`,
		'ì': `\u236`,
		'ỉ': `\u7881`,
		'ĩ': `\u297`,
		'ị': `\u7883`,
		'ó': `\u243`,
		'ò': `\u242`,
		'ỏ': `\u7887`,
		'õ': `\u245`,
		'ọ': `\u7885`,
		'ố': `\u7889`,
		'ồ': `\u7891`,
		'ổ': `\u7893`,
		'ỗ': `\u7895`,
		'ộ': `\u7897`,
		'ớ': `\u7899`,
		'ờ': `\u7901`,
		'ở': `\u7903`,
		'ỡ': `\u7905`,
		'ợ': `\u7907`,
		'ú': `\u250`,
		'ù': `\u249`,
		'ủ': `\u7911`,
		'ũ': `\u361`,
		'ụ': `\u7909`,
		'ứ': `\u7913`,
		'ừ': `\u7915`,
		'ử': `\u7917`,
		'ữ': `\u7919`,
		'ự': `\u7921`,
		'ý': `\u253`,
		'ỳ': `\u7923`,
		'ỷ': `\u7927`,
		'ỹ': `\u7929`,
		'ỵ': `\u7925`,
		'Đ': `\u272`,
		'Â': `\u194`,
		'Ă': `\u258`,
		'Ê': `\u202`,
		'Ô': `\u212`,
		'Ơ': `\u416`,
		'Ư': `\u431`,
		'Á': `\u193`,
		'À': `\u192`,
		'Ả': `\u7842`,
		'Ã': `\u195`,
		'Ạ': `\u7840`,
		'Ấ': `\u7844`,
		'Ầ': `\u7846`,
		'Ẩ': `\u7848`,
		'Ẫ': `\u7850`,
		'Ậ': `\u7852`,
		'Ắ': `\u7854`,
		'Ằ': `\u7856`,
		'Ẳ': `\u7858`,
		'Ẵ': `\u7860`,
		'Ặ': `\u7862`,
		'É': `\u201`,
		'È': `\u200`,
		'Ẻ': `\u7866`,
		'Ẽ': `\u7868`,
		'Ẹ': `\u7864`,
		'Ế': `\u7870`,
		'Ề': `\u7872`,
		'Ể': `\u7874`,
		'Ễ': `\u7876`,
		'Ệ': `\u7878`,
		'Í': `\u205`,
		'Ì': `\u204`,
		'Ỉ': `\u7880`,
		'Ĩ': `\u296`,
		'Ị': `\u7882`,
		'Ó': `\u211`,
		'Ò': `\u210`,
		'Ỏ': `\u7886`,
		'Õ': `\u213`,
		'Ọ': `\u7884`,
		'Ố': `\u7888`,
		'Ồ': `\u7890`,
		'Ổ': `\u7892`,
		'Ỗ': `\u7894`,
		'Ộ': `\u7896`,
		'Ớ': `\u7898`,
		'Ờ': `\u7900`,
		'Ở': `\u7902`,
		'Ỡ': `\u7904`,
		'Ợ': `\u7906`,
		'Ú': `\u218`,
		'Ù': `\u217`,
		'Ủ': `\u7910`,
		'Ũ': `\u360`,
		'Ụ': `\u7908`,
		'Ứ': `\u7912`,
		'Ừ': `\u7914`,
		'Ử': `\u7916`,
		'Ữ': `\u7918`,
		'Ự': `\u7920`,
		'Ý': `\u221`,
		'Ỳ': `\u7922`,
		'Ỷ': `\u7926`,
		'Ỹ': `\u7928`,
		'Ỵ': `\u7924`,
	},
}
