// This file may be redistributed and modified only under the terms of
// the GNU General Public License (See COPYING for details).
// Copyright (C) 2003 Alistair Riddoch

#ifndef ERIS_IROUND_H
#define ERIS_IROUND_H

#ifndef PACKAGE
#error iround.h must be included after config.h
#endif

#ifdef HAVE_LLRINT
    #define L_ROUND(_x) (::llrint(_x)) 
#else
    #define L_ROUND(_x) ((long long)(_x)) 
#endif

#ifdef HAVE_LRINTF
    #define I_ROUND(_x) (::lrintf(_x)) 
#elif defined(HAVE_RINTF)
    #define I_ROUND(_x) ((int)::rintf(_x)) 
#elif defined(HAVE_RINT)
    #define I_ROUND(_x) ((int)::rint(_x)) 
#else
    #define I_ROUND(_x) ((int)(_x)) 
#endif

#ifdef HAVE_FABSF
    #define F_ABS(_x) (::fabsf(_x))
#else
    #define F_ABS(_x) (::fabs(_x))
#endif

#endif // ERIS_IROUND_H
