//
// File: PanelAbout.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Wed Oct 25 18:21:57 2006
//

#include "PanelAbout.h"


PanelAbout::PanelAbout(wxWindow *parent, int id):wxPanel(parent,id)
{
    const wxString APP_NAME = wxT("Encadre_Image");
    const wxString APP_VERSION = wxT("0.7");
    const wxString APP_MAINT = wxT("Éric Laly");
    const wxString APP_LICENCE = wxT("GPL");
    const wxString APP_COPYRIGTH = wxT("© 2006 Éric Laly");
    
    const wxString APP_DESCR = _("\
    \"Encadre image\" est une application qui permet:\n\
      * d'ajouter sur une image au format jpeg:\n\
           - un nombre illimité de cadres (limité par la mémoire disponible)\n\
           - une signature\n\
      * de créer une arborescence pour PHPWebGallery\n\
      * de créer une arborescence libre (avec redimensionnement des images)\n\n\
    Dans le cas de la création d'une arborescence, l'application peut:\n\
        * rechercher récursivement les fichiers images à partir d'un répertoire source.\n\
        * recréer tous les sous-répertoires du répertoire source dans le répertoire destination.\n\n\
     Voir le site pour un mode d'emploi plus détaillé.\n\
     Elle est disponible sous Linux (les Unix en général) et sous Windows (NT, 2000 et XP).\n\
     ");
    
    const wxString APP_WEBSITE = wxT("http://ericlaly.fr");
    const wxString APP_WEBPAGE = wxT("/encadre_image");
    
    const wxString APP_INFOS = _("\
    Ce logiciel utilise wxWidgets et Magick++ :\
    ");
    const wxString APP_WXWIDGETS = wxT("http://wxwidgets.org");
    const wxString APP_MAGICKPP = wxT("http://www.imagemagick.org/Magick++/");


    // about info
    wxFlexGridSizer *aboutinfo = new wxFlexGridSizer (2, 0, 2);
    aboutinfo->Add (new wxStaticText(this, -1,wxT("Version: ")),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, APP_VERSION),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, wxT("Écrit par: ")),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, APP_MAINT),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, wxT("Licence: ")),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, APP_LICENCE),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, wxT("Copyright: ")),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, APP_COPYRIGTH),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, wxT("Site: ")),0, wxALIGN_LEFT);
    aboutinfo->Add (new wxStaticText(this, -1, APP_WEBSITE+APP_WEBPAGE),0, wxALIGN_LEFT);
    
    // about icontitle//info
    wxBoxSizer *aboutpane = new wxBoxSizer (wxHORIZONTAL);
    
    aboutpane->Add (aboutinfo, 0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL);
    aboutpane->Add (20, 0);
    
    // about complete
    wxBoxSizer *totalpane = new wxBoxSizer (wxVERTICAL);
    totalpane->Add (0, 10);
    wxStaticText *appname = new wxStaticText(this, -1, APP_NAME);
    appname->SetFont (wxFont (20, wxDEFAULT, wxNORMAL, wxBOLD));
    totalpane->Add (appname, 0, wxALIGN_CENTER | wxLEFT | wxRIGHT, 40);
    totalpane->Add (0, 10);
    totalpane->Add (aboutpane, 0, wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM, 10);
    totalpane->Add (new wxStaticText(this, -1, APP_DESCR),
                    0, wxALIGN_LEFT | wxLEFT | wxRIGHT, 10);
    totalpane->Add (0, 6);
    totalpane->Add (new wxStaticText(this, -1, APP_INFOS),
                    0, wxALIGN_LEFT | wxLEFT | wxRIGHT, 10);
    totalpane->Add (new wxStaticText(this, -1, APP_WXWIDGETS),
                    0, wxALIGN_RIGHT| wxLEFT | wxRIGHT, 10);
    totalpane->Add (new wxStaticText(this, -1, APP_MAGICKPP),
                    0, wxALIGN_RIGHT| wxLEFT | wxRIGHT, 10);
    totalpane->Add (0, 6);
    
    SetSizer(totalpane);
    totalpane->Fit(this);
}


PanelAbout::~PanelAbout()
{
	// TODO: put destructor code here
}
