//
// File: ThreadTraitement.h
// Created by: Éric Laly <elaly@free.fr>
// Created on: Thu Nov  9 12:25:54 2006
//

#ifndef _THREADTRAITEMENT_H_
#define _THREADTRAITEMENT_H_
#include <wx/wx.h>
#include <wx/dir.h>
#include <vector>
using std::vector;
#include "Encadreur.h"
#include "PanelCadres.h"
#include "PanelSaisieParametresSignature.h"
#include "PanelParametresSortie.h"
#include "PanelChoixImages.h"
class PanelResultat;


class ThreadTraitement : public wxThread
{
	public:
		ThreadTraitement(PanelCadres *panelcadres, PanelSaisieParametresSignature *panelsaisieparametresignature,
                                    PanelChoixImages *panelchoiximage, PanelParametresSortie *panelparametressortie, 
    PanelResultat *panelresultat);
		 ~ThreadTraitement();
        virtual void *Entry();
        virtual void OnExit();
	private:
		Encadreur encadreur;
        PanelCadres *panel_cadres;
        PanelSaisieParametresSignature* panel_signature;
        PanelChoixImages* panel_choix_images;
        PanelParametresSortie* panel_parametres_sortie;
        PanelResultat* panel_resultat;

        vector <wxString> liste_images;

		void EncadreFichiers(unsigned int num);
        bool CreeListeImage(wxString repertoiresource);
        void RecupereFichiers(wxString extension,wxDir &dir);
	
	protected:
	
};


#endif	//_THREADTRAITEMENT_H_
