/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.ResultsMenuBar;

public class KeywordSearch
implements HyperlinkListener {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private static JFrame f = null;
    static JTabbedPane tab;

    public KeywordSearch(JTextField search, String woss, JembossParams mysettings, boolean withSoap, boolean andOperator) {
        String searchTxt = search.getText().trim().toLowerCase();
        if (searchTxt.length() == 0) {
            return;
        }
        String res = this.search(searchTxt, woss.toLowerCase(), mysettings, withSoap, andOperator);
        this.showSearchResult(res, searchTxt, mysettings);
    }

    private String search(String searchTxt, String woss, JembossParams mysettings, boolean withSoap, boolean andOperator) {
        Vector<String> vres = new Vector<String>();
        StringBuffer res = new StringBuffer();
        boolean found = false;
        try {
            String line;
            String stub;
            if (withSoap) {
                stub = mysettings.getembURL();
            } else {
                String embRoot = mysettings.getEmbossBin().trim();
                if (embRoot.endsWith("bin/")) {
                    embRoot = embRoot.substring(0, embRoot.length() - 4);
                } else if (embRoot.endsWith("bin")) {
                    embRoot = embRoot.substring(0, embRoot.length() - 3);
                }
                stub = System.getProperty("os.name").startsWith("Windows") ? "file:/" + embRoot + "doc\\programs\\html\\" : "file://" + embRoot + "/share/EMBOSS/doc/programs/html/";
            }
            String searching = this.getSearchText(searchTxt, andOperator);
            res.append("<h2><a name=\"SEARCH EMBOSS FOR " + searching + "\">Search results for '" + searching + "'</a></h2>");
            BufferedReader in = new BufferedReader(new StringReader(woss));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(":") > -1) continue;
                boolean match = false;
                match = andOperator ? this.searchAND(line, searchTxt) : this.searchOR(line, searchTxt);
                if (!match) continue;
                if (!found) {
                    res.append("<table border cellpadding=4 bgcolor=\"#FFFFF0\">");
                    res.append("<tr><th>Program name</th><th>Description</th></tr>");
                }
                found = true;
                String prog = line.substring(0, line.indexOf(" "));
                String progHTML = "<tr><td><a href=\"" + stub + prog + ".html\">" + prog + "</a></td><td>" + line.substring(line.indexOf(" ")) + "</td></tr>";
                if (vres.contains(progHTML)) continue;
                vres.add(progHTML);
            }
            if (found) {
                Object[] progOrder = vres.toArray();
                Arrays.sort(progOrder);
                for (int i = 0; i < progOrder.length; ++i) {
                    res.append(progOrder[i]);
                }
                res.append("</table>");
            } else {
                res.append("<b>No matches found.</b>");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return res.toString();
    }

    private String getSearchText(String searchTxt, boolean andOperator) {
        if (searchTxt.indexOf(" ") == -1) {
            return searchTxt;
        }
        StringBuffer buff = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(searchTxt, " ");
        while (tok.hasMoreTokens()) {
            buff.append(tok.nextToken());
            if (andOperator && tok.hasMoreTokens()) {
                buff.append(" AND ");
                continue;
            }
            if (andOperator || !tok.hasMoreTokens()) continue;
            buff.append(" OR ");
        }
        return buff.toString();
    }

    private boolean searchAND(String line, String searchTxt) {
        StringTokenizer tok = new StringTokenizer(searchTxt, " ");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (line.indexOf(token) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean searchOR(String line, String searchTxt) {
        StringTokenizer tok = new StringTokenizer(searchTxt, " ");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (line.indexOf(token) <= -1) continue;
            return true;
        }
        return false;
    }

    private void showSearchResult(String woss, String searchTxt, JembossParams mysettings) {
        if (f == null) {
            f = new JFrame("EMBOSS Keyword Search");
            Dimension d = f.getToolkit().getScreenSize();
            d = new Dimension((int)d.getWidth() / 2, (int)d.getHeight() / 2);
            f.setSize(d);
            tab = new JTabbedPane();
            f.getContentPane().add(tab);
            f.addWindowListener(new WinExit());
        }
        JEditorPane searchHTML = new JEditorPane();
        searchHTML.addHyperlinkListener(this);
        searchHTML.setEditable(false);
        searchHTML.setContentType("text/html");
        searchHTML.setEditorKit(new HTMLEditorKit2());
        searchHTML.setText(woss);
        JScrollPane jsp = new JScrollPane(searchHTML);
        tab.addTab("Search :: " + searchTxt, jsp);
        tab.setSelectedComponent(jsp);
        new ResultsMenuBar(f, tab, null, mysettings);
        f.setVisible(true);
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            f.setCursor(this.cbusy);
            try {
                new Browser(event.getURL(), event.getDescription());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            f.setCursor(this.cdone);
        }
    }

    class WinExit
    extends WindowAdapter {
        WinExit() {
        }

        public void windowClosing(WindowEvent we) {
            f.dispose();
            f = null;
        }
    }

    public class HTMLEditorKit2
    extends HTMLEditorKit {
        public Document createDefaultDocument() {
            HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
            doc.setAsynchronousLoadPriority(-1);
            return doc;
        }
    }
}

