(ert-deftest elpy-goto-location-should-insert-location-to-tag-ring ()
  (elpy-testcase ((:project project-root "test.py" "foo\nbar"))
    (let ((orig-buffer (current-buffer))
          (orig-point (point)))
      (elpy-goto-location (f-join project-root "test.py")
                          4)
      (pop-tag-mark)
      (should (equal orig-buffer (current-buffer)))
      (should (equal orig-point (point))))))

(ert-deftest elpy-goto-location-should-go-to-location ()
  (elpy-testcase ((:project project-root ("test.py" "foo\nbar")))
    (elpy-goto-location (f-join project-root "test.py")
                        4)
    (should (looking-at "bar"))))

(ert-deftest elpy-goto-location-should-open-location-in-other-window ()
  (elpy-testcase ((:project project-root ("test.py" "foo\nbar")))
                 (elpy-goto-location (f-join project-root "test.py")
                                     4
                                     t)
                 (should (= (count-windows) 2))))
